/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.components;

import am2.AMCore;
import am2.api.spell.component.interfaces.ISpellComponent;
import am2.api.spell.enums.Affinity;
import am2.api.spell.enums.SpellModifiers;
import am2.items.ItemsCommonProxy;
import am2.particles.AMParticle;
import am2.spell.SpellUtils;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class Ignition
implements ISpellComponent {
    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, int blockx, int blocky, int blockz, int blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        switch (blockFace) {
            case 5: {
                ++blockx;
                break;
            }
            case 2: {
                --blockz;
                break;
            }
            case 3: {
                ++blockz;
                break;
            }
            case 4: {
                --blockx;
            }
        }
        Block block = world.func_147439_a(blockx, blocky, blockz);
        if (world.func_147437_c(blockx, blocky, blockz) || block == Blocks.field_150433_aE || block instanceof BlockFlower) {
            if (!world.field_72995_K) {
                world.func_147449_b(blockx, blocky, blockz, (Block)Blocks.field_150480_ab);
            }
            return true;
        }
        block = world.func_147439_a(blockx, ++blocky, blockz);
        if (world.func_147437_c(blockx, blocky, blockz) || block == Blocks.field_150433_aE || block instanceof BlockFlower) {
            if (!world.field_72995_K) {
                world.func_147449_b(blockx, blocky, blockz, (Block)Blocks.field_150480_ab);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        int burnTime = SpellUtils.instance.getModifiedInt_Mul(3, stack, caster, target, world, 0, SpellModifiers.DURATION);
        burnTime = SpellUtils.instance.modifyDurationBasedOnArmor(caster, burnTime);
        if (target.func_70027_ad()) {
            return false;
        }
        target.func_70015_d(burnTime);
        return true;
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 35.0f;
    }

    @Override
    public float burnout(EntityLivingBase caster) {
        return 10.0f;
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        for (int i = 0; i < 5; ++i) {
            AMParticle particle = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(world, "explosion_2", x + 0.5, y + 0.5, z + 0.5));
            if (particle == null) continue;
            particle.addRandomOffset(1.0, 0.5, 1.0);
            particle.func_70024_g(rand.nextDouble() * 0.2 - 0.1, 0.3, rand.nextDouble() * 0.2 - 0.1);
            particle.setAffectedByGravity();
            particle.setDontRequireControllers();
            particle.setMaxAge(5);
            particle.setParticleScale(0.1f);
            if (colorModifier <= -1) continue;
            particle.setRGBColorF((float)(colorModifier >> 16 & 0xFF) / 255.0f, (float)(colorModifier >> 8 & 0xFF) / 255.0f, (float)(colorModifier & 0xFF) / 255.0f);
        }
    }

    @Override
    public EnumSet<Affinity> getAffinity() {
        return EnumSet.of(Affinity.FIRE);
    }

    @Override
    public int getID() {
        return 26;
    }

    @Override
    public Object[] getRecipeItems() {
        Object[] objectArray = new Object[2];
        objectArray[0] = new ItemStack((Item)ItemsCommonProxy.rune, 1, 11);
        objectArray[1] = Items.field_151033_d;
        return objectArray;
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.01f;
    }
}

