/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.components;

import am2.AMCore;
import am2.api.spell.component.interfaces.ISpellComponent;
import am2.api.spell.enums.Affinity;
import am2.enchantments.AMEnchantments;
import am2.entities.EntityDarkMage;
import am2.entities.EntityLightMage;
import am2.items.ItemsCommonProxy;
import am2.particles.AMParticle;
import am2.particles.ParticleFadeOut;
import am2.particles.ParticleMoveOnHeading;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIArrowAttack;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class Disarm
implements ISpellComponent {
    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, int blockx, int blocky, int blockz, int blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        return false;
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        if (target instanceof EntityLightMage || target instanceof EntityDarkMage) {
            return false;
        }
        if (!(!(target instanceof EntityPlayer) || AMCore.config.getDisarmAffectsPlayers() && MinecraftServer.func_71276_C().func_71219_W())) {
            return false;
        }
        if (target instanceof EntityPlayer && ((EntityPlayer)target).func_70694_bm() != null && !target.field_70170_p.field_72995_K) {
            if (EnchantmentHelper.func_77506_a((int)AMEnchantments.soulbound.field_77352_x, (ItemStack)((EntityPlayer)target).func_70694_bm()) > 0) {
                return true;
            }
            ((EntityPlayer)target).func_71040_bB(true);
            return true;
        }
        if (target instanceof EntityMob && ((EntityMob)target).func_70694_bm() != null) {
            if (EnchantmentHelper.func_77506_a((int)AMEnchantments.soulbound.field_77352_x, (ItemStack)((EntityMob)target).func_70694_bm()) > 0) {
                return true;
            }
            if (!world.field_72995_K) {
                EntityItem item = new EntityItem(world);
                ItemStack dropstack = ((EntityMob)target).func_70694_bm().func_77946_l();
                if (dropstack.func_77958_k() > 0) {
                    dropstack.func_77964_b((int)Math.floor((float)dropstack.func_77958_k() * (0.8f + world.field_73012_v.nextFloat() * 0.19f)));
                }
                item.func_92058_a(dropstack);
                item.func_70107_b(target.field_70165_t, target.field_70163_u, target.field_70161_v);
                world.func_72838_d((Entity)item);
            }
            ((EntityMob)target).func_70062_b(0, null);
            ((EntityMob)target).func_70624_b(caster);
            Iterator it = ((EntityMob)target).field_70714_bg.field_75782_a.iterator();
            boolean removed = false;
            while (it.hasNext()) {
                EntityAITasks.EntityAITaskEntry task = (EntityAITasks.EntityAITaskEntry)it.next();
                if (!(task.field_75733_a instanceof EntityAIArrowAttack)) continue;
                it.remove();
                removed = true;
                break;
            }
            if (removed) {
                ((EntityMob)target).field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)target, 0.5, true));
                ((EntityMob)target).func_98053_h(true);
            }
        } else if (target instanceof EntityEnderman) {
            int blockID = ((EntityEnderman)target).func_70824_q();
            int meta = ((EntityEnderman)target).func_70824_q();
            if (blockID > 0) {
                ((EntityEnderman)target).func_70817_b(0);
                ItemStack dropstack = new ItemStack(Block.func_149729_e((int)blockID), 1, meta);
                EntityItem item = new EntityItem(world);
                item.func_92058_a(dropstack);
                item.func_70107_b(target.field_70165_t, target.field_70163_u, target.field_70161_v);
                world.func_72838_d((Entity)item);
            }
            ((EntityMob)target).func_70624_b(caster);
        }
        return false;
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 130.0f;
    }

    @Override
    public float burnout(EntityLivingBase caster) {
        return 26.0f;
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        for (int i = 0; i < 25; ++i) {
            AMParticle particle = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(world, "sparkle2", x, y, z));
            if (particle == null) continue;
            particle.addRandomOffset(1.0, 2.0, 1.0);
            particle.AddParticleController(new ParticleMoveOnHeading(particle, MathHelper.func_76138_g((double)((target instanceof EntityLivingBase ? ((EntityLivingBase)target).field_70759_as : target.field_70177_z) + 90.0f)), MathHelper.func_76138_g((double)target.field_70125_A), 0.1 + rand.nextDouble() * 0.5, 1, false));
            particle.AddParticleController(new ParticleFadeOut(particle, 1, false).setFadeSpeed(0.05f));
            particle.setAffectedByGravity();
            if (rand.nextBoolean()) {
                particle.setRGBColorF(0.7f, 0.7f, 0.1f);
            } else {
                particle.setRGBColorF(0.1f, 0.7f, 0.1f);
            }
            particle.setMaxAge(40);
            particle.setParticleScale(0.1f);
            if (colorModifier <= -1) continue;
            particle.setRGBColorF((float)(colorModifier >> 16 & 0xFF) / 255.0f, (float)(colorModifier >> 8 & 0xFF) / 255.0f, (float)(colorModifier & 0xFF) / 255.0f);
        }
    }

    @Override
    public EnumSet<Affinity> getAffinity() {
        return EnumSet.of(Affinity.NONE);
    }

    @Override
    public int getID() {
        return 9;
    }

    @Override
    public Object[] getRecipeItems() {
        Object[] objectArray = new Object[2];
        objectArray[0] = new ItemStack((Item)ItemsCommonProxy.rune, 1, 11);
        objectArray[1] = Items.field_151040_l;
        return objectArray;
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.0f;
    }
}

