/*
 * Decompiled with CFR 0.152.
 */
package am2.spell;

import am2.api.events.SpellRecipeItemsEvent;
import am2.api.power.PowerTypes;
import am2.api.spell.component.interfaces.ISpellPart;
import am2.items.ItemsCommonProxy;
import am2.spell.SkillManager;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;

public class SpellRecipeManager {
    private final HashMap<ArrayList<Object>, ISpellPart> recipes = new HashMap();
    public static final SpellRecipeManager instance = new SpellRecipeManager();

    private SpellRecipeManager() {
    }

    public void RegisterRecipe(ISpellPart part) {
        ArrayList<Object> recipeItems = new ArrayList<Object>();
        Object[] recipe = part.getRecipeItems();
        SpellRecipeItemsEvent event = new SpellRecipeItemsEvent(SkillManager.instance.getSkillName(part), SkillManager.instance.getShiftedPartID(part), recipe);
        MinecraftForge.EVENT_BUS.post((Event)event);
        recipe = event.recipeItems;
        if (recipe == null) {
            FMLLog.warning((String)"Ars Magica 2 >> Component %s has been registered with no craftable recipe - is this intentional?  If so, return a 0-length array for recipe.", (Object[])new Object[]{SkillManager.instance.getDisplayName(part)});
            return;
        }
        if (recipe.length == 0) {
            return;
        }
        for (int i = 0; i < recipe.length; ++i) {
            Object o = recipe[i];
            if (o instanceof Item) {
                recipeItems.add(new ItemStack((Item)o));
                continue;
            }
            if (o instanceof Block) {
                recipeItems.add(new ItemStack((Block)o));
                continue;
            }
            if (o instanceof String) {
                if (((String)o).toLowerCase().startsWith("e:")) {
                    if (i == recipe.length - 1 || !(recipe[i + 1] instanceof Integer)) {
                        FMLLog.severe((String)"Ars Magica >> Error registering recipe.  Power must be declared in Integer pairs (type flags, quantity)).", (Object[])new Object[0]);
                        return;
                    }
                    int[] ids = SpellRecipeManager.ParseEssenceIDs((String)o);
                    int flag = 0;
                    for (int f : ids) {
                        flag |= f;
                    }
                    int quantity = (Integer)recipe[++i];
                    ItemStack stack = new ItemStack((Item)ItemsCommonProxy.essence, quantity, 12 + flag);
                    recipeItems.add(stack);
                    continue;
                }
                recipeItems.add(o);
                continue;
            }
            recipeItems.add(o);
        }
        this.recipes.put(recipeItems, part);
    }

    public static int[] ParseEssenceIDs(String s) {
        if (s.toLowerCase().equals("e:*")) {
            int[] all = new int[PowerTypes.all().length];
            int count = 0;
            for (PowerTypes type : PowerTypes.all()) {
                all[count++] = type.ID();
            }
            return all;
        }
        s = s.toLowerCase().replace("e:", "");
        String[] split = s.split("\\|");
        int[] ids = new int[split.length];
        for (int i = 0; i < split.length; ++i) {
            try {
                ids[i] = Integer.parseInt(split[i]);
                continue;
            }
            catch (NumberFormatException nex) {
                FMLLog.severe((String)"Ars Magic >> Invalid power type ID while parsing value %s", (Object[])new Object[]{s});
                ids[i] = 0;
            }
        }
        return ids;
    }

    public ISpellPart getPartByRecipe(ArrayList<ItemStack> recipe) {
        return this.matchRecipe(recipe);
    }

    private ISpellPart matchRecipe(ArrayList<ItemStack> recipe) {
        HashMap<ArrayList<Object>, ISpellPart> safeCopy = new HashMap<ArrayList<Object>, ISpellPart>();
        safeCopy.putAll(this.recipes);
        ArrayList<ArrayList> toRemove = new ArrayList<ArrayList>();
        for (ArrayList arr : safeCopy.keySet()) {
            if (arr.size() == recipe.size()) continue;
            toRemove.add(arr);
        }
        for (ArrayList arr : toRemove) {
            safeCopy.remove(arr);
        }
        int index = 0;
        for (ItemStack recipeItem : recipe) {
            toRemove.clear();
            for (ArrayList arr : safeCopy.keySet()) {
                Object o = arr.get(index);
                boolean matches = false;
                if (o instanceof ItemStack) {
                    matches = this.compareItemStacks((ItemStack)o, recipeItem);
                } else if (o instanceof Item) {
                    matches = (Item)o == recipeItem.func_77973_b();
                } else if (o instanceof Block) {
                    matches = (Block)o == Block.func_149634_a((Item)recipeItem.func_77973_b());
                } else if (o instanceof String) {
                    if (((String)o).startsWith("P:")) {
                        String potionDefinition = ((String)o).substring(2);
                        matches |= this.matchPotion(recipeItem, potionDefinition);
                    } else {
                        ArrayList oreDictItems = OreDictionary.getOres((String)((String)o));
                        for (ItemStack stack : oreDictItems) {
                            matches |= OreDictionary.itemMatches((ItemStack)stack, (ItemStack)recipeItem, (boolean)false);
                        }
                    }
                }
                if (matches) continue;
                toRemove.add(arr);
            }
            ++index;
            for (ArrayList arr : toRemove) {
                safeCopy.remove(arr);
            }
        }
        if (safeCopy.size() > 1) {
            StringBuilder sb = new StringBuilder();
            sb.append("Ars Magica >> Duplicate recipe match on the following spell parts: ");
            for (ISpellPart part : safeCopy.values()) {
                sb.append(SkillManager.instance.getSkillName(part) + " ");
            }
            sb.append("- this should be corrected as soon as possible!");
            FMLLog.warning((String)sb.toString(), (Object[])new Object[0]);
        }
        if (safeCopy.size() > 0) {
            ISpellPart part = (ISpellPart)safeCopy.values().iterator().next();
            FMLLog.info((String)"Ars Magica 2 >> Matched Spell Component: %s", (Object[])new Object[]{part.getClass().toString()});
            return part;
        }
        return null;
    }

    private boolean matchPotion(ItemStack potionStack, String potionDefinition) {
        if (potionStack == null || !(potionStack.func_77973_b() instanceof ItemPotion)) {
            return false;
        }
        int potionMeta = potionStack.func_77960_j();
        String[] potionSections = potionDefinition.split("&");
        boolean match = true;
        for (String s : potionSections) {
            if ((s = s.trim()).contains("+")) continue;
            boolean bitSet = true;
            for (char c : s.toCharArray()) {
                if (c == '!') {
                    bitSet = false;
                    continue;
                }
                if (!Character.isDigit(c)) continue;
                int value = Character.getNumericValue(c);
                match &= this.isBitSet(potionMeta, value) == bitSet;
                bitSet = true;
            }
        }
        return match;
    }

    public static int parsePotionMeta(String potionDefinition) {
        String[] potionSections = potionDefinition.split("&");
        int potionMeta = 0;
        for (String s : potionSections) {
            if ((s = s.trim()).contains("+")) continue;
            boolean bitSet = true;
            for (char c : s.toCharArray()) {
                if (c == '!') {
                    bitSet = false;
                    continue;
                }
                if (!Character.isDigit(c)) continue;
                int value = Character.getNumericValue(c);
                potionMeta = bitSet ? SpellRecipeManager.setBit(potionMeta, value) : SpellRecipeManager.clearBit(potionMeta, value);
                bitSet = true;
            }
        }
        return potionMeta;
    }

    private static int setBit(int value, int bitToSet) {
        return value |= 1 << bitToSet;
    }

    private static int clearBit(int value, int bitToSet) {
        return value &= ~(1 << bitToSet);
    }

    private boolean isBitSet(int value, int bitIndex) {
        return (value & 1 << bitIndex) != 0;
    }

    private boolean compareItemStacks(ItemStack target, ItemStack input) {
        if (target.func_77973_b() == ItemsCommonProxy.essence) {
            if (target.func_77960_j() > 12) {
                int targetMetaMask = target.func_77960_j() - 12;
                int inputMetaMask = input.func_77960_j() - 12;
                return target.func_77973_b() == input.func_77973_b() && (targetMetaMask & inputMetaMask) != 0;
            }
        }
        return target.func_77973_b() == input.func_77973_b() && (target.func_77960_j() == input.func_77960_j() || target.func_77960_j() == Short.MAX_VALUE) && target.field_77994_a >= input.field_77994_a;
    }
}

