/*
 * Decompiled with CFR 0.152.
 */
package am2.spell;

import am2.AMCore;
import am2.api.events.ManaCostEvent;
import am2.api.events.SpellCastingEvent;
import am2.api.spell.ItemSpellBase;
import am2.api.spell.component.interfaces.ISpellComponent;
import am2.api.spell.component.interfaces.ISpellModifier;
import am2.api.spell.component.interfaces.ISpellShape;
import am2.api.spell.enums.SpellCastResult;
import am2.api.spell.enums.SpellModifiers;
import am2.armor.ArmorHelper;
import am2.armor.ArsMagicaArmorMaterial;
import am2.buffs.BuffList;
import am2.entities.EntityDarkMage;
import am2.entities.EntityLightMage;
import am2.items.ItemsCommonProxy;
import am2.network.AMDataWriter;
import am2.network.AMNetHandler;
import am2.playerextensions.ExtendedProperties;
import am2.spell.SkillManager;
import am2.spell.SkillTreeManager;
import am2.spell.SpellUtils;
import am2.spell.modifiers.Colour;
import am2.utility.EntityUtilities;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public class SpellHelper {
    public static final SpellHelper instance = new SpellHelper();
    private final Random rand = new Random();

    private SpellHelper() {
    }

    public SpellCastResult applyStageToGround(ItemStack stack, EntityLivingBase caster, World world, int blockX, int blockY, int blockZ, int blockFace, double impactX, double impactY, double impactZ, int stage, boolean consumeMBR) {
        ISpellComponent[] components;
        ISpellShape stageShape = SpellUtils.instance.getShapeForStage(stack, 0);
        if (stageShape == null || stageShape == SkillManager.instance.missingShape) {
            return SpellCastResult.MALFORMED_SPELL_STACK;
        }
        for (ISpellComponent component : components = SpellUtils.instance.getComponentsForStage(stack, 0)) {
            if (SkillTreeManager.instance.isSkillDisabled(component) || !component.applyEffectBlock(stack, world, blockX, blockY, blockZ, blockFace, impactX, impactY, impactZ, caster)) continue;
            if (world.field_72995_K) {
                int color = -1;
                if (SpellUtils.instance.modifierIsPresent(SpellModifiers.COLOR, stack, 0)) {
                    ISpellModifier[] mods = SpellUtils.instance.getModifiersForStage(stack, 0);
                    int ordinalCount = 0;
                    for (ISpellModifier mod : mods) {
                        if (!(mod instanceof Colour)) continue;
                        byte[] meta = SpellUtils.instance.getModifierMetadataFromStack(stack, mod, 0, ordinalCount++);
                        color = (int)mod.getModifier(SpellModifiers.COLOR, null, null, null, meta);
                    }
                }
                component.spawnParticles(world, blockX, blockY, blockZ, caster, (Entity)caster, this.rand, color);
            }
            if (!consumeMBR) continue;
            SpellUtils.instance.doAffinityShift(caster, component, stageShape);
        }
        return SpellCastResult.SUCCESS;
    }

    public SpellCastResult applyStageToEntity(ItemStack stack, EntityLivingBase caster, World world, Entity target, int stage, boolean shiftAffinityAndXP) {
        ISpellShape stageShape = SpellUtils.instance.getShapeForStage(stack, 0);
        if (stageShape == null) {
            return SpellCastResult.MALFORMED_SPELL_STACK;
        }
        ISpellComponent[] components = SpellUtils.instance.getComponentsForStage(stack, 0);
        boolean appliedOneComponent = false;
        for (ISpellComponent component : components) {
            if (SkillTreeManager.instance.isSkillDisabled(component) || !component.applyEffectEntity(stack, world, caster, target)) continue;
            appliedOneComponent = true;
            if (world.field_72995_K) {
                int color = -1;
                if (SpellUtils.instance.modifierIsPresent(SpellModifiers.COLOR, stack, 0)) {
                    ISpellModifier[] mods = SpellUtils.instance.getModifiersForStage(stack, 0);
                    int ordinalCount = 0;
                    for (ISpellModifier mod : mods) {
                        if (!(mod instanceof Colour)) continue;
                        byte[] meta = SpellUtils.instance.getModifierMetadataFromStack(stack, mod, 0, ordinalCount++);
                        color = (int)mod.getModifier(SpellModifiers.COLOR, null, null, null, meta);
                    }
                }
                component.spawnParticles(world, target.field_70165_t, target.field_70163_u + (double)target.func_70047_e(), target.field_70161_v, caster, target, this.rand, color);
            }
            if (!shiftAffinityAndXP) continue;
            SpellUtils.instance.doAffinityShift(caster, component, stageShape);
        }
        if (appliedOneComponent) {
            return SpellCastResult.SUCCESS;
        }
        return SpellCastResult.EFFECT_FAILED;
    }

    private SpellCastingEvent.Pre preSpellCast(ItemStack stack, EntityLivingBase caster, boolean isChanneled) {
        SpellUtils.SpellRequirements reqs = SpellUtils.instance.getSpellRequirements(stack, caster);
        float manaCost = reqs.manaCost;
        float burnout = reqs.burnout;
        ArrayList<ItemStack> reagents = reqs.reagents;
        ManaCostEvent mce = new ManaCostEvent(stack, caster, manaCost, burnout);
        MinecraftForge.EVENT_BUS.post((Event)mce);
        manaCost = mce.manaCost;
        burnout = mce.burnout;
        SpellCastingEvent spellCastingEvent = new SpellCastingEvent();
        spellCastingEvent.getClass();
        SpellCastingEvent.Pre event = spellCastingEvent.new SpellCastingEvent.Pre(stack, (ItemSpellBase)stack.func_77973_b(), caster, manaCost, burnout, isChanneled);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            event.castResult = SpellCastResult.EFFECT_FAILED;
            return event;
        }
        event.castResult = SpellCastResult.SUCCESS;
        if (!SpellUtils.instance.casterHasAllReagents(caster, reagents)) {
            event.castResult = SpellCastResult.REAGENTS_MISSING;
        }
        if (!SpellUtils.instance.casterHasMana(caster, manaCost)) {
            event.castResult = SpellCastResult.NOT_ENOUGH_MANA;
        }
        return event;
    }

    public SpellCastResult applyStackStage(ItemStack stack, EntityLivingBase caster, EntityLivingBase target, double x, double y, double z, int side, World world, boolean consumeMBR, boolean giveXP, int ticksUsed) {
        if (caster.func_82165_m(BuffList.silence.field_76415_H)) {
            return SpellCastResult.SILENCED;
        }
        ItemStack parsedStack = SpellUtils.instance.constructSpellStack(stack);
        if (SpellUtils.instance.numStages(parsedStack) == 0) {
            return SpellCastResult.SUCCESS;
        }
        ISpellShape shape = SpellUtils.instance.getShapeForStage(parsedStack, 0);
        ItemSpellBase item = (ItemSpellBase)parsedStack.func_77973_b();
        if (SkillTreeManager.instance.isSkillDisabled(shape)) {
            return SpellCastResult.EFFECT_FAILED;
        }
        if (!(caster instanceof EntityPlayer)) {
            consumeMBR = false;
        }
        SpellCastingEvent.Pre checkEvent = null;
        if (consumeMBR) {
            checkEvent = this.preSpellCast(parsedStack, caster, false);
            if (checkEvent.castResult != SpellCastResult.SUCCESS) {
                if (checkEvent.castResult == SpellCastResult.NOT_ENOUGH_MANA && caster.field_70170_p.field_72995_K && caster instanceof EntityPlayer) {
                    AMCore.proxy.flashManaBar();
                }
                SpellCastingEvent spellCastingEvent = new SpellCastingEvent();
                spellCastingEvent.getClass();
                SpellCastingEvent.Post event = spellCastingEvent.new SpellCastingEvent.Post(parsedStack, (ItemSpellBase)parsedStack.func_77973_b(), caster, checkEvent.manaCost, checkEvent.burnout, false, checkEvent.castResult);
                MinecraftForge.EVENT_BUS.post((Event)event);
                return checkEvent.castResult;
            }
        }
        SpellCastResult result = SpellCastResult.MALFORMED_SPELL_STACK;
        if (shape != null) {
            result = shape.beginStackStage(item, parsedStack, caster, target, world, x, y, z, side, giveXP, ticksUsed);
            if (!world.field_72995_K) {
                AMDataWriter writer = new AMDataWriter();
                writer.add(parsedStack);
                writer.add(caster.func_145782_y());
                if (target != null) {
                    writer.add(true);
                    writer.add(target.func_145782_y());
                } else {
                    writer.add(false);
                }
                writer.add(x).add(y).add(z);
                writer.add(side);
                writer.add(ticksUsed);
                AMNetHandler.INSTANCE.sendPacketToAllClientsNear(world.field_73011_w.field_76574_g, x, y, z, 32.0, (byte)2, writer.generate());
            }
        }
        float manaCost = 0.0f;
        float burnout = 0.0f;
        if (consumeMBR) {
            manaCost = checkEvent.manaCost;
            burnout = checkEvent.burnout;
            if (result == SpellCastResult.SUCCESS_REDUCE_MANA) {
                result = SpellCastResult.SUCCESS;
                manaCost *= 0.2f;
                burnout *= 0.2f;
            }
        }
        if (result == SpellCastResult.SUCCESS) {
            String sfx;
            if (consumeMBR) {
                ExtendedProperties.For(caster).deductMana(manaCost);
                ExtendedProperties.For(caster).addBurnout(burnout);
            }
            if (world.field_72995_K && (sfx = shape.getSoundForAffinity(SpellUtils.instance.mainAffinityFor(parsedStack), parsedStack, null)) != null && !shape.isChanneled()) {
                world.func_72980_b(caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, sfx, 0.4f, world.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
            }
        }
        SpellCastingEvent spellCastingEvent = new SpellCastingEvent();
        spellCastingEvent.getClass();
        SpellCastingEvent.Post event = spellCastingEvent.new SpellCastingEvent.Post(parsedStack, (ItemSpellBase)parsedStack.func_77973_b(), caster, manaCost, burnout, false, result);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return result;
    }

    public SpellCastResult applyStackStageOnUsing(ItemStack stack, EntityLivingBase caster, EntityLivingBase target, double x, double y, double z, World world, boolean consumeMBR, boolean giveXP, int ticks) {
        if (SpellUtils.instance.numStages(stack) == 0) {
            return SpellCastResult.SUCCESS;
        }
        if (!SpellUtils.instance.spellIsChanneled(stack)) {
            return SpellCastResult.EFFECT_FAILED;
        }
        return this.applyStackStage(stack, caster, target, x, y, z, 0, world, consumeMBR, giveXP, ticks);
    }

    public boolean attackTargetSpecial(ItemStack spellStack, Entity target, DamageSource damagesource, float magnitude) {
        if (target.field_70170_p.field_72995_K) {
            return true;
        }
        EntityPlayer dmgSrcPlayer = null;
        if (damagesource.func_76364_f() != null) {
            if (damagesource.func_76364_f() instanceof EntityLivingBase) {
                EntityLivingBase source = (EntityLivingBase)damagesource.func_76364_f();
                if ((source instanceof EntityLightMage || source instanceof EntityDarkMage) && target.getClass() == EntityCreeper.class) {
                    return false;
                }
                if (source instanceof EntityLightMage && target instanceof EntityLightMage) {
                    return false;
                }
                if (source instanceof EntityDarkMage && target instanceof EntityDarkMage) {
                    return false;
                }
                if (source instanceof EntityPlayer && target instanceof EntityPlayer && !target.field_70170_p.field_72995_K && (!MinecraftServer.func_71276_C().func_71219_W() || ((EntityPlayer)target).field_71075_bZ.field_75098_d)) {
                    return false;
                }
                if (source.func_70644_a((Potion)BuffList.fury)) {
                    magnitude += 4.0f;
                }
            }
            if (damagesource.func_76364_f() instanceof EntityPlayer) {
                dmgSrcPlayer = (EntityPlayer)damagesource.func_76364_f();
                int armorSet = ArmorHelper.getFullArsMagicaArmorSet(dmgSrcPlayer);
                if (armorSet == ArsMagicaArmorMaterial.MAGE.getMaterialID()) {
                    magnitude *= 1.05f;
                } else if (armorSet == ArsMagicaArmorMaterial.BATTLEMAGE.getMaterialID()) {
                    magnitude *= 1.025f;
                } else if (armorSet == ArsMagicaArmorMaterial.ARCHMAGE.getMaterialID()) {
                    magnitude *= 1.1f;
                }
                ItemStack equipped = dmgSrcPlayer.func_71045_bC();
                if (equipped != null && equipped.func_77973_b() == ItemsCommonProxy.arcaneSpellbook) {
                    magnitude *= 1.1f;
                }
            }
        }
        if (target instanceof EntityLivingBase && EntityUtilities.isSummon((EntityLivingBase)target) && damagesource.field_76373_n.equals("magic")) {
            magnitude *= 3.0f;
        }
        Object oldItemStack = null;
        boolean success = false;
        success = target instanceof EntityDragon ? ((EntityDragon)target).func_70965_a(((EntityDragon)target).field_70987_i, damagesource, magnitude) : target.func_70097_a(damagesource, magnitude *= AMCore.config.getDamageMultiplier());
        if (dmgSrcPlayer != null && spellStack != null && target instanceof EntityLivingBase && !target.field_70170_p.field_72995_K && ((EntityLivingBase)target).func_110143_aJ() <= 0.0f && SpellUtils.instance.modifierIsPresent(SpellModifiers.DISMEMBERING_LEVEL, spellStack, 0)) {
            double chance = SpellUtils.instance.getModifiedDouble_Add(0.0, spellStack, (EntityLivingBase)dmgSrcPlayer, target, dmgSrcPlayer.field_70170_p, 0, SpellModifiers.DISMEMBERING_LEVEL);
            if (dmgSrcPlayer.field_70170_p.field_73012_v.nextDouble() <= chance) {
                this.dropHead(target, dmgSrcPlayer.field_70170_p);
            }
        }
        return success;
    }

    private void dropHead(Entity target, World world) {
        if (target.getClass() == EntitySkeleton.class) {
            if (((EntitySkeleton)target).func_82202_m() == 1) {
                this.dropHead_do(world, target.field_70165_t, target.field_70163_u, target.field_70161_v, 1);
            } else {
                this.dropHead_do(world, target.field_70165_t, target.field_70163_u, target.field_70161_v, 0);
            }
        } else if (target.getClass() == EntityZombie.class) {
            this.dropHead_do(world, target.field_70165_t, target.field_70163_u, target.field_70161_v, 2);
        } else if (target.getClass() == EntityCreeper.class) {
            this.dropHead_do(world, target.field_70165_t, target.field_70163_u, target.field_70161_v, 4);
        } else if (target instanceof EntityPlayer) {
            this.dropHead_do(world, target.field_70165_t, target.field_70163_u, target.field_70161_v, 3);
        }
    }

    private void dropHead_do(World world, double x, double y, double z, int type) {
        EntityItem item = new EntityItem(world);
        ItemStack stack = new ItemStack(Items.field_151144_bL, 1, type);
        item.func_92058_a(stack);
        item.func_70107_b(x, y, z);
        world.func_72838_d((Entity)item);
    }
}

