/*
 * Decompiled with CFR 0.152.
 */
package am2.playerextensions;

import am2.api.IAffinityData;
import am2.api.spell.enums.Affinity;
import am2.network.AMDataReader;
import am2.network.AMDataWriter;
import am2.network.AMNetHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class AffinityData
implements IExtendedEntityProperties,
IAffinityData {
    public static final String identifier = "AffinityData";
    private HashMap<Integer, Float> affinityDepths;
    public static final float MAX_DEPTH = 100.0f;
    private static final float ADJACENT_FACTOR = 0.25f;
    private static final float MINOR_OPPOSING_FACTOR = 0.5f;
    private static final float MAJOR_OPPOSING_FACTOR = 0.75f;
    private Entity entity;
    private float diminishingReturns = 1.2f;
    public float accumulatedHungerRegen = 0.0f;
    public float accumulatedLifeRegen = 0.0f;
    private boolean hasDoneFullSync = false;
    private boolean hasUpdate = false;
    private boolean forcingSync = false;
    private int ticksToSync = 0;
    private final int syncTickDelay = 100;
    private boolean isLocked = false;
    private Affinity[] highestAffinities = new Affinity[2];

    public AffinityData() {
        this.setupAffinityDefaults();
    }

    public static AffinityData For(EntityLivingBase living) {
        return (AffinityData)living.getExtendedProperties(identifier);
    }

    @Override
    public float getAffinityDepth(Affinity affinity) {
        if (affinity == Affinity.NONE) {
            return 0.0f;
        }
        return this.affinityDepths.get(affinity.ordinal()).floatValue() / 100.0f;
    }

    @Override
    public float getDiminishingReturnsFactor() {
        return this.diminishingReturns;
    }

    public void tickDiminishingReturns() {
        if (this.diminishingReturns < 1.2f) {
            this.diminishingReturns += 0.005f;
        }
    }

    public void addDiminishingReturns(boolean isChanneled) {
        this.diminishingReturns -= isChanneled ? 0.1f : 0.3f;
        if (this.diminishingReturns < 0.0f) {
            this.diminishingReturns = 0.0f;
        }
    }

    @Override
    public void setAffinityAndDepth(Affinity affinity, float depth) {
        if (affinity == Affinity.NONE) {
            return;
        }
        if (depth > 100.0f) {
            depth = 100.0f;
        }
        if (depth < 0.0f) {
            depth = 0.0f;
        }
        this.affinityDepths.put(affinity.ordinal(), Float.valueOf(depth));
        this.hasUpdate = true;
        this.updateHighestAffinities();
    }

    @Override
    public void incrementAffinity(Affinity affinity, float amt) {
        if (affinity == Affinity.NONE || this.isLocked) {
            return;
        }
        float adjacentDecrement = amt * 0.25f;
        float minorOppositeDecrement = amt * 0.5f;
        float majorOppositeDecrement = amt * 0.75f;
        this.addToAffinity(affinity, amt);
        if (this.getAffinityDepth(affinity) * 100.0f == 100.0f) {
            this.isLocked = true;
        }
        for (Affinity adjacent : affinity.getAdjacentAffinities()) {
            this.subtractFromAffinity(adjacent, adjacentDecrement);
        }
        for (Affinity minorOpposite : affinity.getMinorOpposingAffinities()) {
            this.subtractFromAffinity(minorOpposite, minorOppositeDecrement);
        }
        for (Affinity majorOpposite : affinity.getMajorOpposingAffinities()) {
            this.subtractFromAffinity(majorOpposite, majorOppositeDecrement);
        }
        Affinity directOpposite = affinity.getOpposingAffinity();
        if (directOpposite != null) {
            this.subtractFromAffinity(directOpposite, amt);
        }
        this.hasUpdate = true;
        this.updateHighestAffinities();
    }

    private void addToAffinity(Affinity affinity, float amt) {
        if (affinity == Affinity.NONE || this.isLocked) {
            return;
        }
        float existingAmt = this.affinityDepths.get(affinity.ordinal()).floatValue();
        if ((existingAmt += amt) > 100.0f) {
            existingAmt = 100.0f;
        } else if (existingAmt < 0.0f) {
            existingAmt = 0.0f;
        }
        this.affinityDepths.put(affinity.ordinal(), Float.valueOf(existingAmt));
    }

    private void subtractFromAffinity(Affinity affinity, float amt) {
        if (affinity == Affinity.NONE || this.isLocked) {
            return;
        }
        float existingAmt = this.affinityDepths.get(affinity.ordinal()).floatValue();
        if ((existingAmt -= amt) > 100.0f) {
            existingAmt = 100.0f;
        } else if (existingAmt < 0.0f) {
            existingAmt = 0.0f;
        }
        this.affinityDepths.put(affinity.ordinal(), Float.valueOf(existingAmt));
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagCompound tags = new NBTTagCompound();
        for (Integer affinity : this.affinityDepths.keySet()) {
            tags.func_74780_a(Affinity.values()[affinity].name(), (double)this.affinityDepths.get(affinity).floatValue());
        }
        compound.func_74782_a("AffinityDepthData", (NBTBase)tags);
        compound.func_74757_a("AffinityLocked", this.isLocked);
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagCompound tags = compound.func_74775_l("AffinityDepthData");
        this.setupAffinityDefaults();
        for (Affinity affinity : Affinity.values()) {
            if (!tags.func_74764_b(affinity.name())) continue;
            float depth = (float)tags.func_74769_h(affinity.name());
            this.setAffinityAndDepth(affinity, depth);
        }
        this.isLocked = compound.func_74767_n("AffinityLocked");
    }

    public void init(Entity entity, World world) {
        this.entity = entity;
    }

    private void setupAffinityDefaults() {
        this.affinityDepths = new HashMap();
        for (Affinity affinity : Affinity.values()) {
            if (affinity == Affinity.NONE) continue;
            this.affinityDepths.put(affinity.ordinal(), Float.valueOf(0.0f));
        }
        this.updateHighestAffinities();
    }

    public boolean HasDoneFullSync() {
        return this.hasDoneFullSync;
    }

    public void setFullSync() {
        this.ticksToSync = 0;
        this.hasUpdate = true;
        this.hasDoneFullSync = true;
        this.forcingSync = true;
    }

    public void setDelayedSync(int delay) {
        this.setFullSync();
        this.ticksToSync = delay;
    }

    public void forceSync() {
        this.forcingSync = true;
        this.ticksToSync = 0;
    }

    public boolean hasUpdate() {
        if (!(this.entity instanceof EntityPlayer) && !this.forcingSync) {
            return false;
        }
        --this.ticksToSync;
        if (this.ticksToSync <= 0) {
            this.ticksToSync = this.syncTickDelay;
        }
        return this.hasUpdate && this.ticksToSync == this.syncTickDelay;
    }

    private byte[] getUpdateData() {
        AMDataWriter writer = new AMDataWriter();
        writer.add(this.entity.func_145782_y());
        writer.add(this.affinityDepths.get(Affinity.AIR.ordinal()).floatValue());
        writer.add(this.affinityDepths.get(Affinity.LIGHTNING.ordinal()).floatValue());
        writer.add(this.affinityDepths.get(Affinity.ARCANE.ordinal()).floatValue());
        writer.add(this.affinityDepths.get(Affinity.FIRE.ordinal()).floatValue());
        writer.add(this.affinityDepths.get(Affinity.ENDER.ordinal()).floatValue());
        writer.add(this.affinityDepths.get(Affinity.EARTH.ordinal()).floatValue());
        writer.add(this.affinityDepths.get(Affinity.ICE.ordinal()).floatValue());
        writer.add(this.affinityDepths.get(Affinity.NATURE.ordinal()).floatValue());
        writer.add(this.affinityDepths.get(Affinity.WATER.ordinal()).floatValue());
        writer.add(this.affinityDepths.get(Affinity.LIFE.ordinal()).floatValue());
        writer.add(this.diminishingReturns);
        writer.add(this.isLocked);
        this.hasUpdate = false;
        this.forcingSync = false;
        return writer.generate();
    }

    public boolean handlePacketData(byte[] data) {
        AMDataReader rdr = new AMDataReader(data, false);
        int entID = rdr.getInt();
        if (entID != this.entity.func_145782_y()) {
            return false;
        }
        this.affinityDepths.put(Affinity.AIR.ordinal(), Float.valueOf(rdr.getFloat()));
        this.affinityDepths.put(Affinity.LIGHTNING.ordinal(), Float.valueOf(rdr.getFloat()));
        this.affinityDepths.put(Affinity.ARCANE.ordinal(), Float.valueOf(rdr.getFloat()));
        this.affinityDepths.put(Affinity.FIRE.ordinal(), Float.valueOf(rdr.getFloat()));
        this.affinityDepths.put(Affinity.ENDER.ordinal(), Float.valueOf(rdr.getFloat()));
        this.affinityDepths.put(Affinity.EARTH.ordinal(), Float.valueOf(rdr.getFloat()));
        this.affinityDepths.put(Affinity.ICE.ordinal(), Float.valueOf(rdr.getFloat()));
        this.affinityDepths.put(Affinity.NATURE.ordinal(), Float.valueOf(rdr.getFloat()));
        this.affinityDepths.put(Affinity.WATER.ordinal(), Float.valueOf(rdr.getFloat()));
        this.affinityDepths.put(Affinity.LIFE.ordinal(), Float.valueOf(rdr.getFloat()));
        this.diminishingReturns = rdr.getFloat();
        this.isLocked = rdr.getBoolean();
        this.updateHighestAffinities();
        return true;
    }

    public void handleExtendedPropertySync() {
        if (!this.HasDoneFullSync()) {
            this.setFullSync();
        }
        if (!this.entity.field_70170_p.field_72995_K && this.hasUpdate()) {
            byte[] data = this.getUpdateData();
            AMNetHandler.INSTANCE.sendPacketToAllClientsNear(this.entity.field_70170_p.field_73011_w.field_76574_g, this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v, 32.0, (byte)34, data);
        }
    }

    private void updateHighestAffinities() {
        List<Float> values = new ArrayList<Float>(this.affinityDepths.values());
        Collections.sort(values);
        values = values.subList(values.size() - 2, values.size());
        Iterator<Object> it = values.iterator();
        while (it.hasNext()) {
            Float f = it.next();
            if (Math.floor(f.floatValue() * 100.0f) / 100.0 != 0.0) continue;
            it.remove();
        }
        ArrayList<Affinity> resolvedAffinties = new ArrayList<Affinity>();
        HashMap clone = (HashMap)this.affinityDepths.clone();
        block1: for (Float f : values) {
            it = clone.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = (Map.Entry)it.next();
                if (!this.compareFloats(((Float)e.getValue()).floatValue(), f.floatValue(), 2)) continue;
                resolvedAffinties.add(Affinity.getByID((Integer)e.getKey()));
                it.remove();
                continue block1;
            }
        }
        for (int i = 0; i < this.highestAffinities.length; ++i) {
            this.highestAffinities[this.highestAffinities.length - 1 - i] = i < resolvedAffinties.size() ? (Affinity)((Object)resolvedAffinties.get(i)) : null;
        }
    }

    private boolean compareFloats(float f1, float f2, int precision) {
        float factor = 10.0f * (float)precision;
        return Math.floor(f1 * factor) / (double)factor == Math.floor(f2 * factor) / (double)factor;
    }

    public void setLocked(boolean locked) {
        this.isLocked = locked;
    }

    public List getColoredAffinityEffects(Affinity aff) {
        ArrayList<String> list = new ArrayList<String>();
        switch (aff) {
            case AIR: {
                list.add(new AffinityEffectDescriptor(this.getAffinityDepth(aff) > 0.5f, StatCollector.func_74838_a((String)"am2.affinity.agile")).toString());
                list.add(new AffinityEffectDescriptor(this.getAffinityDepth(aff) > 0.5f, StatCollector.func_74838_a((String)"am2.affinity.lightasafeather")).toString());
                break;
            }
            case ARCANE: {
                list.add(new AffinityEffectDescriptor(this.getAffinityDepth(aff) > 0.4f, StatCollector.func_74838_a((String)"am2.affinity.clearcaster")).toString());
                list.add(new AffinityEffectDescriptor(this.getAffinityDepth(aff) > 0.5f, StatCollector.func_74838_a((String)"am2.affinity.onewithmagic")).toString());
                list.add(new AffinityEffectDescriptor(this.getAffinityDepth(aff) > 0.25f, StatCollector.func_74838_a((String)"am2.affinity.magicweakness")).toString());
                break;
            }
            case EARTH: {
                list.add(new AffinityEffectDescriptor(this.getAffinityDepth(aff) > 0.1f, StatCollector.func_74838_a((String)"am2.affinity.stoneskin")).toString());
                list.add(new AffinityEffectDescriptor(this.getAffinityDepth(aff) > 0.25f, StatCollector.func_74838_a((String)"am2.affinity.solidbones")).toString());
                break;
            }
            case ENDER: {
                list.add(new AffinityEffectDescriptor(this.getAffinityDepth(aff) > 0.5f, StatCollector.func_74838_a((String)"am2.affinity.waterweakness")).toString());
                list.add(new AffinityEffectDescriptor(this.getAffinityDepth(aff) >= 1.0f, StatCollector.func_74838_a((String)"am2.affinity.sunlightweakness")).toString());
                list.add(new AffinityEffectDescriptor(this.getAffinityDepth(aff) > 0.25f, StatCollector.func_74838_a((String)"am2.affinity.poisonresistance")).toString());
                list.add(new AffinityEffectDescriptor(this.getAffinityDepth(aff) > 0.75f, StatCollector.func_74838_a((String)"am2.affinity.darkvision")).toString());
                break;
            }
            case FIRE: {
                list.add(new AffinityEffectDescriptor(this.getAffinityDepth(aff) > 0.25f, StatCollector.func_74838_a((String)"am2.affinity.fireresistance")).toString());
                list.add(new AffinityEffectDescriptor(this.getAffinityDepth(aff) > 0.25f, StatCollector.func_74838_a((String)"am2.affinity.firepunch")).toString());
                list.add(new AffinityEffectDescriptor(this.getAffinityDepth(aff) > 0.25f, StatCollector.func_74838_a((String)"am2.affinity.waterweakness")).toString());
                break;
            }
            case ICE: {
                list.add(new AffinityEffectDescriptor(this.getAffinityDepth(aff) > 0.5f, StatCollector.func_74838_a((String)"am2.affinity.waterfreeze")).toString());
                list.add(new AffinityEffectDescriptor(this.getAffinityDepth(aff) >= 1.0f, StatCollector.func_74838_a((String)"am2.affinity.lavafreeze")).toString());
                list.add(new AffinityEffectDescriptor(this.getAffinityDepth(aff) > 0.1f, StatCollector.func_74838_a((String)"am2.affinity.coldblooded")).toString());
                break;
            }
            case LIFE: {
                list.add(new AffinityEffectDescriptor(this.getAffinityDepth(aff) > 0.1f, StatCollector.func_74838_a((String)"am2.affinity.fasthealing")).toString());
                list.add(new AffinityEffectDescriptor(this.getAffinityDepth(aff) > 0.6f, StatCollector.func_74838_a((String)"am2.affinity.pacifist")).toString());
                break;
            }
            case WATER: {
                list.add(new AffinityEffectDescriptor(this.getAffinityDepth(aff) > 0.5f, StatCollector.func_74838_a((String)"am2.affinity.swiftswim")).toString());
                list.add(new AffinityEffectDescriptor(this.getAffinityDepth(aff) > 0.4f, StatCollector.func_74838_a((String)"am2.affinity.expandedlungs")).toString());
                list.add(new AffinityEffectDescriptor(this.getAffinityDepth(aff) > 0.5f, StatCollector.func_74838_a((String)"am2.affinity.fluidity")).toString());
                list.add(new AffinityEffectDescriptor(this.getAffinityDepth(aff) >= 1.0f, StatCollector.func_74838_a((String)"am2.affinity.antiendermen")).toString());
                list.add(new AffinityEffectDescriptor(this.getAffinityDepth(aff) > 0.25f, StatCollector.func_74838_a((String)"am2.affinity.fireweakness")).toString());
                break;
            }
            case NATURE: {
                list.add(new AffinityEffectDescriptor(this.getAffinityDepth(aff) > 0.5f, StatCollector.func_74838_a((String)"am2.affinity.harvester")).toString());
                list.add(new AffinityEffectDescriptor(this.getAffinityDepth(aff) > 0.5f, StatCollector.func_74838_a((String)"am2.affinity.thorns")).toString());
                list.add(new AffinityEffectDescriptor(this.getAffinityDepth(aff) >= 1.0f, StatCollector.func_74838_a((String)"am2.affinity.photosynthesis")).toString());
                list.add(new AffinityEffectDescriptor(this.getAffinityDepth(aff) > 0.1f, StatCollector.func_74838_a((String)"am2.affinity.rooted")).toString());
                break;
            }
            case LIGHTNING: {
                list.add(new AffinityEffectDescriptor(this.getAffinityDepth(aff) > 0.65f, StatCollector.func_74838_a((String)"am2.affinity.reflexes")).toString());
                list.add(new AffinityEffectDescriptor(this.getAffinityDepth(aff) > 0.25f, StatCollector.func_74838_a((String)"am2.affinity.shortcircuit")).toString());
                list.add(new AffinityEffectDescriptor(this.getAffinityDepth(aff) > 0.75f, StatCollector.func_74838_a((String)"am2.affinity.thunderpunch")).toString());
                list.add(new AffinityEffectDescriptor(this.getAffinityDepth(aff) > 0.5f, StatCollector.func_74838_a((String)"am2.affinity.fulmination")).toString());
                break;
            }
            case NONE: {
                break;
            }
        }
        return list;
    }

    public Affinity[] getHighestAffinities() {
        return this.highestAffinities;
    }

    class AffinityEffectDescriptor {
        private final boolean hasDepth;
        private final String description;

        public AffinityEffectDescriptor(boolean hasDepth, String description) {
            this.hasDepth = hasDepth;
            this.description = description;
        }

        public String toString() {
            return (this.hasDepth ? "\u00a7a" : "\u00a74") + this.description;
        }
    }
}

