/*
 * Decompiled with CFR 0.152.
 */
package am2.particles;

import am2.particles.AMParticle;
import am2.particles.ParticleController;
import java.util.Random;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;

public final class ParticleOrbitEntity
extends ParticleController {
    private final Entity target;
    private double distance;
    private final boolean rotateClockwise;
    private double targetY;
    private double curYOffset;
    private double targetDistance;
    private final double orbitSpeed;
    private double orbitAngle;
    private double orbitY = -512.0;
    private boolean ignoreYCoordinate = false;

    public ParticleOrbitEntity(AMParticle particleEffect, Entity orbitTarget, double orbitSpeed, int priority, boolean exclusive) {
        super(particleEffect, priority, exclusive);
        this.target = orbitTarget;
        this.orbitAngle = this.rand.nextInt(360);
        this.rotateClockwise = this.rand.nextBoolean();
        this.generateNewTargetY();
        this.targetDistance = 1.0 + this.rand.nextDouble() * 0.5;
        this.orbitSpeed = orbitSpeed;
    }

    public ParticleOrbitEntity setOrbitY(double orbitY) {
        this.orbitY = orbitY;
        return this;
    }

    public ParticleOrbitEntity SetTargetDistance(double targetDistance) {
        this.targetDistance = targetDistance;
        return this;
    }

    private void generateNewTargetY() {
        this.targetY = this.target != null ? new Random().nextDouble() * (double)this.target.field_70131_O : 0.0;
    }

    private void generateNewDistance() {
        this.targetDistance = this.target != null ? new Random().nextDouble() * 2.0 : 0.0;
    }

    @Override
    public void doUpdate() {
        if (this.firstTick) {
            this.curYOffset = this.particle.field_70163_u - (this.target.field_70163_u + (double)this.target.func_70047_e());
        }
        if (this.target == null || this.target.field_70128_L) {
            this.finish();
            return;
        }
        double posY = this.particle.field_70163_u;
        if (Math.abs(this.targetY - this.curYOffset) < 0.1) {
            this.generateNewTargetY();
        }
        double posX = this.target.field_70165_t + Math.cos(this.orbitAngle) * this.targetDistance;
        double posZ = this.target.field_70161_v + Math.sin(this.orbitAngle) * this.targetDistance;
        if (this.targetY < this.curYOffset) {
            this.curYOffset -= this.orbitSpeed / 4.0;
        } else if (this.targetY > this.curYOffset) {
            this.curYOffset += this.orbitSpeed / 4.0;
        }
        this.orbitAngle = this.rotateClockwise ? (this.orbitAngle += this.orbitSpeed) : (this.orbitAngle -= this.orbitSpeed);
        if (this.orbitAngle > 360.0) {
            this.orbitAngle -= 360.0;
        } else if (this.orbitAngle < 0.0) {
            this.orbitAngle += 360.0;
        }
        if (!this.ignoreYCoordinate) {
            if (this.orbitY != -512.0) {
                posY = this.target.field_70163_u + (double)this.target.func_70047_e() + this.orbitY;
            } else {
                int offset = 0;
                if (this.target instanceof EntityPlayer && !(this.target instanceof EntityClientPlayerMP)) {
                    offset = (int)((float)offset + 2.0f * this.target.field_70131_O);
                }
                posY = this.target.field_70163_u - (double)this.target.func_70047_e() + this.curYOffset + (double)offset;
            }
        }
        this.particle.func_70107_b(posX, posY, posZ);
        if (this.firstTick) {
            this.particle.field_70169_q = posX;
            this.particle.field_70167_r = posY;
            this.particle.field_70166_s = posZ;
        }
    }

    @Override
    public ParticleController clone() {
        ParticleOrbitEntity clone = new ParticleOrbitEntity(this.particle, this.target, this.orbitSpeed, this.priority, this.rotateClockwise).SetTargetDistance(this.targetDistance);
        if (this.orbitY != -512.0) {
            clone.setOrbitY(this.orbitY);
        }
        clone.setIgnoreYCoordinate(this.ignoreYCoordinate);
        return clone;
    }

    public ParticleOrbitEntity setIgnoreYCoordinate(boolean b) {
        this.ignoreYCoordinate = b;
        return this;
    }
}

