/*
 * Decompiled with CFR 0.152.
 */
package am2.network;

import am2.AMCore;
import am2.api.math.AMVector3;
import am2.api.power.IPowerNode;
import am2.blocks.tileentities.TileEntityArmorImbuer;
import am2.blocks.tileentities.TileEntityInscriptionTable;
import am2.blocks.tileentities.TileEntityMagiciansWorkbench;
import am2.blocks.tileentities.TileEntityParticleEmitter;
import am2.containers.ContainerMagiciansWorkbench;
import am2.containers.ContainerSpellCustomization;
import am2.items.ContainerKeystone;
import am2.items.ItemSpellBook;
import am2.items.ItemsCommonProxy;
import am2.network.AMDataReader;
import am2.network.AMDataWriter;
import am2.network.AMNetHandler;
import am2.playerextensions.ExtendedProperties;
import am2.playerextensions.SkillData;
import am2.power.PowerNodeRegistry;
import am2.spell.SpellUtils;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.server.FMLServerHandler;
import io.netty.buffer.ByteBufInputStream;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class AMPacketProcessorServer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SubscribeEvent
    public void onServerPacketData(FMLNetworkEvent.ServerCustomPacketEvent event) {
        ByteBufInputStream bbis = new ByteBufInputStream(event.packet.payload());
        int packetID = -1;
        try {
            if (event.packet.getTarget() != Side.SERVER) {
                return;
            }
            packetID = bbis.readByte();
            NetHandlerPlayServer srv = (NetHandlerPlayServer)event.packet.handler();
            EntityPlayerMP player = srv.field_147369_b;
            byte[] remaining = new byte[bbis.available()];
            bbis.readFully(remaining);
            switch (packetID) {
                case 1: {
                    this.handleCastingModeChange(remaining, player);
                    return;
                }
                case 3: {
                    this.handleMagicLevelUp(remaining, player);
                    return;
                }
                case 17: {
                    this.handleSyncBetaParticles(remaining, player);
                    return;
                }
                case 29: {
                    this.handlePossibleClientExpropDesync(remaining);
                    return;
                }
                case 31: {
                    this.handleRequestBetaParticles(remaining, player);
                    return;
                }
                case 32: {
                    this.handleSpellCustomize(remaining, player);
                    return;
                }
                case 14: {
                    this.handleSpellBookChangeActiveSlot(remaining, player);
                    return;
                }
                case 27: {
                    this.handleSyncSpellKnowledge(remaining, player);
                    return;
                }
                case 35: {
                    this.handleDecoBlockUpdate(remaining, player);
                    return;
                }
                case 36: {
                    this.handleInscriptionTableUpdate(remaining, player);
                    return;
                }
                case 39: {
                    ExtendedProperties.For((EntityLivingBase)player).TK_Distance = new AMDataReader(remaining).getFloat();
                    return;
                }
                case 40: {
                    this.handleSaveKeystoneCombo(remaining, player);
                    return;
                }
                case 41: {
                    this.handleSetKeystoneCombo(remaining, player);
                    return;
                }
                case 45: {
                    this.handleSetMagiciansWorkbenchRecipe(remaining, player);
                    return;
                }
                case 51: {
                    this.handleRuneBagGUIOpen(remaining, player);
                    return;
                }
                case 52: {
                    this.handleMBenchLockRecipe(remaining, player);
                    return;
                }
                case 54: {
                    this.handleImbueArmor(remaining, player);
                    return;
                }
                case 53: {
                    this.handlePowerPathSync(remaining, player);
                    return;
                }
                case 16: {
                    this.handleExpropOperation(remaining, player);
                    return;
                }
            }
            return;
        }
        catch (Throwable t) {
            FMLLog.severe((String)"Ars Magica >> Server Packet Failed to Handle!", (Object[])new Object[0]);
            FMLLog.severe((String)("Ars Magica >> Packet Type: " + packetID), (Object[])new Object[0]);
            t.printStackTrace();
            return;
        }
        finally {
            try {
                if (bbis != null) {
                    bbis.close();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private void handleExpropOperation(byte[] data, EntityPlayerMP player) {
        ExtendedProperties.For((EntityLivingBase)player).performRemoteOp(new AMDataReader(data, false).getInt());
    }

    private void handlePowerPathSync(byte[] data, EntityPlayerMP player) {
        AMDataReader rdr = new AMDataReader(data, false);
        byte nom = rdr.getByte();
        if (nom == 1) {
            AMVector3 loc = new AMVector3(rdr.getFloat(), rdr.getFloat(), rdr.getFloat());
            TileEntity te = player.field_70170_p.func_147438_o((int)loc.x, (int)loc.y, (int)loc.z);
            if (te != null && te instanceof IPowerNode) {
                AMNetHandler.INSTANCE.sendPowerResponseToClient(PowerNodeRegistry.For(player.field_70170_p).getDataCompoundForNode((IPowerNode)te), player, te);
            }
        }
    }

    private void handleImbueArmor(byte[] data, EntityPlayerMP player) {
        AMDataReader rdr = new AMDataReader(data, false);
        TileEntity te = player.field_70170_p.func_147438_o(rdr.getInt(), rdr.getInt(), rdr.getInt());
        if (te != null && te instanceof TileEntityArmorImbuer) {
            ((TileEntityArmorImbuer)te).imbueCurrentArmor(rdr.getString());
        }
    }

    private void handleMBenchLockRecipe(byte[] data, EntityPlayerMP player) {
        int z;
        int y;
        AMDataReader rdr = new AMDataReader(data, false);
        int x = rdr.getInt();
        TileEntity te = player.field_70170_p.func_147438_o(x, y = rdr.getInt(), z = rdr.getInt());
        if (te != null && te instanceof TileEntityMagiciansWorkbench) {
            ((TileEntityMagiciansWorkbench)te).setRecipeLocked(rdr.getInt(), rdr.getBoolean());
            te.func_145831_w().func_147471_g(te.field_145851_c, te.field_145848_d, te.field_145849_e);
        }
    }

    private void handleRuneBagGUIOpen(byte[] data, EntityPlayerMP player) {
        AMDataReader rdr = new AMDataReader(data, false);
        int entityID = rdr.getInt();
        if (player == null) {
            return;
        }
        player.openGui((Object)AMCore.instance, 20, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
    }

    private void handleSetMagiciansWorkbenchRecipe(byte[] data, EntityPlayerMP player) {
        if (player.field_71070_bA != null && player.field_71070_bA instanceof ContainerMagiciansWorkbench) {
            ((ContainerMagiciansWorkbench)player.field_71070_bA).moveRecipeToCraftingGrid(new AMDataReader(data).getInt());
        }
    }

    private void handleSetKeystoneCombo(byte[] data, EntityPlayerMP player) {
        if (player.field_71070_bA instanceof ContainerKeystone) {
            AMDataReader rdr = new AMDataReader(data, false);
            ((ContainerKeystone)player.field_71070_bA).setInventoryToCombination(rdr.getInt());
        }
    }

    private void handleSaveKeystoneCombo(byte[] data, EntityPlayerMP player) {
        if (player.field_71070_bA instanceof ContainerKeystone) {
            AMDataReader rdr = new AMDataReader(data, false);
            boolean add = rdr.getBoolean();
            String name = rdr.getString();
            int[] metas = new int[]{rdr.getInt(), rdr.getInt(), rdr.getInt()};
            if (add) {
                ItemsCommonProxy.keystone.addCombination(((ContainerKeystone)player.field_71070_bA).getKeystoneStack(), name, metas);
            } else {
                ItemsCommonProxy.keystone.removeCombination(((ContainerKeystone)player.field_71070_bA).getKeystoneStack(), name);
            }
        }
    }

    private void handleInscriptionTableUpdate(byte[] data, EntityPlayerMP player) {
        World world = player.field_70170_p;
        AMDataReader rdr = new AMDataReader(data, false);
        TileEntity te = world.func_147438_o(rdr.getInt(), rdr.getInt(), rdr.getInt());
        if (te == null || !(te instanceof TileEntityInscriptionTable)) {
            return;
        }
        ((TileEntityInscriptionTable)te).HandleUpdatePacket(rdr.getRemainingBytes());
        world.func_147471_g(te.field_145851_c, te.field_145848_d, te.field_145849_e);
    }

    private void handleDecoBlockUpdate(byte[] data, EntityPlayerMP player) {
        World world = player.field_70170_p;
        AMDataReader rdr = new AMDataReader(data, false);
        TileEntity te = world.func_147438_o(rdr.getInt(), rdr.getInt(), rdr.getInt());
        if (te == null || !(te instanceof TileEntityParticleEmitter)) {
            return;
        }
        ((TileEntityParticleEmitter)te).func_145839_a(rdr.getNBTTagCompound());
        world.func_147471_g(te.field_145851_c, te.field_145848_d, te.field_145849_e);
    }

    private void handleSyncSpellKnowledge(byte[] data, EntityPlayerMP player) {
        SkillData.For((EntityPlayer)player).handlePacketData(data);
    }

    private void handleSpellBookChangeActiveSlot(byte[] data, EntityPlayerMP player) {
        AMDataReader rdr = new AMDataReader(data, false);
        byte subID = rdr.getByte();
        int entityID = rdr.getInt();
        int inventorySlot = rdr.getInt();
        ItemStack stack = player.field_71071_by.func_70301_a(inventorySlot);
        if (stack == null || !(stack.func_77973_b() instanceof ItemSpellBook)) {
            return;
        }
        int newIndex = 0;
        if (subID == 0) {
            newIndex = ItemsCommonProxy.spellBook.SetNextSlot(stack);
        } else if (subID == 1) {
            newIndex = ItemsCommonProxy.spellBook.SetPrevSlot(stack);
        } else {
            return;
        }
    }

    private void handleSpellCustomize(byte[] data, EntityPlayerMP player) {
        AMDataReader rdr = new AMDataReader(data, false);
        int entityID = rdr.getInt();
        EntityLivingBase ent = this.getEntityByID(entityID);
        if (player == null) {
            return;
        }
        int IIconIndex = rdr.getInt();
        String name = rdr.getString();
        if (player.field_71070_bA instanceof ContainerSpellCustomization) {
            ((ContainerSpellCustomization)player.field_71070_bA).setNameAndIndex(name, IIconIndex);
        }
    }

    private void handleRequestBetaParticles(byte[] data, EntityPlayerMP player) {
        AMDataReader rdr = new AMDataReader(data, false);
        int requesterID = rdr.getInt();
        int entityID = rdr.getInt();
        EntityLivingBase entity = this.getEntityByID(entityID);
        if (player == null || entity == null || !(entity instanceof EntityPlayer)) {
            return;
        }
        if (!AMCore.proxy.playerTracker.hasAA((EntityPlayer)entity)) {
            return;
        }
        byte[] expropData = ExtendedProperties.For(entity).getAuraData();
        AMDataWriter writer = new AMDataWriter();
        writer.add(entity.func_145782_y());
        writer.add(expropData);
        AMNetHandler.INSTANCE.sendPacketToClientPlayer(player, (byte)31, writer.generate());
    }

    private void handlePossibleClientExpropDesync(byte[] data) {
        ExtendedProperties props;
        AMDataReader rdr = new AMDataReader(data, false);
        int entityID = rdr.getInt();
        EntityLivingBase e = this.getEntityByID(entityID);
        if (e != null && e instanceof EntityPlayer && !(props = ExtendedProperties.For(e)).detectPossibleDesync()) {
            props.setFullSync();
            props.forceSync();
        }
    }

    private void handleSyncBetaParticles(byte[] data, EntityPlayerMP player) {
        AMDataReader rdr = new AMDataReader(data, false);
        if (player == null || !AMCore.proxy.playerTracker.hasAA((EntityPlayer)player)) {
            return;
        }
        int index = rdr.getInt();
        int behaviour = rdr.getInt();
        float scale = rdr.getFloat();
        float alpha = rdr.getFloat();
        boolean randomColor = rdr.getBoolean();
        boolean defaultColor = rdr.getBoolean();
        int color = rdr.getInt();
        int delay = rdr.getInt();
        int quantity = rdr.getInt();
        float speed = rdr.getFloat();
        ExtendedProperties.For((EntityLivingBase)player).updateAuraData(index, behaviour, scale, alpha, randomColor, defaultColor, color, delay, quantity, speed);
    }

    private void handleCastingModeChange(byte[] data, EntityPlayerMP player) {
        AMDataReader rdr = new AMDataReader(data, false);
        int newShapeGroupOrdinal = rdr.getInt();
        int index = rdr.getInt();
        ItemStack stack = player.func_71045_bC();
        if (stack != null) {
            if (stack.func_77973_b() == ItemsCommonProxy.spell) {
                SpellUtils.instance.setShapeGroup(stack, newShapeGroupOrdinal);
            } else if (stack.func_77973_b() == ItemsCommonProxy.spellBook || stack.func_77973_b() == ItemsCommonProxy.arcaneSpellbook) {
                ItemStack spellStack = ((ItemSpellBook)stack.func_77973_b()).GetActiveItemStack(stack);
                SpellUtils.instance.setShapeGroup(spellStack, newShapeGroupOrdinal);
                ((ItemSpellBook)stack.func_77973_b()).replaceAciveItemStack(stack, spellStack);
            }
        }
    }

    private void handleMagicLevelUp(byte[] data, EntityPlayerMP player) {
    }

    public WorldServer[] getWorldServers() {
        return FMLServerHandler.instance().getServer().field_71305_c;
    }

    public EntityLivingBase getEntityByID(int entityID) {
        return AMCore.proxy.getEntityByID(entityID);
    }
}

