/*
 * Decompiled with CFR 0.152.
 */
package am2.lore;

import am2.guis.GuiArcaneCompendium;
import am2.lore.CompendiumEntry;
import am2.lore.CompendiumEntryTypes;
import am2.multiblock.IMultiblockStructureController;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CompendiumEntryStructure
extends CompendiumEntry {
    private String controllerClass;

    public CompendiumEntryStructure() {
        super(CompendiumEntryTypes.instance.STRUCTURE);
    }

    @Override
    protected void parseEx(Node node) {
        NodeList childNodes = node.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (!child.getNodeName().equals("controller")) continue;
            this.controllerClass = child.getTextContent();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected GuiArcaneCompendium getCompendiumGui(String searchID, int meta) {
        Class tileEntityClass;
        if (this.controllerClass != null && (tileEntityClass = (Class)((Map)ReflectionHelper.getPrivateValue(TileEntity.class, null, (int)1)).get(this.controllerClass)) != null && IMultiblockStructureController.class.isAssignableFrom(tileEntityClass)) {
            try {
                TileEntity te = (TileEntity)tileEntityClass.newInstance();
                return new GuiArcaneCompendium(((IMultiblockStructureController)te).getDefinition(), te);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return new GuiArcaneCompendium(searchID);
    }

    @Override
    public ItemStack getRepresentItemStack(String searchID, int meta) {
        return null;
    }
}

