/*
 * Decompiled with CFR 0.152.
 */
package am2.items.renderers;

import am2.api.spell.enums.Affinity;
import am2.bosses.models.ModelPlantGuardianSickle;
import am2.items.ItemsCommonProxy;
import am2.items.renderers.SpellScrollRenderer;
import am2.proxy.gui.ModelLibrary;
import am2.texture.ResourceManager;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class CustomItemRenderer
implements IItemRenderer {
    private Minecraft mc = Minecraft.func_71410_x();
    private static final ResourceLocation sickleLocation = new ResourceLocation("arsmagica2", ResourceManager.getMobTexturePath("bosses/plant_guardian.png"));
    private static final ResourceLocation arcaneBookLocation = new ResourceLocation("arsmagica2", ResourceManager.getMobTexturePath("bosses/arcane_guardian.png"));
    private static final ResourceLocation winterArmLocation = new ResourceLocation("arsmagica2", ResourceManager.getMobTexturePath("bosses/ice_guardian.png"));
    private static final ResourceLocation airLocation = new ResourceLocation("arsmagica2", ResourceManager.getMobTexturePath("bosses/air_guardian.png"));
    private static final ResourceLocation waterLocation = new ResourceLocation("arsmagica2", ResourceManager.getMobTexturePath("bosses/water_guardian.png"));
    private static final ResourceLocation fireLocation = new ResourceLocation("arsmagica2", ResourceManager.getMobTexturePath("bosses/fire_guardian.png"));
    private static final ResourceLocation earthLocation = new ResourceLocation("arsmagica2", ResourceManager.getMobTexturePath("bosses/earth_guardian.png"));
    private static final ResourceLocation broomLocation = new ResourceLocation("arsmagica2", ResourceManager.getMobTexturePath("broom.png"));
    private static final ResourceLocation candleLocation = new ResourceLocation("arsmagica2", ResourceManager.getCustomBlockTexturePath("candle.png"));
    protected ModelPlantGuardianSickle modelSickle = new ModelPlantGuardianSickle();
    public static final CustomItemRenderer instance = new CustomItemRenderer();

    private CustomItemRenderer() {
        this.modelSickle.setNoSpin();
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type == IItemRenderer.ItemRenderType.ENTITY || type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON || type == IItemRenderer.ItemRenderType.INVENTORY;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        this.bindTextureByItem(item);
        GL11.glPushMatrix();
        this.setupItemRender(type, item);
        this.renderModelByItem(item);
        GL11.glPopMatrix();
        if (item.func_77973_b() == ItemsCommonProxy.wardingCandle && (type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON)) {
            this.renderCandleFlame(type, item, data);
        }
    }

    private void renderCandleFlame(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (item.func_77942_o()) {
            GL11.glColor3f((float)item.field_77990_d.func_74760_g("flame_red"), (float)item.field_77990_d.func_74760_g("flame_green"), (float)item.field_77990_d.func_74760_g("flame_blue"));
        }
        GL11.glPushMatrix();
        if (type == IItemRenderer.ItemRenderType.EQUIPPED) {
            GL11.glTranslatef((float)0.2f, (float)1.0f, (float)0.0f);
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        } else if (type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            GL11.glTranslatef((float)-1.5f, (float)1.85f, (float)0.9f);
            GL11.glScalef((float)0.15f, (float)0.15f, (float)0.15f);
        }
        SpellScrollRenderer.instance.renderEffect(Affinity.FIRE, false, data);
        GL11.glPopMatrix();
    }

    private void setupItemRender(IItemRenderer.ItemRenderType type, ItemStack stack) {
        float scale = 1.0f;
        switch (type) {
            case ENTITY: {
                if (stack.func_77973_b() == ItemsCommonProxy.magicBroom) {
                    GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-3.0f);
                } else if (stack.func_77973_b() == ItemsCommonProxy.arcaneSpellbook) {
                    GL11.glTranslatef((float)0.0f, (float)0.6f, (float)0.0f);
                } else if (stack.func_77973_b() == ItemsCommonProxy.earthGuardianArmor) {
                    GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-3.0f);
                } else if (stack.func_77973_b() == ItemsCommonProxy.fireEars) {
                    GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-1.0f);
                } else if (stack.func_77973_b() == ItemsCommonProxy.waterGuardianOrbs) {
                    GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2.0f);
                } else if (stack.func_77973_b() == ItemsCommonProxy.airGuardianLower) {
                    GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2.0f);
                } else if (stack.func_77973_b() == ItemsCommonProxy.wardingCandle) {
                    GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-3.0f);
                }
                scale = 1.6f;
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                if (stack.func_77973_b() == ItemsCommonProxy.magicBroom) {
                    GL11.glRotatef((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glTranslatef((float)-0.5f, (float)1.0f, (float)0.0f);
                    break;
                }
                if (stack.func_77973_b() == ItemsCommonProxy.arcaneSpellbook) {
                    GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glTranslatef((float)0.5f, (float)1.0f, (float)-0.5f);
                    break;
                }
                if (stack.func_77973_b() == ItemsCommonProxy.winterGuardianArm) {
                    GL11.glRotatef((float)60.0f, (float)1.0f, (float)-0.6f, (float)0.0f);
                    GL11.glTranslatef((float)1.0f, (float)0.5f, (float)-1.0f);
                    break;
                }
                if (stack.func_77973_b() == ItemsCommonProxy.winterGuardianArm) {
                    GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-1.0f);
                    break;
                }
                if (stack.func_77973_b() == ItemsCommonProxy.earthGuardianArmor) {
                    GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glTranslatef((float)0.0f, (float)0.7f, (float)-2.0f);
                    break;
                }
                if (stack.func_77973_b() == ItemsCommonProxy.fireEars) {
                    GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glTranslatef((float)-0.8f, (float)1.2f, (float)-1.0f);
                    break;
                }
                if (stack.func_77973_b() == ItemsCommonProxy.waterGuardianOrbs) {
                    GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glTranslatef((float)0.0f, (float)0.8f, (float)-0.5f);
                    break;
                }
                if (stack.func_77973_b() == ItemsCommonProxy.airGuardianLower) {
                    GL11.glTranslatef((float)0.0f, (float)0.8f, (float)-0.8f);
                    break;
                }
                if (stack.func_77973_b() == ItemsCommonProxy.wardingCandle) {
                    GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glTranslatef((float)-1.0f, (float)0.75f, (float)-3.5f);
                    break;
                }
                GL11.glRotatef((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslatef((float)-0.55f, (float)-0.35f, (float)-1.0f);
                break;
            }
            case EQUIPPED: {
                scale = 1.6f;
                GL11.glRotatef((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                if (stack.func_77973_b() == ItemsCommonProxy.magicBroom) {
                    GL11.glRotatef((float)20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glTranslatef((float)-0.3f, (float)0.0f, (float)-1.5f);
                    break;
                }
                if (stack.func_77973_b() == ItemsCommonProxy.arcaneSpellbook) {
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)120.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glTranslatef((float)-0.05f, (float)0.1f, (float)-1.0f);
                    break;
                }
                if (stack.func_77973_b() == ItemsCommonProxy.winterGuardianArm) {
                    GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-1.0f);
                    break;
                }
                if (stack.func_77973_b() == ItemsCommonProxy.earthGuardianArmor) {
                    GL11.glRotatef((float)60.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glTranslatef((float)-1.0f, (float)-1.0f, (float)-1.2f);
                    break;
                }
                if (stack.func_77973_b() == ItemsCommonProxy.fireEars) {
                    GL11.glTranslatef((float)0.0f, (float)0.15f, (float)-2.0f);
                    break;
                }
                if (stack.func_77973_b() == ItemsCommonProxy.waterGuardianOrbs) {
                    GL11.glRotatef((float)45.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)-0.7f, (float)-0.7f, (float)-3.0f);
                    break;
                }
                if (stack.func_77973_b() == ItemsCommonProxy.airGuardianLower) {
                    GL11.glTranslatef((float)0.0f, (float)0.2f, (float)-2.5f);
                    break;
                }
                if (stack.func_77973_b() == ItemsCommonProxy.wardingCandle) {
                    GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glTranslatef((float)-0.3f, (float)-0.75f, (float)-3.5f);
                    break;
                }
                GL11.glRotatef((float)60.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)-0.55f, (float)-0.75f, (float)-1.0f);
                break;
            }
            case INVENTORY: {
                scale = 0.5f;
                GL11.glTranslatef((float)0.25f, (float)0.0f, (float)0.0f);
                if (stack.func_77973_b() == ItemsCommonProxy.magicBroom) {
                    GL11.glRotatef((float)50.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glTranslatef((float)-0.5f, (float)0.0f, (float)-1.5f);
                    scale = 1.0f;
                    break;
                }
                if (stack.func_77973_b() == ItemsCommonProxy.winterGuardianArm) {
                    scale = 1.0f;
                    GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.0f);
                    break;
                }
                if (stack.func_77973_b() == ItemsCommonProxy.arcaneSpellbook) {
                    GL11.glRotatef((float)240.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)45.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glTranslatef((float)0.2f, (float)0.1f, (float)0.0f);
                    break;
                }
                if (stack.func_77973_b() == ItemsCommonProxy.earthGuardianArmor) {
                    GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    scale = 1.0f;
                    GL11.glTranslatef((float)0.2f, (float)0.8f, (float)-1.6f);
                    break;
                }
                if (stack.func_77973_b() == ItemsCommonProxy.fireEars) {
                    GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.7f);
                    scale = 1.7f;
                    GL11.glTranslatef((float)0.2f, (float)0.2f, (float)-0.8f);
                    break;
                }
                if (stack.func_77973_b() == ItemsCommonProxy.waterGuardianOrbs) {
                    GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)1.0f);
                    scale = 1.2f;
                    GL11.glTranslatef((float)-0.4f, (float)0.3f, (float)-0.4f);
                    break;
                }
                if (stack.func_77973_b() == ItemsCommonProxy.airGuardianLower) {
                    scale = 2.4f;
                    GL11.glTranslatef((float)0.0f, (float)0.45f, (float)-1.75f);
                    break;
                }
                if (stack.func_77973_b() != ItemsCommonProxy.wardingCandle) break;
                scale = 2.4f;
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)-0.5f, (float)0.0f, (float)-4.0f);
            }
        }
        if (stack.func_77973_b() == ItemsCommonProxy.arcaneSpellbook) {
            scale = 3.5f;
        } else if (stack.func_77973_b() != ItemsCommonProxy.winterGuardianArm) {
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)0.3f, (float)0.75f, (float)0.0f);
        }
        GL11.glScalef((float)scale, (float)scale, (float)scale);
    }

    private void renderSickle(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        switch (type) {
            case ENTITY: {
                this.renderModelByItem(item);
                break;
            }
            case EQUIPPED: {
                this.renderModelByItem(item);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                this.renderModelByItem(item);
                break;
            }
            case FIRST_PERSON_MAP: {
                return;
            }
            case INVENTORY: {
                this.renderModelByItem(item);
            }
        }
    }

    private void renderModelByItem(ItemStack stack) {
        if (stack == null) {
            return;
        }
        if (stack.func_77973_b() == ItemsCommonProxy.scythe) {
            ModelLibrary.instance.sickle.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        } else if (stack.func_77973_b() == ItemsCommonProxy.magicBroom) {
            ModelLibrary.instance.magicBroom.func_78088_a((Entity)ModelLibrary.instance.dummyBroom, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        } else if (stack.func_77973_b() == ItemsCommonProxy.arcaneSpellbook) {
            ModelLibrary.instance.dummyArcaneSpellbook.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        } else if (stack.func_77973_b() == ItemsCommonProxy.winterGuardianArm) {
            ModelLibrary.instance.winterGuardianArm.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        } else if (stack.func_77973_b() == ItemsCommonProxy.airGuardianLower) {
            ModelLibrary.instance.airSled.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        } else if (stack.func_77973_b() == ItemsCommonProxy.waterGuardianOrbs) {
            ModelLibrary.instance.waterOrbs.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        } else if (stack.func_77973_b() == ItemsCommonProxy.fireEars) {
            ModelLibrary.instance.fireEars.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        } else if (stack.func_77973_b() == ItemsCommonProxy.earthGuardianArmor) {
            ModelLibrary.instance.earthArmor.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        } else if (stack.func_77973_b() == ItemsCommonProxy.wardingCandle) {
            ModelLibrary.instance.wardingCandle.render(0.0625f);
        }
    }

    private void bindTextureByItem(ItemStack stack) {
        if (stack == null) {
            return;
        }
        if (stack.func_77973_b() == ItemsCommonProxy.scythe) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(sickleLocation);
        } else if (stack.func_77973_b() == ItemsCommonProxy.magicBroom) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(broomLocation);
        } else if (stack.func_77973_b() == ItemsCommonProxy.arcaneSpellbook) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(arcaneBookLocation);
        } else if (stack.func_77973_b() == ItemsCommonProxy.winterGuardianArm) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(winterArmLocation);
        } else if (stack.func_77973_b() == ItemsCommonProxy.airGuardianLower) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(airLocation);
        } else if (stack.func_77973_b() == ItemsCommonProxy.waterGuardianOrbs) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(waterLocation);
        } else if (stack.func_77973_b() == ItemsCommonProxy.fireEars) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(fireLocation);
        } else if (stack.func_77973_b() == ItemsCommonProxy.earthGuardianArmor) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(earthLocation);
        } else if (stack.func_77973_b() == ItemsCommonProxy.wardingCandle) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(candleLocation);
        }
    }
}

