/*
 * Decompiled with CFR 0.152.
 */
package am2.items;

import am2.items.ArsMagicaItem;
import am2.items.ItemsCommonProxy;
import am2.playerextensions.ExtendedProperties;
import am2.texture.ResourceManager;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemManaPotionBundle
extends ArsMagicaItem {
    private IIcon[] icons;
    private final String[] textureFiles = new String[]{"potion_bundle_lesser", "potion_bundle_standard", "potion_bundle_greater", "potion_bundle_epic", "potion_bundle_legendary"};

    public ItemManaPotionBundle() {
        this.func_77656_e(0);
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.icons = new IIcon[this.textureFiles.length];
        for (int i = 0; i < this.textureFiles.length; ++i) {
            this.icons[i] = ResourceManager.RegisterTexture(this.textureFiles[i], par1IconRegister);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int par1) {
        Item potion = this.getPotion(par1);
        if (potion == ItemsCommonProxy.lesserManaPotion) {
            return this.icons[0];
        }
        if (potion == ItemsCommonProxy.standardManaPotion) {
            return this.icons[1];
        }
        if (potion == ItemsCommonProxy.greaterManaPotion) {
            return this.icons[2];
        }
        if (potion == ItemsCommonProxy.epicManaPotion) {
            return this.icons[3];
        }
        if (potion == ItemsCommonProxy.legendaryManaPotion) {
            return this.icons[4];
        }
        return this.icons[0];
    }

    private Item getPotion(int damage) {
        int id = damage >> 8;
        switch (id) {
            case 0: {
                return ItemsCommonProxy.lesserManaPotion;
            }
            case 1: {
                return ItemsCommonProxy.standardManaPotion;
            }
            case 2: {
                return ItemsCommonProxy.greaterManaPotion;
            }
            case 3: {
                return ItemsCommonProxy.epicManaPotion;
            }
            case 4: {
                return ItemsCommonProxy.legendaryManaPotion;
            }
        }
        return ItemsCommonProxy.lesserManaPotion;
    }

    private int getUses(int damage) {
        return damage & 0xF;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 32;
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.drink;
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        ExtendedProperties props = ExtendedProperties.For((EntityLivingBase)par3EntityPlayer);
        if (props.getCurrentMana() < props.getMaxMana()) {
            par3EntityPlayer.func_71008_a(par1ItemStack, this.func_77626_a(par1ItemStack));
        }
        return par1ItemStack;
    }

    public ItemStack func_77654_b(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        Item potion = this.getPotion(par1ItemStack.func_77960_j());
        if (potion == ItemsCommonProxy.lesserManaPotion) {
            ItemsCommonProxy.lesserManaPotion.func_77654_b(par1ItemStack, par2World, par3EntityPlayer);
        } else if (potion == ItemsCommonProxy.standardManaPotion) {
            ItemsCommonProxy.standardManaPotion.func_77654_b(par1ItemStack, par2World, par3EntityPlayer);
        } else if (potion == ItemsCommonProxy.greaterManaPotion) {
            ItemsCommonProxy.greaterManaPotion.func_77654_b(par1ItemStack, par2World, par3EntityPlayer);
        } else if (potion == ItemsCommonProxy.epicManaPotion) {
            ItemsCommonProxy.epicManaPotion.func_77654_b(par1ItemStack, par2World, par3EntityPlayer);
        } else if (potion == ItemsCommonProxy.legendaryManaPotion) {
            ItemsCommonProxy.legendaryManaPotion.func_77654_b(par1ItemStack, par2World, par3EntityPlayer);
        }
        par1ItemStack.func_77964_b((par1ItemStack.func_77960_j() >> 8 << 8) + this.getUses(par1ItemStack.func_77960_j()) - 1);
        if (this.getUses(par1ItemStack.func_77960_j()) == 0) {
            this.giveOrDropItem(par3EntityPlayer, new ItemStack(Items.field_151007_F));
            par3EntityPlayer.field_71071_by.func_70299_a(par3EntityPlayer.field_71071_by.field_70461_c, null);
        }
        this.giveOrDropItem(par3EntityPlayer, new ItemStack(Items.field_151069_bo));
        return par1ItemStack;
    }

    private void giveOrDropItem(EntityPlayer player, ItemStack stack) {
        if (!player.field_71071_by.func_70441_a(stack)) {
            player.func_71019_a(stack, true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        Item potion = this.getPotion(par1ItemStack.func_77960_j());
        if (potion == ItemsCommonProxy.lesserManaPotion) {
            par3List.add("Lesser Mana Restoration");
        } else if (potion == ItemsCommonProxy.standardManaPotion) {
            par3List.add("Standard Mana Restoration");
        } else if (potion == ItemsCommonProxy.greaterManaPotion) {
            par3List.add("Greater Mana Restoration");
        } else if (potion == ItemsCommonProxy.epicManaPotion) {
            par3List.add("Epic Mana Restoration");
        } else if (potion == ItemsCommonProxy.legendaryManaPotion) {
            par3List.add("Legendary Mana Restoration");
        }
        par3List.add("" + this.getUses(par1ItemStack.func_77960_j()) + " " + StatCollector.func_74838_a((String)"am2.tooltip.uses") + ".");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack((Item)ItemsCommonProxy.manaPotionBundle, 1, 3));
        par3List.add(new ItemStack((Item)ItemsCommonProxy.manaPotionBundle, 1, 259));
        par3List.add(new ItemStack((Item)ItemsCommonProxy.manaPotionBundle, 1, 515));
        par3List.add(new ItemStack((Item)ItemsCommonProxy.manaPotionBundle, 1, 771));
        par3List.add(new ItemStack((Item)ItemsCommonProxy.manaPotionBundle, 1, 1027));
    }

    public String func_77653_i(ItemStack par1ItemStack) {
        Item potion = this.getPotion(par1ItemStack.func_77960_j());
        if (potion == ItemsCommonProxy.lesserManaPotion) {
            return String.format("%s %s", StatCollector.func_74838_a((String)"item.arsmagica2:mana_potion_lesser.name"), StatCollector.func_74838_a((String)"item.arsmagica2:potionBundle.name"));
        }
        if (potion == ItemsCommonProxy.standardManaPotion) {
            return String.format("%s %s", StatCollector.func_74838_a((String)"item.arsmagica2:mana_potion_standard.name"), StatCollector.func_74838_a((String)"item.arsmagica2:potionBundle.name"));
        }
        if (potion == ItemsCommonProxy.greaterManaPotion) {
            return String.format("%s %s", StatCollector.func_74838_a((String)"item.arsmagica2:mana_potion_greater.name"), StatCollector.func_74838_a((String)"item.arsmagica2:potionBundle.name"));
        }
        if (potion == ItemsCommonProxy.epicManaPotion) {
            return String.format("%s %s", StatCollector.func_74838_a((String)"item.arsmagica2:mana_potion_epic.name"), StatCollector.func_74838_a((String)"item.arsmagica2:potionBundle.name"));
        }
        if (potion == ItemsCommonProxy.legendaryManaPotion) {
            return String.format("%s %s", StatCollector.func_74838_a((String)"item.arsmagica2:mana_potion_legendary.name"), StatCollector.func_74838_a((String)"item.arsmagica2:potionBundle.name"));
        }
        return "? " + StatCollector.func_74838_a((String)"am2.items.bundle");
    }

    public boolean func_77614_k() {
        return true;
    }
}

