/*
 * Decompiled with CFR 0.152.
 */
package am2.items;

import am2.buffs.BuffEffectManaRegen;
import am2.items.ArsMagicaItem;
import am2.items.ItemsCommonProxy;
import am2.playerextensions.ExtendedProperties;
import am2.texture.ResourceManager;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemManaPotion
extends ArsMagicaItem {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;
    @SideOnly(value=Side.CLIENT)
    private String[] textureFiles;

    public ItemManaPotion() {
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.textureFiles = new String[]{"mana_potion_lesser", "mana_potion_standard", "mana_potion_greater", "mana_potion_epic", "mana_potion_legendary"};
        this.icons = new IIcon[this.textureFiles.length];
        for (int i = 0; i < this.textureFiles.length; ++i) {
            this.icons[i] = ResourceManager.RegisterTexture(this.textureFiles[i], par1IconRegister);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack par1ItemStack) {
        return true;
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        ExtendedProperties props = ExtendedProperties.For((EntityLivingBase)par3EntityPlayer);
        if (props.getCurrentMana() < props.getMaxMana()) {
            par3EntityPlayer.func_71008_a(par1ItemStack, this.func_77626_a(par1ItemStack));
        }
        return par1ItemStack;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int par1) {
        if (this == ItemsCommonProxy.lesserManaPotion) {
            return this.icons[0];
        }
        if (this == ItemsCommonProxy.standardManaPotion) {
            return this.icons[1];
        }
        if (this == ItemsCommonProxy.greaterManaPotion) {
            return this.icons[2];
        }
        if (this == ItemsCommonProxy.epicManaPotion) {
            return this.icons[3];
        }
        if (this == ItemsCommonProxy.legendaryManaPotion) {
            return this.icons[4];
        }
        return this.icons[0];
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return false;
    }

    private float getManaRestored() {
        float manaRestored = 0.0f;
        if (this == ItemsCommonProxy.lesserManaPotion) {
            manaRestored = 100.0f;
        } else if (this == ItemsCommonProxy.standardManaPotion) {
            manaRestored = 250.0f;
        } else if (this == ItemsCommonProxy.greaterManaPotion) {
            manaRestored = 2000.0f;
        } else if (this == ItemsCommonProxy.epicManaPotion) {
            manaRestored = 5000.0f;
        } else if (this == ItemsCommonProxy.legendaryManaPotion) {
            manaRestored = 10000.0f;
        }
        return manaRestored;
    }

    private int getManaRegenLevel() {
        if (this == ItemsCommonProxy.lesserManaPotion) {
            return 0;
        }
        if (this == ItemsCommonProxy.standardManaPotion) {
            return 0;
        }
        if (this == ItemsCommonProxy.greaterManaPotion) {
            return 1;
        }
        if (this == ItemsCommonProxy.epicManaPotion) {
            return 1;
        }
        if (this == ItemsCommonProxy.legendaryManaPotion) {
            return 2;
        }
        return 0;
    }

    private int getManaRegenDuration() {
        if (this == ItemsCommonProxy.lesserManaPotion) {
            return 600;
        }
        if (this == ItemsCommonProxy.standardManaPotion) {
            return 1200;
        }
        if (this == ItemsCommonProxy.greaterManaPotion) {
            return 1800;
        }
        if (this == ItemsCommonProxy.epicManaPotion) {
            return 2400;
        }
        if (this == ItemsCommonProxy.legendaryManaPotion) {
            return 3000;
        }
        return 600;
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.drink;
    }

    public ItemStack func_77654_b(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        par1ItemStack = new ItemStack(Items.field_151069_bo);
        ExtendedProperties.For((EntityLivingBase)par3EntityPlayer).setCurrentMana(ExtendedProperties.For((EntityLivingBase)par3EntityPlayer).getCurrentMana() + this.getManaRestored());
        ExtendedProperties.For((EntityLivingBase)par3EntityPlayer).forceSync();
        if (!par2World.field_72995_K) {
            par3EntityPlayer.func_70690_d((PotionEffect)new BuffEffectManaRegen(this.getManaRegenDuration(), this.getManaRegenLevel()));
        }
        return par1ItemStack;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 32;
    }

    public boolean func_77614_k() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
    }
}

