/*
 * Decompiled with CFR 0.152.
 */
package am2.items;

import am2.AMCore;
import am2.api.math.AMVector3;
import am2.api.power.IPowerNode;
import am2.blocks.tileentities.TileEntityCrystalMarker;
import am2.blocks.tileentities.TileEntityFlickerHabitat;
import am2.items.ArsMagicaRotatedItem;
import am2.particles.AMParticle;
import am2.particles.ParticleFadeOut;
import am2.particles.ParticleMoveOnHeading;
import am2.power.PowerNodeRegistry;
import am2.texture.ResourceManager;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemCrystalWrench
extends ArsMagicaRotatedItem {
    @SideOnly(value=Side.CLIENT)
    private IIcon wrenchStoredIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon wrenchDisconnectIcon;
    private static String KEY_PAIRLOC = "PAIRLOC";
    private static String HAB_PAIRLOC = "HABLOC";
    private static String KEEP_BINDING = "KEEPBINDING";
    private static String MODE = "WRENCHMODE";
    private static final int MODE_PAIR = 0;
    private static final int MODE_DISCONNECT = 1;

    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV = ResourceManager.RegisterTexture("crystal_wrench", par1IconRegister);
        this.wrenchStoredIcon = ResourceManager.RegisterTexture("crystal_wrench_stored", par1IconRegister);
        this.wrenchDisconnectIcon = ResourceManager.RegisterTexture("crystal_wrench_disconnect", par1IconRegister);
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        int cMode = this.getMode(stack);
        if (te != null && !(te instanceof IPowerNode) && cMode == 1) {
            player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"am2.tooltip.wrongWrenchMode")));
            return false;
        }
        if (te != null && te instanceof IPowerNode) {
            if (cMode == 1) {
                this.doDisconnect((IPowerNode)te, world, (float)x + hitX, (float)y + hitY, (float)z + hitZ, player);
                return false;
            }
            if (stack.field_77990_d.func_74764_b(KEY_PAIRLOC)) {
                this.doPairNodes(world, x, y, z, stack, player, hitX, hitY, hitZ, te);
            } else {
                this.storePairLocation(world, te, stack, player, (float)x + hitX, (float)y + hitY, (float)z + hitZ);
            }
        } else if (te != null && te instanceof TileEntityCrystalMarker && stack.field_77990_d != null && stack.field_77990_d.func_74764_b(HAB_PAIRLOC)) {
            this.handleCMPair(stack, world, player, te, (float)x + hitX, (float)y + hitY, (float)z + hitZ);
        } else if (player.func_70093_af()) {
            this.handleModeChanges(stack);
        }
        return false;
    }

    private void handleCMPair(ItemStack stack, World world, EntityPlayer player, TileEntity te, double hitX, double hitY, double hitZ) {
        AMVector3 habLocation = AMVector3.readFromNBT(stack.field_77990_d.func_74775_l(HAB_PAIRLOC));
        if (world.field_72995_K) {
            this.spawnLinkParticles(world, hitX, hitY, hitZ);
        } else {
            TileEntityCrystalMarker tecm = (TileEntityCrystalMarker)te;
            tecm.linkToHabitat(habLocation, player);
            if (!stack.field_77990_d.func_74764_b(KEEP_BINDING)) {
                stack.field_77990_d.func_82580_o(HAB_PAIRLOC);
            }
        }
    }

    private void storePairLocation(World world, TileEntity te, ItemStack stack, EntityPlayer player, double hitX, double hitY, double hitZ) {
        AMVector3 destination = new AMVector3(te);
        if (!world.field_72995_K) {
            if (te instanceof TileEntityFlickerHabitat) {
                NBTTagCompound habLoc = new NBTTagCompound();
                destination.writeToNBT(habLoc);
                stack.field_77990_d.func_74782_a(HAB_PAIRLOC, (NBTBase)habLoc);
            } else {
                NBTTagCompound pairLoc = new NBTTagCompound();
                destination.writeToNBT(pairLoc);
                stack.field_77990_d.func_74782_a(KEY_PAIRLOC, (NBTBase)pairLoc);
            }
            if (player.func_70093_af()) {
                stack.field_77990_d.func_74757_a(KEEP_BINDING, true);
            }
        } else {
            this.spawnLinkParticles(world, hitX, hitY, hitZ);
        }
    }

    private void doPairNodes(World world, int x, int y, int z, ItemStack stack, EntityPlayer player, double hitX, double hitY, double hitZ, TileEntity te) {
        AMVector3 source = AMVector3.readFromNBT(stack.field_77990_d.func_74775_l(KEY_PAIRLOC));
        TileEntity sourceTE = world.func_147438_o((int)source.x, (int)source.y, (int)source.z);
        if (sourceTE != null && sourceTE instanceof IPowerNode && !world.field_72995_K) {
            player.func_145747_a((IChatComponent)new ChatComponentText(PowerNodeRegistry.For(world).tryPairNodes((IPowerNode)sourceTE, (IPowerNode)te)));
        } else if (world.field_72995_K) {
            this.spawnLinkParticles(world, (double)x + hitX, (double)y + hitY, (double)z + hitZ);
        }
        if (!stack.field_77990_d.func_74764_b(KEEP_BINDING)) {
            stack.field_77990_d.func_82580_o(KEY_PAIRLOC);
        }
    }

    private void doDisconnect(IPowerNode node, World world, double hitX, double hitY, double hitZ, EntityPlayer player) {
        PowerNodeRegistry.For(world).tryDisconnectAllNodes(node);
        if (world.field_72995_K) {
            this.spawnLinkParticles(player.field_70170_p, hitX, hitY, hitZ, true);
        } else {
            player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"am2.tooltip.disconnectPower")));
        }
    }

    private void handleModeChanges(ItemStack stack) {
        if (stack.field_77990_d.func_74764_b(KEEP_BINDING)) {
            stack.field_77990_d.func_82580_o(KEEP_BINDING);
            if (stack.field_77990_d.func_74764_b(KEY_PAIRLOC)) {
                stack.field_77990_d.func_82580_o(KEY_PAIRLOC);
            }
            if (stack.field_77990_d.func_74764_b(HAB_PAIRLOC)) {
                stack.field_77990_d.func_82580_o(HAB_PAIRLOC);
            }
        } else if (this.getMode(stack) == 0) {
            stack.field_77990_d.func_74768_a(MODE, 1);
        } else {
            stack.field_77990_d.func_74768_a(MODE, 0);
        }
    }

    private int getMode(ItemStack stack) {
        if (stack.field_77990_d.func_74764_b(MODE)) {
            return stack.field_77990_d.func_74762_e(MODE);
        }
        return 0;
    }

    private void spawnLinkParticles(World world, double hitX, double hitY, double hitZ) {
        this.spawnLinkParticles(world, hitX, hitY, hitZ, false);
    }

    private void spawnLinkParticles(World world, double hitX, double hitY, double hitZ, boolean disconnect) {
        for (int i = 0; i < 10; ++i) {
            AMParticle particle = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(world, "none_hand", hitX, hitY, hitZ));
            if (particle == null) continue;
            if (disconnect) {
                particle.setRGBColorF(1.0f, 0.0f, 0.0f);
                particle.addRandomOffset(0.5, 0.5, 0.5);
            }
            particle.setMaxAge(10);
            particle.setParticleScale(0.1f);
            particle.AddParticleController(new ParticleMoveOnHeading(particle, world.field_73012_v.nextInt(360), world.field_73012_v.nextInt(360), world.field_73012_v.nextDouble() * 0.2, 1, false));
            particle.AddParticleController(new ParticleFadeOut(particle, 1, false).setFadeSpeed(0.1f));
        }
    }

    public boolean func_77651_p() {
        return true;
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        return this.GetWrenchIcon(stack, pass);
    }

    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        return this.GetWrenchIcon(stack, renderPass);
    }

    public IIcon func_77650_f(ItemStack par1ItemStack) {
        return this.GetWrenchIcon(par1ItemStack, 0);
    }

    private IIcon GetWrenchIcon(ItemStack stack, int pass) {
        if (stack.field_77990_d != null && pass == 0) {
            if (stack.field_77990_d.func_74764_b(KEEP_BINDING)) {
                return this.wrenchStoredIcon;
            }
            if (stack.field_77990_d.func_74764_b(MODE) && stack.field_77990_d.func_74762_e(MODE) == 1) {
                return this.wrenchDisconnectIcon;
            }
            return this.field_77791_bV;
        }
        return this.field_77791_bV;
    }

    public int func_77639_j() {
        return 1;
    }
}

