/*
 * Decompiled with CFR 0.152.
 */
package am2.entities.ai;

import am2.blocks.BlocksCommonProxy;
import am2.items.ItemsCommonProxy;
import cpw.mods.fml.common.registry.VillagerRegistry;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;

public class MageVillagerTrade
implements VillagerRegistry.IVillageTradeHandler {
    private static int min = 1;
    private static int max = 2;

    public void manipulateTradesForVillager(EntityVillager villager, MerchantRecipeList recipeList, Random random) {
        recipeList.clear();
        int numChoices = random.nextInt(4) + 1;
        for (int i = 0; i < numChoices; ++i) {
            ItemStack choice = this.getRandomChoiceForTrade(random);
            if (choice == null) continue;
            MerchantRecipe itemToSell = new MerchantRecipe(new ItemStack(Items.field_151166_bC, random.nextInt(max - min) + min), choice);
            recipeList.add((Object)itemToSell);
        }
    }

    private ItemStack getRandomChoiceForTrade(Random random) {
        int itemSeed = random.nextInt(1000);
        HashMap<ItemStack, Integer> weightedRandomChoices = new HashMap<ItemStack, Integer>();
        ItemStack choice = null;
        if (itemSeed < 150) {
            weightedRandomChoices.put(new ItemStack((Item)ItemsCommonProxy.itemOre, 1, 2), 1000);
            for (int i = 0; i < 13; ++i) {
                if (i == 11) {
                    weightedRandomChoices.put(new ItemStack((Item)ItemsCommonProxy.essence, 1, i), 250);
                    continue;
                }
                weightedRandomChoices.put(new ItemStack((Item)ItemsCommonProxy.essence, 1, i), 120);
            }
            choice = this.pickRandomWeightedItem(random, weightedRandomChoices);
            if (choice.func_77960_j() == 11) {
                min = 11;
                max = 16;
            } else if (choice.func_77973_b() == ItemsCommonProxy.itemOre) {
                min = 2;
                max = 5;
            } else {
                min = 4;
                max = 7;
            }
        } else if (itemSeed >= 150 && itemSeed < 300) {
            min = 2;
            max = 4;
            choice = new ItemStack((Item)ItemsCommonProxy.spellBook);
        } else if (itemSeed >= 300 && itemSeed < 700) {
            weightedRandomChoices.put(new ItemStack((Item)ItemsCommonProxy.lesserFocus), 500);
            weightedRandomChoices.put(new ItemStack((Item)ItemsCommonProxy.standardFocus), 250);
            weightedRandomChoices.put(new ItemStack((Item)ItemsCommonProxy.greaterFocus), 50);
            weightedRandomChoices.put(new ItemStack((Item)ItemsCommonProxy.chargeFocus), 250);
            weightedRandomChoices.put(new ItemStack((Item)ItemsCommonProxy.manaFocus), 250);
            weightedRandomChoices.put(new ItemStack((Item)ItemsCommonProxy.playerFocus), 250);
            weightedRandomChoices.put(new ItemStack((Item)ItemsCommonProxy.itemFocus), 250);
            weightedRandomChoices.put(new ItemStack((Item)ItemsCommonProxy.creatureFocus), 250);
            weightedRandomChoices.put(new ItemStack((Item)ItemsCommonProxy.mobFocus), 250);
            choice = this.pickRandomWeightedItem(random, weightedRandomChoices);
            if (choice.func_77973_b() == ItemsCommonProxy.greaterFocus) {
                min = 4;
                max = 11;
            } else if (choice.func_77973_b() == ItemsCommonProxy.lesserFocus) {
                min = 2;
                max = 5;
            } else {
                min = 4;
                max = 7;
            }
        } else if (itemSeed >= 700 && itemSeed < 800) {
            weightedRandomChoices.put(new ItemStack(ItemsCommonProxy.mageHood), 750);
            weightedRandomChoices.put(new ItemStack(ItemsCommonProxy.mageArmor), 750);
            weightedRandomChoices.put(new ItemStack(ItemsCommonProxy.mageLeggings), 750);
            weightedRandomChoices.put(new ItemStack(ItemsCommonProxy.mageBoots), 750);
            weightedRandomChoices.put(new ItemStack(ItemsCommonProxy.battlemageHood), 250);
            weightedRandomChoices.put(new ItemStack(ItemsCommonProxy.battlemageArmor), 250);
            weightedRandomChoices.put(new ItemStack(ItemsCommonProxy.battlemageLeggings), 250);
            weightedRandomChoices.put(new ItemStack(ItemsCommonProxy.battlemageBoots), 250);
            choice = this.pickRandomWeightedItem(random, weightedRandomChoices);
            if (choice.func_77973_b() == ItemsCommonProxy.battlemageHood || choice.func_77973_b() == ItemsCommonProxy.battlemageArmor || choice.func_77973_b() == ItemsCommonProxy.battlemageBoots || choice.func_77973_b() == ItemsCommonProxy.battlemageLeggings) {
                min = 8;
                max = 17;
            } else if (choice.func_77973_b() == ItemsCommonProxy.mageHood || choice.func_77973_b() == ItemsCommonProxy.mageArmor || choice.func_77973_b() == ItemsCommonProxy.mageBoots || choice.func_77973_b() == ItemsCommonProxy.mageLeggings) {
                min = 4;
                max = 9;
            } else {
                min = 2;
                max = 6;
            }
        } else if (itemSeed >= 800) {
            min = 1;
            max = 1;
            choice = new ItemStack(BlocksCommonProxy.seerStone);
        }
        return choice;
    }

    private ItemStack pickRandomWeightedItem(Random random, HashMap<ItemStack, Integer> weightedChoices) {
        int totalWeight = 0;
        for (Integer weight : weightedChoices.values()) {
            totalWeight += weight.intValue();
        }
        int randWeight = random.nextInt(totalWeight);
        ItemStack choice = null;
        for (ItemStack item : weightedChoices.keySet()) {
            int weight = weightedChoices.get(item);
            if ((randWeight -= weight) > 0) continue;
            choice = item;
            break;
        }
        return choice;
    }
}

