/*
 * Decompiled with CFR 0.152.
 */
package am2.codechicken;

import am2.api.math.AMVector3;
import am2.codechicken.LightningBoltCommon;
import am2.texture.ResourceManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class LightningBolt
extends EntityFX {
    private int type = 0;
    private int overrideColor = -1;
    private LightningBoltCommon main;
    private static final ResourceLocation bolt = new ResourceLocation("arsmagica2", ResourceManager.GetFXTexturePath("smoke.png"));

    public LightningBolt(World world, AMVector3 jammervec, AMVector3 targetvec, long seed) {
        super(world, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        this.main = new LightningBoltCommon(world, jammervec, targetvec, seed);
        this.setupFromMain();
    }

    public LightningBolt(World world, Entity detonator, Entity target, long seed) {
        super(world, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        this.main = new LightningBoltCommon(world, detonator, target, seed);
        this.setupFromMain();
    }

    public LightningBolt(World world, Entity detonator, Entity target, long seed, int speed) {
        super(world, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        this.main = new LightningBoltCommon(world, detonator, target, seed, speed);
        this.setupFromMain();
    }

    public LightningBolt(World world, TileEntity detonator, Entity target, long seed) {
        super(world, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        this.main = new LightningBoltCommon(world, detonator, target, seed);
        this.setupFromMain();
    }

    public LightningBolt(World world, double x1, double y1, double z1, double x, double y, double z, long seed, int duration, float multi) {
        super(world, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        this.main = new LightningBoltCommon(world, x1, y1, z1, x, y, z, seed, duration, multi);
        this.setupFromMain();
    }

    public LightningBolt(World world, double x1, double y1, double z1, double x, double y, double z, long seed, int duration, float multi, int speed) {
        super(world, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        this.main = new LightningBoltCommon(world, x1, y1, z1, x, y, z, seed, duration, multi, speed);
        this.setupFromMain();
    }

    public LightningBolt(World world, double x1, double y1, double z1, double x, double y, double z, long seed, int duration) {
        super(world, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        this.main = new LightningBoltCommon(world, x1, y1, z1, x, y, z, seed, duration, 1.0f);
        this.setupFromMain();
    }

    public LightningBolt(World world, TileEntity detonator, double x, double y, double z, long seed) {
        super(world, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        this.main = new LightningBoltCommon(world, detonator, x, y, z, seed);
        this.setupFromMain();
    }

    private void setupFromMain() {
        this.main.setWrapper((Entity)this);
        this.field_70546_d = this.main.particleMaxAge;
        this.func_70107_b(this.main.start.x, this.main.start.y, this.main.start.z);
        this.func_70016_h(0.0, 0.0, 0.0);
    }

    public void defaultFractal() {
        this.main.defaultFractal();
    }

    public void fractal(int splits, float amount, float splitchance, float splitlength, float splitangle) {
        this.main.fractal(splits, amount, splitchance, splitlength, splitangle);
    }

    public void finalizeBolt() {
        this.main.finalizeBolt();
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)this);
    }

    public void setOverrideColor(int overrideColor) {
        this.overrideColor = overrideColor;
    }

    public void setSourceEntity(Entity entity) {
        this.main.wrapper = entity;
    }

    public void setType(int type) {
        this.type = type;
        this.main.type = type;
    }

    public void setDamage(int dmg) {
        this.main.damage = dmg;
    }

    public void setNonLethal() {
        this.main.nonLethal = true;
    }

    public void setMultiplier(float m) {
        this.main.multiplier = m;
    }

    public void func_70071_h_() {
        this.main.onUpdate();
        if (this.main.particleAge >= this.main.particleMaxAge) {
            this.func_70106_y();
        }
    }

    private static AMVector3 getRelativeViewVector(AMVector3 pos) {
        EntityClientPlayerMP renderentity = Minecraft.func_71410_x().field_71439_g;
        return new AMVector3((float)renderentity.field_70165_t - pos.x, (float)renderentity.field_70163_u - pos.y, (float)renderentity.field_70161_v - pos.z);
    }

    private void renderBolt(Tessellator tessellator, float partialframe, float cosyaw, float cospitch, float sinyaw, float cossinpitch, int pass) {
        AMVector3 playervec = new AMVector3(sinyaw * -cospitch, -cossinpitch / cosyaw, cosyaw * cospitch);
        float boltage = this.main.particleAge >= 0 ? (float)(this.main.particleAge / this.main.particleMaxAge) : 0.0f;
        float mainalpha = 1.0f;
        mainalpha = pass == 0 ? (1.0f - boltage) * 0.9f : (pass == 1 ? 1.0f - boltage * 0.6f : 1.0f - boltage * 0.3f);
        int renderlength = (int)(((float)this.main.particleAge + partialframe + (float)((int)(this.main.length * 3.0f))) / (float)((int)(this.main.length * 3.0f)) * (float)this.main.numsegments0);
        for (LightningBoltCommon.Segment rendersegment : this.main.segments) {
            float rz3;
            float ry3;
            float rx3;
            AMVector3 roundend;
            if (rendersegment.segmentno > renderlength) continue;
            float width = 0.03f * (LightningBolt.getRelativeViewVector(rendersegment.startpoint.point).length() / 10.0f + 1.0f) * (1.0f + rendersegment.light) * 0.5f;
            if (width > 0.05f) {
                width = 0.05f;
            }
            if (pass == 1) {
                width += 0.025f;
            } else if (pass == 1) {
                width += 0.05f;
            }
            AMVector3 diff1 = AMVector3.crossProduct(playervec, rendersegment.prevdiff).scale(width / rendersegment.sinprev);
            AMVector3 diff2 = AMVector3.crossProduct(playervec, rendersegment.nextdiff).scale(width / rendersegment.sinnext);
            AMVector3 startvec = rendersegment.startpoint.point;
            AMVector3 endvec = rendersegment.endpoint.point;
            float rx1 = (float)((double)startvec.x - field_70556_an);
            float ry1 = (float)((double)startvec.y - field_70554_ao);
            float rz1 = (float)((double)startvec.z - field_70555_ap);
            float rx2 = (float)((double)endvec.x - field_70556_an);
            float ry2 = (float)((double)endvec.y - field_70554_ao);
            float rz2 = (float)((double)endvec.z - field_70555_ap);
            tessellator.func_78369_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, mainalpha * rendersegment.light);
            tessellator.func_78374_a((double)(rx2 - diff2.x), (double)(ry2 - diff2.y), (double)(rz2 - diff2.z), 0.5, 0.0);
            tessellator.func_78374_a((double)(rx1 - diff1.x), (double)(ry1 - diff1.y), (double)(rz1 - diff1.z), 0.5, 0.0);
            tessellator.func_78374_a((double)(rx1 + diff1.x), (double)(ry1 + diff1.y), (double)(rz1 + diff1.z), 0.5, 1.0);
            tessellator.func_78374_a((double)(rx2 + diff2.x), (double)(ry2 + diff2.y), (double)(rz2 + diff2.z), 0.5, 1.0);
            if (rendersegment.next == null) {
                roundend = rendersegment.endpoint.point.copy().add(rendersegment.diff.copy().normalize().scale(width));
                rx3 = (float)((double)roundend.x - field_70556_an);
                ry3 = (float)((double)roundend.y - field_70554_ao);
                rz3 = (float)((double)roundend.z - field_70555_ap);
                tessellator.func_78374_a((double)(rx3 - diff2.x), (double)(ry3 - diff2.y), (double)(rz3 - diff2.z), 0.0, 0.0);
                tessellator.func_78374_a((double)(rx2 - diff2.x), (double)(ry2 - diff2.y), (double)(rz2 - diff2.z), 0.5, 0.0);
                tessellator.func_78374_a((double)(rx2 + diff2.x), (double)(ry2 + diff2.y), (double)(rz2 + diff2.z), 0.5, 1.0);
                tessellator.func_78374_a((double)(rx3 + diff2.x), (double)(ry3 + diff2.y), (double)(rz3 + diff2.z), 0.0, 1.0);
            }
            if (rendersegment.prev != null) continue;
            roundend = rendersegment.startpoint.point.copy().sub(rendersegment.diff.copy().normalize().scale(width));
            rx3 = (float)((double)roundend.x - field_70556_an);
            ry3 = (float)((double)roundend.y - field_70554_ao);
            rz3 = (float)((double)roundend.z - field_70555_ap);
            tessellator.func_78374_a((double)(rx1 - diff1.x), (double)(ry1 - diff1.y), (double)(rz1 - diff1.z), 0.5, 0.0);
            tessellator.func_78374_a((double)(rx3 - diff1.x), (double)(ry3 - diff1.y), (double)(rz3 - diff1.z), 0.0, 0.0);
            tessellator.func_78374_a((double)(rx3 + diff1.x), (double)(ry3 + diff1.y), (double)(rz3 + diff1.z), 0.0, 1.0);
            tessellator.func_78374_a((double)(rx1 + diff1.x), (double)(ry1 + diff1.y), (double)(rz1 + diff1.z), 0.5, 1.0);
        }
    }

    public void func_70539_a(Tessellator tessellator, float partialframe, float cosyaw, float cospitch, float sinyaw, float sinsinpitch, float cossinpitch) {
        EntityClientPlayerMP renderentity = Minecraft.func_71410_x().field_71439_g;
        int visibleDistance = 100;
        if (!Minecraft.func_71410_x().field_71474_y.field_74347_j) {
            visibleDistance = 50;
        }
        if (renderentity.func_70011_f(this.field_70165_t, this.field_70163_u, this.field_70161_v) > (double)visibleDistance) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)262144);
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(bolt);
        this.field_70551_j = 1.0f;
        this.field_70553_i = 1.0f;
        this.field_70552_h = 1.0f;
        int brightness = 983280;
        switch (this.type) {
            case 0: {
                this.field_70552_h = 0.1f;
                this.field_70553_i = 0.1f;
                this.field_70551_j = 0.6f;
                GL11.glBlendFunc((int)770, (int)1);
                break;
            }
            case 1: {
                this.field_70552_h = 0.6f;
                this.field_70553_i = 0.6f;
                this.field_70551_j = 0.1f;
                GL11.glBlendFunc((int)770, (int)1);
                break;
            }
            case 2: {
                this.field_70552_h = 0.6f;
                this.field_70553_i = 0.1f;
                this.field_70551_j = 0.6f;
                GL11.glBlendFunc((int)770, (int)1);
                break;
            }
            case 3: {
                this.field_70552_h = 0.1f;
                this.field_70553_i = 1.0f;
                this.field_70551_j = 0.1f;
                GL11.glBlendFunc((int)770, (int)1);
                break;
            }
            case 4: {
                this.field_70552_h = 0.1f;
                this.field_70553_i = 0.1f;
                this.field_70551_j = 0.1f;
                GL11.glBlendFunc((int)770, (int)771);
                brightness = 983136;
                break;
            }
            case 5: {
                this.field_70552_h = 0.6f;
                this.field_70553_i = 0.3f;
                this.field_70551_j = 0.6f;
                GL11.glBlendFunc((int)770, (int)771);
                break;
            }
            case 6: {
                this.field_70552_h = 0.1f;
                this.field_70553_i = 0.1f;
                this.field_70551_j = 0.1f;
                GL11.glBlendFunc((int)770, (int)1);
                brightness = 983040;
            }
        }
        if (this.overrideColor != -1) {
            this.field_70552_h = (float)(this.overrideColor >> 16 & 0xFF) / 255.0f;
            this.field_70553_i = (float)(this.overrideColor >> 8 & 0xFF) / 255.0f;
            this.field_70551_j = (float)(this.overrideColor & 0xFF) / 255.0f;
        }
        tessellator.func_78380_c(brightness);
        this.renderBolt(tessellator, partialframe, cosyaw, cospitch, sinyaw, cossinpitch, 0);
        try {
            tessellator.func_78381_a();
        }
        catch (Throwable t) {
            // empty catch block
        }
        brightness = 983280;
        switch (this.type) {
            case 0: {
                this.field_70552_h = 1.0f;
                this.field_70553_i = 0.6f;
                this.field_70551_j = 1.0f;
                break;
            }
            case 1: {
                this.field_70552_h = 0.1f;
                this.field_70553_i = 0.1f;
                this.field_70551_j = 1.0f;
                break;
            }
            case 2: {
                this.field_70552_h = 0.0f;
                this.field_70553_i = 0.0f;
                this.field_70551_j = 0.0f;
                break;
            }
            case 3: {
                this.field_70552_h = 0.1f;
                this.field_70553_i = 0.6f;
                this.field_70551_j = 0.1f;
                break;
            }
            case 4: {
                this.field_70552_h = 0.6f;
                this.field_70553_i = 0.1f;
                this.field_70551_j = 0.1f;
                GL11.glBlendFunc((int)770, (int)771);
                break;
            }
            case 5: {
                this.field_70552_h = 1.0f;
                this.field_70553_i = 1.0f;
                this.field_70551_j = 0.1f;
                GL11.glBlendFunc((int)770, (int)771);
                break;
            }
            case 6: {
                this.field_70552_h = 0.6f;
                this.field_70553_i = 0.1f;
                this.field_70551_j = 0.6f;
                GL11.glBlendFunc((int)770, (int)1);
                brightness = 983136;
            }
        }
        if (this.overrideColor != -1) {
            this.field_70552_h = (float)(this.overrideColor >> 16 & 0xFF) / 255.0f;
            this.field_70553_i = (float)(this.overrideColor >> 8 & 0xFF) / 255.0f;
            this.field_70551_j = (float)(this.overrideColor & 0xFF) / 255.0f;
        }
        try {
            tessellator.func_78382_b();
        }
        catch (Throwable t) {
            // empty catch block
        }
        tessellator.func_78380_c(brightness);
        this.renderBolt(tessellator, partialframe, cosyaw, cospitch, sinyaw, cossinpitch, 1);
        try {
            tessellator.func_78381_a();
        }
        catch (Throwable t) {
            // empty catch block
        }
        brightness = 983280;
        switch (this.type) {
            case 0: {
                this.field_70552_h = 1.0f;
                this.field_70553_i = 0.6f;
                this.field_70551_j = 1.0f;
                break;
            }
            case 1: {
                this.field_70552_h = 0.1f;
                this.field_70553_i = 0.1f;
                this.field_70551_j = 1.0f;
                break;
            }
            case 2: {
                this.field_70552_h = 0.0f;
                this.field_70553_i = 0.0f;
                this.field_70551_j = 0.0f;
                break;
            }
            case 3: {
                this.field_70552_h = 0.1f;
                this.field_70553_i = 0.6f;
                this.field_70551_j = 0.1f;
                break;
            }
            case 4: {
                this.field_70552_h = 0.1f;
                this.field_70553_i = 0.1f;
                this.field_70551_j = 0.1f;
                brightness = 983136;
                GL11.glBlendFunc((int)770, (int)771);
                break;
            }
            case 5: {
                this.field_70552_h = 1.0f;
                this.field_70553_i = 1.0f;
                this.field_70551_j = 0.1f;
                GL11.glBlendFunc((int)770, (int)771);
                break;
            }
            case 6: {
                this.field_70552_h = 0.6f;
                this.field_70553_i = 0.1f;
                this.field_70551_j = 0.6f;
                GL11.glBlendFunc((int)770, (int)1);
                brightness = 983136;
            }
        }
        if (this.overrideColor != -1) {
            this.field_70552_h = (float)(this.overrideColor >> 16 & 0xFF) / 255.0f;
            this.field_70553_i = (float)(this.overrideColor >> 8 & 0xFF) / 255.0f;
            this.field_70551_j = (float)(this.overrideColor & 0xFF) / 255.0f;
        }
        try {
            tessellator.func_78382_b();
        }
        catch (Throwable t) {
            // empty catch block
        }
        tessellator.func_78380_c(brightness);
        this.renderBolt(tessellator, partialframe, cosyaw, cospitch, sinyaw, cossinpitch, 2);
        try {
            tessellator.func_78381_a();
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            tessellator.func_78382_b();
        }
        catch (Throwable t) {
            // empty catch block
        }
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    public int getRenderPass() {
        return 2;
    }
}

