/*
 * Decompiled with CFR 0.152.
 */
package am2.bosses;

import am2.AMCore;
import am2.api.math.AMVector3;
import am2.bosses.AM2Boss;
import am2.bosses.BossActions;
import am2.bosses.ai.EntityAIDispel;
import am2.bosses.ai.EntityAIHurricane;
import am2.bosses.ai.EntityAISpawnWhirlwind;
import am2.damage.DamageSourceLightning;
import am2.entities.ai.EntityAIGuardSpawnLocation;
import am2.items.ItemsCommonProxy;
import am2.network.AMNetHandler;
import am2.particles.AMParticle;
import am2.particles.ParticleApproachEntity;
import am2.particles.ParticleFloatUpward;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class EntityAirGuardian
extends AM2Boss {
    private boolean useLeftArm = false;
    public float spinRotation = 0.0f;
    private float orbitRotation;
    public int hitCount = 0;
    private boolean firstTick = true;

    public EntityAirGuardian(World par1World) {
        super(par1World);
        this.func_70105_a(1.0f, 2.0f);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(220.0);
    }

    public int func_70658_aO() {
        return 14;
    }

    @Override
    protected void initSpecificAI() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIDispel(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISpawnWhirlwind(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIHurricane(this, 0.5f));
    }

    @Override
    public void setCurrentAction(BossActions action) {
        super.setCurrentAction(action);
        this.spinRotation = 0.0f;
        this.hitCount = 0;
        if (action == BossActions.CASTING) {
            boolean bl = this.useLeftArm = !this.useLeftArm;
        }
        if (!this.field_70170_p.field_72995_K) {
            AMNetHandler.INSTANCE.sendActionUpdateToAllAround(this);
        }
    }

    public boolean useLeftArm() {
        return this.useLeftArm;
    }

    @Override
    public void func_70071_h_() {
        int i;
        if (this.firstTick) {
            this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIGuardSpawnLocation((EntityCreature)this, 0.5f, 5.0f, 16.0f, new AMVector3((Entity)this)));
            this.firstTick = false;
        }
        this.orbitRotation += 2.0f;
        this.orbitRotation %= 360.0f;
        switch (this.currentAction) {
            case IDLE: {
                break;
            }
            case SPINNING: {
                this.spinRotation = (this.spinRotation - 40.0f) % 360.0f;
                if (!this.field_70170_p.field_72995_K) break;
                for (i = 0; i < AMCore.config.getGFXLevel(); ++i) {
                    AMParticle particle = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(this.field_70170_p, "wind", this.field_70165_t + this.field_70170_p.field_73012_v.nextDouble() * 4.0 - 2.0, this.field_70163_u, this.field_70161_v + this.field_70170_p.field_73012_v.nextDouble() * 4.0 - 2.0));
                    if (particle == null) continue;
                    if (this.ticksInCurrentAction < BossActions.SPINNING.getMaxActionTime() - 10) {
                        particle.AddParticleController(new ParticleApproachEntity(particle, (Entity)this, 0.2f, 0.5, 1, true));
                        particle.AddParticleController(new ParticleFloatUpward(particle, 0.01f, 0.2f, 2, true));
                    } else {
                        particle.AddParticleController(new ParticleFloatUpward(particle, 0.1f, 1.0f, 1, false));
                    }
                    particle.setMaxAge(30);
                }
                break;
            }
        }
        if (this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.8999999165534973;
        }
        if (this.field_70163_u < 150.0) {
            if (this.field_70170_p.field_72995_K) {
                for (i = 0; i < 25; ++i) {
                    AMParticle wind = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(this.field_70170_p, "wind", this.field_70165_t, this.field_70163_u, this.field_70161_v));
                    if (wind == null) continue;
                    wind.setIgnoreMaxAge(false);
                    wind.setMaxAge(10 + this.field_70146_Z.nextInt(10));
                    wind.setDontRequireControllers();
                    wind.addRandomOffset(1.0, 1.0, 1.0);
                }
            } else if (this.field_70163_u < 145.0) {
                this.func_70106_y();
            }
        }
        super.func_70071_h_();
    }

    public float getOrbitRotation() {
        return this.orbitRotation;
    }

    public boolean func_70104_M() {
        return this.getCurrentAction() != BossActions.SPINNING;
    }

    protected void func_70069_a(float par1) {
    }

    protected void func_70628_a(boolean par1, int par2) {
        if (par1) {
            this.func_70099_a(new ItemStack((Item)ItemsCommonProxy.rune, 1, 18), 0.0f);
        }
        int i = this.field_70146_Z.nextInt(4);
        for (int j = 0; j < i; ++j) {
            this.func_70099_a(new ItemStack((Item)ItemsCommonProxy.essence, 1, 2), 0.0f);
        }
        i = this.field_70146_Z.nextInt(10);
        if (i < 3 && par1) {
            this.func_70099_a(ItemsCommonProxy.airSledEnchanted.func_77946_l(), 0.0f);
        }
    }

    @Override
    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        ++this.hitCount;
        return super.func_70097_a(par1DamageSource, par2);
    }

    @Override
    protected float modifyDamageAmount(DamageSource source, float damageAmt) {
        if (source.func_82725_o()) {
            damageAmt /= 2.0f;
        } else if (source instanceof DamageSourceLightning) {
            damageAmt *= 2.0f;
        }
        return damageAmt;
    }

    protected String func_70621_aR() {
        return "arsmagica2:mob.airguardian.hit";
    }

    protected String func_70673_aS() {
        return "arsmagica2:mob.airguardian.death";
    }

    protected String func_70639_aQ() {
        return "arsmagica2:mob.airguardian.idle";
    }

    @Override
    public String getAttackSound() {
        return "";
    }
}

