/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentities;

import am2.api.math.AMVector3;
import am2.api.spell.enums.Affinity;
import am2.blocks.BlocksCommonProxy;
import am2.blocks.tileentities.TileEntityCrystalMarker;
import am2.blocks.tileentities.flickers.FlickerOperatorRegistry;
import am2.blocks.tileentities.flickers.TileEntityFlickerControllerBase;
import am2.items.ItemFlickerJar;
import am2.items.ItemsCommonProxy;
import cpw.mods.fml.common.FMLLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityFlickerHabitat
extends TileEntityFlickerControllerBase
implements IInventory {
    private static final float FULL_CIRCLE = 360.0f;
    private static final float ROATATION_RATE = 1.0f;
    private static final float FLOAT_RATE = 0.001f;
    private static final float MAX_FLOAT_UP = 0.1f;
    private static final float MAX_FLOAT_DOWN = -0.04f;
    public static final int PRIORITY_LEVELS = 10;
    public static final int PRIORITY_FINAL = 11;
    private static final float MAX_SHIFT_TICKS = 20.0f;
    private int colorCounter = 0;
    private int fadeCounter = 0;
    private ArrayList<AMVector3> inList;
    private HashMap<Integer, ArrayList<AMVector3>> outList;
    private int timer;
    private int inListPosition = 0;
    private HashMap<Integer, Integer> outListPositions = new HashMap();
    private int defoutListPosition = 0;
    private ItemStack flickerJar;
    private float rotateOffset = 0.0f;
    private float floatOffset = 0.0f;
    private boolean floatUp = true;
    private boolean isUpgrade = false;
    private ForgeDirection mainHabitatDirection = ForgeDirection.UNKNOWN;

    public boolean isUpgrade() {
        return this.isUpgrade;
    }

    public void setUpgrade(boolean isUpgrade, ForgeDirection direction) {
        this.isUpgrade = isUpgrade;
        this.mainHabitatDirection = direction;
    }

    public ForgeDirection getMainHabitatDirection() {
        return this.mainHabitatDirection;
    }

    public TileEntityFlickerHabitat() {
        this.initLocationLists();
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            Random rnd = new Random(System.currentTimeMillis());
            this.rotateOffset = rnd.nextFloat() * 360.0f - 1.0f;
            this.floatOffset = -0.04f + (rnd.nextFloat() * 0.14f + 1.0f);
        }
    }

    private void initLocationLists() {
        this.inList = new ArrayList();
        this.outList = new HashMap();
        for (int i = 0; i < 10; ++i) {
            this.outList.put(i, new ArrayList());
        }
    }

    public Affinity getSelectedAffinity() {
        if (this.flickerJar != null) {
            return Affinity.getByID(this.flickerJar.func_77960_j());
        }
        return null;
    }

    public boolean hasFlicker() {
        return this.flickerJar != null;
    }

    public int getInListPosition() {
        return this.inListPosition;
    }

    public void setInListPosition(int inListPosition) {
        this.inListPosition = inListPosition;
    }

    public int getOutListPosition(int priority) {
        if (!this.outListPositions.containsKey(priority)) {
            this.outListPositions.put(priority, 0);
        }
        return this.outListPositions.get(priority);
    }

    public void setOutListPosition(int priority, int outListPosition) {
        this.outListPositions.put(priority, outListPosition);
    }

    public int getDeferredOutListPosition() {
        return this.defoutListPosition;
    }

    public void setDeferredOutListPosition(int position) {
        this.defoutListPosition = position;
    }

    public AMVector3 getInListAt(int index) {
        return this.inList.get(index);
    }

    public void setInListAt(int index, AMVector3 value) {
        this.inList.set(index, value);
    }

    public void removeInListAt(int index) {
        this.inList.remove(index);
    }

    public void removeInListAt(AMVector3 value) {
        this.inList.remove(value);
    }

    public int getInListSize() {
        return this.inList.size();
    }

    public AMVector3 getOutListAt(int priority, int index) {
        if (this.outList != null && this.outList.containsKey(priority) && this.outList.get(priority).size() > 0) {
            return this.outList.get(priority).get(index);
        }
        return new AMVector3(this);
    }

    public void setOutListAt(int priority, int index, AMVector3 value) {
        if (this.outList.containsKey(priority)) {
            this.outList.get(priority).set(index, value);
        }
    }

    public void removeOutListAt(int priority, int index) {
        if (this.outList.containsKey(priority)) {
            this.outList.get(priority).remove(index);
        }
    }

    public void removeOutListAt(int priority, AMVector3 value) {
        if (!this.outList.containsKey(priority)) {
            return;
        }
        this.outList.get(priority).remove(value);
    }

    public int getOutListSize(int priority) {
        if (this.outList.containsKey(priority)) {
            return this.outList.get(priority).size();
        }
        return 0;
    }

    public float getRotateOffset() {
        return this.rotateOffset;
    }

    public float getFloatOffset() {
        return this.floatOffset;
    }

    public void AddMarkerLocationIn(AMVector3 markerLocation) {
        if (!this.inList.contains(markerLocation)) {
            this.inList.add(markerLocation);
            FMLLog.info((String)"In Link Created", (Object[])new Object[0]);
        } else {
            FMLLog.info((String)"Link Already Exists", (Object[])new Object[0]);
        }
    }

    public void AddMarkerLocationOut(AMVector3 markerLocation) {
        Block out = this.field_145850_b.func_147439_a((int)markerLocation.x, (int)markerLocation.y, (int)markerLocation.z);
        if (out != BlocksCommonProxy.crystalMarker) {
            return;
        }
        TileEntity te = this.field_145850_b.func_147438_o((int)markerLocation.x, (int)markerLocation.y, (int)markerLocation.z);
        if (te == null || !(te instanceof TileEntityCrystalMarker)) {
            return;
        }
        int priority = ((TileEntityCrystalMarker)te).getPriority();
        if (!this.outList.containsKey(priority)) {
            this.outList.put(priority, new ArrayList());
        }
        if (!this.outList.get(priority).contains(markerLocation)) {
            this.outList.get(priority).add(markerLocation);
            FMLLog.finer((String)"Out Link Create", (Object[])new Object[0]);
        } else {
            FMLLog.finer((String)"Link Already Exists", (Object[])new Object[0]);
        }
    }

    public void removeInMarkerLocation(int x, int y, int z) {
        this.inList.remove(new AMVector3(x, y, z));
    }

    public void removeOutMarkerLocation(int x, int y, int z) {
        this.outList.remove(new AMVector3(x, y, z));
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        NBTTagList inItems = new NBTTagList();
        for (AMVector3 inItem : this.inList) {
            NBTTagCompound vectorItem = new NBTTagCompound();
            vectorItem.func_74776_a("x", inItem.x);
            vectorItem.func_74776_a("y", inItem.y);
            vectorItem.func_74776_a("z", inItem.z);
            inItems.func_74742_a((NBTBase)vectorItem);
        }
        nbttagcompound.func_74782_a("InList", (NBTBase)inItems);
        this.writeOutList(nbttagcompound);
        if (this.flickerJar != null) {
            NBTTagCompound jar = new NBTTagCompound();
            this.flickerJar.func_77955_b(jar);
            nbttagcompound.func_74782_a("flickerJar", (NBTBase)jar);
        }
        nbttagcompound.func_74757_a("upgrade", this.isUpgrade);
        if (this.isUpgrade) {
            nbttagcompound.func_74768_a("mainHabitatDirection", this.mainHabitatDirection.flag);
        }
    }

    private void writeOutList(NBTTagCompound compound) {
        NBTTagList outputList = new NBTTagList();
        for (int priority : this.outList.keySet()) {
            NBTTagCompound priorityCompound = new NBTTagCompound();
            priorityCompound.func_74768_a("priority", priority);
            ArrayList<AMVector3> priorityList = this.outList.get(priority);
            if (priorityList == null) continue;
            NBTTagList vectors = new NBTTagList();
            for (AMVector3 vec : priorityList) {
                NBTTagCompound vectorItem = new NBTTagCompound();
                vec.writeToNBT(vectorItem);
                vectors.func_74742_a((NBTBase)vectorItem);
            }
            priorityCompound.func_74782_a("vectors", (NBTBase)vectors);
            outputList.func_74742_a((NBTBase)priorityCompound);
        }
        compound.func_74782_a("outList", (NBTBase)outputList);
    }

    private void readOutList(NBTTagCompound compound) {
        if (!compound.func_74764_b("outList")) {
            return;
        }
        NBTTagList outputList = compound.func_150295_c("outList", 10);
        for (int i = 0; i < outputList.func_74745_c(); ++i) {
            NBTTagCompound priorityCompound = outputList.func_150305_b(i);
            ArrayList<AMVector3> locationsInPriority = new ArrayList<AMVector3>();
            if (!priorityCompound.func_74764_b("priority") || !priorityCompound.func_74764_b("vectors")) {
                FMLLog.info((String)"Malformed save data for flicker item transport controller - cannot process records.", (Object[])new Object[0]);
                continue;
            }
            int priority = priorityCompound.func_74762_e("priority");
            NBTTagList vectors = priorityCompound.func_150295_c("vectors", 10);
            for (int x = 0; x < vectors.func_74745_c(); ++x) {
                NBTTagCompound vectorItem = vectors.func_150305_b(x);
                AMVector3 vec = AMVector3.readFromNBT(vectorItem);
                if (vec == null || vec == AMVector3.zero()) continue;
                locationsInPriority.add(vec);
            }
            this.outList.put(priority, locationsInPriority);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.initLocationLists();
        if (nbttagcompound.func_74764_b("InList")) {
            NBTTagList inItems = nbttagcompound.func_150295_c("InList", 10);
            for (int i = 0; i < inItems.func_74745_c(); ++i) {
                NBTTagCompound inItem = inItems.func_150305_b(i);
                if (inItem == null) continue;
                float x = 0.0f;
                float y = 0.0f;
                float z = 0.0f;
                boolean success = true;
                if (inItem.func_74764_b("x")) {
                    x = inItem.func_74760_g("x");
                } else {
                    success = false;
                }
                if (success && inItem.func_74764_b("y")) {
                    y = inItem.func_74760_g("y");
                } else {
                    success = false;
                }
                if (success && inItem.func_74764_b("z")) {
                    z = inItem.func_74760_g("z");
                } else {
                    success = false;
                }
                if (!success) continue;
                this.inList.add(new AMVector3(x, y, z));
            }
        }
        this.readOutList(nbttagcompound);
        if (nbttagcompound.func_74764_b("upgrade")) {
            this.isUpgrade = nbttagcompound.func_74767_n("upgrade");
        }
        if (nbttagcompound.func_74764_b("flickerJar")) {
            NBTTagCompound jar = nbttagcompound.func_74775_l("flickerJar");
            this.flickerJar = ItemStack.func_77949_a((NBTTagCompound)jar);
            if (!this.isUpgrade) {
                this.setOperatorBasedOnFlicker();
            }
        }
        if (this.isUpgrade) {
            int flag = nbttagcompound.func_74762_e("mainHabitatDirection");
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                if (direction.flag != flag) continue;
                this.mainHabitatDirection = direction;
                break;
            }
        }
    }

    public int getCrystalColor() {
        if (this.flickerJar == null) {
            return 0;
        }
        if (this.flickerJar.func_77973_b() == ItemsCommonProxy.flickerJar) {
            return ((ItemFlickerJar)this.flickerJar.func_77973_b()).func_82790_a(this.flickerJar, 0);
        }
        if (this.flickerJar.func_77973_b() == ItemsCommonProxy.flickerFocus) {
            ArrayList<Affinity> affinities = new ArrayList<Affinity>();
            int meta = this.flickerJar.func_77960_j();
            for (Affinity aff : Affinity.values()) {
                if (aff == Affinity.NONE || (meta & aff.getAffinityMask()) != aff.getAffinityMask()) continue;
                affinities.add(aff);
            }
            if (affinities.size() > 0) {
                int firstColor = ((Affinity)((Object)affinities.get((int)(this.colorCounter % affinities.size())))).color;
                int secondColor = ((Affinity)((Object)affinities.get((int)((this.colorCounter + 1) % affinities.size())))).color;
                if (firstColor == secondColor) {
                    return firstColor;
                }
                if ((float)this.fadeCounter > 20.0f) {
                    return secondColor;
                }
                return this.colorShift(firstColor, secondColor);
            }
        }
        return 0;
    }

    private int colorShift(int f, int s) {
        int fr = f >> 16 & 0xFF;
        int fg = f >> 8 & 0xFF;
        int fb = f & 0xFF;
        int sr = s >> 16 & 0xFF;
        int sg = s >> 8 & 0xFF;
        int sb = s & 0xFF;
        float dr = (float)(sr - fr) / 20.0f;
        float dg = (float)(sg - fg) / 20.0f;
        float db = (float)(sb - fb) / 20.0f;
        int combined = (fr + (int)(dr * (float)this.fadeCounter) & 0xFF) << 16 | (fg + (int)(dg * (float)this.fadeCounter) & 0xFF) << 8 | fb + (int)(db * (float)this.fadeCounter) & 0xFF;
        return combined;
    }

    public int func_70302_i_() {
        return 1;
    }

    public ItemStack func_70301_a(int i) {
        if (i <= this.func_70302_i_() && this.flickerJar != null) {
            return this.flickerJar;
        }
        return null;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (i <= this.func_70302_i_() && this.flickerJar != null) {
            ItemStack jar = this.flickerJar;
            this.flickerJar = null;
            return jar;
        }
        return null;
    }

    public ItemStack func_70304_b(int i) {
        if (i <= this.func_70302_i_() && this.flickerJar != null) {
            ItemStack jar = this.flickerJar;
            this.flickerJar = null;
            return jar;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.flickerJar = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "Flicker Habitat";
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return entityplayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
        if (!this.isUpgrade) {
            this.setOperatorBasedOnFlicker();
            this.scanForNearbyUpgrades();
        } else {
            this.setUpgradeOfMainHabitat();
        }
    }

    private void setUpgradeOfMainHabitat() {
        TileEntity te;
        if (this.mainHabitatDirection != ForgeDirection.UNKNOWN && (te = this.field_145850_b.func_147438_o(this.field_145851_c + this.mainHabitatDirection.offsetX, this.field_145848_d + this.mainHabitatDirection.offsetY, this.field_145849_e + this.mainHabitatDirection.offsetZ)) != null && te instanceof TileEntityFlickerHabitat) {
            ((TileEntityFlickerHabitat)te).notifyOfNearbyUpgradeChange(this);
        }
    }

    private void setOperatorBasedOnFlicker() {
        if (this.flickerJar != null && this.flickerJar.func_77973_b() == ItemsCommonProxy.flickerFocus) {
            this.setOperator(FlickerOperatorRegistry.instance.getOperatorForMask(this.flickerJar.func_77960_j()));
        } else {
            this.setOperator(null);
        }
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return false;
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_145841_b(nbt);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.fadeCounter++ >= 30) {
            ++this.colorCounter;
            this.fadeCounter = 0;
        }
        if (this.field_145850_b.field_72995_K && this.hasFlicker()) {
            this.rotateOffset += 1.0f;
            if (this.rotateOffset >= 360.0f) {
                this.rotateOffset -= 360.0f;
            }
            if (this.floatUp) {
                this.floatOffset += 0.001f;
                if (this.floatOffset >= 0.1f) {
                    this.invertDirection();
                }
            } else {
                this.floatOffset -= 0.001f;
                if (this.floatOffset <= -0.04f) {
                    this.invertDirection();
                }
            }
        }
    }

    private void invertDirection() {
        this.floatUp = !this.floatUp;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void switchMarkerPriority(AMVector3 vec, int oldPriority, int priority) {
        if (this.outList.containsKey(oldPriority)) {
            this.removeOutListAt(oldPriority, vec);
        }
        if (!this.outList.containsKey(priority)) {
            this.outList.put(priority, new ArrayList());
        }
        this.outList.get(priority).add(vec);
    }
}

