/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentities;

import am2.AMCore;
import am2.api.blocks.MultiblockStructureDefinition;
import am2.api.math.AMVector3;
import am2.api.power.IPowerNode;
import am2.api.power.PowerTypes;
import am2.api.spell.component.interfaces.ISkillTreeEntry;
import am2.api.spell.component.interfaces.ISpellModifier;
import am2.api.spell.component.interfaces.ISpellPart;
import am2.blocks.BlocksCommonProxy;
import am2.blocks.tileentities.TileEntityAMPower;
import am2.blocks.tileentities.TileEntityLectern;
import am2.blocks.tileentities.TileEntityOtherworldAura;
import am2.items.ItemEssence;
import am2.items.ItemsCommonProxy;
import am2.multiblock.IMultiblockStructureController;
import am2.network.AMDataReader;
import am2.network.AMDataWriter;
import am2.network.AMNetHandler;
import am2.particles.AMParticle;
import am2.particles.ParticleFadeOut;
import am2.particles.ParticleMoveOnHeading;
import am2.power.PowerNodeRegistry;
import am2.spell.SkillManager;
import am2.spell.SpellRecipeManager;
import am2.spell.SpellUtils;
import am2.spell.components.Summon;
import am2.spell.shapes.Binding;
import am2.utility.KeyValuePair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;

public class TileEntityCraftingAltar
extends TileEntityAMPower
implements IMultiblockStructureController {
    private MultiblockStructureDefinition primary;
    private MultiblockStructureDefinition secondary;
    private boolean isCrafting;
    private final ArrayList<ItemStack> allAddedItems;
    private final ArrayList<ItemStack> currentAddedItems;
    private final ArrayList<KeyValuePair<ISpellPart, byte[]>> spellDef;
    private final ArrayList<ArrayList<KeyValuePair<ISpellPart, byte[]>>> shapeGroups;
    private boolean allShapeGroupsAdded = false;
    private int currentKey = -1;
    private int checkCounter;
    private boolean structureValid;
    private MultiblockStructureDefinition.BlockCoord podiumLocation;
    private MultiblockStructureDefinition.BlockCoord switchLocation;
    private int maxEffects;
    private ItemStack addedPhylactery = null;
    private ItemStack addedBindingCatalyst = null;
    private int[] spellGuide;
    private int[] outputCombo;
    private int[][] shapeGroupGuide;
    private int currentConsumedPower = 0;
    private int ticksExisted = 0;
    private PowerTypes currentMainPowerTypes = PowerTypes.NONE;
    private static final byte CRAFTING_CHANGED = 1;
    private static final byte COMPONENT_ADDED = 2;
    private static final byte FULL_UPDATE = 3;
    private static final int augmatl_mutex = 2;
    private static final int lectern_mutex = 4;
    private MultiblockStructureDefinition.StructureGroup[] lecternGroup_primary;
    private MultiblockStructureDefinition.StructureGroup[] augMatl_primary;
    private MultiblockStructureDefinition.StructureGroup wood_primary;
    private MultiblockStructureDefinition.StructureGroup quartz_primary;
    private MultiblockStructureDefinition.StructureGroup netherbrick_primary;
    private MultiblockStructureDefinition.StructureGroup cobble_primary;
    private MultiblockStructureDefinition.StructureGroup brick_primary;
    private MultiblockStructureDefinition.StructureGroup sandstone_primary;
    private MultiblockStructureDefinition.StructureGroup witchwood_primary;
    private MultiblockStructureDefinition.StructureGroup[] lecternGroup_secondary;
    private MultiblockStructureDefinition.StructureGroup[] augMatl_secondary;
    private MultiblockStructureDefinition.StructureGroup wood_secondary;
    private MultiblockStructureDefinition.StructureGroup quartz_secondary;
    private MultiblockStructureDefinition.StructureGroup netherbrick_secondary;
    private MultiblockStructureDefinition.StructureGroup cobble_secondary;
    private MultiblockStructureDefinition.StructureGroup brick_secondary;
    private MultiblockStructureDefinition.StructureGroup sandstone_secondary;
    private MultiblockStructureDefinition.StructureGroup witchwood_secondary;
    private String currentSpellName = "";

    public TileEntityCraftingAltar() {
        super(500);
        this.setupMultiblock();
        this.allAddedItems = new ArrayList();
        this.currentAddedItems = new ArrayList();
        this.isCrafting = false;
        this.structureValid = false;
        this.checkCounter = 0;
        this.setNoPowerRequests();
        this.maxEffects = 2;
        this.spellDef = new ArrayList();
        this.shapeGroups = new ArrayList();
        for (int i = 0; i < 5; ++i) {
            this.shapeGroups.add(new ArrayList());
        }
    }

    private void setupMultiblock() {
        int n;
        int j;
        int i;
        this.primary = new MultiblockStructureDefinition("craftingAltar_alt");
        Block[] augMatls = new Block[]{Blocks.field_150359_w, Blocks.field_150402_ci, Blocks.field_150451_bX, Blocks.field_150339_S, Blocks.field_150368_y, Blocks.field_150340_R, Blocks.field_150484_ah, Blocks.field_150475_bE, BlocksCommonProxy.AMOres, BlocksCommonProxy.AMOres};
        int[] nArray = new int[10];
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        nArray[3] = 0;
        nArray[4] = 0;
        nArray[5] = 0;
        nArray[6] = 0;
        nArray[7] = 0;
        nArray[8] = 5;
        nArray[9] = 8;
        int[] augMetas = nArray;
        this.lecternGroup_primary = new MultiblockStructureDefinition.StructureGroup[4];
        for (int i2 = 0; i2 < this.lecternGroup_primary.length; ++i2) {
            this.lecternGroup_primary[i2] = this.primary.createGroup("lectern" + i2, 4);
        }
        int count = 0;
        for (i = -2; i <= 2; i += 4) {
            this.primary.addAllowedBlock(this.lecternGroup_primary[count], i, -3, i, BlocksCommonProxy.blockLectern);
            this.primary.addAllowedBlock(this.lecternGroup_primary[count], i, -2, -i, Blocks.field_150442_at, count < 2 ? 2 : 1);
            this.primary.addAllowedBlock(this.lecternGroup_primary[count], i, -2, -i, Blocks.field_150442_at, count < 2 ? 10 : 9);
            this.primary.addAllowedBlock(this.lecternGroup_primary[++count], i, -3, -i, BlocksCommonProxy.blockLectern);
            this.primary.addAllowedBlock(this.lecternGroup_primary[count], i, -2, i, Blocks.field_150442_at, count < 2 ? 2 : 1);
            this.primary.addAllowedBlock(this.lecternGroup_primary[count], i, -2, i, Blocks.field_150442_at, count < 2 ? 10 : 9);
            ++count;
        }
        this.augMatl_primary = new MultiblockStructureDefinition.StructureGroup[augMatls.length];
        for (i = 0; i < augMatls.length; ++i) {
            this.augMatl_primary[i] = this.primary.createGroup("augmatl" + i, 2);
        }
        for (i = 0; i < augMatls.length; ++i) {
            this.primary.addAllowedBlock(this.augMatl_primary[i], -1, 0, -2, augMatls[i], augMetas[i]);
        }
        this.primary.addAllowedBlock(-1, 0, -1, Blocks.field_150390_bg, 0);
        this.primary.addAllowedBlock(-1, 0, 0, Blocks.field_150390_bg, 0);
        this.primary.addAllowedBlock(-1, 0, 1, Blocks.field_150390_bg, 0);
        for (i = 0; i < augMatls.length; ++i) {
            this.primary.addAllowedBlock(this.augMatl_primary[i], -1, 0, 2, augMatls[i], augMetas[i]);
        }
        this.primary.addAllowedBlock(0, 0, -2, Blocks.field_150390_bg, 2);
        this.primary.addAllowedBlock(0, 0, -1, Blocks.field_150417_aV, 0);
        this.primary.addAllowedBlock(0, 0, 0, (Block)BlocksCommonProxy.craftingAltar);
        this.primary.addAllowedBlock(0, 0, 1, Blocks.field_150417_aV, 0);
        this.primary.addAllowedBlock(0, 0, 2, Blocks.field_150390_bg, 3);
        for (i = 0; i < augMatls.length; ++i) {
            this.primary.addAllowedBlock(this.augMatl_primary[i], 1, 0, -2, augMatls[i], augMetas[i]);
        }
        this.primary.addAllowedBlock(1, 0, -1, Blocks.field_150390_bg, 1);
        this.primary.addAllowedBlock(1, 0, 0, Blocks.field_150390_bg, 1);
        this.primary.addAllowedBlock(1, 0, 1, Blocks.field_150390_bg, 1);
        for (i = 0; i < augMatls.length; ++i) {
            this.primary.addAllowedBlock(this.augMatl_primary[i], 1, 0, 2, augMatls[i], augMetas[i]);
        }
        this.primary.addAllowedBlock(1, -1, -2, Blocks.field_150417_aV, 0);
        this.primary.addAllowedBlock(1, -1, -1, Blocks.field_150390_bg, 7);
        this.primary.addAllowedBlock(1, -1, 1, Blocks.field_150390_bg, 6);
        this.primary.addAllowedBlock(1, -1, 2, Blocks.field_150417_aV, 0);
        this.primary.addAllowedBlock(0, -1, -2, BlocksCommonProxy.magicWall, 0);
        this.primary.addAllowedBlock(0, -1, 2, BlocksCommonProxy.magicWall, 0);
        this.primary.addAllowedBlock(-1, -1, -2, Blocks.field_150417_aV, 0);
        this.primary.addAllowedBlock(-1, -1, -1, Blocks.field_150390_bg, 7);
        this.primary.addAllowedBlock(-1, -1, 1, Blocks.field_150390_bg, 6);
        this.primary.addAllowedBlock(-1, -1, 2, Blocks.field_150417_aV, 0);
        this.primary.addAllowedBlock(1, -2, -2, Blocks.field_150417_aV, 0);
        this.primary.addAllowedBlock(1, -2, 2, Blocks.field_150417_aV, 0);
        this.primary.addAllowedBlock(0, -2, -2, BlocksCommonProxy.magicWall, 0);
        this.primary.addAllowedBlock(0, -2, 2, BlocksCommonProxy.magicWall, 0);
        this.primary.addAllowedBlock(-1, -2, -2, Blocks.field_150417_aV, 0);
        this.primary.addAllowedBlock(-1, -2, 2, Blocks.field_150417_aV, 0);
        this.primary.addAllowedBlock(1, -3, -2, Blocks.field_150417_aV, 0);
        this.primary.addAllowedBlock(1, -3, 2, Blocks.field_150417_aV, 0);
        this.primary.addAllowedBlock(0, -3, -2, BlocksCommonProxy.magicWall, 0);
        this.primary.addAllowedBlock(0, -3, 2, BlocksCommonProxy.magicWall, 0);
        this.primary.addAllowedBlock(-1, -3, -2, Blocks.field_150417_aV, 0);
        this.primary.addAllowedBlock(-1, -3, 2, Blocks.field_150417_aV, 0);
        for (i = -2; i <= 2; ++i) {
            for (j = -2; j <= 2; ++j) {
                if (i == 0 && j == 0) {
                    for (n = 0; n < augMatls.length; ++n) {
                        this.primary.addAllowedBlock(this.augMatl_primary[n], i, -4, j, augMatls[n], augMetas[n]);
                    }
                    continue;
                }
                this.primary.addAllowedBlock(i, -4, j, Blocks.field_150417_aV, 0);
            }
        }
        this.wood_primary = this.primary.copyGroup("main", "main_wood");
        this.wood_primary.replaceAllBlocksOfType(Blocks.field_150417_aV, Blocks.field_150344_f);
        this.wood_primary.replaceAllBlocksOfType(Blocks.field_150390_bg, Blocks.field_150476_ad);
        this.quartz_primary = this.primary.copyGroup("main", "main_quartz");
        this.quartz_primary.replaceAllBlocksOfType(Blocks.field_150417_aV, Blocks.field_150371_ca);
        this.quartz_primary.replaceAllBlocksOfType(Blocks.field_150390_bg, Blocks.field_150370_cb);
        this.netherbrick_primary = this.primary.copyGroup("main", "main_netherbrick");
        this.netherbrick_primary.replaceAllBlocksOfType(Blocks.field_150417_aV, Blocks.field_150385_bj);
        this.netherbrick_primary.replaceAllBlocksOfType(Blocks.field_150390_bg, Blocks.field_150387_bl);
        this.cobble_primary = this.primary.copyGroup("main", "main_cobble");
        this.cobble_primary.replaceAllBlocksOfType(Blocks.field_150417_aV, Blocks.field_150347_e);
        this.cobble_primary.replaceAllBlocksOfType(Blocks.field_150390_bg, Blocks.field_150446_ar);
        this.brick_primary = this.primary.copyGroup("main", "main_brick");
        this.brick_primary.replaceAllBlocksOfType(Blocks.field_150417_aV, Blocks.field_150336_V);
        this.brick_primary.replaceAllBlocksOfType(Blocks.field_150390_bg, Blocks.field_150389_bf);
        this.sandstone_primary = this.primary.copyGroup("main", "main_sandstone");
        this.sandstone_primary.replaceAllBlocksOfType(Blocks.field_150417_aV, Blocks.field_150322_A);
        this.sandstone_primary.replaceAllBlocksOfType(Blocks.field_150390_bg, Blocks.field_150372_bz);
        this.witchwood_primary = this.primary.copyGroup("main", "main_witchwood");
        this.witchwood_primary.replaceAllBlocksOfType(Blocks.field_150417_aV, (Block)BlocksCommonProxy.witchwoodPlanks);
        this.witchwood_primary.replaceAllBlocksOfType(Blocks.field_150390_bg, (Block)BlocksCommonProxy.witchwoodStairs);
        this.secondary = new MultiblockStructureDefinition("craftingAltar");
        this.lecternGroup_secondary = new MultiblockStructureDefinition.StructureGroup[4];
        for (i = 0; i < this.lecternGroup_secondary.length; ++i) {
            this.lecternGroup_secondary[i] = this.secondary.createGroup("lectern" + i, 4);
        }
        count = 0;
        for (i = -2; i <= 2; i += 4) {
            this.secondary.addAllowedBlock(this.lecternGroup_secondary[count], i, -3, i, BlocksCommonProxy.blockLectern);
            this.secondary.addAllowedBlock(this.lecternGroup_secondary[count], -i, -2, i, Blocks.field_150442_at, count < 2 ? 4 : 3);
            this.secondary.addAllowedBlock(this.lecternGroup_secondary[count], -i, -2, i, Blocks.field_150442_at, count < 2 ? 12 : 11);
            this.secondary.addAllowedBlock(this.lecternGroup_secondary[++count], -i, -3, i, BlocksCommonProxy.blockLectern);
            this.secondary.addAllowedBlock(this.lecternGroup_secondary[count], i, -2, i, Blocks.field_150442_at, count < 2 ? 4 : 3);
            this.secondary.addAllowedBlock(this.lecternGroup_secondary[count], i, -2, i, Blocks.field_150442_at, count < 2 ? 12 : 11);
            ++count;
        }
        this.augMatl_secondary = new MultiblockStructureDefinition.StructureGroup[augMatls.length];
        for (i = 0; i < augMatls.length; ++i) {
            this.augMatl_secondary[i] = this.secondary.createGroup("augmatl" + i, 2);
        }
        for (i = 0; i < augMatls.length; ++i) {
            this.secondary.addAllowedBlock(this.augMatl_secondary[i], -2, 0, -1, augMatls[i], augMetas[i]);
        }
        this.secondary.addAllowedBlock(-1, 0, -1, Blocks.field_150390_bg, 2);
        this.secondary.addAllowedBlock(0, 0, -1, Blocks.field_150390_bg, 2);
        this.secondary.addAllowedBlock(1, 0, -1, Blocks.field_150390_bg, 2);
        for (i = 0; i < augMatls.length; ++i) {
            this.secondary.addAllowedBlock(this.augMatl_secondary[i], 2, 0, -1, augMatls[i], augMetas[i]);
        }
        this.secondary.addAllowedBlock(-2, 0, 0, Blocks.field_150390_bg, 0);
        this.secondary.addAllowedBlock(-1, 0, 0, Blocks.field_150417_aV, 0);
        this.secondary.addAllowedBlock(0, 0, 0, (Block)BlocksCommonProxy.craftingAltar);
        this.secondary.addAllowedBlock(1, 0, 0, Blocks.field_150417_aV, 0);
        this.secondary.addAllowedBlock(2, 0, 0, Blocks.field_150390_bg, 1);
        for (i = 0; i < augMatls.length; ++i) {
            this.secondary.addAllowedBlock(this.augMatl_secondary[i], -2, 0, 1, augMatls[i], augMetas[i]);
        }
        this.secondary.addAllowedBlock(-1, 0, 1, Blocks.field_150390_bg, 3);
        this.secondary.addAllowedBlock(0, 0, 1, Blocks.field_150390_bg, 3);
        this.secondary.addAllowedBlock(1, 0, 1, Blocks.field_150390_bg, 3);
        for (i = 0; i < augMatls.length; ++i) {
            this.secondary.addAllowedBlock(this.augMatl_secondary[i], 2, 0, 1, augMatls[i], augMetas[i]);
        }
        this.secondary.addAllowedBlock(-2, -1, 1, Blocks.field_150417_aV, 0);
        this.secondary.addAllowedBlock(-1, -1, 1, Blocks.field_150390_bg, 5);
        this.secondary.addAllowedBlock(1, -1, 1, Blocks.field_150390_bg, 4);
        this.secondary.addAllowedBlock(2, -1, 1, Blocks.field_150417_aV, 0);
        this.secondary.addAllowedBlock(-2, -1, 0, BlocksCommonProxy.magicWall, 0);
        this.secondary.addAllowedBlock(2, -1, 0, BlocksCommonProxy.magicWall, 0);
        this.secondary.addAllowedBlock(-2, -1, -1, Blocks.field_150417_aV, 0);
        this.secondary.addAllowedBlock(-1, -1, -1, Blocks.field_150390_bg, 5);
        this.secondary.addAllowedBlock(1, -1, -1, Blocks.field_150390_bg, 4);
        this.secondary.addAllowedBlock(2, -1, -1, Blocks.field_150417_aV, 0);
        this.secondary.addAllowedBlock(-2, -2, 1, Blocks.field_150417_aV, 0);
        this.secondary.addAllowedBlock(2, -2, 1, Blocks.field_150417_aV, 0);
        this.secondary.addAllowedBlock(-2, -2, 0, BlocksCommonProxy.magicWall, 0);
        this.secondary.addAllowedBlock(2, -2, 0, BlocksCommonProxy.magicWall, 0);
        this.secondary.addAllowedBlock(-2, -2, -1, Blocks.field_150417_aV, 0);
        this.secondary.addAllowedBlock(2, -2, -1, Blocks.field_150417_aV, 0);
        this.secondary.addAllowedBlock(-2, -3, 1, Blocks.field_150417_aV, 0);
        this.secondary.addAllowedBlock(2, -3, 1, Blocks.field_150417_aV, 0);
        this.secondary.addAllowedBlock(-2, -3, 0, BlocksCommonProxy.magicWall, 0);
        this.secondary.addAllowedBlock(2, -3, 0, BlocksCommonProxy.magicWall, 0);
        this.secondary.addAllowedBlock(-2, -3, -1, Blocks.field_150417_aV, 0);
        this.secondary.addAllowedBlock(2, -3, -1, Blocks.field_150417_aV, 0);
        for (i = -2; i <= 2; ++i) {
            for (j = -2; j <= 2; ++j) {
                if (i == 0 && j == 0) {
                    for (n = 0; n < augMatls.length; ++n) {
                        this.secondary.addAllowedBlock(this.augMatl_secondary[n], i, -4, j, augMatls[n], augMetas[n]);
                    }
                    continue;
                }
                this.secondary.addAllowedBlock(i, -4, j, Blocks.field_150417_aV, 0);
            }
        }
        this.wood_secondary = this.secondary.copyGroup("main", "main_wood");
        this.wood_secondary.replaceAllBlocksOfType(Blocks.field_150417_aV, Blocks.field_150344_f);
        this.wood_secondary.replaceAllBlocksOfType(Blocks.field_150390_bg, Blocks.field_150476_ad);
        this.quartz_secondary = this.secondary.copyGroup("main", "main_quartz");
        this.quartz_secondary.replaceAllBlocksOfType(Blocks.field_150417_aV, Blocks.field_150371_ca);
        this.quartz_secondary.replaceAllBlocksOfType(Blocks.field_150390_bg, Blocks.field_150370_cb);
        this.netherbrick_secondary = this.secondary.copyGroup("main", "main_netherbrick");
        this.netherbrick_secondary.replaceAllBlocksOfType(Blocks.field_150417_aV, Blocks.field_150385_bj);
        this.netherbrick_secondary.replaceAllBlocksOfType(Blocks.field_150390_bg, Blocks.field_150387_bl);
        this.cobble_secondary = this.secondary.copyGroup("main", "main_cobble");
        this.cobble_secondary.replaceAllBlocksOfType(Blocks.field_150417_aV, Blocks.field_150347_e);
        this.cobble_secondary.replaceAllBlocksOfType(Blocks.field_150390_bg, Blocks.field_150446_ar);
        this.brick_secondary = this.secondary.copyGroup("main", "main_brick");
        this.brick_secondary.replaceAllBlocksOfType(Blocks.field_150417_aV, Blocks.field_150336_V);
        this.brick_secondary.replaceAllBlocksOfType(Blocks.field_150390_bg, Blocks.field_150389_bf);
        this.sandstone_secondary = this.secondary.copyGroup("main", "main_sandstone");
        this.sandstone_secondary.replaceAllBlocksOfType(Blocks.field_150417_aV, Blocks.field_150322_A);
        this.sandstone_secondary.replaceAllBlocksOfType(Blocks.field_150390_bg, Blocks.field_150372_bz);
        this.witchwood_secondary = this.secondary.copyGroup("main", "main_witchwood");
        this.witchwood_secondary.replaceAllBlocksOfType(Blocks.field_150417_aV, (Block)BlocksCommonProxy.witchwoodPlanks);
        this.witchwood_secondary.replaceAllBlocksOfType(Blocks.field_150390_bg, (Block)BlocksCommonProxy.witchwoodStairs);
    }

    @Override
    public MultiblockStructureDefinition getDefinition() {
        return this.secondary;
    }

    public ItemStack getNextPlannedItem() {
        if (this.spellGuide != null) {
            if (this.allAddedItems.size() * 3 < this.spellGuide.length) {
                int guide_id = this.spellGuide[this.allAddedItems.size() * 3];
                int guide_qty = this.spellGuide[this.allAddedItems.size() * 3 + 1];
                int guide_meta = this.spellGuide[this.allAddedItems.size() * 3 + 2];
                ItemStack stack = new ItemStack(Item.func_150899_d((int)guide_id), guide_qty, guide_meta);
                return stack;
            }
            return new ItemStack((Item)ItemsCommonProxy.spellParchment);
        }
        return null;
    }

    private int getNumPartsInSpell() {
        int parts = 0;
        if (this.outputCombo != null) {
            parts = this.outputCombo.length;
        }
        if (this.shapeGroupGuide != null) {
            for (int i = 0; i < this.shapeGroupGuide.length; ++i) {
                if (this.shapeGroupGuide[i] == null) continue;
                parts += this.shapeGroupGuide[i].length;
            }
        }
        return parts;
    }

    private boolean spellGuideIsWithinStructurePower() {
        return this.getNumPartsInSpell() <= this.maxEffects;
    }

    private boolean currentDefinitionIsWithinStructurePower() {
        int count = this.spellDef.size();
        for (ArrayList<KeyValuePair<ISpellPart, byte[]>> part : this.shapeGroups) {
            count += part.size();
        }
        return count <= this.maxEffects;
    }

    public boolean structureValid() {
        return this.structureValid;
    }

    public boolean isCrafting() {
        return this.isCrafting;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        ++this.ticksExisted;
        this.checkStructure();
        this.checkForStartCondition();
        this.updateLecternInformation();
        if (this.isCrafting) {
            this.checkForEndCondition();
            this.updatePowerRequestData();
            if (!this.field_145850_b.field_72995_K && !this.currentDefinitionIsWithinStructurePower() && this.ticksExisted > 100) {
                this.field_145850_b.func_72885_a(null, (double)this.field_145851_c + 0.5, (double)this.field_145848_d - 1.5, (double)this.field_145849_e + 0.5, 5.0f, false, true);
                this.setCrafting(false);
                return;
            }
            if (this.field_145850_b.field_72995_K && this.checkCounter == 1) {
                AMCore.proxy.particleManager.RibbonFromPointToPoint(this.field_145850_b, (double)this.field_145851_c + 0.5, this.field_145848_d - 2, (double)this.field_145849_e + 0.5, (double)this.field_145851_c + 0.5, this.field_145848_d - 3, (double)this.field_145849_e + 0.5);
            }
            List<EntityItem> components = this.lookForValidItems();
            ItemStack stack = this.getNextPlannedItem();
            for (EntityItem item : components) {
                if (item.field_70128_L) continue;
                ItemStack entityItemStack = item.func_92059_d();
                if (stack == null || !this.compareItemStacks(stack, entityItemStack)) continue;
                if (!this.field_145850_b.field_72995_K) {
                    this.updateCurrentRecipe(item);
                    item.func_70106_y();
                    continue;
                }
                this.field_145850_b.func_72980_b((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "arsmagica2:misc.craftingaltar.component_added", 1.0f, 0.4f + this.field_145850_b.field_73012_v.nextFloat() * 0.6f, false);
                for (int i = 0; i < 5 * AMCore.config.getGFXLevel(); ++i) {
                    AMParticle particle = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(this.field_145850_b, "radiant", item.field_70165_t, item.field_70163_u, item.field_70161_v));
                    if (particle == null) continue;
                    particle.setMaxAge(40);
                    particle.AddParticleController(new ParticleMoveOnHeading(particle, this.field_145850_b.field_73012_v.nextFloat() * 360.0f, this.field_145850_b.field_73012_v.nextFloat() * 360.0f, 0.01f, 1, false));
                    particle.AddParticleController(new ParticleFadeOut(particle, 1, false).setFadeSpeed(0.05f).setKillParticleOnFinish(true));
                    particle.setParticleScale(0.02f);
                    particle.setRGBColorF(this.field_145850_b.field_73012_v.nextFloat(), this.field_145850_b.field_73012_v.nextFloat(), this.field_145850_b.field_73012_v.nextFloat());
                }
            }
        }
    }

    private void updateLecternInformation() {
        if (this.podiumLocation == null) {
            return;
        }
        TileEntityLectern lectern = (TileEntityLectern)this.field_145850_b.func_147438_o(this.field_145851_c + this.podiumLocation.getX(), this.field_145848_d + this.podiumLocation.getY(), this.field_145849_e + this.podiumLocation.getZ());
        if (lectern != null) {
            if (lectern.hasStack()) {
                ItemStack lecternStack = lectern.getStack();
                if (lecternStack.func_77942_o()) {
                    this.spellGuide = lecternStack.func_77978_p().func_74759_k("spell_combo");
                    this.outputCombo = lecternStack.func_77978_p().func_74759_k("output_combo");
                    this.currentSpellName = lecternStack.func_82833_r();
                    int numShapeGroups = lecternStack.func_77978_p().func_74762_e("numShapeGroups");
                    this.shapeGroupGuide = new int[numShapeGroups][];
                    for (int i = 0; i < numShapeGroups; ++i) {
                        this.shapeGroupGuide[i] = lecternStack.func_77978_p().func_74759_k("shapeGroupCombo_" + i);
                    }
                }
                if (this.isCrafting) {
                    if (this.spellGuide != null) {
                        lectern.setNeedsBook(false);
                        lectern.setTooltipStack(this.getNextPlannedItem());
                    } else {
                        lectern.setNeedsBook(true);
                    }
                } else {
                    lectern.setTooltipStack(null);
                }
                if (this.spellGuideIsWithinStructurePower()) {
                    lectern.setOverpowered(false);
                } else {
                    lectern.setOverpowered(true);
                }
            } else {
                if (this.isCrafting) {
                    lectern.setNeedsBook(true);
                }
                lectern.setTooltipStack(null);
            }
        }
    }

    public MultiblockStructureDefinition.BlockCoord getSwitchLocation() {
        return this.switchLocation;
    }

    public boolean switchIsOn() {
        if (this.switchLocation == null) {
            return false;
        }
        Block block = this.field_145850_b.func_147439_a(this.field_145851_c + this.switchLocation.getX(), this.field_145848_d + this.switchLocation.getY(), this.field_145849_e + this.switchLocation.getZ());
        boolean b = false;
        if (block == Blocks.field_150442_at) {
            for (int i = 0; i < 6 && !(b |= Blocks.field_150442_at.func_149748_c((IBlockAccess)this.field_145850_b, this.field_145851_c + this.switchLocation.getX(), this.field_145848_d + this.switchLocation.getY(), this.field_145849_e + this.switchLocation.getZ(), i) > 0); ++i) {
            }
        }
        return b;
    }

    public void flipSwitch() {
        if (this.switchLocation == null) {
            return;
        }
        Block block = this.field_145850_b.func_147439_a(this.field_145851_c + this.switchLocation.getX(), this.field_145848_d + this.switchLocation.getY(), this.field_145849_e + this.switchLocation.getZ());
        if (block == Blocks.field_150442_at) {
            Blocks.field_150442_at.func_149727_a(this.field_145850_b, this.field_145851_c + this.switchLocation.getX(), this.field_145848_d + this.switchLocation.getY(), this.field_145849_e + this.switchLocation.getZ(), null, 0, 0.0f, 0.0f, 0.0f);
        }
    }

    private void updatePowerRequestData() {
        ItemStack stack = this.getNextPlannedItem();
        if (stack != null && stack.func_77973_b() instanceof ItemEssence && stack.func_77960_j() > 12) {
            if (this.switchIsOn()) {
                int flags = stack.func_77960_j() - 12;
                this.setPowerRequests();
                this.pickPowerType(stack);
                if (this.currentMainPowerTypes != PowerTypes.NONE && PowerNodeRegistry.For(this.field_145850_b).checkPower(this, 100.0f)) {
                    this.currentConsumedPower = (int)((float)this.currentConsumedPower + PowerNodeRegistry.For(this.field_145850_b).consumePower(this, this.currentMainPowerTypes, Math.min(100, stack.field_77994_a - this.currentConsumedPower)));
                }
                if (this.currentConsumedPower >= stack.field_77994_a) {
                    PowerNodeRegistry.For(this.field_145850_b).setPower(this, PowerTypes.LIGHT, 0.0f);
                    PowerNodeRegistry.For(this.field_145850_b).setPower(this, PowerTypes.NEUTRAL, 0.0f);
                    PowerNodeRegistry.For(this.field_145850_b).setPower(this, PowerTypes.DARK, 0.0f);
                    if (!this.field_145850_b.field_72995_K) {
                        this.addItemToRecipe(new ItemStack((Item)ItemsCommonProxy.essence, stack.field_77994_a, 12 + flags));
                    }
                    this.currentConsumedPower = 0;
                    this.currentMainPowerTypes = PowerTypes.NONE;
                    this.setNoPowerRequests();
                    this.flipSwitch();
                }
            } else {
                this.setNoPowerRequests();
            }
        } else {
            this.setNoPowerRequests();
        }
    }

    @Override
    protected void setNoPowerRequests() {
        this.currentConsumedPower = 0;
        this.currentMainPowerTypes = PowerTypes.NONE;
        super.setNoPowerRequests();
    }

    private void pickPowerType(ItemStack stack) {
        if (this.currentMainPowerTypes != PowerTypes.NONE) {
            return;
        }
        int flags = stack.func_77960_j() - 12;
        PowerTypes highestValid = PowerTypes.NONE;
        float amt = 0.0f;
        for (PowerTypes type : PowerTypes.all()) {
            float tmpAmt = PowerNodeRegistry.For(this.field_145850_b).getPower(this, type);
            if (!(tmpAmt > amt)) continue;
            highestValid = type;
        }
        this.currentMainPowerTypes = highestValid;
    }

    private void updateCurrentRecipe(EntityItem item) {
        ItemStack stack = item.func_92059_d();
        this.addItemToRecipe(stack);
    }

    private void addItemToRecipe(ItemStack stack) {
        this.allAddedItems.add(stack);
        this.currentAddedItems.add(stack);
        if (!this.field_145850_b.field_72995_K) {
            AMDataWriter writer = new AMDataWriter();
            writer.add(this.field_145851_c);
            writer.add(this.field_145848_d);
            writer.add(this.field_145849_e);
            writer.add((byte)2);
            writer.add(stack);
            AMNetHandler.INSTANCE.sendPacketToAllClientsNear(this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e, 32.0, (byte)4, writer.generate());
        }
        if (this.matchCurrentRecipe()) {
            this.currentAddedItems.clear();
            return;
        }
    }

    private boolean matchCurrentRecipe() {
        ISpellPart part = SpellRecipeManager.instance.getPartByRecipe(this.currentAddedItems);
        if (part == null) {
            return false;
        }
        ArrayList<KeyValuePair<ISpellPart, byte[]>> currentShapeGroupList = this.getShapeGroupToAddTo();
        if (part instanceof Summon) {
            this.handleSummonShape();
        }
        if (part instanceof Binding) {
            this.handleBindingShape();
        }
        byte[] metaData = new byte[]{};
        if (part instanceof ISpellModifier && (metaData = ((ISpellModifier)part).getModifierMetadata(this.currentAddedItems.toArray(new ItemStack[this.currentAddedItems.size()]))) == null) {
            metaData = new byte[]{};
        }
        if (currentShapeGroupList == null) {
            this.spellDef.add(new KeyValuePair<ISpellPart, byte[]>(part, metaData));
        } else {
            currentShapeGroupList.add(new KeyValuePair<ISpellPart, byte[]>(part, metaData));
        }
        return true;
    }

    private ArrayList<KeyValuePair<ISpellPart, byte[]>> getShapeGroupToAddTo() {
        for (int i = 0; i < this.shapeGroupGuide.length; ++i) {
            int guideLength = this.shapeGroupGuide[i].length;
            int addedLength = this.shapeGroups.get(i).size();
            if (addedLength >= guideLength) continue;
            return this.shapeGroups.get(i);
        }
        return null;
    }

    private void handleSummonShape() {
        if (this.currentAddedItems.size() > 2) {
            this.addedPhylactery = this.currentAddedItems.get(this.currentAddedItems.size() - 2);
        }
    }

    private void handleBindingShape() {
        if (this.currentAddedItems.size() == 7) {
            this.addedBindingCatalyst = this.currentAddedItems.get(this.currentAddedItems.size() - 1);
        }
    }

    private List<EntityItem> lookForValidItems() {
        if (!this.isCrafting) {
            return new ArrayList<EntityItem>();
        }
        double radius = this.field_145850_b.field_72995_K ? 2.1 : 2.0;
        List items = this.field_145850_b.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - radius), (double)(this.field_145848_d - 3), (double)((double)this.field_145849_e - radius), (double)((double)this.field_145851_c + radius), (double)this.field_145848_d, (double)((double)this.field_145849_e + radius)));
        return items;
    }

    private void checkStructure() {
        if (this.isCrafting && this.checkCounter++ < 50 || !this.isCrafting && this.checkCounter++ < 200) {
            return;
        }
        this.checkCounter = 0;
        boolean primaryvalid = this.primary.checkStructure(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        boolean secondaryvalid = this.secondary.checkStructure(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (!primaryvalid && !secondaryvalid && this.isCrafting) {
            this.setCrafting(false);
        }
        if (primaryvalid || secondaryvalid) {
            MultiblockStructureDefinition.StructureGroup group;
            this.maxEffects = 0;
            ArrayList<MultiblockStructureDefinition.StructureGroup> lecternGroups = null;
            ArrayList<MultiblockStructureDefinition.StructureGroup> augmatlGroups = null;
            ArrayList<MultiblockStructureDefinition.StructureGroup> mainmatlGroups = null;
            if (primaryvalid) {
                lecternGroups = this.primary.getMatchedGroups(4, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                augmatlGroups = this.primary.getMatchedGroups(2, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                mainmatlGroups = this.primary.getMatchedGroups(1, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            } else if (secondaryvalid) {
                lecternGroups = this.secondary.getMatchedGroups(4, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                augmatlGroups = this.secondary.getMatchedGroups(2, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                mainmatlGroups = this.secondary.getMatchedGroups(1, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            if (lecternGroups != null && lecternGroups.size() > 0) {
                group = (MultiblockStructureDefinition.StructureGroup)lecternGroups.get(0);
                HashMap<MultiblockStructureDefinition.BlockCoord, ArrayList<MultiblockStructureDefinition.BlockDec>> blocks = group.getAllowedBlocks();
                for (MultiblockStructureDefinition.BlockCoord bc : blocks.keySet()) {
                    Block block = this.field_145850_b.func_147439_a(this.field_145851_c + bc.getX(), this.field_145848_d + bc.getY(), this.field_145849_e + bc.getZ());
                    if (block == BlocksCommonProxy.blockLectern) {
                        this.podiumLocation = bc;
                        continue;
                    }
                    if (block != Blocks.field_150442_at) continue;
                    this.switchLocation = bc;
                }
            }
            if (augmatlGroups != null && augmatlGroups.size() == 1) {
                group = (MultiblockStructureDefinition.StructureGroup)augmatlGroups.get(0);
                int index = -1;
                for (MultiblockStructureDefinition.StructureGroup augmatlGroup : primaryvalid ? this.augMatl_primary : this.augMatl_secondary) {
                    ++index;
                    if (augmatlGroup == group) break;
                }
                this.maxEffects = index + 1;
            }
            if (mainmatlGroups != null && mainmatlGroups.size() == 1) {
                group = (MultiblockStructureDefinition.StructureGroup)mainmatlGroups.get(0);
                this.maxEffects = group == this.wood_primary || group == this.wood_secondary ? ++this.maxEffects : (group == this.cobble_primary || group == this.cobble_secondary || group == this.sandstone_primary || group == this.sandstone_secondary ? ++this.maxEffects : (group == this.brick_primary || group == this.brick_secondary || group == this.witchwood_primary || group == this.witchwood_secondary ? (this.maxEffects += 2) : (group == this.netherbrick_primary || group == this.netherbrick_secondary || group == this.quartz_primary || group == this.quartz_secondary ? (this.maxEffects += 3) : (this.maxEffects += 2))));
            }
        } else {
            this.podiumLocation = null;
            this.switchLocation = null;
            this.maxEffects = 0;
        }
        this.setStructureValid(primaryvalid || secondaryvalid);
    }

    private void checkForStartCondition() {
        EntityItem item;
        if (this.field_145850_b.field_72995_K || !this.structureValid || this.isCrafting) {
            return;
        }
        List items = this.field_145850_b.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 2), (double)(this.field_145848_d - 3), (double)(this.field_145849_e - 2), (double)(this.field_145851_c + 2), (double)this.field_145848_d, (double)(this.field_145849_e + 2)));
        if (items.size() == 1 && (item = (EntityItem)items.get(0)) != null && !item.field_70128_L && item.func_92059_d().func_77973_b() == ItemsCommonProxy.rune) {
            if (item.func_92059_d().func_77960_j() == 1) {
                item.func_70106_y();
                this.setCrafting(true);
            }
        }
    }

    private void checkForEndCondition() {
        EntityItem item;
        if (!this.structureValid || !this.isCrafting || this.field_145850_b == null) {
            return;
        }
        double radius = this.field_145850_b.field_72995_K ? 2.2 : 2.0;
        List items = this.field_145850_b.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - radius), (double)(this.field_145848_d - 3), (double)((double)this.field_145849_e - radius), (double)((double)this.field_145851_c + radius), (double)this.field_145848_d, (double)((double)this.field_145849_e + radius)));
        if (items.size() == 1 && (item = (EntityItem)items.get(0)) != null && !item.field_70128_L && item.func_92059_d() != null && item.func_92059_d().func_77973_b() == ItemsCommonProxy.spellParchment) {
            if (!this.field_145850_b.field_72995_K) {
                item.func_70106_y();
                this.setCrafting(false);
                EntityItem craftedItem = new EntityItem(this.field_145850_b);
                craftedItem.func_70107_b((double)this.field_145851_c + 0.5, (double)this.field_145848_d - 1.5, (double)this.field_145849_e + 0.5);
                ItemStack craftStack = SpellUtils.instance.createSpellStack(this.shapeGroups, this.spellDef);
                if (!craftStack.func_77942_o()) {
                    craftStack.field_77990_d = new NBTTagCompound();
                }
                this.AddSpecialMetadata(craftStack);
                craftStack.field_77990_d.func_74778_a("suggestedName", this.currentSpellName != null ? this.currentSpellName : "");
                craftedItem.func_92058_a(craftStack);
                this.field_145850_b.func_72838_d((Entity)craftedItem);
                this.allAddedItems.clear();
                this.currentAddedItems.clear();
            } else {
                this.field_145850_b.func_72980_b((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "arsmagica2:misc.craftingaltar.create_spell", 1.0f, 1.0f, true);
            }
        }
    }

    private void AddSpecialMetadata(ItemStack craftStack) {
        if (this.addedPhylactery != null) {
            Summon summon = (Summon)SkillManager.instance.getSkill("Summon");
            summon.setSummonType(craftStack, this.addedPhylactery);
        }
        if (this.addedBindingCatalyst != null) {
            Binding binding = (Binding)SkillManager.instance.getSkill("Binding");
            binding.setBindingType(craftStack, this.addedBindingCatalyst);
        }
    }

    private void setCrafting(boolean crafting) {
        this.isCrafting = crafting;
        if (!this.field_145850_b.field_72995_K) {
            AMDataWriter writer = new AMDataWriter();
            writer.add(this.field_145851_c);
            writer.add(this.field_145848_d);
            writer.add(this.field_145849_e);
            writer.add((byte)1);
            writer.add(crafting);
            AMNetHandler.INSTANCE.sendPacketToAllClientsNear(this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e, 32.0, (byte)4, writer.generate());
        }
        if (crafting) {
            IPowerNode[] nodes;
            this.allAddedItems.clear();
            this.currentAddedItems.clear();
            this.spellDef.clear();
            for (ArrayList<KeyValuePair<ISpellPart, byte[]>> groups : this.shapeGroups) {
                groups.clear();
            }
            for (IPowerNode node : nodes = PowerNodeRegistry.For(this.field_145850_b).getAllNearbyNodes(this.field_145850_b, new AMVector3(this), PowerTypes.DARK)) {
                if (!(node instanceof TileEntityOtherworldAura)) continue;
                ((TileEntityOtherworldAura)node).setActive(true, this);
                break;
            }
        }
    }

    private void setStructureValid(boolean valid) {
        if (this.structureValid == valid) {
            return;
        }
        this.structureValid = valid;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void deactivate() {
        if (!this.field_145850_b.field_72995_K) {
            this.setCrafting(false);
            for (ItemStack stack : this.allAddedItems) {
                if (stack.func_77973_b() == ItemsCommonProxy.essence) {
                    if (stack.func_77960_j() > 12) continue;
                }
                EntityItem eItem = new EntityItem(this.field_145850_b);
                eItem.func_70107_b((double)this.field_145851_c, (double)(this.field_145848_d - 1), (double)this.field_145849_e);
                eItem.func_92058_a(stack);
                this.field_145850_b.func_72838_d((Entity)eItem);
            }
            this.allAddedItems.clear();
        }
    }

    @Override
    public boolean canProvidePower(PowerTypes type) {
        return false;
    }

    private boolean compareItemStacks(ItemStack target, ItemStack input) {
        if (target.func_77973_b() == Items.field_151068_bn && input.func_77973_b() == Items.field_151068_bn) {
            return (target.func_77960_j() & 0xF) == (input.func_77960_j() & 0xF);
        }
        return target.func_77973_b() == input.func_77973_b() && (target.func_77960_j() == input.func_77960_j() || target.func_77960_j() == Short.MAX_VALUE) && target.field_77994_a == input.field_77994_a;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        NBTTagCompound altarCompound = new NBTTagCompound();
        altarCompound.func_74757_a("isCrafting", this.isCrafting);
        altarCompound.func_74768_a("currentKey", this.currentKey);
        altarCompound.func_74778_a("currentSpellName", this.currentSpellName);
        NBTTagList allAddedItemsList = new NBTTagList();
        for (ItemStack stack : this.allAddedItems) {
            NBTTagCompound addedItem = new NBTTagCompound();
            stack.func_77955_b(addedItem);
            allAddedItemsList.func_74742_a((NBTBase)addedItem);
        }
        altarCompound.func_74782_a("allAddedItems", (NBTBase)allAddedItemsList);
        NBTTagList currentAddedItemsList = new NBTTagList();
        for (ItemStack stack : this.currentAddedItems) {
            NBTTagCompound addedItem = new NBTTagCompound();
            stack.func_77955_b(addedItem);
            currentAddedItemsList.func_74742_a((NBTBase)addedItem);
        }
        altarCompound.func_74782_a("currentAddedItems", (NBTBase)currentAddedItemsList);
        if (this.addedPhylactery != null) {
            NBTTagCompound phylactery = new NBTTagCompound();
            this.addedPhylactery.func_77955_b(phylactery);
            altarCompound.func_74782_a("phylactery", (NBTBase)phylactery);
        }
        if (this.addedBindingCatalyst != null) {
            NBTTagCompound catalyst = new NBTTagCompound();
            this.addedBindingCatalyst.func_77955_b(catalyst);
            altarCompound.func_74782_a("catalyst", (NBTBase)catalyst);
        }
        NBTTagList shapeGroupData = new NBTTagList();
        for (ArrayList<KeyValuePair<ISpellPart, byte[]>> list : this.shapeGroups) {
            shapeGroupData.func_74742_a((NBTBase)this.ISpellPartListToNBT(list));
        }
        altarCompound.func_74782_a("shapeGroups", (NBTBase)shapeGroupData);
        NBTTagCompound spellDefSave = this.ISpellPartListToNBT(this.spellDef);
        altarCompound.func_74782_a("spellDef", (NBTBase)spellDefSave);
        nbttagcompound.func_74782_a("altarData", (NBTBase)altarCompound);
    }

    private NBTTagCompound ISpellPartListToNBT(ArrayList<KeyValuePair<ISpellPart, byte[]>> list) {
        NBTTagCompound shapeGroupData = new NBTTagCompound();
        int[] ids = new int[list.size()];
        byte[][] meta = new byte[list.size()][];
        for (int d = 0; d < list.size(); ++d) {
            ids[d] = SkillManager.instance.getShiftedPartID(list.get(d).getKey());
            meta[d] = list.get(d).getValue();
        }
        shapeGroupData.func_74783_a("group_ids", ids);
        for (int i = 0; i < meta.length; ++i) {
            shapeGroupData.func_74773_a("meta_" + i, meta[i]);
        }
        return shapeGroupData;
    }

    private ArrayList<KeyValuePair<ISpellPart, byte[]>> NBTToISpellPartList(NBTTagCompound compound) {
        int[] ids = compound.func_74759_k("group_ids");
        ArrayList<KeyValuePair<ISpellPart, byte[]>> list = new ArrayList<KeyValuePair<ISpellPart, byte[]>>();
        for (int i = 0; i < ids.length; ++i) {
            int partID = ids[i];
            ISkillTreeEntry part = SkillManager.instance.getSkill(i);
            byte[] partMeta = compound.func_74770_j("meta_" + i);
            if (!(part instanceof ISpellPart)) continue;
            list.add(new KeyValuePair<ISpellPart, byte[]>((ISpellPart)part, partMeta));
        }
        return list;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        ItemStack stack;
        NBTTagCompound addedItem;
        int i;
        NBTTagCompound catalyst;
        NBTTagCompound phylactery;
        super.func_145839_a(nbttagcompound);
        if (!nbttagcompound.func_74764_b("altarData")) {
            return;
        }
        NBTTagCompound altarCompound = nbttagcompound.func_74775_l("altarData");
        NBTTagList allAddedItems = altarCompound.func_150295_c("allAddedItems", 10);
        NBTTagList currentAddedItems = altarCompound.func_150295_c("currentAddedItems", 10);
        this.isCrafting = altarCompound.func_74767_n("isCrafting");
        this.currentKey = altarCompound.func_74762_e("currentKey");
        this.currentSpellName = altarCompound.func_74779_i("currentSpellName");
        if (altarCompound.func_74764_b("phylactery") && (phylactery = altarCompound.func_74775_l("phylactery")) != null) {
            this.addedPhylactery = ItemStack.func_77949_a((NBTTagCompound)phylactery);
        }
        if (altarCompound.func_74764_b("catalyst") && (catalyst = altarCompound.func_74775_l("catalyst")) != null) {
            this.addedBindingCatalyst = ItemStack.func_77949_a((NBTTagCompound)catalyst);
        }
        this.allAddedItems.clear();
        for (i = 0; i < allAddedItems.func_74745_c(); ++i) {
            addedItem = allAddedItems.func_150305_b(i);
            if (addedItem == null || (stack = ItemStack.func_77949_a((NBTTagCompound)addedItem)) == null) continue;
            this.allAddedItems.add(stack);
        }
        this.currentAddedItems.clear();
        for (i = 0; i < currentAddedItems.func_74745_c(); ++i) {
            addedItem = currentAddedItems.func_150305_b(i);
            if (addedItem == null || (stack = ItemStack.func_77949_a((NBTTagCompound)addedItem)) == null) continue;
            this.currentAddedItems.add(stack);
        }
        this.spellDef.clear();
        for (ArrayList<KeyValuePair<ISpellPart, byte[]>> groups : this.shapeGroups) {
            groups.clear();
        }
        NBTTagCompound currentSpellDef = altarCompound.func_74775_l("spellDef");
        this.spellDef.addAll(this.NBTToISpellPartList(currentSpellDef));
        NBTTagList currentShapeGroups = altarCompound.func_150295_c("shapeGroups", 10);
        for (int i2 = 0; i2 < currentShapeGroups.func_74745_c(); ++i2) {
            NBTTagCompound compound = currentShapeGroups.func_150305_b(i2);
            this.shapeGroups.get(i2).addAll(this.NBTToISpellPartList(compound));
        }
    }

    @Override
    public int getChargeRate() {
        return 250;
    }

    @Override
    public boolean canRelayPower(PowerTypes type) {
        return false;
    }

    public void HandleUpdatePacket(byte[] remainingBytes) {
        AMDataReader rdr = new AMDataReader(remainingBytes, false);
        byte subID = rdr.getByte();
        switch (subID) {
            case 3: {
                this.isCrafting = rdr.getBoolean();
                this.currentKey = rdr.getInt();
                this.allAddedItems.clear();
                this.currentAddedItems.clear();
                int itemCount = rdr.getInt();
                for (int i = 0; i < itemCount; ++i) {
                    this.allAddedItems.add(rdr.getItemStack());
                }
                break;
            }
            case 1: {
                this.setCrafting(rdr.getBoolean());
                break;
            }
            case 2: {
                this.allAddedItems.add(rdr.getItemStack());
            }
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_145841_b(compound);
        S35PacketUpdateTileEntity packet = new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e), compound);
        return packet;
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }
}

