/*
 * Decompiled with CFR 0.152.
 */
package am2.api.math;

import am2.api.math.AMVector3;

public class AMLineSegment {
    private AMVector3 a;
    private AMVector3 b;

    public AMLineSegment(AMVector3 a, AMVector3 b) {
        this.a = a;
        this.b = b;
    }

    public AMVector3 closestPointOnLine(AMVector3 vPoint) {
        AMVector3 vVector1 = vPoint.copy().sub(this.a);
        AMVector3 vVector2 = this.b.copy().sub(this.a).normalize();
        float d = (float)this.a.distanceTo(this.b);
        float t = AMVector3.dotProduct(vVector2, vVector1);
        if (t <= 0.0f) {
            return this.a.copy();
        }
        if (t >= d) {
            return this.b.copy();
        }
        AMVector3 vVector3 = vVector2.copy().scale(t);
        AMVector3 vClosestPoint = this.a.copy().add(vVector3);
        return vClosestPoint;
    }
}

