/*
 * Decompiled with CFR 0.152.
 */
package am2.api;

import am2.api.IAMRecipeManager;
import am2.api.IAffinityData;
import am2.api.IExtendedProperties;
import am2.api.ISkillData;
import am2.api.enchantment.IAMEnchantmentHelper;
import am2.api.entities.IEntityManager;
import am2.api.flickers.IFlickerRegistry;
import am2.api.items.IKeystoneHelper;
import am2.api.items.armor.IImbuementRegistry;
import am2.api.potion.IBuffHelper;
import am2.api.power.IObeliskFuelHelper;
import am2.api.spell.ISkillTreeManager;
import am2.api.spell.ISpellIconManager;
import am2.api.spell.ISpellPartManager;
import am2.api.spell.ISpellUtils;
import am2.api.spell.component.interfaces.ISkillTreeEntry;
import am2.api.spell.enums.SkillPointTypes;
import am2.api.spell.enums.SkillTrees;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.IIcon;

public class ArsMagicaApi {
    public static final ArsMagicaApi instance = new ArsMagicaApi();
    public static final String AM2ModID = "arsmagica2";
    private static String extendedPropertiesIdentifier;
    private static String affinityDataIdentifier;
    private static String skillDataIdentifier;
    private static String riftStorageIdentifier;
    public static final IAttribute maxManaBonus;
    public static final IAttribute maxBurnoutBonus;
    public static final IAttribute xpGainModifier;
    public static final IAttribute manaRegenTimeModifier;
    public static final IAttribute burnoutReductionRate;
    private static final float manaBurnoutRatio = 0.38f;
    private ISpellPartManager spellPartManager;
    private ISpellUtils spellUtils;
    private ISkillTreeManager skillTreeManager;
    private IAMEnchantmentHelper enchantmentHelper;
    private IEntityManager entityManager;
    private IKeystoneHelper keystoneHelper;
    private IObeliskFuelHelper obeliskFuelHelper;
    private IFlickerRegistry flickerOperatorRegistry;
    private IImbuementRegistry armorInfusionRegistry;
    private IAMRecipeManager essenceRecipes;
    @SideOnly(value=Side.CLIENT)
    private ISpellIconManager spellIconManager;
    private IBuffHelper buffHelper;
    private boolean colourblindMode;

    private ArsMagicaApi() {
    }

    public final ISpellPartManager getSpellPartManager() {
        return this.spellPartManager;
    }

    public final IAMEnchantmentHelper getEnchantHelper() {
        return this.enchantmentHelper;
    }

    public final ISkillTreeManager getSkillTreeManager() {
        return this.skillTreeManager;
    }

    public static final float getBurnoutFromMana(float manaCost) {
        return manaCost * 0.38f;
    }

    public final IKeystoneHelper getKeystoneHelper() {
        return this.keystoneHelper;
    }

    public final IEntityManager getEntityManager() {
        return this.entityManager;
    }

    public final IObeliskFuelHelper getFuelHelper() {
        return this.obeliskFuelHelper;
    }

    public final IFlickerRegistry getFlickerOperatorRegistry() {
        return this.flickerOperatorRegistry;
    }

    public final IImbuementRegistry getArmorInfusionRegistry() {
        return this.armorInfusionRegistry;
    }

    public final IAMRecipeManager getEssenceRecipeManager() {
        return this.essenceRecipes;
    }

    public final boolean getColourblindMode() {
        return this.colourblindMode;
    }

    public final IExtendedProperties getExtendedProperties(EntityLivingBase entity) {
        return (IExtendedProperties)entity.getExtendedProperties(extendedPropertiesIdentifier);
    }

    public final ISkillData getSkillData(EntityPlayer entity) {
        return (ISkillData)entity.getExtendedProperties(skillDataIdentifier);
    }

    public final IAffinityData getAffinityData(EntityLivingBase entity) {
        return (IAffinityData)entity.getExtendedProperties(affinityDataIdentifier);
    }

    public final IInventory getRiftStorage(EntityPlayer entity) {
        return (IInventory)entity.getExtendedProperties(riftStorageIdentifier);
    }

    public final void registerSkillTreeEntry(ISkillTreeEntry entry, String name, SkillTrees tree, int x, int y, SkillPointTypes point, ISkillTreeEntry ... prereqs) {
        this.spellPartManager.registerSkillTreeEntry(entry, name);
        this.skillTreeManager.RegisterPart(entry, x, y, tree, point, prereqs);
    }

    @SideOnly(value=Side.CLIENT)
    public final void registerSkillIcon(String name, IIcon IIcon2) {
        this.spellIconManager.registerIcon(name, IIcon2);
    }

    @SideOnly(value=Side.CLIENT)
    public final ISpellIconManager getSpellIconManager() {
        return this.spellIconManager;
    }

    public final IBuffHelper getBuffHelper() {
        return this.buffHelper;
    }

    public final ISpellUtils getSpellUtils() {
        return this.spellUtils;
    }

    public final void setSpellPartManager(ISpellPartManager manager) {
        if (this.spellPartManager == null) {
            this.spellPartManager = manager;
        }
    }

    public final void setEnchantmentHelper(IAMEnchantmentHelper helper) {
        if (this.enchantmentHelper == null) {
            this.enchantmentHelper = helper;
        }
    }

    public final void setSkillTreeManager(ISkillTreeManager manager) {
        if (this.skillTreeManager == null) {
            this.skillTreeManager = manager;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public final void setSpellIconManager(ISpellIconManager manager) {
        if (this.spellIconManager == null) {
            this.spellIconManager = manager;
        }
    }

    public final void setKeystoneHelper(IKeystoneHelper helper) {
        if (this.keystoneHelper == null) {
            this.keystoneHelper = helper;
        }
    }

    public final void setExtendedPropertiesID(String identifier) {
        if (extendedPropertiesIdentifier == null) {
            extendedPropertiesIdentifier = identifier;
        }
    }

    public final void setAffinityDataID(String identifier) {
        if (affinityDataIdentifier == null) {
            affinityDataIdentifier = identifier;
        }
    }

    public final void setSkillDataID(String identifier) {
        if (skillDataIdentifier == null) {
            skillDataIdentifier = identifier;
        }
    }

    public final void setRiftStorageID(String identifier) {
        if (riftStorageIdentifier == null) {
            riftStorageIdentifier = identifier;
        }
    }

    public final void setEntityManager(IEntityManager manager) {
        if (this.entityManager == null) {
            this.entityManager = manager;
        }
    }

    public final void setObeliskFuelHelper(IObeliskFuelHelper manager) {
        if (this.obeliskFuelHelper == null) {
            this.obeliskFuelHelper = manager;
        }
    }

    public final void setFlickerOperatorRegistry(IFlickerRegistry registry) {
        if (this.flickerOperatorRegistry == null) {
            this.flickerOperatorRegistry = registry;
        }
    }

    public final void setInfusionRegistry(IImbuementRegistry registry) {
        if (this.armorInfusionRegistry == null) {
            this.armorInfusionRegistry = registry;
        }
    }

    public final void setEssenceRecipeHandler(IAMRecipeManager manager) {
        if (this.essenceRecipes != null) {
            this.essenceRecipes = manager;
        }
    }

    public final void setColourblindMode(boolean colourblindMode) {
        this.colourblindMode = colourblindMode;
    }

    public final void setBuffHelper(IBuffHelper helper) {
        if (this.buffHelper == null) {
            this.buffHelper = helper;
        }
    }

    public final void setSpellUtils(ISpellUtils utilsHelper) {
        if (this.spellUtils == null) {
            this.spellUtils = utilsHelper;
        }
    }

    static {
        maxManaBonus = new RangedAttribute("am2.maxManaBonus", 0.0, 0.0, Double.MAX_VALUE).func_111117_a("Mana Bonus").func_111112_a(true);
        maxBurnoutBonus = new RangedAttribute("am2.maxBurnoutBonus", 0.0, 0.0, Double.MAX_VALUE).func_111117_a("Burnout Bonus").func_111112_a(true);
        xpGainModifier = new RangedAttribute("am2.xpMultiplier", 1.0, 0.0, Double.MAX_VALUE).func_111117_a("XP Mutiplier").func_111112_a(true);
        manaRegenTimeModifier = new RangedAttribute("am2.manaRegenModifier", 1.0, 0.5, 2.0).func_111117_a("Mana Regen Rate Multiplier").func_111112_a(true);
        burnoutReductionRate = new RangedAttribute("am2.burnoutReduction", 1.0, (double)0.1f, 2.0).func_111117_a("Burnout Reduction Rate").func_111112_a(true);
    }
}

