/*
 * Decompiled with CFR 0.152.
 */
package com.mia.craftstudio.minecraft;

import com.mia.craftstudio.CSModelAnim;
import com.mia.craftstudio.CSProject;
import com.mia.craftstudio.api.ICSProject;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;

public class AnimationState {
    public int animationID;
    public long startTime;
    public int repeatCount;
    public boolean holdsLastKeyframe;
    public float frameTime = 0.0f;
    public int lastFullFrameRendered = 0;
    public boolean running = true;
    public final CSModelAnim animation;
    public final ICSProject project;

    public AnimationState(ICSProject project, int id, long time, int count, boolean holdFrame) {
        this.animationID = id;
        this.startTime = time;
        this.repeatCount = count;
        this.holdsLastKeyframe = holdFrame;
        this.project = project;
        this.animation = project.getAnimation(id);
    }

    public AnimationState(ByteBuf buf) {
        this.animationID = buf.readInt();
        this.startTime = buf.readLong();
        this.repeatCount = buf.readInt();
        this.holdsLastKeyframe = buf.readBoolean();
        this.project = CSProject.getProjectFromID(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.animation = this.project.getAnimation(this.animationID);
    }

    public void write(ByteBuf buf) {
        buf.writeInt(this.animationID);
        buf.writeLong(this.startTime);
        buf.writeInt(this.repeatCount);
        buf.writeBoolean(this.holdsLastKeyframe);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.project.getProjectID());
    }
}

