/*
 * Decompiled with CFR 0.152.
 */
package com.mia.craftstudio;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.mia.craftstudio.CSExceptions;
import com.mia.craftstudio.CSModel;
import com.mia.craftstudio.CSModelAnim;
import com.mia.craftstudio.CSPack;
import com.mia.craftstudio.api.ICSProject;
import com.mia.craftstudio.minecraft.forge.CSLibMod;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class CSProject
implements ICSProject {
    private static HashMap<String, CSProject> projectsList = new HashMap();
    private final List<CSPack> packs = new ArrayList<CSPack>();
    private final Map<Integer, CSModel> models = new HashMap<Integer, CSModel>();
    private final Map<Integer, CSModelAnim> animations = new HashMap<Integer, CSModelAnim>();
    private final Map<Integer, JsonElement> descriptors = new HashMap<Integer, JsonElement>();
    private final Multimap<String, CSModel> modelsMM = HashMultimap.create();
    private final String name;
    private final String modid;
    private final String projectID;
    private final File jarFile;

    public CSProject(String name, String modid, File jarFile) {
        this.projectID = String.format("%s:%s", modid, name);
        if (projectsList.put(this.projectID, this) != null) {
            throw new CSExceptions.DuplicateProjectException((Object)this.projectID);
        }
        this.name = name;
        this.modid = modid;
        this.jarFile = jarFile;
    }

    public static ICSProject getProjectFromID(String projectID) {
        return projectsList.get(projectID);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getModID() {
        return this.modid;
    }

    @Override
    public File getJarFile() {
        return this.jarFile;
    }

    @Override
    public String getProjectID() {
        return this.projectID;
    }

    @Override
    public String getProjectPath() {
        return String.format("/assets/%s/models/%s", this.modid.toLowerCase(), this.name);
    }

    public String toString() {
        if (this.jarFile != null) {
            return String.format("CSProject[%s:%s] located in File: %s", this.modid, this.name, this.jarFile.toString());
        }
        return String.format("CSProject[%s:%s]", this.modid, this.name);
    }

    private Set<String> getResourceList(String path) throws CSExceptions.ResourcesNotFoundException {
        HashSet<String> filenames;
        block7: {
            filenames = new HashSet<String>();
            try {
                URL directory = CSProject.class.getResource(path);
                if (directory != null && "file".equals(directory.getProtocol())) {
                    filenames.addAll(Arrays.asList(new File(directory.toURI()).list()));
                    break block7;
                }
                if (this.jarFile != null && this.jarFile.isFile()) {
                    path = path.substring(1) + "/";
                    ZipFile zipfile = new ZipFile(this.jarFile);
                    Enumeration<? extends ZipEntry> entryList = zipfile.entries();
                    while (entryList.hasMoreElements()) {
                        ZipEntry zipEntry = entryList.nextElement();
                        if (zipEntry.getName().equals(path) || !zipEntry.getName().startsWith(path)) continue;
                        filenames.add(zipEntry.getName().substring(path.length()));
                    }
                    zipfile.close();
                    break block7;
                }
                throw new CSExceptions.ResourcesNotFoundException(this);
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (CSExceptions.ResourcesNotFoundException e) {
                throw e;
            }
        }
        return filenames;
    }

    @Override
    public ICSProject addAllPacks() {
        this.packs.clear();
        ArrayList<String> orderedPacks = null;
        orderedPacks = new ArrayList<String>(this.getResourceList(this.getProjectPath()));
        if (CSLibMod.debugMsgs) {
            CSLibMod.log.info(String.format("Looking up CSPacks for %s", this));
            for (String s : orderedPacks) {
                CSLibMod.log.info(String.format("\t+ %s", s));
            }
        }
        Collections.sort(orderedPacks, new Comparator<String>(){

            private boolean isIntNumber(String str) {
                for (char c : str.toCharArray()) {
                    if (Character.isDigit(c)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public int compare(String name1, String name2) {
                try {
                    int sep1 = name1.indexOf(95);
                    int sep2 = name2.indexOf(95);
                    String date1 = name1.substring(0, sep1);
                    String date2 = name2.substring(0, sep2);
                    if (this.isIntNumber(date1)) {
                        if (this.isIntNumber(date2)) {
                            int result = Long.valueOf(date1).compareTo(Long.valueOf(date2));
                            if (result == 0) {
                                return name1.substring(sep1).toLowerCase().compareTo(name2.substring(sep2).toLowerCase());
                            }
                            return result;
                        }
                        return 1;
                    }
                    if (this.isIntNumber(date2)) {
                        return -1;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return name1.toLowerCase().compareTo(name2.toLowerCase());
            }
        });
        for (String pack : orderedPacks) {
            if (!pack.endsWith(".cspack")) continue;
            this.addPack(new CSPack(pack));
        }
        return this;
    }

    public ICSProject addPack(CSPack pack) {
        this.packs.add(pack);
        pack.project = this;
        return this;
    }

    public boolean removePack(String name) {
        for (CSPack pack : this.packs) {
            if (!pack.getName().equals(name)) continue;
            this.packs.remove(pack.cleanup());
            return true;
        }
        return false;
    }

    @Override
    public List<CSPack> getPacks() {
        return this.packs;
    }

    @Override
    public ICSProject loadPacks() {
        this.models.clear();
        this.modelsMM.clear();
        this.animations.clear();
        for (CSPack pack : Arrays.copyOf(this.packs.toArray(new CSPack[0]), this.packs.size())) {
            try {
                pack.readPackFile();
            }
            catch (CSExceptions.NoCSProjectException e) {
                System.out.printf("Removing CSPack '%s' from CSProject '%s'. It was improperly added.", pack.getName(), this.name);
                this.packs.remove(pack.cleanup());
            }
        }
        for (CSPack pack : this.packs) {
            BiMap<Integer, CSPack.ProjectEntry> entries = pack.getEntries();
            for (CSPack.ProjectEntry entry : entries.values()) {
                if (entry.getType() != 0) continue;
                this.modelsMM.put((Object)entry.getName(), (Object)this.models.get(entry.getID()));
            }
        }
        if (CSLibMod.debugMsgs) {
            CSLibMod.log.info(String.format("%s", this));
            CSLibMod.log.info(String.format("\t+ %d models", this.models.size()));
            CSLibMod.log.info(String.format("\t+ %d animations", this.animations.size()));
        }
        return this;
    }

    public Integer findFirstIDfromName(String name) {
        List<Integer> ret = this.getIDsForName(name);
        return ret.size() > 0 ? ret.get(0) : -1;
    }

    public List<Integer> getIDsForName(String name) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (CSPack pack : this.packs) {
            BiMap<Integer, CSPack.ProjectEntry> entries = pack.getEntries();
            for (CSPack.ProjectEntry entry : entries.values()) {
                if (!entry.getName().equals(name)) continue;
                ret.add((Integer)entries.inverse().get((Object)entry));
            }
        }
        return ret;
    }

    public String findNamefromID(Integer id) {
        for (CSPack pack : this.packs) {
            BiMap<Integer, CSPack.ProjectEntry> entries = pack.getEntries();
            if (!entries.containsKey((Object)id)) continue;
            return ((CSPack.ProjectEntry)entries.get((Object)id)).getName();
        }
        return null;
    }

    @Override
    public BiMap<Integer, CSModel> getModels() {
        return ImmutableBiMap.copyOf(this.models);
    }

    @Override
    public List<CSModel> getModels(String name) {
        return (List)(this.modelsMM.get((Object)name).size() > 0 ? ImmutableList.copyOf((Collection)this.modelsMM.get((Object)name)) : new ArrayList());
    }

    @Override
    public CSModel getModel(Integer id) {
        return this.models.get(id);
    }

    @Override
    public CSModel getModel(String name) {
        return this.modelsMM.get((Object)name).size() > 0 ? this.getModels(name).get(0) : null;
    }

    @Override
    public int getModelCount() {
        return this.models.size();
    }

    @Override
    public Map<Integer, CSModelAnim> getAnimations() {
        return ImmutableMap.copyOf(this.animations);
    }

    @Override
    public CSModelAnim getAnimation(Integer id) {
        return this.animations.get(id);
    }

    @Override
    public int getAnimationCount() {
        return this.animations.size();
    }

    @Override
    public JsonElement getDescriptor(Integer id) {
        return this.descriptors.get(id);
    }

    boolean addModel(Integer id, CSModel model) {
        return this.models.put(id, model) != null;
    }

    boolean addAnimation(Integer id, CSModelAnim anim) {
        return this.animations.put(id, anim) != null;
    }

    boolean addDescriptor(Integer id, JsonElement json) {
        return this.descriptors.put(id, json) != null;
    }
}

