/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.inventory.IDrawerInventory;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroupInteractive;
import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.ILockable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IShroudable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IVoidable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.BlockSlave;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockCoord;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntitySlave;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public class TileEntityController
extends TileEntity
implements IDrawerGroup,
ISidedInventory {
    private static final int PRI_VOID = 0;
    private static final int PRI_LOCKED = 1;
    private static final int PRI_NORMAL = 2;
    private static final int PRI_EMPTY = 3;
    private static final int PRI_DISABLED = 4;
    private static final int DEPTH_LIMIT = 12;
    private static final int[] emptySlots = new int[0];
    private Comparator<SlotRecord> slotRecordComparator = new Comparator<SlotRecord>(){

        @Override
        public int compare(SlotRecord o1, SlotRecord o2) {
            return o1.priority - o2.priority;
        }
    };
    private Queue<BlockCoord> searchQueue = new LinkedList<BlockCoord>();
    private Set<BlockCoord> searchDiscovered = new HashSet<BlockCoord>();
    private Map<BlockCoord, StorageRecord> storage = new HashMap<BlockCoord, StorageRecord>();
    private List<SlotRecord> invSlotList = new ArrayList<SlotRecord>();
    private List<SlotRecord> drawerSlotList = new ArrayList<SlotRecord>();
    private int[] inventorySlots = new int[0];
    private int[] drawerSlots = new int[0];
    private int[] autoSides = new int[]{0, 1, 2, 3, 4, 5};
    private int direction;
    private int drawerSize = 0;
    private int range;
    private long lastClickTime;
    private UUID lastClickUUID;
    private String customName;

    private int getSlotPriority(SlotRecord record, boolean invBased) {
        int drawerSlot;
        IDrawerGroup group = this.getGroupForCoord(record.coord);
        if (group == null) {
            return 4;
        }
        int n = drawerSlot = invBased ? group.getDrawerInventory().getDrawerSlot(record.slot) : record.slot;
        if (!group.isDrawerEnabled(drawerSlot)) {
            return 4;
        }
        IDrawer drawer = group.getDrawer(drawerSlot);
        if (drawer.isEmpty()) {
            return 3;
        }
        if (drawer instanceof IVoidable && ((IVoidable)((Object)drawer)).isVoid() || group instanceof IVoidable && ((IVoidable)((Object)group)).isVoid()) {
            return 0;
        }
        if (drawer instanceof ILockable && ((ILockable)((Object)drawer)).isLocked(LockAttribute.LOCK_POPULATED) || group instanceof ILockable && ((ILockable)((Object)group)).isLocked(LockAttribute.LOCK_POPULATED)) {
            return 1;
        }
        return 2;
    }

    public TileEntityController() {
        this.invSlotList.add(new SlotRecord(null, 0));
        this.inventorySlots = new int[]{0};
        this.range = StorageDrawers.config.getControllerRange();
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction % 6;
    }

    public int interactPutItemsIntoInventory(EntityPlayer player) {
        if (this.inventorySlots.length == 0) {
            this.updateCache();
        }
        boolean dumpInventory = this.field_145850_b.func_82737_E() - this.lastClickTime < 10L && player.getPersistentID().equals(this.lastClickUUID);
        int count = 0;
        for (int slotIndex : this.drawerSlots) {
            IDrawer drawer;
            IDrawerGroup group = this.getGroupForDrawerSlot(slotIndex);
            if (group == null || !(group instanceof IDrawerGroupInteractive)) continue;
            IDrawerGroupInteractive intGroup = (IDrawerGroupInteractive)group;
            int slot = this.getLocalDrawerSlot(slotIndex);
            if (!group.isDrawerEnabled(slot) || (drawer = group.getDrawer(slot)) == null || drawer.isEmpty()) continue;
            if (dumpInventory) {
                count += intGroup.interactPutCurrentInventoryIntoSlot(slot, player);
                continue;
            }
            count += intGroup.interactPutCurrentItemIntoSlot(slot, player);
        }
        this.lastClickTime = this.field_145850_b.func_82737_E();
        this.lastClickUUID = player.getPersistentID();
        return count;
    }

    public void toggleShroud() {
        IShroudable template = null;
        boolean state = false;
        for (StorageRecord record : this.storage.values()) {
            if (record.storage == null) continue;
            int n = record.storage.getDrawerCount();
            for (int i = 0; i < n; ++i) {
                IDrawer drawer;
                if (!record.storage.isDrawerEnabled(i) || !((drawer = record.storage.getDrawer(i)) instanceof IShroudable)) continue;
                IShroudable shroudableStorage = (IShroudable)((Object)drawer);
                if (template == null) {
                    template = shroudableStorage;
                    state = !template.isShrouded();
                }
                shroudableStorage.setIsShrouded(state);
            }
        }
    }

    public void toggleLock(EnumSet<LockAttribute> attributes, LockAttribute key) {
        ILockable template = null;
        boolean state = false;
        for (StorageRecord record : this.storage.values()) {
            if (record.storage == null) continue;
            if (record.storage instanceof ILockable) {
                ILockable lockableStorage = (ILockable)((Object)record.storage);
                if (template == null) {
                    template = lockableStorage;
                    state = !template.isLocked(key);
                }
                for (LockAttribute attr : attributes) {
                    lockableStorage.setLocked(attr, state);
                }
                continue;
            }
            int n = record.storage.getDrawerCount();
            for (int i = 0; i < n; ++i) {
                IDrawer drawer;
                if (!record.storage.isDrawerEnabled(i) || !((drawer = record.storage.getDrawer(i)) instanceof IShroudable)) continue;
                ILockable lockableStorage = (ILockable)((Object)drawer);
                if (template == null) {
                    template = lockableStorage;
                    state = !template.isLocked(key);
                }
                for (LockAttribute attr : attributes) {
                    lockableStorage.setLocked(attr, state);
                }
            }
        }
    }

    private void resetCache() {
        this.storage.clear();
        this.invSlotList.clear();
        this.drawerSlotList.clear();
        this.drawerSize = 0;
    }

    public boolean isValidSlave(BlockCoord coord) {
        StorageRecord record = this.storage.get(coord);
        if (record == null || !record.mark) {
            return false;
        }
        return record.storage == null;
    }

    public void updateCache() {
        int preCount = this.inventorySlots.length;
        this.resetCache();
        this.populateNodes(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.flattenLists();
        this.inventorySlots = this.sortSlotRecords(this.invSlotList, true);
        this.drawerSlots = this.sortSlotRecords(this.drawerSlotList, false);
        if (!(preCount == this.inventorySlots.length || preCount != 0 && this.inventorySlots.length != 0 || this.field_145850_b.field_72995_K)) {
            this.func_70296_d();
        }
    }

    private void indexSlotRecords(List<SlotRecord> records, boolean invBased) {
        int n = records.size();
        for (int i = 0; i < n; ++i) {
            SlotRecord record = records.get(i);
            if (record == null) continue;
            record.index = i;
            record.priority = this.getSlotPriority(record, invBased);
        }
    }

    private int[] sortSlotRecords(List<SlotRecord> records, boolean invBased) {
        this.indexSlotRecords(records, invBased);
        ArrayList<SlotRecord> copied = new ArrayList<SlotRecord>(records);
        Collections.sort(copied, this.slotRecordComparator);
        int[] slotMap = new int[copied.size()];
        for (int i = 0; i < slotMap.length; ++i) {
            slotMap[i] = ((SlotRecord)copied.get((int)i)).index;
        }
        return slotMap;
    }

    private boolean containsNullEntries(List<SlotRecord> list) {
        int nullCount = 0;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (list.get(i) != null) continue;
            ++nullCount;
        }
        return nullCount > 0;
    }

    private void flattenLists() {
        SlotRecord record;
        int i;
        int n;
        if (this.containsNullEntries(this.invSlotList)) {
            ArrayList<SlotRecord> newInvSlotList = new ArrayList<SlotRecord>();
            n = this.invSlotList.size();
            for (i = 0; i < n; ++i) {
                record = this.invSlotList.get(i);
                if (record == null) continue;
                newInvSlotList.add(record);
            }
            this.invSlotList = newInvSlotList;
        }
        if (this.containsNullEntries(this.drawerSlotList)) {
            ArrayList<SlotRecord> newDrawerSlotList = new ArrayList<SlotRecord>();
            n = this.drawerSlotList.size();
            for (i = 0; i < n; ++i) {
                record = this.drawerSlotList.get(i);
                if (record == null) continue;
                newDrawerSlotList.add(record);
            }
            this.drawerSlotList = newDrawerSlotList;
        }
    }

    private void clearRecordInfo(BlockCoord coord, StorageRecord record) {
        SlotRecord slotRecord;
        int i;
        record.clear();
        for (i = 0; i < this.invSlotList.size(); ++i) {
            slotRecord = this.invSlotList.get(i);
            if (slotRecord == null || !coord.equals(slotRecord.coord)) continue;
            this.invSlotList.set(i, null);
        }
        for (i = 0; i < this.drawerSlotList.size(); ++i) {
            slotRecord = this.drawerSlotList.get(i);
            if (slotRecord == null || !coord.equals(slotRecord.coord)) continue;
            this.drawerSlotList.set(i, null);
        }
    }

    private void updateRecordInfo(BlockCoord coord, StorageRecord record, TileEntity te) {
        if (te == null) {
            if (record.storage != null) {
                this.clearRecordInfo(coord, record);
            }
            return;
        }
        if (te instanceof TileEntityController) {
            if (record.storage == null && record.invStorageSize > 0) {
                return;
            }
            if (record.storage != null) {
                this.clearRecordInfo(coord, record);
            }
            record.storage = null;
            record.invStorageSize = 1;
            this.invSlotList.add(new SlotRecord(null, 0));
        } else if (te instanceof TileEntitySlave) {
            if (record.storage == null && record.invStorageSize == 0 && ((TileEntitySlave)te).getController() == this) {
                return;
            }
            if (record.storage != null) {
                this.clearRecordInfo(coord, record);
            }
            record.storage = null;
            record.invStorageSize = 0;
            ((TileEntitySlave)te).bindController(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        } else if (te instanceof IDrawerGroup) {
            int i;
            IDrawerInventory inventory;
            IDrawerGroup group = (IDrawerGroup)te;
            if (record.storage == group) {
                return;
            }
            if (record.storage != null && record.storage != group) {
                this.clearRecordInfo(coord, record);
            }
            if ((inventory = group.getDrawerInventory()) == null) {
                return;
            }
            record.storage = group;
            record.invStorageSize = inventory.func_70302_i_();
            record.drawerStorageSize = group.getDrawerCount();
            int n = record.invStorageSize;
            for (i = 0; i < n; ++i) {
                this.invSlotList.add(new SlotRecord(coord, i));
            }
            n = record.drawerStorageSize;
            for (i = 0; i < n; ++i) {
                this.drawerSlotList.add(new SlotRecord(coord, i));
            }
            this.drawerSize += record.drawerStorageSize;
        } else if (record.storage != null) {
            this.clearRecordInfo(coord, record);
        }
    }

    private void populateNodes(int x, int y, int z) {
        BlockCoord root = new BlockCoord(x, y, z);
        this.searchQueue.clear();
        this.searchQueue.add(root);
        this.searchDiscovered.clear();
        this.searchDiscovered.add(root);
        while (!this.searchQueue.isEmpty()) {
            BlockCoord[] neighbors;
            Block block;
            BlockCoord coord = this.searchQueue.remove();
            int depth = Math.max(Math.max(Math.abs(coord.x() - x), Math.abs(coord.y() - y)), Math.abs(coord.z() - z));
            if (depth > this.range || !((block = this.field_145850_b.func_147439_a(coord.x(), coord.y(), coord.z())) instanceof INetworked)) continue;
            StorageRecord record = this.storage.get(coord);
            if (record == null) {
                record = new StorageRecord();
                this.storage.put(coord, record);
            }
            if (block instanceof BlockSlave) {
                ((BlockSlave)block).getTileEntitySafe(this.field_145850_b, coord.x(), coord.y(), coord.z());
            }
            this.updateRecordInfo(coord, record, this.field_145850_b.func_147438_o(coord.x(), coord.y(), coord.z()));
            record.mark = true;
            record.distance = depth;
            for (BlockCoord n : neighbors = new BlockCoord[]{new BlockCoord(coord.x() + 1, coord.y(), coord.z()), new BlockCoord(coord.x() - 1, coord.y(), coord.z()), new BlockCoord(coord.x(), coord.y(), coord.z() + 1), new BlockCoord(coord.x(), coord.y(), coord.z() - 1), new BlockCoord(coord.x(), coord.y() + 1, coord.z()), new BlockCoord(coord.x(), coord.y() - 1, coord.z())}) {
                if (this.searchDiscovered.contains(n)) continue;
                this.searchQueue.add(n);
                this.searchDiscovered.add(n);
            }
        }
    }

    private IDrawerGroup getGroupForInvSlot(int invSlot) {
        if (invSlot >= this.invSlotList.size()) {
            return null;
        }
        SlotRecord record = this.invSlotList.get(invSlot);
        if (record == null) {
            return null;
        }
        return this.getGroupForCoord(record.coord);
    }

    private IDrawerGroup getGroupForDrawerSlot(int drawerSlot) {
        if (drawerSlot >= this.drawerSlotList.size()) {
            return null;
        }
        SlotRecord record = this.drawerSlotList.get(drawerSlot);
        if (record == null) {
            return null;
        }
        return this.getGroupForCoord(record.coord);
    }

    private IDrawerGroup getGroupForCoord(BlockCoord coord) {
        if (coord == null || !this.storage.containsKey(coord)) {
            return null;
        }
        TileEntity te = this.field_145850_b.func_147438_o(coord.x(), coord.y(), coord.z());
        if (!(te instanceof IDrawerGroup)) {
            this.storage.remove(coord);
            return null;
        }
        return this.storage.get((Object)coord).storage;
    }

    private int getLocalInvSlot(int invSlot) {
        if (invSlot >= this.invSlotList.size()) {
            return 0;
        }
        SlotRecord record = this.invSlotList.get(invSlot);
        if (record == null) {
            return 0;
        }
        return record.slot;
    }

    private int getLocalDrawerSlot(int drawerSlot) {
        if (drawerSlot >= this.drawerSlotList.size()) {
            return 0;
        }
        SlotRecord record = this.drawerSlotList.get(drawerSlot);
        if (record == null) {
            return 0;
        }
        return record.slot;
    }

    private IDrawerInventory getDrawerInventory(int invSlot) {
        IDrawerGroup group = this.getGroupForInvSlot(invSlot);
        if (group == null) {
            return null;
        }
        return group.getDrawerInventory();
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.setDirection(tag.func_74771_c("Dir"));
        if (tag.func_150297_b("CustomName", 8)) {
            this.customName = tag.func_74779_i("CustomName");
        }
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.updateCache();
        }
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74774_a("Dir", (byte)this.direction);
        if (this.func_145818_k_()) {
            tag.func_74778_a("CustomName", this.customName);
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 5, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.func_145831_w().func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public IDrawerInventory getDrawerInventory() {
        return null;
    }

    @Override
    public int getDrawerCount() {
        return this.drawerSlotList.size();
    }

    @Override
    public IDrawer getDrawer(int slot) {
        IDrawerGroup group = this.getGroupForDrawerSlot(slot);
        if (group == null) {
            return null;
        }
        return group.getDrawer(this.getLocalDrawerSlot(slot));
    }

    @Override
    public boolean isDrawerEnabled(int slot) {
        IDrawerGroup group = this.getGroupForDrawerSlot(slot);
        if (group == null) {
            return false;
        }
        return group.isDrawerEnabled(this.getLocalDrawerSlot(slot));
    }

    public void func_70296_d() {
        for (StorageRecord record : this.storage.values()) {
            IDrawerGroup group = record.storage;
            if (group == null || group.getDrawerInventory() == null) continue;
            group.markDirtyIfNeeded();
        }
        super.func_70296_d();
    }

    @Override
    public boolean markDirtyIfNeeded() {
        boolean synced = false;
        for (StorageRecord record : this.storage.values()) {
            IDrawerGroup group = record.storage;
            if (group == null || group.getDrawerInventory() == null) continue;
            synced |= group.markDirtyIfNeeded();
        }
        if (synced) {
            super.func_70296_d();
        }
        return synced;
    }

    public int[] func_94128_d(int side) {
        for (int aside : this.autoSides) {
            if (side != aside) continue;
            return this.inventorySlots;
        }
        return emptySlots;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        IDrawerInventory inventory = this.getDrawerInventory(slot);
        if (inventory == null) {
            return false;
        }
        return inventory.canInsertItem(this.getLocalInvSlot(slot), stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        IDrawerInventory inventory = this.getDrawerInventory(slot);
        if (inventory == null) {
            return false;
        }
        return inventory.canExtractItem(this.getLocalInvSlot(slot), stack);
    }

    public int func_70302_i_() {
        return this.inventorySlots.length;
    }

    public ItemStack func_70301_a(int slot) {
        IDrawerInventory inventory = this.getDrawerInventory(slot);
        if (inventory == null) {
            return null;
        }
        return inventory.func_70301_a(this.getLocalInvSlot(slot));
    }

    public ItemStack func_70298_a(int slot, int count) {
        IDrawerInventory inventory = this.getDrawerInventory(slot);
        if (inventory == null) {
            return null;
        }
        return inventory.func_70298_a(this.getLocalInvSlot(slot), count);
    }

    public ItemStack func_70304_b(int slot) {
        IDrawerInventory inventory = this.getDrawerInventory(slot);
        if (inventory == null) {
            return null;
        }
        return inventory.func_70304_b(this.getLocalInvSlot(slot));
    }

    public void func_70299_a(int slot, ItemStack stack) {
        IDrawerInventory inventory = this.getDrawerInventory(slot);
        if (inventory == null) {
            return;
        }
        inventory.func_70299_a(this.getLocalInvSlot(slot), stack);
        inventory.func_70296_d();
    }

    public void setInventoryName(String name) {
        this.customName = name;
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "storageDrawers.container.controller";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        IDrawerInventory inventory = this.getDrawerInventory(slot);
        if (inventory == null) {
            return false;
        }
        return inventory.func_94041_b(this.getLocalInvSlot(slot), stack);
    }

    private static class SlotRecord {
        public BlockCoord coord;
        public int slot;
        public int index;
        public int priority;

        public SlotRecord(BlockCoord coord, int slot) {
            this.coord = coord;
            this.slot = slot;
        }
    }

    private static class StorageRecord {
        public IDrawerGroup storage;
        public boolean mark;
        public int invStorageSize;
        public int drawerStorageSize;
        public int distance = Integer.MAX_VALUE;

        private StorageRecord() {
        }

        public void clear() {
            this.storage = null;
            this.mark = false;
            this.invStorageSize = 0;
            this.drawerStorageSize = 0;
            this.distance = Integer.MAX_VALUE;
        }
    }
}

