/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.machine;

import cofh.api.item.IAugmentItem;
import cofh.core.util.CoreUtils;
import cofh.lib.util.helpers.MathHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.block.machine.TileMachineBase;
import cofh.thermalexpansion.gui.client.machine.GuiFurnace;
import cofh.thermalexpansion.gui.container.machine.ContainerFurnace;
import cofh.thermalexpansion.item.TEAugments;
import cofh.thermalexpansion.util.crafting.FurnaceManager;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class TileFurnace
extends TileMachineBase {
    static final int TYPE = BlockMachine.Types.FURNACE.ordinal();
    public boolean foodBoost;
    int inputTracker;
    int outputTracker;

    public static void initialize() {
        TileMachineBase.defaultSideConfig[TileFurnace.TYPE] = new TileTEBase.SideConfig();
        TileMachineBase.defaultSideConfig[TileFurnace.TYPE].numConfig = 4;
        TileMachineBase.defaultSideConfig[TileFurnace.TYPE].slotGroups = new int[][]{new int[0], {0}, {1}, {0, 1}};
        TileMachineBase.defaultSideConfig[TileFurnace.TYPE].allowInsertionSide = new boolean[]{false, true, false, true};
        TileMachineBase.defaultSideConfig[TileFurnace.TYPE].allowExtractionSide = new boolean[]{false, true, true, true};
        TileMachineBase.defaultSideConfig[TileFurnace.TYPE].allowInsertionSlot = new boolean[]{true, false, false};
        TileMachineBase.defaultSideConfig[TileFurnace.TYPE].allowExtractionSlot = new boolean[]{true, true, false};
        TileMachineBase.defaultSideConfig[TileFurnace.TYPE].sideTex = new int[]{0, 1, 4, 7};
        TileMachineBase.defaultSideConfig[TileFurnace.TYPE].defaultSides = new byte[]{1, 1, 2, 2, 2, 2};
        String string = "Machine.Furnace";
        int n = MathHelper.clampI((int)ThermalExpansion.config.get(string, "BasePower", 20), (int)10, (int)500);
        ThermalExpansion.config.set(string, "BasePower", n);
        TileMachineBase.defaultEnergyConfig[TileFurnace.TYPE] = new TileTEBase.EnergyConfig();
        TileMachineBase.defaultEnergyConfig[TYPE].setParamsPower(n);
        TileMachineBase.sounds[TileFurnace.TYPE] = CoreUtils.getSoundName((String)"ThermalExpansion", (String)"blockMachineFurnace");
        GameRegistry.registerTileEntity(TileFurnace.class, (String)"thermalexpansion.Furnace");
    }

    public TileFurnace() {
        this.inventory = new ItemStack[3];
    }

    public int getType() {
        return TYPE;
    }

    @Override
    protected boolean canStart() {
        if (this.inventory[0] == null) {
            return false;
        }
        if (this.foodBoost && !FurnaceManager.isFoodItem(this.inventory[0])) {
            return false;
        }
        FurnaceManager.RecipeFurnace recipeFurnace = FurnaceManager.getRecipe(this.inventory[0]);
        if (recipeFurnace == null || this.energyStorage.getEnergyStored() < recipeFurnace.getEnergy() * this.energyMod / this.processMod) {
            return false;
        }
        ItemStack itemStack = recipeFurnace.getOutput();
        if (this.inventory[1] == null) {
            return true;
        }
        if (!this.inventory[1].func_77969_a(itemStack)) {
            return false;
        }
        return this.inventory[1].field_77994_a + itemStack.field_77994_a <= itemStack.func_77976_d();
    }

    @Override
    protected boolean hasValidInput() {
        FurnaceManager.RecipeFurnace recipeFurnace = FurnaceManager.getRecipe(this.inventory[0]);
        if (this.foodBoost && !FurnaceManager.isFoodItem(this.inventory[0])) {
            return false;
        }
        return recipeFurnace == null ? false : recipeFurnace.getInput().field_77994_a <= this.inventory[0].field_77994_a;
    }

    @Override
    protected void processStart() {
        this.processMax = FurnaceManager.getRecipe(this.inventory[0]).getEnergy();
        if (this.foodBoost) {
            this.processMax /= 2;
        }
        this.processRem = this.processMax;
    }

    @Override
    protected void processFinish() {
        FurnaceManager.RecipeFurnace recipeFurnace = FurnaceManager.getRecipe(this.inventory[0]);
        if (recipeFurnace == null) {
            this.isActive = false;
            this.wasActive = true;
            this.tracker.markTime(((TileEntity)this).field_145850_b);
            this.processRem = 0;
            return;
        }
        ItemStack itemStack = recipeFurnace.getOutput();
        if (this.inventory[1] == null) {
            this.inventory[1] = itemStack;
        } else {
            this.inventory[1].field_77994_a += itemStack.field_77994_a;
        }
        if (this.foodBoost && recipeFurnace.isOutputFood() && this.inventory[1].field_77994_a < this.inventory[1].func_77976_d()) {
            this.inventory[1].field_77994_a += itemStack.field_77994_a;
        }
        this.inventory[0].field_77994_a -= recipeFurnace.getInput().field_77994_a;
        if (this.inventory[0].field_77994_a <= 0) {
            this.inventory[0] = null;
        }
    }

    @Override
    protected void transferInput() {
        if (!this.augmentAutoInput) {
            return;
        }
        for (int i = this.inputTracker + 1; i <= this.inputTracker + 6; ++i) {
            int n = i % 6;
            if (this.sideCache[n] != 1 || !this.extractItem(0, TileMachineBase.AUTO_TRANSFER[this.level], n)) continue;
            this.inputTracker = n;
            break;
        }
    }

    @Override
    protected void transferOutput() {
        if (!this.augmentAutoOutput) {
            return;
        }
        if (this.inventory[1] == null) {
            return;
        }
        for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            int n = i % 6;
            if (this.sideCache[n] != 2 || !this.transferItem(1, TileMachineBase.AUTO_TRANSFER[this.level], n)) continue;
            this.outputTracker = n;
            break;
        }
    }

    public Object getGuiClient(InventoryPlayer inventoryPlayer) {
        return new GuiFurnace(inventoryPlayer, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventoryPlayer) {
        return new ContainerFurnace(inventoryPlayer, (TileEntity)this);
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.inputTracker = nBTTagCompound.func_74762_e("TrackIn");
        this.outputTracker = nBTTagCompound.func_74762_e("TrackOut");
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74768_a("TrackIn", this.inputTracker);
        nBTTagCompound.func_74768_a("TrackOut", this.outputTracker);
    }

    @Override
    protected boolean installAugment(int n) {
        IAugmentItem iAugmentItem = (IAugmentItem)this.augments[n].func_77973_b();
        boolean bl = false;
        if (iAugmentItem.getAugmentLevel(this.augments[n], TEAugments.MACHINE_FURNACE_FOOD) > 0) {
            this.foodBoost = true;
            bl = true;
        }
        return bl ? true : super.installAugment(n);
    }

    @Override
    protected void resetAugments() {
        super.resetAugments();
        this.foodBoost = false;
    }

    @Override
    public boolean func_94041_b(int n, ItemStack itemStack) {
        return n == 0 ? (this.foodBoost ? FurnaceManager.isFoodItem(itemStack) : FurnaceManager.recipeExists(itemStack)) : true;
    }
}

