/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.world;

import cofh.api.world.IFeatureGenerator;
import com.google.common.primitives.Ints;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.setup.MFRConfig;
import powercrystals.minefactoryreloaded.setup.MFRThings;
import powercrystals.minefactoryreloaded.world.WorldGenLakesMeta;
import powercrystals.minefactoryreloaded.world.WorldGenMassiveTree;
import powercrystals.minefactoryreloaded.world.WorldGenRubberTree;

public class MineFactoryReloadedWorldGen
implements IFeatureGenerator {
    private static List<Integer> _blacklistedDimensions;
    private static List<String> _sludgeBiomeList;
    private static List<String> _sewageBiomeList;
    private static List<String> _rubberTreeBiomeList;
    private static boolean _sludgeLakeMode;
    private static boolean _sewageLakeMode;
    private static boolean _rubberTreesEnabled;
    private static boolean _lakesEnabled;
    private static boolean _regenSewage;
    private static boolean _regenSludge;
    private static boolean _regenTrees;
    private static int _sludgeLakeRarity;
    private static int _sewageLakeRarity;
    private final String name = "MFR:WorldGen";

    public static boolean generateMegaRubberTree(World world, Random random, int n, int n2, int n3, boolean bl) {
        return new WorldGenMassiveTree(false).setTreeScale(4 + random.nextInt(3), 0.8f, 0.7f).setLeafAttenuation(0.6f).setSloped(true).setSafe(bl).func_76484_a(world, random, n, n2, n3);
    }

    public static boolean generateSacredSpringRubberTree(World world, Random random, int n, int n2, int n3) {
        return new WorldGenMassiveTree(false).setTreeScale(6 + random.nextInt(4), 1.0f, 0.9f).setLeafAttenuation(0.35f).setSloped(false).setMinTrunkSize(4).func_76484_a(world, random, n, n2, n3);
    }

    public String getFeatureName() {
        return "MFR:WorldGen";
    }

    public boolean generateFeature(Random random, int n, int n2, World world, boolean bl) {
        int n3;
        if (_blacklistedDimensions == null) {
            MineFactoryReloadedWorldGen.buildBlacklistedDimensions();
        }
        if (_blacklistedDimensions.contains(world.field_73011_w.field_76574_g)) {
            return false;
        }
        int n4 = n * 16 + random.nextInt(16);
        BiomeGenBase biomeGenBase = world.func_72807_a(n4, n3 = n2 * 16 + random.nextInt(16));
        if (biomeGenBase == null) {
            return false;
        }
        String string = biomeGenBase.field_76791_y;
        if (_rubberTreesEnabled & (bl | _regenTrees) && _rubberTreeBiomeList.contains(string) && random.nextInt(100) < 40) {
            if (random.nextInt(30) == 0) {
                String string2 = string.toLowerCase();
                if (string2.contains("mega")) {
                    MineFactoryReloadedWorldGen.generateMegaRubberTree(world, random, n4, world.func_72976_f(n4, n3), n3, false);
                } else if (string2.contains("sacred") && random.nextInt(20) == 0) {
                    MineFactoryReloadedWorldGen.generateSacredSpringRubberTree(world, random, n4, world.func_72976_f(n4, n3), n3);
                }
            }
            new WorldGenRubberTree(false).func_76484_a(world, random, n4, random.nextInt(3) + 4, n3);
        }
        if (_lakesEnabled && world.field_73011_w.func_76567_e()) {
            int n5;
            int n6;
            int n7;
            int n8 = _sludgeLakeRarity;
            if (n8 > 0 & (bl | _regenSludge) && _sludgeBiomeList.contains(string) == _sludgeLakeMode && random.nextInt(n8) == 0) {
                n7 = n4 - 8 + random.nextInt(16);
                n6 = random.nextInt(world.func_72940_L());
                n5 = n3 - 8 + random.nextInt(16);
                new WorldGenLakesMeta((Block)MFRThings.sludgeLiquid, 0).func_76484_a(world, random, n7, n6, n5);
            }
            if ((n8 = _sewageLakeRarity) > 0 & (bl | _regenSewage) && _sewageBiomeList.contains(string) == _sewageLakeMode && random.nextInt(n8) == 0) {
                n7 = n4 - 8 + random.nextInt(16);
                n6 = random.nextInt(world.func_72940_L());
                n5 = n3 - 8 + random.nextInt(16);
                String string3 = string.toLowerCase();
                if (string3.contains("mushroom")) {
                    new WorldGenLakesMeta((Block)MFRThings.mushroomSoupLiquid, 0).func_76484_a(world, random, n7, n6, n5);
                } else {
                    new WorldGenLakesMeta((Block)MFRThings.sewageLiquid, 0).func_76484_a(world, random, n7, n6, n5);
                }
            }
        }
        return true;
    }

    private static void buildBlacklistedDimensions() {
        _blacklistedDimensions = Ints.asList((int[])MFRConfig.worldGenDimensionBlacklist.getIntList());
        _rubberTreeBiomeList = MFRRegistry.getRubberTreeBiomes();
        _rubberTreesEnabled = MFRConfig.rubberTreeWorldGen.getBoolean(true);
        _lakesEnabled = MFRConfig.mfrLakeWorldGen.getBoolean(true);
        _sludgeLakeRarity = MFRConfig.mfrLakeSludgeRarity.getInt();
        _sludgeBiomeList = Arrays.asList(MFRConfig.mfrLakeSludgeBiomeList.getStringList());
        _sludgeLakeMode = MFRConfig.mfrLakeSludgeBiomeListToggle.getBoolean(false);
        _sewageLakeRarity = MFRConfig.mfrLakeSewageRarity.getInt();
        _sewageBiomeList = Arrays.asList(MFRConfig.mfrLakeSewageBiomeList.getStringList());
        _sewageLakeMode = MFRConfig.mfrLakeSewageBiomeListToggle.getBoolean(false);
        _regenSewage = MFRConfig.mfrLakeSewageRetrogen.getBoolean(false);
        _regenSludge = MFRConfig.mfrLakeSludgeRetrogen.getBoolean(false);
        _regenTrees = MFRConfig.rubberTreeRetrogen.getBoolean(false);
    }
}

