/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.rednet;

import cofh.lib.util.LinkedHashList;
import cofh.lib.util.position.BlockPosition;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import powercrystals.minefactoryreloaded.api.rednet.IRedNetInputNode;
import powercrystals.minefactoryreloaded.api.rednet.IRedNetOutputNode;
import powercrystals.minefactoryreloaded.api.rednet.connectivity.IRedstoneAlike;
import powercrystals.minefactoryreloaded.core.ArrayHashList;
import powercrystals.minefactoryreloaded.core.IGrid;
import powercrystals.minefactoryreloaded.core.MFRUtil;
import powercrystals.minefactoryreloaded.net.GridTickHandler;
import powercrystals.minefactoryreloaded.setup.MFRConfig;
import powercrystals.minefactoryreloaded.setup.MFRThings;
import powercrystals.minefactoryreloaded.tile.rednet.TileEntityRedNetCable;

public class RedstoneNetwork
implements IGrid {
    static final GridTickHandler<RedstoneNetwork, TileEntityRedNetCable> HANDLER = GridTickHandler.redstone;
    private boolean _ignoreUpdates;
    private boolean _mustUpdate;
    private boolean updatePowerLevels;
    private boolean[] _updateSubnets = new boolean[16];
    private Set<BlockPosition>[] _singleNodes = new Set[16];
    private Set<BlockPosition> _omniNodes = new LinkedHashSet<BlockPosition>();
    private Set<BlockPosition> _weakNodes = new LinkedHashSet<BlockPosition>();
    private boolean regenerating;
    private ArrayHashList<TileEntityRedNetCable> nodeSet = new ArrayHashList();
    private LinkedHashList<TileEntityRedNetCable> conduitSet;
    private int[] _powerLevelOutput = new int[16];
    private BlockPosition[] _powerProviders = new BlockPosition[16];
    private World _world;
    private static boolean log = false;
    private static Logger _log = LogManager.getLogger((String)"RedNet Debug");

    public static void log(String string, Object ... objectArray) {
        if (log && string != null) {
            _log.debug(string, objectArray);
        }
    }

    private RedstoneNetwork(World world) {
        this._world = world;
        log = MFRConfig.redNetDebug.getBoolean(false);
        for (int i = 0; i < 16; ++i) {
            this._singleNodes[i] = new LinkedHashSet<BlockPosition>();
        }
    }

    public RedstoneNetwork(TileEntityRedNetCable tileEntityRedNetCable) {
        this(tileEntityRedNetCable.func_145831_w());
        this.conduitSet = new LinkedHashList();
        this.regenerating = true;
        this.addConduit(tileEntityRedNetCable);
        this.regenerating = false;
    }

    @Override
    public void doGridPreUpdate() {
        if (this._mustUpdate) {
            int n = 16;
            while (n-- > 0) {
                if (!this._updateSubnets[n]) continue;
                this.notifyNodes(n);
            }
            this._mustUpdate = false;
        }
    }

    @Override
    public void doGridUpdate() {
        if (this.updatePowerLevels) {
            this.updatePowerLevels();
            this.updatePowerLevels = false;
        }
    }

    public void addConduit(TileEntityRedNetCable tileEntityRedNetCable) {
        if (this.conduitSet.add((Object)tileEntityRedNetCable) && !this.conduitAdded(tileEntityRedNetCable)) {
            return;
        }
        if (tileEntityRedNetCable.isRSNode) {
            if (this.nodeSet.add(tileEntityRedNetCable)) {
                this.nodeAdded(tileEntityRedNetCable);
            }
        } else if (!this.nodeSet.isEmpty() && this.nodeSet.remove(tileEntityRedNetCable)) {
            this.nodeRemoved(tileEntityRedNetCable);
        }
    }

    public void removeConduit(TileEntityRedNetCable tileEntityRedNetCable) {
        this.conduitSet.remove((Object)tileEntityRedNetCable);
        if (!this.nodeSet.isEmpty() && this.nodeSet.remove(tileEntityRedNetCable)) {
            this.nodeRemoved(tileEntityRedNetCable);
        }
    }

    @Override
    public void markSweep() {
        RedstoneNetwork redstoneNetwork;
        BlockPosition blockPosition2;
        this.destroyGrid();
        if (this.conduitSet.isEmpty()) {
            return;
        }
        TileEntityRedNetCable tileEntityRedNetCable = (TileEntityRedNetCable)this.conduitSet.iterator().next();
        this.nodeSet.clear();
        this._omniNodes.clear();
        this._weakNodes.clear();
        for (BlockPosition blockPosition2 : this._singleNodes) {
            blockPosition2.clear();
        }
        LinkedHashList<TileEntityRedNetCable> linkedHashList = this.conduitSet;
        this.conduitSet = new LinkedHashList(Math.min(linkedHashList.size() / 6, 5));
        LinkedHashList linkedHashList2 = new LinkedHashList();
        LinkedHashList linkedHashList3 = new LinkedHashList();
        blockPosition2 = new BlockPosition(0, 0, 0);
        ForgeDirection[] forgeDirectionArray = ForgeDirection.VALID_DIRECTIONS;
        linkedHashList2.add((Object)tileEntityRedNetCable);
        linkedHashList3.add((Object)tileEntityRedNetCable);
        while (!linkedHashList2.isEmpty()) {
            tileEntityRedNetCable = (TileEntityRedNetCable)linkedHashList2.shift();
            this.addConduit(tileEntityRedNetCable);
            redstoneNetwork = tileEntityRedNetCable.func_145831_w();
            int n = 6;
            while (n-- > 0) {
                TileEntityRedNetCable tileEntityRedNetCable2;
                TileEntity tileEntity;
                blockPosition2.x = tileEntityRedNetCable.field_145851_c;
                blockPosition2.y = tileEntityRedNetCable.field_145848_d;
                blockPosition2.z = tileEntityRedNetCable.field_145849_e;
                blockPosition2.step(forgeDirectionArray[n]);
                if (!redstoneNetwork.func_72899_e(blockPosition2.x, blockPosition2.y, blockPosition2.z) || !((tileEntity = blockPosition2.getTileEntity((World)redstoneNetwork)) instanceof TileEntityRedNetCable) || !tileEntityRedNetCable.canInterface(tileEntityRedNetCable2 = (TileEntityRedNetCable)tileEntity, forgeDirectionArray[n ^ 1]) || !linkedHashList3.add((Object)tileEntityRedNetCable2)) continue;
                linkedHashList2.add((Object)tileEntityRedNetCable2);
            }
            linkedHashList.remove((Object)tileEntityRedNetCable);
        }
        if (!linkedHashList.isEmpty()) {
            redstoneNetwork = new RedstoneNetwork(this._world);
            redstoneNetwork.conduitSet = linkedHashList;
            redstoneNetwork.regenerating = true;
            redstoneNetwork.markSweep();
        }
        if (this.nodeSet.isEmpty()) {
            HANDLER.removeGrid(this);
        } else {
            HANDLER.addGrid(this);
        }
        this.regenerating = false;
        this.updatePowerLevels = !this.nodeSet.isEmpty();
    }

    public void destroyGrid() {
        this.regenerating = true;
        for (TileEntityRedNetCable tileEntityRedNetCable : this.nodeSet) {
            this.destroyNode(tileEntityRedNetCable);
        }
        for (TileEntityRedNetCable tileEntityRedNetCable : this.conduitSet) {
            this.destroyConduit(tileEntityRedNetCable);
        }
        HANDLER.removeGrid(this);
    }

    public void destroyNode(TileEntityRedNetCable tileEntityRedNetCable) {
        tileEntityRedNetCable._network = null;
    }

    public void destroyConduit(TileEntityRedNetCable tileEntityRedNetCable) {
        tileEntityRedNetCable._network = null;
    }

    public void nodeAdded(TileEntityRedNetCable tileEntityRedNetCable) {
        HANDLER.addConduitForUpdate(tileEntityRedNetCable);
        if (!this.nodeSet.isEmpty()) {
            HANDLER.addGrid(this);
        }
    }

    public void nodeRemoved(TileEntityRedNetCable tileEntityRedNetCable) {
        if (this.nodeSet.isEmpty()) {
            HANDLER.removeGrid(this);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean conduitAdded(TileEntityRedNetCable tileEntityRedNetCable) {
        if (tileEntityRedNetCable._network != null) {
            if (tileEntityRedNetCable._network == this) return false;
            this.conduitSet.remove((Object)tileEntityRedNetCable);
            if (!this.canMergeGrid(tileEntityRedNetCable._network)) return false;
            this.mergeGrid(tileEntityRedNetCable._network);
            return true;
        } else {
            tileEntityRedNetCable.setNetwork(this);
        }
        return true;
    }

    public boolean canMergeGrid(RedstoneNetwork redstoneNetwork) {
        return redstoneNetwork != null;
    }

    public void mergeGrid(RedstoneNetwork redstoneNetwork) {
        if (redstoneNetwork == this) {
            return;
        }
        boolean bl = this.regenerating || redstoneNetwork.regenerating;
        redstoneNetwork.destroyGrid();
        if (!this.regenerating & bl) {
            this.regenerate();
        }
        this.regenerating = true;
        for (TileEntityRedNetCable tileEntityRedNetCable : redstoneNetwork.conduitSet) {
            this.addConduit(tileEntityRedNetCable);
        }
        this.regenerating = bl;
        redstoneNetwork.conduitSet.clear();
        redstoneNetwork.nodeSet.clear();
    }

    public void regenerate() {
        this.regenerating = true;
        HANDLER.regenerateGrid(this);
    }

    public boolean isRegenerating() {
        return this.regenerating;
    }

    public int getConduitCount() {
        return this.conduitSet.size();
    }

    public int getNodeCount() {
        return this.nodeSet.size();
    }

    public int getPowerLevelOutput(int n) {
        return this._powerLevelOutput[n];
    }

    boolean isPowerProvider(int n, BlockPosition blockPosition) {
        return blockPosition.equals(this._powerProviders[n]);
    }

    public String toString() {
        return "RedstoneNetwork@" + Integer.toString(this.hashCode()) + "" + "; regenerating:" + this.regenerating + "; isTicking:" + HANDLER.isGridTicking(this);
    }

    public boolean isWeakNode(BlockPosition blockPosition) {
        return this._weakNodes.contains(blockPosition);
    }

    public void addOrUpdateNode(BlockPosition blockPosition) {
        int[] nArray;
        Block block = this._world.func_147439_a(blockPosition.x, blockPosition.y, blockPosition.z);
        if (block == MFRThings.rednetCableBlock) {
            return;
        }
        if (!this._omniNodes.contains(blockPosition)) {
            RedstoneNetwork.log("Network with ID %d adding omni node %s", this.hashCode(), blockPosition);
            this._omniNodes.add(blockPosition);
            this.notifyOmniNode(blockPosition);
        }
        if ((nArray = this.getOmniNodePowerLevel(blockPosition)) == null) {
            return;
        }
        for (int i = 0; i < 16; ++i) {
            int n = nArray[i];
            if (Math.abs(n) > Math.abs(this._powerLevelOutput[i])) {
                RedstoneNetwork.log("Network with ID %d:%d has omni node %s as new power provider", this.hashCode(), i, blockPosition);
                this._powerLevelOutput[i] = n;
                this._powerProviders[i] = blockPosition;
                this._mustUpdate = true;
                this._updateSubnets[i] = true;
                continue;
            }
            if (!blockPosition.equals(this._powerProviders[i]) || Math.abs(n) >= Math.abs(this._powerLevelOutput[i])) continue;
            this.updatePowerLevels(i);
        }
    }

    public void addOrUpdateNode(BlockPosition blockPosition, int n, boolean bl) {
        Block block = this._world.func_147439_a(blockPosition.x, blockPosition.y, blockPosition.z);
        if (block == MFRThings.rednetCableBlock) {
            return;
        }
        boolean bl2 = false;
        if (!this._singleNodes[n].contains(blockPosition)) {
            bl2 = true;
            this.removeNode(blockPosition);
            RedstoneNetwork.log("Network with ID %d:%d adding node %s", this.hashCode(), n, blockPosition);
            this._singleNodes[n].add(blockPosition);
        }
        bl2 = bl ? (bl2 |= this._weakNodes.add(blockPosition)) : (bl2 |= this._weakNodes.remove(blockPosition));
        int n2 = this.getSingleNodePowerLevel(blockPosition, n);
        RedstoneNetwork.log("Network with ID %d:%d calculated power for node %s as %d", this.hashCode(), n, blockPosition, n2);
        if (Math.abs(n2) > Math.abs(this._powerLevelOutput[n])) {
            RedstoneNetwork.log("Network with ID %d:%d has node %s as new power provider", this.hashCode(), n, blockPosition);
            this._powerLevelOutput[n] = n2;
            this._powerProviders[n] = blockPosition;
            this._mustUpdate = true;
            this._updateSubnets[n] = true;
        } else if (blockPosition.equals(this._powerProviders[n]) && Math.abs(n2) < Math.abs(this._powerLevelOutput[n])) {
            RedstoneNetwork.log("Network with ID %d:%d removing power provider node, recalculating", this.hashCode(), n);
            this.updatePowerLevels(n);
        }
        if (bl2) {
            this.notifySingleNode(blockPosition, n);
        }
    }

    public void removeNode(BlockPosition blockPosition) {
        boolean bl;
        boolean bl2 = bl = this._omniNodes.remove(blockPosition);
        bl2 |= this._weakNodes.remove(blockPosition);
        for (int i = 0; i < 16; ++i) {
            if (this._singleNodes[i].contains(blockPosition)) {
                bl2 = true;
                RedstoneNetwork.log("Network with ID %d:%d removing node %s", this.hashCode(), i, blockPosition);
                this._singleNodes[i].remove(blockPosition);
            }
            if (!blockPosition.equals(this._powerProviders[i])) continue;
            RedstoneNetwork.log("Network with ID %d:%d removing power provider node, recalculating", this.hashCode(), i);
            this.updatePowerLevels(i);
        }
        if (bl2) {
            Block block = this._world.func_147439_a(blockPosition.x, blockPosition.y, blockPosition.z);
            if (block == MFRThings.rednetCableBlock) {
                return;
            }
            if (block instanceof IRedNetInputNode) {
                if (bl) {
                    ((IRedNetInputNode)block).onInputsChanged(this._world, blockPosition.x, blockPosition.y, blockPosition.z, blockPosition.orientation.getOpposite(), new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
                } else {
                    ((IRedNetInputNode)block).onInputChanged(this._world, blockPosition.x, blockPosition.y, blockPosition.z, blockPosition.orientation.getOpposite(), 0);
                }
            }
            MFRUtil.notifyNearbyBlocksExcept(this._world, blockPosition.x, blockPosition.y, blockPosition.z, Blocks.field_150350_a);
        }
    }

    public void updatePowerLevels() {
        for (int i = 0; i < 16; ++i) {
            this.updatePowerLevels(i);
        }
    }

    public void updatePowerLevels(int n) {
        boolean bl;
        int n2;
        int n3 = this._powerLevelOutput[n];
        this._powerLevelOutput[n] = 0;
        this._powerProviders[n] = null;
        RedstoneNetwork.log("Network with ID %d:%d recalculating power levels for %d single nodes and %d omni nodes", this.hashCode(), n, this._singleNodes[n].size(), this._omniNodes.size());
        for (BlockPosition blockPosition : this._singleNodes[n]) {
            if (!this.isNodeLoaded(blockPosition) || Math.abs(n2 = this.getSingleNodePowerLevel(blockPosition, n)) <= Math.abs(this._powerLevelOutput[n])) continue;
            this._powerLevelOutput[n] = n2;
            this._powerProviders[n] = blockPosition;
        }
        for (BlockPosition blockPosition : this._omniNodes) {
            if (!this.isNodeLoaded(blockPosition) || Math.abs(n2 = this.getOmniNodePowerLevel(blockPosition, n)) <= Math.abs(this._powerLevelOutput[n])) continue;
            this._powerLevelOutput[n] = n2;
            this._powerProviders[n] = blockPosition;
        }
        RedstoneNetwork.log("Network with ID %d:%d recalculated power levels as: output: %d with powering node %s", this.hashCode(), n, this._powerLevelOutput[n], this._powerProviders[n]);
        this._updateSubnets[n] = bl = this._powerLevelOutput[n] != n3;
        this._mustUpdate |= bl;
    }

    private void notifyNodes(int n) {
        if (this._ignoreUpdates) {
            RedstoneNetwork.log("Network asked to notify nodes while ignoring updates (API misuse?)!", new Object[0]);
            this._mustUpdate = true;
            this._updateSubnets[n] = true;
            return;
        }
        this._updateSubnets[n] = false;
        this._ignoreUpdates = true;
        RedstoneNetwork.log("Network with ID %d:%d notifying %d single nodes and %d omni nodes", this.hashCode(), n, this._singleNodes[n].size(), this._omniNodes.size());
        for (BlockPosition blockPosition : this._singleNodes[n]) {
            RedstoneNetwork.log("Network with ID %d:%d notifying node %s of power state change to %d", this.hashCode(), n, blockPosition, this._powerLevelOutput[n]);
            this.notifySingleNode(blockPosition, n);
        }
        for (BlockPosition blockPosition : this._omniNodes) {
            RedstoneNetwork.log("Network with ID %d:%d notifying omni node %s of power state change to %d", this.hashCode(), n, blockPosition, this._powerLevelOutput[n]);
            this.notifyOmniNode(blockPosition);
        }
        this._ignoreUpdates = false;
    }

    private boolean isNodeLoaded(BlockPosition blockPosition) {
        return this._world.func_72863_F().func_73149_a(blockPosition.x >> 4, blockPosition.z >> 4);
    }

    private void notifySingleNode(BlockPosition blockPosition, int n) {
        if (this.isNodeLoaded(blockPosition)) {
            Block block = this._world.func_147439_a(blockPosition.x, blockPosition.y, blockPosition.z);
            if (block == MFRThings.rednetCableBlock) {
                return;
            }
            if (block instanceof IRedNetInputNode) {
                ((IRedNetInputNode)block).onInputChanged(this._world, blockPosition.x, blockPosition.y, blockPosition.z, blockPosition.orientation.getOpposite(), this._powerLevelOutput[n]);
            } else {
                MFRUtil.notifyNearbyBlocksExcept(this._world, blockPosition.x, blockPosition.y, blockPosition.z, Blocks.field_150350_a);
            }
        }
    }

    private void notifyOmniNode(BlockPosition blockPosition) {
        Block block;
        if (this.isNodeLoaded(blockPosition) && (block = this._world.func_147439_a(blockPosition.x, blockPosition.y, blockPosition.z)) instanceof IRedNetInputNode) {
            ((IRedNetInputNode)block).onInputsChanged(this._world, blockPosition.x, blockPosition.y, blockPosition.z, blockPosition.orientation.getOpposite(), Arrays.copyOf(this._powerLevelOutput, 16));
        }
    }

    private int getOmniNodePowerLevel(BlockPosition blockPosition, int n) {
        if (!this.isNodeLoaded(blockPosition)) {
            return 0;
        }
        int[] nArray = this.getOmniNodePowerLevel(blockPosition);
        return nArray == null ? 0 : nArray[n];
    }

    private int[] getOmniNodePowerLevel(BlockPosition blockPosition) {
        if (!this.isNodeLoaded(blockPosition)) {
            return null;
        }
        Block block = this._world.func_147439_a(blockPosition.x, blockPosition.y, blockPosition.z);
        if (block instanceof IRedNetOutputNode) {
            return ((IRedNetOutputNode)block).getOutputValues(this._world, blockPosition.x, blockPosition.y, blockPosition.z, blockPosition.orientation.getOpposite());
        }
        return null;
    }

    private int getSingleNodePowerLevel(BlockPosition blockPosition, int n) {
        if (!this.isNodeLoaded(blockPosition)) {
            return 0;
        }
        Block block = this._world.func_147439_a(blockPosition.x, blockPosition.y, blockPosition.z);
        if (block instanceof IRedNetOutputNode) {
            return ((IRedNetOutputNode)block).getOutputValue(this._world, blockPosition.x, blockPosition.y, blockPosition.z, blockPosition.orientation, n);
        }
        int n2 = 0;
        if (block == Blocks.field_150488_af || block instanceof IRedstoneAlike) {
            n2 = -1;
        }
        int n3 = 0;
        if (this._weakNodes.contains(blockPosition)) {
            int n4 = this._world.func_72878_l(blockPosition.x, blockPosition.y, blockPosition.z, blockPosition.orientation.ordinal()) + n2;
            int n5 = this._world.func_72879_k(blockPosition.x, blockPosition.y, blockPosition.z, blockPosition.orientation.ordinal()) + n2;
            n3 = Math.max(n4, n5);
        } else {
            n3 = this._world.func_72879_k(blockPosition.x, blockPosition.y, blockPosition.z, blockPosition.orientation.ordinal()) + n2;
        }
        if (n2 == n3) {
            return 0;
        }
        return n3;
    }
}

