/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.base;

import cofh.api.item.IAugmentItem;
import cofh.core.util.fluid.FluidTankAdv;
import cofh.lib.util.helpers.FluidHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import powercrystals.minefactoryreloaded.core.MFRLiquidMover;
import powercrystals.minefactoryreloaded.core.UtilInventory;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactory;

public abstract class TileEntityFactoryInventory
extends TileEntityFactory
implements ISidedInventory {
    protected static final FluidTankAdv[] emptyIFluidTank = new FluidTankAdv[0];
    protected static final FluidTankInfo[] emptyFluidTankInfo = FluidHelper.NULL_TANK_INFO;
    protected static final int BUCKET_VOLUME = 1000;
    protected List<ItemStack> failedDrops = null;
    private List<ItemStack> missedDrops = new ArrayList<ItemStack>(5);
    protected int _failedDropTicksMax = 20;
    private int _failedDropTicks = 0;
    protected FluidTankAdv[] _tanks;
    protected ItemStack[] _inventory = new ItemStack[this.func_70302_i_()];
    protected boolean internalChange = false;

    protected TileEntityFactoryInventory(Machine machine) {
        super(machine);
        this._tanks = this.createTanks();
        this.setManageFluids(this._tanks != null);
    }

    public String func_145825_b() {
        return this._invName != null ? this._invName : StatCollector.func_74838_a((String)(this._machine.getInternalName() + ".name"));
    }

    public boolean func_145818_k_() {
        return this._invName != null;
    }

    public void onDisassembled() {
        if (this.failedDrops != null) {
            while (this.failedDrops.size() > 0) {
                ItemStack itemStack = this.failedDrops.remove(0);
                if (itemStack == null || itemStack.func_77973_b() == null) continue;
                float f = this.field_145850_b.field_73012_v.nextFloat() * 0.8f + 0.1f;
                float f2 = this.field_145850_b.field_73012_v.nextFloat() * 0.8f + 0.1f;
                float f3 = this.field_145850_b.field_73012_v.nextFloat() * 0.8f + 0.1f;
                while (itemStack.field_77994_a > 0) {
                    int n = this.field_145850_b.field_73012_v.nextInt(21) + 10;
                    if (n > itemStack.field_77994_a) {
                        n = itemStack.field_77994_a;
                    }
                    itemStack.field_77994_a -= n;
                    EntityItem entityItem = new EntityItem(this.field_145850_b, (double)((float)this.field_145851_c + f), (double)((float)this.field_145848_d + f2), (double)((float)this.field_145849_e + f3), new ItemStack(itemStack.func_77973_b(), n, itemStack.func_77960_j()));
                    if (itemStack.func_77978_p() != null) {
                        entityItem.func_92059_d().func_77982_d(itemStack.func_77978_p());
                    }
                    float f4 = 0.05f;
                    entityItem.field_70159_w = (float)this.field_145850_b.field_73012_v.nextGaussian() * f4;
                    entityItem.field_70181_x = (float)this.field_145850_b.field_73012_v.nextGaussian() * f4 + 0.2f;
                    entityItem.field_70179_y = (float)this.field_145850_b.field_73012_v.nextGaussian() * f4;
                    this.field_145850_b.func_72838_d((Entity)entityItem);
                }
            }
        }
    }

    public void onBlockBroken() {
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        this.writeItemNBT(nBTTagCompound);
        this.onDisassembled();
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection forgeDirection) {
        FluidTankAdv[] fluidTankAdvArray = this.getTanks();
        if (fluidTankAdvArray.length == 0) {
            return emptyFluidTankInfo;
        }
        FluidTankInfo[] fluidTankInfoArray = new FluidTankInfo[fluidTankAdvArray.length];
        int n = fluidTankAdvArray.length;
        while (n-- > 0) {
            fluidTankInfoArray[n] = fluidTankAdvArray[n].getInfo();
        }
        return fluidTankInfoArray;
    }

    protected FluidTankAdv[] createTanks() {
        return null;
    }

    public FluidTankAdv[] getTanks() {
        if (this._tanks != null) {
            return this._tanks;
        }
        return emptyIFluidTank;
    }

    public int drain(FluidTankAdv fluidTankAdv, int n, boolean bl) {
        FluidStack fluidStack;
        if (fluidTankAdv.getFluidAmount() > 0 && (fluidStack = fluidTankAdv.drain(n, bl)) != null) {
            if (bl) {
                this.internalChange = true;
                this.func_70296_d();
                this.internalChange = false;
            }
            return fluidStack.amount;
        }
        return 0;
    }

    public FluidStack drain(int n, boolean bl) {
        for (FluidTankAdv fluidTankAdv : this.getTanks()) {
            if (fluidTankAdv.getFluidAmount() <= 0) continue;
            return fluidTankAdv.drain(n, bl);
        }
        return null;
    }

    public FluidStack drain(FluidStack fluidStack, boolean bl) {
        if (fluidStack != null) {
            for (FluidTankAdv fluidTankAdv : this.getTanks()) {
                if (!fluidStack.isFluidEqual(fluidTankAdv.getFluid())) continue;
                return fluidTankAdv.drain(fluidStack.amount, bl);
            }
        }
        return null;
    }

    public int fill(FluidStack fluidStack, boolean bl) {
        if (fluidStack != null) {
            for (FluidTankAdv fluidTankAdv : this.getTanks()) {
                if (!FluidHelper.isFluidEqualOrNull((FluidStack)fluidTankAdv.getFluid(), (FluidStack)fluidStack)) continue;
                return fluidTankAdv.fill(fluidStack, bl);
            }
        }
        return 0;
    }

    protected boolean shouldPumpLiquid() {
        return false;
    }

    protected boolean shouldPumpTank(IFluidTank iFluidTank) {
        return true;
    }

    public boolean allowBucketFill(ItemStack itemStack) {
        return false;
    }

    public boolean allowBucketDrain(ItemStack itemStack) {
        return false;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K && this.shouldPumpLiquid()) {
            for (FluidTankAdv fluidTankAdv : this.getTanks()) {
                if (!this.shouldPumpTank((IFluidTank)fluidTankAdv)) continue;
                MFRLiquidMover.pumpLiquid((IFluidTank)fluidTankAdv, this);
            }
        }
        if (this.failedDrops != null) {
            if (this._failedDropTicks < this._failedDropTicksMax) {
                ++this._failedDropTicks;
                return;
            }
            this._failedDropTicks = 0;
            if (!this.doDrop(this.failedDrops)) {
                return;
            }
            this.failedDrops = null;
            this.func_70296_d();
        }
    }

    public boolean doDrop(ItemStack itemStack) {
        if ((itemStack = UtilInventory.dropStack((TileEntity)this, itemStack, this.getDropDirections(), this.getDropDirection())) != null && itemStack.field_77994_a > 0) {
            if (this.failedDrops == null) {
                this.failedDrops = new ArrayList<ItemStack>();
            }
            this.failedDrops.add(itemStack);
            this.func_70296_d();
        }
        return true;
    }

    public boolean doDrop(List<ItemStack> list) {
        if (list == null || list.size() <= 0) {
            return true;
        }
        List<ItemStack> list2 = this.missedDrops;
        list2.clear();
        int n = list.size();
        while (n-- > 0) {
            ItemStack itemStack = list.get(n);
            if ((itemStack = UtilInventory.dropStack((TileEntity)this, itemStack, this.getDropDirections(), this.getDropDirection())) == null || itemStack.field_77994_a <= 0) continue;
            list2.add(itemStack);
        }
        if (list2.size() != 0) {
            if (list != this.failedDrops) {
                if (this.failedDrops == null) {
                    this.failedDrops = new ArrayList<ItemStack>(list2.size());
                }
                this.failedDrops.addAll(list2);
            } else {
                this.failedDrops.clear();
                this.failedDrops.addAll(list2);
            }
            this.func_70296_d();
            return false;
        }
        return true;
    }

    public boolean hasDrops() {
        return this.failedDrops != null;
    }

    protected int getUpgradeSlot() {
        return -1;
    }

    protected boolean canUseUpgrade(ItemStack itemStack, IAugmentItem iAugmentItem) {
        return iAugmentItem.getAugmentLevel(itemStack, "radius") != 0;
    }

    public boolean isUsableAugment(ItemStack itemStack) {
        if (itemStack == null || !(itemStack.func_77973_b() instanceof IAugmentItem)) {
            return false;
        }
        return this.canUseUpgrade(itemStack, (IAugmentItem)itemStack.func_77973_b());
    }

    public boolean acceptUpgrade(ItemStack itemStack) {
        int n = this.getUpgradeSlot();
        if (n < 0 | itemStack == null || !this.isUsableAugment(itemStack)) {
            return false;
        }
        if (this.func_70301_a(n) != null) {
            return false;
        }
        this.func_70299_a(n, itemStack);
        return true;
    }

    public ItemStack func_70301_a(int n) {
        return this._inventory[n];
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public ItemStack func_70298_a(int n, int n2) {
        if (this._inventory[n] != null) {
            if (this._inventory[n].field_77994_a <= n2) {
                ItemStack itemStack = this._inventory[n];
                this._inventory[n] = null;
                this.func_70296_d();
                return itemStack;
            }
            ItemStack itemStack = this._inventory[n].func_77979_a(n2);
            if (this._inventory[n].field_77994_a <= 0) {
                this._inventory[n] = null;
            }
            this.func_70296_d();
            return itemStack;
        }
        this.func_70296_d();
        return null;
    }

    public void func_70299_a(int n, ItemStack itemStack) {
        if (itemStack != null) {
            if (itemStack.field_77994_a > this.func_70297_j_()) {
                itemStack.field_77994_a = this.func_70297_j_();
            } else if (itemStack.field_77994_a < 0) {
                itemStack = null;
            }
        }
        this._inventory[n] = itemStack;
        this.func_70296_d();
    }

    @Override
    public void func_70296_d() {
        if (!this.internalChange) {
            this.onFactoryInventoryChanged();
        }
        super.func_70296_d();
    }

    protected void onFactoryInventoryChanged() {
    }

    public int func_70297_j_() {
        return 127;
    }

    public boolean func_94041_b(int n, ItemStack itemStack) {
        int n2 = this.getStartInventorySide(ForgeDirection.UNKNOWN);
        if (n < n2 || n > n2 + this.getSizeInventorySide(ForgeDirection.UNKNOWN)) {
            return false;
        }
        if (itemStack == null) {
            return true;
        }
        if (itemStack.field_77994_a > Math.min(itemStack.func_77976_d(), this.func_70297_j_())) {
            return false;
        }
        ItemStack itemStack2 = this.func_70301_a(n);
        return itemStack2 == null || UtilInventory.stacksEqual(itemStack, itemStack2);
    }

    public boolean func_70300_a(EntityPlayer entityPlayer) {
        if (this.func_145837_r() || this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return entityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        NBTTagList nBTTagList;
        super.func_145839_a(nBTTagCompound);
        this._inventory = new ItemStack[this.func_70302_i_()];
        if (nBTTagCompound.func_74764_b("Items")) {
            nBTTagList = nBTTagCompound.func_150295_c("Items", 10);
            int n = nBTTagList.func_74745_c();
            while (n-- > 0) {
                NBTTagCompound nBTTagCompound2 = nBTTagList.func_150305_b(n);
                int n2 = nBTTagCompound2.func_74771_c("Slot") & 0xFF;
                if (!(n2 >= 0 & n2 < this._inventory.length)) continue;
                this._inventory[n2] = ItemStack.func_77949_a((NBTTagCompound)nBTTagCompound2);
                if (this._inventory[n2].field_77994_a >= 0) continue;
                this._inventory[n2] = null;
            }
        }
        this.func_70296_d();
        if (this.manageFluids() && nBTTagCompound.func_74764_b("Tanks")) {
            FluidTankAdv[] fluidTankAdvArray = this.getTanks();
            nBTTagList = nBTTagCompound.func_150295_c("Tanks", 10);
            for (int i = 0; i < nBTTagList.func_74745_c(); ++i) {
                FluidStack fluidStack;
                NBTTagCompound nBTTagCompound3 = nBTTagList.func_150305_b(i);
                int n = nBTTagCompound3.func_74771_c("Tank") & 0xFF;
                if (n < 0 || n >= fluidTankAdvArray.length || (fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nBTTagCompound3)) == null) continue;
                fluidTankAdvArray[n].setFluid(fluidStack);
            }
        }
        if (nBTTagCompound.func_74764_b("DropItems")) {
            ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
            nBTTagList = nBTTagCompound.func_150295_c("DropItems", 10);
            int n = nBTTagList.func_74745_c();
            while (n-- > 0) {
                NBTTagCompound nBTTagCompound4 = nBTTagList.func_150305_b(n);
                ItemStack itemStack = ItemStack.func_77949_a((NBTTagCompound)nBTTagCompound4);
                if (itemStack == null || itemStack.field_77994_a <= 0) continue;
                arrayList.add(itemStack);
            }
            if (arrayList.size() != 0) {
                this.failedDrops = arrayList;
            }
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        NBTTagList nBTTagList;
        super.func_145841_b(nBTTagCompound);
        if (this._inventory.length > 0) {
            nBTTagList = new NBTTagList();
            for (int i = 0; i < this._inventory.length; ++i) {
                if (this._inventory[i] == null || this._inventory[i].field_77994_a < 0) continue;
                ItemStack itemStack = new NBTTagCompound();
                itemStack.func_74774_a("Slot", (byte)i);
                this._inventory[i].func_77955_b((NBTTagCompound)itemStack);
                nBTTagList.func_74742_a((NBTBase)itemStack);
            }
            if (nBTTagList.func_74745_c() > 0) {
                nBTTagCompound.func_74782_a("Items", (NBTBase)nBTTagList);
            }
        }
        if (this.failedDrops != null) {
            nBTTagList = new NBTTagList();
            for (ItemStack itemStack : this.failedDrops) {
                NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
                itemStack.func_77955_b(nBTTagCompound2);
                nBTTagList.func_74742_a((NBTBase)nBTTagCompound2);
            }
            if (nBTTagList.func_74745_c() > 0) {
                nBTTagCompound.func_74782_a("DropItems", (NBTBase)nBTTagList);
            }
        }
    }

    @Override
    public void writeItemNBT(NBTTagCompound nBTTagCompound) {
        super.writeItemNBT(nBTTagCompound);
        FluidTankAdv[] fluidTankAdvArray = this.getTanks();
        if (fluidTankAdvArray.length > 0) {
            NBTTagList nBTTagList = new NBTTagList();
            int n = fluidTankAdvArray.length;
            for (int i = 0; i < n; ++i) {
                if (fluidTankAdvArray[i].getFluid() == null) continue;
                NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
                nBTTagCompound2.func_74774_a("Tank", (byte)i);
                FluidStack fluidStack = fluidTankAdvArray[i].getFluid();
                fluidStack.writeToNBT(nBTTagCompound2);
                nBTTagList.func_74742_a((NBTBase)nBTTagCompound2);
            }
            if (nBTTagList.func_74745_c() > 0) {
                nBTTagCompound.func_74782_a("Tanks", (NBTBase)nBTTagList);
            }
        }
    }

    public ItemStack func_70304_b(int n) {
        return null;
    }

    public boolean shouldDropSlotWhenBroken(int n) {
        return true;
    }

    public int[] func_94128_d(int n) {
        int n2 = this.getStartInventorySide(ForgeDirection.getOrientation((int)n));
        int n3 = this.getSizeInventorySide(ForgeDirection.getOrientation((int)n));
        int[] nArray = new int[n3];
        for (int i = 0; i < n3; ++i) {
            nArray[i] = i + n2;
        }
        return nArray;
    }

    public int getStartInventorySide(ForgeDirection forgeDirection) {
        return 0;
    }

    public int getSizeInventorySide(ForgeDirection forgeDirection) {
        return this.func_70302_i_();
    }

    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        return itemStack == null || this.func_94041_b(n, itemStack);
    }

    public boolean func_102008_b(int n, ItemStack itemStack, int n2) {
        return true;
    }

    public int getComparatorOutput(int n) {
        int[] nArray;
        FluidTankAdv[] fluidTankAdvArray = this.getTanks();
        FluidTankAdv fluidTankAdv = null;
        if (fluidTankAdvArray.length > 0) {
            fluidTankAdv = fluidTankAdvArray[0];
        }
        float f = 0.0f;
        float f2 = 0.0f;
        boolean bl = false;
        boolean bl2 = false;
        if (fluidTankAdv != null) {
            bl = true;
            if (fluidTankAdv.getFluid() != null) {
                f = (float)fluidTankAdv.getFluid().amount / (float)fluidTankAdv.getCapacity();
            }
        }
        if ((nArray = this.func_94128_d(n)).length > 0) {
            bl2 = true;
            int[] nArray2 = nArray;
            int n2 = 0;
            float f3 = 0.0f;
            int n3 = nArray2.length;
            while (n3-- > 0) {
                if (!this.func_102007_a(nArray2[n3], null, n)) continue;
                ItemStack itemStack = this.func_70301_a(nArray2[n3]);
                if (itemStack != null) {
                    float f4 = Math.min(itemStack.func_77976_d(), this.func_70297_j_());
                    f3 += Math.max(Math.min((float)itemStack.field_77994_a / f4, 1.0f), 0.0f);
                }
                ++n2;
            }
            f2 = f3 / (float)n2;
        }
        float f5 = bl & bl2 ? (f + f2) / 2.0f : (bl ? f : (bl2 ? f2 : 0.0f));
        return (int)Math.ceil(15.0f * f5);
    }
}

