/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.core;

import buildcraft.api.transport.IPipeTile;
import cofh.api.transport.IItemDuct;
import cofh.asm.relauncher.Strippable;
import cofh.lib.inventory.InventoryManager;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.position.BlockPosition;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.minefactoryreloaded.core.MFRUtil;

public abstract class UtilInventory {
    private static boolean handlePipeTiles = false;
    private static final String pipeClass = "buildcraft.api.transport.IPipeTile";

    public static Map<ForgeDirection, IItemDuct> findConduits(World world, int n, int n2, int n3) {
        return UtilInventory.findConduits(world, n, n2, n3, ForgeDirection.VALID_DIRECTIONS);
    }

    public static Map<ForgeDirection, IItemDuct> findConduits(World world, int n, int n2, int n3, ForgeDirection[] forgeDirectionArray) {
        LinkedHashMap<ForgeDirection, IItemDuct> linkedHashMap = new LinkedHashMap<ForgeDirection, IItemDuct>();
        BlockPosition blockPosition = new BlockPosition(n, n2, n3);
        for (ForgeDirection forgeDirection : forgeDirectionArray) {
            blockPosition.x = n;
            blockPosition.y = n2;
            blockPosition.z = n3;
            blockPosition.step(forgeDirection, 1);
            TileEntity tileEntity = world.func_147438_o(blockPosition.x, blockPosition.y, blockPosition.z);
            if (!(tileEntity instanceof IItemDuct)) continue;
            linkedHashMap.put(forgeDirection, (IItemDuct)tileEntity);
        }
        return linkedHashMap;
    }

    @Strippable(value={"buildcraft.api.transport.IPipeTile"})
    public static Map<ForgeDirection, IPipeTile> findPipes(World world, int n, int n2, int n3) {
        return UtilInventory.findPipes(world, n, n2, n3, ForgeDirection.VALID_DIRECTIONS);
    }

    @Strippable(value={"buildcraft.api.transport.IPipeTile"})
    public static Map<ForgeDirection, IPipeTile> findPipes(World world, int n, int n2, int n3, ForgeDirection[] forgeDirectionArray) {
        LinkedHashMap<ForgeDirection, IPipeTile> linkedHashMap = new LinkedHashMap<ForgeDirection, IPipeTile>();
        BlockPosition blockPosition = new BlockPosition(n, n2, n3);
        for (ForgeDirection forgeDirection : forgeDirectionArray) {
            blockPosition.x = n;
            blockPosition.y = n2;
            blockPosition.z = n3;
            blockPosition.step(forgeDirection, 1);
            TileEntity tileEntity = world.func_147438_o(blockPosition.x, blockPosition.y, blockPosition.z);
            if (!(tileEntity instanceof IPipeTile)) continue;
            linkedHashMap.put(forgeDirection, (IPipeTile)tileEntity);
        }
        return linkedHashMap;
    }

    public static Map<ForgeDirection, IInventory> findChests(World world, int n, int n2, int n3) {
        return UtilInventory.findChests(world, n, n2, n3, ForgeDirection.VALID_DIRECTIONS);
    }

    public static Map<ForgeDirection, IInventory> findChests(World world, int n, int n2, int n3, ForgeDirection[] forgeDirectionArray) {
        LinkedHashMap<ForgeDirection, IInventory> linkedHashMap = new LinkedHashMap<ForgeDirection, IInventory>();
        BlockPosition blockPosition = new BlockPosition(n, n2, n3);
        for (ForgeDirection forgeDirection : forgeDirectionArray) {
            blockPosition.x = n;
            blockPosition.y = n2;
            blockPosition.z = n3;
            blockPosition.step(forgeDirection, 1);
            TileEntity tileEntity = world.func_147438_o(blockPosition.x, blockPosition.y, blockPosition.z);
            if (tileEntity == null || !(tileEntity instanceof IInventory)) continue;
            linkedHashMap.put(forgeDirection, UtilInventory.checkForDoubleChest(world, tileEntity, blockPosition));
        }
        return linkedHashMap;
    }

    private static IInventory checkForDoubleChest(World world, TileEntity tileEntity, BlockPosition blockPosition) {
        block3: {
            Block block;
            block2: {
                block = world.func_147439_a(blockPosition.x, blockPosition.y, blockPosition.z);
                if (block != Blocks.field_150486_ae) break block2;
                for (BlockPosition blockPosition2 : blockPosition.getAdjacent(false)) {
                    if (world.func_147439_a(blockPosition2.x, blockPosition2.y, blockPosition2.z) != Blocks.field_150486_ae) continue;
                    return new InventoryLargeChest("", (IInventory)tileEntity, (IInventory)world.func_147438_o(blockPosition2.x, blockPosition2.y, blockPosition2.z));
                }
                break block3;
            }
            if (block != Blocks.field_150447_bR) break block3;
            for (BlockPosition blockPosition3 : blockPosition.getAdjacent(false)) {
                if (world.func_147439_a(blockPosition3.x, blockPosition3.y, blockPosition3.z) != Blocks.field_150447_bR) continue;
                return new InventoryLargeChest("", (IInventory)tileEntity, (IInventory)world.func_147438_o(blockPosition3.x, blockPosition3.y, blockPosition3.z));
            }
        }
        return (IInventory)tileEntity;
    }

    public static ItemStack dropStack(TileEntity tileEntity, ItemStack itemStack) {
        return UtilInventory.dropStack(tileEntity.func_145831_w(), new BlockPosition(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e), itemStack, ForgeDirection.VALID_DIRECTIONS, ForgeDirection.UNKNOWN);
    }

    public static ItemStack dropStack(TileEntity tileEntity, ItemStack itemStack, ForgeDirection forgeDirection) {
        return UtilInventory.dropStack(tileEntity.func_145831_w(), new BlockPosition(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e), itemStack, ForgeDirection.VALID_DIRECTIONS, forgeDirection);
    }

    public static ItemStack dropStack(TileEntity tileEntity, ItemStack itemStack, ForgeDirection forgeDirection, ForgeDirection forgeDirection2) {
        ForgeDirection[] forgeDirectionArray = new ForgeDirection[]{forgeDirection};
        return UtilInventory.dropStack(tileEntity.func_145831_w(), new BlockPosition(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e), itemStack, forgeDirectionArray, forgeDirection2);
    }

    public static ItemStack dropStack(TileEntity tileEntity, ItemStack itemStack, ForgeDirection[] forgeDirectionArray, ForgeDirection forgeDirection) {
        return UtilInventory.dropStack(tileEntity.func_145831_w(), new BlockPosition(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e), itemStack, forgeDirectionArray, forgeDirection);
    }

    public static ItemStack dropStack(World world, BlockPosition blockPosition, ItemStack itemStack, ForgeDirection[] forgeDirectionArray, ForgeDirection forgeDirection) {
        ForgeDirection forgeDirection2;
        if (world.field_72995_K | itemStack == null || itemStack.field_77994_a == 0 || itemStack.func_77973_b() == null) {
            return null;
        }
        itemStack = itemStack.func_77946_l();
        for (Map.Entry<ForgeDirection, IItemDuct> entry : UtilInventory.findConduits(world, blockPosition.x, blockPosition.y, blockPosition.z, forgeDirectionArray).entrySet()) {
            forgeDirection2 = entry.getKey().getOpposite();
            itemStack = entry.getValue().insertItem(forgeDirection2, itemStack);
            if (itemStack != null && itemStack.field_77994_a > 0) continue;
            return null;
        }
        if (handlePipeTiles) {
            itemStack = UtilInventory.handleIPipeTile(world, blockPosition, forgeDirectionArray, itemStack);
        }
        for (Map.Entry<ForgeDirection, IItemDuct> entry : UtilInventory.findChests(world, blockPosition.x, blockPosition.y, blockPosition.z, forgeDirectionArray).entrySet()) {
            forgeDirection2 = InventoryManager.create((Object)entry.getValue(), (ForgeDirection)entry.getKey().getOpposite());
            itemStack = forgeDirection2.addItem(itemStack);
            if (itemStack != null && itemStack.field_77994_a > 0) continue;
            return null;
        }
        blockPosition.orientation = forgeDirection;
        blockPosition.moveForwards(1);
        if (MFRUtil.VALID_DIRECTIONS.contains(forgeDirection) && UtilInventory.isAirDrop(world, blockPosition.x, blockPosition.y, blockPosition.z)) {
            blockPosition.moveBackwards(1);
            UtilInventory.dropStackInAir(world, blockPosition, itemStack, forgeDirection);
            return null;
        }
        return itemStack;
    }

    public static boolean isAirDrop(World world, int n, int n2, int n3) {
        Block block = world.func_147439_a(n, n2, n3);
        if (block.isAir((IBlockAccess)world, n, n2, n3)) {
            return true;
        }
        block.func_149719_a((IBlockAccess)world, n, n2, n3);
        return block.func_149668_a(world, n, n2, n3) == null;
    }

    private static ItemStack handleIPipeTile(World world, BlockPosition blockPosition, ForgeDirection[] forgeDirectionArray, ItemStack itemStack) {
        for (Map.Entry<ForgeDirection, IPipeTile> entry : UtilInventory.findPipes(world, blockPosition.x, blockPosition.y, blockPosition.z, forgeDirectionArray).entrySet()) {
            ForgeDirection forgeDirection = entry.getKey().getOpposite();
            if (!entry.getValue().isPipeConnected(forgeDirection) || entry.getValue().injectItem(itemStack.func_77946_l(), false, forgeDirection) <= 0) continue;
            itemStack.field_77994_a -= entry.getValue().injectItem(itemStack.func_77946_l(), true, forgeDirection);
            if (itemStack.field_77994_a > 0) continue;
            return null;
        }
        return itemStack;
    }

    public static void dropStackInAir(World world, BlockPosition blockPosition, ItemStack itemStack) {
        UtilInventory.dropStackInAir(world, blockPosition, itemStack, ForgeDirection.UNKNOWN);
    }

    public static void dropStackInAir(World world, BlockPosition blockPosition, ItemStack itemStack, int n) {
        UtilInventory.dropStackInAir(world, blockPosition, itemStack, n, ForgeDirection.UNKNOWN);
    }

    public static void dropStackInAir(World world, BlockPosition blockPosition, ItemStack itemStack, ForgeDirection forgeDirection) {
        UtilInventory.dropStackInAir(world, blockPosition, itemStack, 20, forgeDirection);
    }

    public static void dropStackInAir(World world, BlockPosition blockPosition, ItemStack itemStack, int n, ForgeDirection forgeDirection) {
        UtilInventory.dropStackInAir(world, blockPosition.x, blockPosition.y, blockPosition.z, itemStack, n, forgeDirection);
    }

    public static void dropStackInAir(World world, Entity entity, ItemStack itemStack) {
        UtilInventory.dropStackInAir(world, entity, itemStack, ForgeDirection.UNKNOWN);
    }

    public static void dropStackInAir(World world, Entity entity, ItemStack itemStack, int n) {
        UtilInventory.dropStackInAir(world, entity, itemStack, n, ForgeDirection.UNKNOWN);
    }

    public static void dropStackInAir(World world, Entity entity, ItemStack itemStack, ForgeDirection forgeDirection) {
        UtilInventory.dropStackInAir(world, entity, itemStack, 20, forgeDirection);
    }

    public static void dropStackInAir(World world, Entity entity, ItemStack itemStack, int n, ForgeDirection forgeDirection) {
        UtilInventory.dropStackInAir(world, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, itemStack, n, forgeDirection);
    }

    public static void dropStackInAir(World world, double d, double d2, double d3, ItemStack itemStack, int n, ForgeDirection forgeDirection) {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        switch (forgeDirection) {
            case UP: {
                f = 0.5f;
                f2 = 1.5f;
                f3 = 0.5f;
                break;
            }
            case DOWN: {
                f = 0.5f;
                f2 = -0.75f;
                f3 = 0.5f;
                break;
            }
            case NORTH: {
                f = 0.5f;
                f2 = 0.5f;
                f3 = -0.5f;
                break;
            }
            case SOUTH: {
                f = 0.5f;
                f2 = 0.5f;
                f3 = 1.5f;
                break;
            }
            case EAST: {
                f = 1.5f;
                f2 = 0.5f;
                f3 = 0.5f;
                break;
            }
            case WEST: {
                f = -0.5f;
                f2 = 0.5f;
                f3 = 0.5f;
                break;
            }
        }
        EntityItem entityItem = new EntityItem(world, d + (double)f, d2 + (double)f2, d3 + (double)f3, itemStack.func_77946_l());
        entityItem.field_70159_w = 0.0;
        if (forgeDirection != ForgeDirection.DOWN) {
            entityItem.field_70181_x = 0.3;
        }
        entityItem.field_70179_y = 0.0;
        entityItem.field_145804_b = n;
        world.func_72838_d((Entity)entityItem);
    }

    public static ItemStack consumeItem(ItemStack itemStack, EntityPlayer entityPlayer) {
        return ItemHelper.consumeItem((ItemStack)itemStack, (EntityPlayer)entityPlayer);
    }

    public static void mergeStacks(ItemStack itemStack, ItemStack itemStack2) {
        if (!UtilInventory.stacksEqual(itemStack, itemStack2)) {
            return;
        }
        int n = Math.min(itemStack.func_77976_d() - itemStack.field_77994_a, itemStack2.field_77994_a);
        itemStack.field_77994_a += n;
        itemStack2.field_77994_a -= n;
    }

    public static boolean stacksEqual(ItemStack itemStack, ItemStack itemStack2) {
        return UtilInventory.stacksEqual(itemStack, itemStack2, true);
    }

    public static boolean stacksEqual(ItemStack itemStack, ItemStack itemStack2, boolean bl) {
        if (itemStack == null | itemStack2 == null) {
            return false;
        }
        if (!itemStack.func_77969_a(itemStack2)) {
            return false;
        }
        if (!bl) {
            return true;
        }
        if (itemStack.func_77978_p() == itemStack2.func_77978_p()) {
            return true;
        }
        if (itemStack.func_77978_p() == null || itemStack2.func_77978_p() == null) {
            return false;
        }
        return itemStack.func_77978_p().equals((Object)itemStack2.func_77978_p());
    }

    static {
        try {
            Class.forName(pipeClass);
            handlePipeTiles = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

