/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.block;

import cofh.lib.util.position.IRotateableTile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.minefactoryreloaded.MineFactoryReloadedCore;
import powercrystals.minefactoryreloaded.api.rednet.IRedNetOmniNode;
import powercrystals.minefactoryreloaded.api.rednet.connectivity.RedNetConnectionType;
import powercrystals.minefactoryreloaded.block.BlockFactory;
import powercrystals.minefactoryreloaded.setup.MFRThings;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityBase;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactory;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryInventory;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityLaserDrill;

public class BlockFactoryMachine
extends BlockFactory
implements IRedNetOmniNode {
    private int _mfrMachineBlockIndex;
    private static int[] itemRotation = new int[]{0, 1, 3, 2, 5, 4};

    public BlockFactoryMachine(int n) {
        super(0.5f);
        this.func_149663_c("mfr.machine." + n);
        this._mfrMachineBlockIndex = n;
        this.providesPower = true;
    }

    public int getBlockIndex() {
        return this._mfrMachineBlockIndex;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iIconRegister) {
        Machine.LoadTextures(this._mfrMachineBlockIndex, iIconRegister);
    }

    public IIcon func_149673_e(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4) {
        int n5 = iBlockAccess.func_72805_g(n, n2, n3);
        boolean bl = false;
        TileEntity tileEntity = iBlockAccess.func_147438_o(n, n2, n3);
        if (tileEntity instanceof TileEntityFactory) {
            n4 = ((TileEntityFactory)tileEntity).getRotatedSide(n4);
            bl = ((TileEntityFactory)tileEntity).isActive();
        }
        return Machine.getMachineFromIndex(this._mfrMachineBlockIndex, n5).getIcon(n4, bl);
    }

    public IIcon func_149691_a(int n, int n2) {
        n = itemRotation[n];
        return Machine.getMachineFromIndex(this._mfrMachineBlockIndex, n2).getIcon(n, false);
    }

    public int getLightOpacity(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        if (iBlockAccess.func_147438_o(n, n2, n3) instanceof TileEntityLaserDrill) {
            return 0;
        }
        return super.getLightOpacity(iBlockAccess, n, n2, n3);
    }

    @Override
    public void onNeighborChange(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4, int n5, int n6) {
        TileEntity tileEntity = iBlockAccess.func_147438_o(n, n2, n3);
        if (tileEntity instanceof TileEntityFactory) {
            ((TileEntityFactory)tileEntity).onNeighborTileChange(n4, n5, n6);
        }
    }

    private void dropContents(TileEntity tileEntity, ArrayList<ItemStack> arrayList) {
        if (tileEntity instanceof IInventory) {
            World world = tileEntity.func_145831_w();
            IInventory iInventory = (IInventory)tileEntity;
            TileEntityFactoryInventory tileEntityFactoryInventory = null;
            if (tileEntity instanceof TileEntityFactoryInventory) {
                tileEntityFactoryInventory = (TileEntityFactoryInventory)tileEntity;
            }
            int n = iInventory.func_70302_i_();
            while (n-- > 0) {
                ItemStack itemStack;
                if (tileEntityFactoryInventory != null && !tileEntityFactoryInventory.shouldDropSlotWhenBroken(n) || (itemStack = iInventory.func_70301_a(n)) == null) continue;
                iInventory.func_70299_a(n, null);
                if (arrayList != null) {
                    arrayList.add(itemStack);
                    continue;
                }
                this.dropStack(world, tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e, itemStack);
            }
        }
    }

    private void dropStack(World world, int n, int n2, int n3, ItemStack itemStack) {
        while (itemStack.field_77994_a > 0) {
            float f = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float f2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float f3 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            int n4 = Math.min(world.field_73012_v.nextInt(21) + 10, itemStack.field_77994_a);
            EntityItem entityItem = new EntityItem(world, (double)((float)n + f), (double)((float)n2 + f2), (double)((float)n3 + f3), itemStack.func_77979_a(n4));
            float f4 = 0.05f;
            entityItem.field_70159_w = (float)world.field_73012_v.nextGaussian() * f4;
            entityItem.field_70181_x = (float)world.field_73012_v.nextGaussian() * f4 + 0.2f;
            entityItem.field_70179_y = (float)world.field_73012_v.nextGaussian() * f4;
            world.func_72838_d((Entity)entityItem);
        }
    }

    public void func_149749_a(World world, int n, int n2, int n3, Block block, int n4) {
        TileEntity tileEntity = BlockFactoryMachine.getTile(world, n, n2, n3);
        if (tileEntity != null) {
            this.dropContents(tileEntity, null);
            if (tileEntity instanceof TileEntityFactoryInventory) {
                ((TileEntityFactoryInventory)tileEntity).onBlockBroken();
            }
        }
        super.func_149749_a(world, n, n2, n3, block, n4);
    }

    @Override
    public ArrayList<ItemStack> dismantleBlock(EntityPlayer entityPlayer, World world, int n, int n2, int n3, boolean bl) {
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>(1);
        ItemStack itemStack = new ItemStack(this.func_149650_a(world.func_72805_g(n, n2, n3), world.field_73012_v, 0), 1, this.func_149692_a(world.func_72805_g(n, n2, n3)));
        arrayList.add(itemStack);
        TileEntity tileEntity = BlockFactoryMachine.getTile(world, n, n2, n3);
        if (tileEntity instanceof TileEntityBase) {
            this.dropContents(tileEntity, arrayList);
            if (tileEntity instanceof TileEntityFactoryInventory) {
                ((TileEntityFactoryInventory)tileEntity).onDisassembled();
            }
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            ((TileEntityBase)tileEntity).writeItemNBT(nBTTagCompound);
            if (!nBTTagCompound.func_82582_d()) {
                itemStack.func_77982_d(nBTTagCompound);
            }
        }
        world.func_147468_f(n, n2, n3);
        if (!bl) {
            for (ItemStack itemStack2 : arrayList) {
                this.dropStack(world, n, n2, n3, itemStack2);
            }
        }
        return arrayList;
    }

    @Override
    public boolean canDismantle(EntityPlayer entityPlayer, World world, int n, int n2, int n3) {
        return BlockFactoryMachine.getTile(world, n, n2, n3) instanceof TileEntityFactory;
    }

    @Override
    public void func_149689_a(World world, int n, int n2, int n3, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        super.func_149689_a(world, n, n2, n3, entityLivingBase, itemStack);
        if (entityLivingBase == null) {
            return;
        }
        TileEntity tileEntity = BlockFactoryMachine.getTile(world, n, n2, n3);
        if (tileEntity instanceof IRotateableTile && ((IRotateableTile)tileEntity).canRotate()) {
            switch (MathHelper.func_76128_c((double)((double)(entityLivingBase.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) {
                case 0: {
                    ((IRotateableTile)tileEntity).rotateDirectlyTo(3);
                    break;
                }
                case 1: {
                    ((IRotateableTile)tileEntity).rotateDirectlyTo(4);
                    break;
                }
                case 2: {
                    ((IRotateableTile)tileEntity).rotateDirectlyTo(2);
                    break;
                }
                case 3: {
                    ((IRotateableTile)tileEntity).rotateDirectlyTo(5);
                }
            }
        }
        if (tileEntity instanceof TileEntityFactory) {
            if (entityLivingBase instanceof ICommandSender && entityLivingBase.field_70175_ag) {
                ((TileEntityFactory)tileEntity).setOwner(((ICommandSender)entityLivingBase).func_70005_c_());
            } else {
                ((TileEntityFactory)tileEntity).setOwner(null);
            }
        }
    }

    @Override
    public TileEntity func_149915_a(World world, int n) {
        return Machine.getMachineFromIndex(this._mfrMachineBlockIndex, n).getNewTileEntity();
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int n, int n2, int n3, int n4) {
        TileEntity tileEntity = BlockFactoryMachine.getTile(world, n, n2, n3);
        if (tileEntity instanceof TileEntityFactoryInventory) {
            return ((TileEntityFactoryInventory)tileEntity).getComparatorOutput(n4);
        }
        return 0;
    }

    @Override
    public boolean activated(World world, int n, int n2, int n3, EntityPlayer entityPlayer, int n4) {
        if (super.activated(world, n, n2, n3, entityPlayer, n4)) {
            return true;
        }
        TileEntity tileEntity = BlockFactoryMachine.getTile(world, n, n2, n3);
        if (tileEntity == null) {
            return false;
        }
        if (tileEntity instanceof TileEntityFactory && ((TileEntityFactory)tileEntity).getContainer(entityPlayer.field_71071_by) != null) {
            if (!world.field_72995_K) {
                entityPlayer.openGui((Object)MineFactoryReloadedCore.instance(), 0, world, n, n2, n3);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isSideSolid(IBlockAccess iBlockAccess, int n, int n2, int n3, ForgeDirection forgeDirection) {
        return true;
    }

    @Override
    public int func_149709_b(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4) {
        TileEntity tileEntity = iBlockAccess.func_147438_o(n, n2, n3);
        if (tileEntity instanceof TileEntityFactory) {
            return ((TileEntityFactory)tileEntity).getRedNetOutput(ForgeDirection.getOrientation((int)n4));
        }
        return 0;
    }

    @Override
    public int func_149748_c(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4) {
        return this.func_149709_b(iBlockAccess, n, n2, n3, n4);
    }

    @Override
    public RedNetConnectionType getConnectionType(World world, int n, int n2, int n3, ForgeDirection forgeDirection) {
        return RedNetConnectionType.DecorativeSingle;
    }

    @Override
    public int[] getOutputValues(World world, int n, int n2, int n3, ForgeDirection forgeDirection) {
        return null;
    }

    @Override
    public void onInputsChanged(World world, int n, int n2, int n3, ForgeDirection forgeDirection, int[] nArray) {
    }

    @Override
    public int getOutputValue(World world, int n, int n2, int n3, ForgeDirection forgeDirection, int n4) {
        TileEntity tileEntity = BlockFactoryMachine.getTile(world, n, n2, n3);
        if (tileEntity instanceof TileEntityFactory) {
            return ((TileEntityFactory)tileEntity).getRedNetOutput(forgeDirection);
        }
        return 0;
    }

    @Override
    public void onInputChanged(World world, int n, int n2, int n3, ForgeDirection forgeDirection, int n4) {
        TileEntity tileEntity = BlockFactoryMachine.getTile(world, n, n2, n3);
        if (tileEntity instanceof TileEntityFactory) {
            ((TileEntityFactory)tileEntity).onRedNetChanged(forgeDirection, n4);
            this.func_149695_a(world, n, n2, n3, MFRThings.rednetCableBlock);
        }
    }
}

