/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftEnergy;
import buildcraft.api.core.StackKey;
import buildcraft.api.fuels.BuildcraftFuelRegistry;
import buildcraft.api.fuels.ICoolant;
import buildcraft.api.fuels.IFuel;
import buildcraft.api.fuels.ISolidCoolant;
import buildcraft.api.statements.IActionExternal;
import buildcraft.api.statements.IOverrideDefaultStatements;
import buildcraft.api.statements.ITriggerExternal;
import buildcraft.api.transport.IItemPipe;
import buildcraft.core.lib.engines.TileEngineBase;
import buildcraft.core.lib.engines.TileEngineWithInventory;
import buildcraft.core.lib.fluids.Tank;
import buildcraft.core.lib.fluids.TankManager;
import buildcraft.core.lib.fluids.TankUtils;
import buildcraft.core.lib.inventory.InvUtils;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEngineIron
extends TileEngineWithInventory
implements IFluidHandler,
IOverrideDefaultStatements {
    public static int MAX_LIQUID = 10000;
    public static float HEAT_PER_RF = 2.3E-4f;
    public static float COOLDOWN_RATE = 0.05f;
    public static int MAX_COOLANT_PER_TICK = 40;
    public Tank tankFuel = new Tank("tankFuel", MAX_LIQUID, this);
    public Tank tankCoolant = new Tank("tankCoolant", MAX_LIQUID, this);
    private int burnTime = 0;
    private float coolingBuffer = 0.0f;
    private int tankFuelAmountCache = 0;
    private int tankCoolantAmountCache = 0;
    private TankManager<Tank> tankManager = new TankManager();
    private IFuel currentFuel;
    private int penaltyCooling = 0;
    private boolean lastPowered = false;
    private BiomeGenBase biomeCache;

    public TileEngineIron() {
        super(1);
        this.tankManager.add((Object)this.tankFuel);
        this.tankManager.add((Object)this.tankCoolant);
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, ForgeDirection side) {
        if (super.onBlockActivated(player, side)) {
            return true;
        }
        ItemStack current = player.func_71045_bC();
        if (current != null) {
            if (current.func_77973_b() instanceof IItemPipe) {
                return false;
            }
            if (!this.field_145850_b.field_72995_K ? TankUtils.handleRightClick(this, side, player, true, true) : FluidContainerRegistry.isContainer((ItemStack)current)) {
                return true;
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            player.openGui((Object)BuildCraftEnergy.instance, 20, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return true;
    }

    @Override
    public float getPistonSpeed() {
        if (!this.field_145850_b.field_72995_K) {
            return Math.max(0.07f * this.getHeatLevel(), 0.01f);
        }
        switch (this.getEnergyStage()) {
            case BLUE: {
                return 0.04f;
            }
            case GREEN: {
                return 0.05f;
            }
            case YELLOW: {
                return 0.06f;
            }
            case RED: {
                return 0.07f;
            }
        }
        return 0.0f;
    }

    public boolean hasFuelBelowThreshold(float threshold) {
        FluidStack fuel = this.tankFuel.getFluid();
        if (fuel == null) {
            return true;
        }
        float percentage = (float)fuel.amount / (float)MAX_LIQUID;
        return percentage < threshold;
    }

    public boolean hasCoolantBelowThreshold(float threshold) {
        FluidStack coolant = this.tankCoolant.getFluid();
        if (coolant == null) {
            return true;
        }
        float percentage = (float)coolant.amount / (float)MAX_LIQUID;
        return percentage < threshold;
    }

    private float getBiomeTempScalar() {
        if (this.biomeCache == null) {
            this.biomeCache = this.field_145850_b.func_72807_a(this.field_145851_c, this.field_145849_e);
        }
        float tempScalar = this.biomeCache.field_76750_F - 1.0f;
        tempScalar *= 0.5f;
        return tempScalar += 1.0f;
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.biomeCache = null;
    }

    @Override
    public boolean isBurning() {
        if (this.getEnergyStage() == TileEngineBase.EnergyStage.OVERHEAT) {
            return false;
        }
        FluidStack fuel = this.tankFuel.getFluid();
        return fuel != null && fuel.amount > 0 && this.penaltyCooling == 0 && this.isRedstonePowered;
    }

    @Override
    public void overheat() {
        super.overheat();
        this.tankCoolant.setFluid(null);
    }

    @Override
    public void burn() {
        FluidStack fuel = this.tankFuel.getFluid();
        if (this.currentFuel == null && fuel != null) {
            this.currentFuel = BuildcraftFuelRegistry.fuel.getFuel(fuel.getFluid());
        }
        if (this.currentFuel == null) {
            return;
        }
        if (this.penaltyCooling <= 0 && this.isRedstonePowered) {
            this.lastPowered = true;
            if (this.burnTime > 0 || fuel != null && fuel.amount > 0) {
                if (this.burnTime > 0) {
                    --this.burnTime;
                }
                if (this.burnTime <= 0) {
                    if (fuel != null) {
                        if (--fuel.amount <= 0) {
                            this.tankFuel.setFluid(null);
                        }
                        this.burnTime = this.currentFuel.getTotalBurningTime() / 1000;
                    } else {
                        this.currentFuel = null;
                        return;
                    }
                }
                this.currentOutput = this.currentFuel.getPowerPerCycle();
                this.addEnergy(this.currentFuel.getPowerPerCycle());
                this.heat += (float)this.currentFuel.getPowerPerCycle() * HEAT_PER_RF * this.getBiomeTempScalar();
            }
        } else if (this.penaltyCooling <= 0 && this.lastPowered) {
            this.lastPowered = false;
            this.penaltyCooling = 10;
        }
    }

    @Override
    public void updateHeat() {
        if (this.energyStage == TileEngineBase.EnergyStage.OVERHEAT && this.heat > 20.0f) {
            this.heat -= COOLDOWN_RATE;
        }
    }

    @Override
    public void engineUpdate() {
        super.engineUpdate();
        ItemStack stack = this.func_70301_a(0);
        if (stack != null) {
            FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
            if (liquid == null && this.heat > 40.0f) {
                ItemStack stackOne = stack.func_77946_l();
                stackOne.field_77994_a = 1;
                ISolidCoolant coolant = BuildcraftFuelRegistry.coolant.getSolidCoolant(StackKey.stack(stackOne));
                if (coolant != null) {
                    liquid = coolant.getFluidFromSolidCoolant(stackOne);
                }
            }
            if (liquid != null && this.fill(ForgeDirection.UNKNOWN, liquid, false) == liquid.amount) {
                this.fill(ForgeDirection.UNKNOWN, liquid, true);
                this.func_70299_a(0, InvUtils.consumeItem(stack));
            }
        }
        if (this.heat > 20.0f && (this.penaltyCooling > 0 || !this.isRedstonePowered)) {
            this.heat -= COOLDOWN_RATE;
            this.coolEngine(20.0f);
            this.getEnergyStage();
        } else if (this.heat > 100.0f) {
            this.coolEngine(100.0f);
        }
        if (this.heat <= 20.0f && this.penaltyCooling > 0) {
            --this.penaltyCooling;
        }
        if (this.heat <= 20.0f) {
            this.heat = 20.0f;
        }
    }

    private void coolEngine(float idealHeat) {
        float extraHeat = this.heat - idealHeat;
        if (this.coolingBuffer < extraHeat) {
            this.fillCoolingBuffer();
        }
        if (this.coolingBuffer >= extraHeat) {
            this.coolingBuffer -= extraHeat;
            this.heat -= extraHeat;
            return;
        }
        this.heat -= this.coolingBuffer;
        this.coolingBuffer = 0.0f;
    }

    private void fillCoolingBuffer() {
        FluidStack coolant = this.tankCoolant.getFluid();
        if (coolant == null) {
            return;
        }
        int coolantAmount = Math.min(MAX_COOLANT_PER_TICK, coolant.amount);
        ICoolant currentCoolant = BuildcraftFuelRegistry.coolant.getCoolant(coolant.getFluid());
        if (currentCoolant != null) {
            float cooling = currentCoolant.getDegreesCoolingPerMB(this.heat);
            this.coolingBuffer += (float)coolantAmount * (cooling /= this.getBiomeTempScalar());
            this.tankCoolant.drain(coolantAmount, true);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.tankManager.readFromNBT(data);
        this.burnTime = data.func_74762_e("burnTime");
        this.penaltyCooling = data.func_74762_e("penaltyCooling");
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        this.tankManager.writeToNBT(data);
        data.func_74768_a("burnTime", this.burnTime);
        data.func_74768_a("penaltyCooling", this.penaltyCooling);
    }

    @Override
    public void getGUINetworkData(int id, int value) {
        super.getGUINetworkData(id, value);
        switch (id) {
            case 15: {
                if (FluidRegistry.getFluid((int)value) != null) {
                    this.tankFuel.setFluid(new FluidStack(FluidRegistry.getFluid((int)value), this.tankFuelAmountCache));
                    break;
                }
                this.tankFuel.setFluid(null);
                break;
            }
            case 16: {
                if (FluidRegistry.getFluid((int)value) != null) {
                    this.tankCoolant.setFluid(new FluidStack(FluidRegistry.getFluid((int)value), this.tankCoolantAmountCache));
                    break;
                }
                this.tankCoolant.setFluid(null);
                break;
            }
            case 17: {
                this.tankFuelAmountCache = value;
                if (this.tankFuel.getFluid() == null) break;
                this.tankFuel.getFluid().amount = value;
                break;
            }
            case 18: {
                this.tankCoolantAmountCache = value;
                if (this.tankCoolant.getFluid() == null) break;
                this.tankCoolant.getFluid().amount = value;
                break;
            }
            case 19: {
                this.tankFuel.colorRenderCache = value;
                break;
            }
            case 20: {
                this.tankCoolant.colorRenderCache = value;
            }
        }
    }

    @Override
    public void sendGUINetworkData(Container containerEngine, ICrafting iCrafting) {
        super.sendGUINetworkData(containerEngine, iCrafting);
        iCrafting.func_71112_a(containerEngine, 15, this.tankFuel.getFluid() != null && this.tankFuel.getFluid().getFluid() != null ? this.tankFuel.getFluid().getFluid().getID() : 0);
        iCrafting.func_71112_a(containerEngine, 16, this.tankCoolant.getFluid() != null && this.tankCoolant.getFluid().getFluid() != null ? this.tankCoolant.getFluid().getFluid().getID() : 0);
        iCrafting.func_71112_a(containerEngine, 17, this.tankFuel.getFluid() != null ? this.tankFuel.getFluid().amount : 0);
        iCrafting.func_71112_a(containerEngine, 18, this.tankCoolant.getFluid() != null ? this.tankCoolant.getFluid().amount : 0);
        iCrafting.func_71112_a(containerEngine, 19, this.tankFuel.colorRenderCache);
        iCrafting.func_71112_a(containerEngine, 20, this.tankCoolant.colorRenderCache);
    }

    @Override
    public boolean isActive() {
        return this.penaltyCooling <= 0;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tankFuel.drain(maxDrain, doDrain);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null) {
            return null;
        }
        if (this.tankCoolant.getFluidType() == resource.getFluid()) {
            return this.tankCoolant.drain(resource.amount, doDrain);
        }
        if (this.tankFuel.getFluidType() == resource.getFluid()) {
            return this.tankFuel.drain(resource.amount, doDrain);
        }
        return null;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return from != this.orientation;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource == null || resource.getFluid() == null) {
            return 0;
        }
        if (BuildcraftFuelRegistry.coolant.getCoolant(resource.getFluid()) != null) {
            return this.tankCoolant.fill(resource, doFill);
        }
        if (BuildcraftFuelRegistry.fuel.getFuel(resource.getFluid()) != null) {
            int filled = this.tankFuel.fill(resource, doFill);
            if (filled > 0 && this.tankFuel.getFluid() != null && this.tankFuel.getFluid().getFluid() != null && (this.currentFuel == null || this.tankFuel.getFluid().getFluid() != this.currentFuel.getFluid())) {
                this.currentFuel = BuildcraftFuelRegistry.fuel.getFuel(this.tankFuel.getFluid().getFluid());
            }
            return filled;
        }
        return 0;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return from != this.orientation && fluid != null && (BuildcraftFuelRegistry.coolant.getCoolant(fluid) != null || BuildcraftFuelRegistry.fuel.getFuel(fluid) != null);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection direction) {
        return this.tankManager.getTankInfo(direction);
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        if (BuildcraftFuelRegistry.coolant.getSolidCoolant(StackKey.stack(itemstack)) != null) {
            return true;
        }
        FluidStack fluidStack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemstack);
        return fluidStack != null && this.canFill(ForgeDirection.UNKNOWN, fluidStack.getFluid());
    }

    public FluidStack getFuel() {
        return this.tankFuel.getFluid();
    }

    public FluidStack getCoolant() {
        return this.tankCoolant.getFluid();
    }

    @Override
    public int getMaxEnergy() {
        return 100000;
    }

    @Override
    public int getIdealOutput() {
        if (this.currentFuel == null) {
            return 0;
        }
        return this.currentFuel.getPowerPerCycle();
    }

    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public List<ITriggerExternal> overrideTriggers() {
        LinkedList<ITriggerExternal> triggers = new LinkedList<ITriggerExternal>();
        triggers.add(BuildCraftCore.triggerEmptyInventory);
        triggers.add(BuildCraftCore.triggerContainsInventory);
        triggers.add(BuildCraftCore.triggerSpaceInventory);
        triggers.add(BuildCraftCore.triggerFullInventory);
        triggers.add(BuildCraftEnergy.triggerBlueEngineHeat);
        triggers.add(BuildCraftEnergy.triggerGreenEngineHeat);
        triggers.add(BuildCraftEnergy.triggerYellowEngineHeat);
        triggers.add(BuildCraftEnergy.triggerRedEngineHeat);
        triggers.add(BuildCraftEnergy.triggerEngineOverheat);
        triggers.add(BuildCraftEnergy.triggerCoolantBelow25);
        triggers.add(BuildCraftEnergy.triggerCoolantBelow50);
        triggers.add(BuildCraftEnergy.triggerFuelBelow25);
        triggers.add(BuildCraftEnergy.triggerFuelBelow50);
        return triggers;
    }

    @Override
    public List<IActionExternal> overrideActions() {
        return null;
    }
}

