/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.block;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.ISerializable;
import buildcraft.api.tiles.IControllable;
import buildcraft.core.DefaultProps;
import buildcraft.core.lib.RFBattery;
import buildcraft.core.lib.TileBuffer;
import buildcraft.core.lib.network.PacketTileUpdate;
import buildcraft.core.lib.utils.Utils;
import cofh.api.energy.IEnergyHandler;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileBuildCraft
extends TileEntity
implements IEnergyHandler,
ISerializable {
    protected TileBuffer[] cache;
    protected HashSet<EntityPlayer> guiWatchers = new HashSet();
    protected IControllable.Mode mode;
    private boolean init = false;
    private String owner = "[BuildCraft]";
    private RFBattery battery;
    private int receivedTick;
    private int extractedTick;
    private long worldTimeEnergyReceive;

    public String getOwner() {
        return this.owner;
    }

    public void addGuiWatcher(EntityPlayer player) {
        if (!this.guiWatchers.contains(player)) {
            this.guiWatchers.add(player);
        }
    }

    public void removeGuiWatcher(EntityPlayer player) {
        if (this.guiWatchers.contains(player)) {
            this.guiWatchers.remove(player);
        }
    }

    public void func_145845_h() {
        if (!this.init && !this.func_145837_r()) {
            this.initialize();
            this.init = true;
        }
        if (this.battery != null) {
            this.receivedTick = 0;
            this.extractedTick = 0;
        }
    }

    public void initialize() {
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.cache = null;
    }

    public void func_145843_s() {
        this.init = false;
        super.func_145843_s();
        this.cache = null;
    }

    public void onBlockPlacedBy(EntityLivingBase entity, ItemStack stack) {
        if (entity instanceof EntityPlayer) {
            this.owner = ((EntityPlayer)entity).getDisplayName();
        }
    }

    public void destroy() {
        this.cache = null;
    }

    public void sendNetworkUpdate() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            BuildCraftCore.instance.sendToPlayers(this.getPacketUpdate(), this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getNetworkUpdateRange());
        }
    }

    protected int getNetworkUpdateRange() {
        return DefaultProps.NETWORK_UPDATE_RANGE;
    }

    @Override
    public void writeData(ByteBuf stream) {
    }

    @Override
    public void readData(ByteBuf stream) {
    }

    public buildcraft.core.lib.network.Packet getPacketUpdate() {
        return new PacketTileUpdate(this);
    }

    public Packet func_145844_m() {
        return Utils.toPacket(this.getPacketUpdate(), 0);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74778_a("owner", this.owner);
        if (this.battery != null) {
            NBTTagCompound batteryNBT = new NBTTagCompound();
            this.battery.writeToNBT(batteryNBT);
            nbt.func_74782_a("battery", (NBTBase)batteryNBT);
        }
        if (this.mode != null) {
            nbt.func_74774_a("lastMode", (byte)this.mode.ordinal());
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("owner")) {
            this.owner = nbt.func_74779_i("owner");
        }
        if (this.battery != null) {
            this.battery.readFromNBT(nbt.func_74775_l("battery"));
        }
        if (nbt.func_74764_b("lastMode")) {
            this.mode = IControllable.Mode.values()[nbt.func_74771_c("lastMode")];
        }
    }

    protected int getTicksSinceEnergyReceived() {
        return (int)(this.field_145850_b.func_82737_E() - this.worldTimeEnergyReceive);
    }

    public int hashCode() {
        return (this.field_145851_c * 37 + this.field_145848_d) * 37 + this.field_145849_e;
    }

    public boolean equals(Object cmp) {
        return this == cmp;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return this.battery != null;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (this.battery != null && this.canConnectEnergy(from)) {
            int received = this.battery.receiveEnergy(maxReceive - this.receivedTick, simulate);
            if (!simulate) {
                this.receivedTick += received;
                this.worldTimeEnergyReceive = this.field_145850_b.func_82737_E();
            }
            return received;
        }
        return 0;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        if (this.battery != null && this.canConnectEnergy(from)) {
            int extracted = this.battery.extractEnergy(maxExtract - this.extractedTick, simulate);
            if (!simulate) {
                this.extractedTick += extracted;
            }
            return extracted;
        }
        return 0;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        if (this.battery != null && this.canConnectEnergy(from)) {
            return this.battery.getEnergyStored();
        }
        return 0;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        if (this.battery != null && this.canConnectEnergy(from)) {
            return this.battery.getMaxEnergyStored();
        }
        return 0;
    }

    public RFBattery getBattery() {
        return this.battery;
    }

    protected void setBattery(RFBattery battery) {
        this.battery = battery;
    }

    public Block getBlock(ForgeDirection side) {
        if (this.cache == null) {
            this.cache = TileBuffer.makeBuffer(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, false);
        }
        return this.cache[side.ordinal()].getBlock();
    }

    public TileEntity getTile(ForgeDirection side) {
        if (this.cache == null) {
            this.cache = TileBuffer.makeBuffer(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, false);
        }
        return this.cache[side.ordinal()].getTile();
    }

    public IControllable.Mode getControlMode() {
        return this.mode;
    }

    public void setControlMode(IControllable.Mode mode) {
        this.mode = mode;
    }
}

