/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.builders.patterns;

import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementMouseClick;
import buildcraft.core.lib.utils.StringUtils;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public class PatternParameterHollow
implements IStatementParameter {
    private static IIcon iconHollow;
    private static IIcon iconFilled;
    public boolean filled = false;

    public PatternParameterHollow() {
    }

    public PatternParameterHollow(boolean hollow) {
        this();
        this.filled = !hollow;
    }

    @Override
    public String getUniqueTag() {
        return "buildcraft:fillerParameterHollow";
    }

    @Override
    public IIcon getIcon() {
        return this.filled ? iconFilled : iconHollow;
    }

    @Override
    public ItemStack getItemStack() {
        return null;
    }

    @Override
    public void registerIcons(IIconRegister iconRegister) {
        iconFilled = iconRegister.func_94245_a("buildcraftcore:fillerParameters/filled");
        iconHollow = iconRegister.func_94245_a("buildcraftcore:fillerParameters/hollow");
    }

    @Override
    public String getDescription() {
        return StringUtils.localize("fillerpattern.parameter." + (this.filled ? "filled" : "hollow"));
    }

    @Override
    public void onClick(IStatementContainer source, IStatement stmt, ItemStack stack, StatementMouseClick mouse) {
        this.filled = !this.filled;
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        this.filled = compound.func_74767_n("filled");
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74757_a("filled", this.filled);
    }

    @Override
    public IStatementParameter rotateLeft() {
        return this;
    }
}

