/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc.client;

import com.google.common.base.Strings;
import com.google.common.io.Files;
import cpw.mods.fml.common.FMLCommonHandler;
import li.cil.oc.OpenComputers$;
import li.cil.oc.api.detail.ManualAPI;
import li.cil.oc.api.manual.ContentProvider;
import li.cil.oc.api.manual.ImageProvider;
import li.cil.oc.api.manual.ImageRenderer;
import li.cil.oc.api.manual.PathProvider;
import li.cil.oc.api.manual.TabIconRenderer;
import li.cil.oc.client.Manual;
import li.cil.oc.client.Manual$History$;
import li.cil.oc.client.gui.Manual;
import li.cil.oc.common.GuiType$;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.convert.WrapAsJava$;
import scala.collection.convert.WrapAsScala$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Stack;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.NonLocalReturnControl;

public final class Manual$
implements ManualAPI {
    public static final Manual$ MODULE$;
    private final String LanguageKey;
    private final String FallbackLanguage;
    private final Buffer<Manual.Tab> tabs;
    private final Buffer<PathProvider> pathProviders;
    private final Buffer<ContentProvider> contentProviders;
    private final Buffer<Tuple2<String, ImageProvider>> imageProviders;
    private final Stack<Manual.History> history;

    static {
        new Manual$();
    }

    public final String LanguageKey() {
        return "%LANGUAGE%";
    }

    public final String FallbackLanguage() {
        return "en_US";
    }

    public Buffer<Manual.Tab> tabs() {
        return this.tabs;
    }

    public Buffer<PathProvider> pathProviders() {
        return this.pathProviders;
    }

    public Buffer<ContentProvider> contentProviders() {
        return this.contentProviders;
    }

    public Buffer<Tuple2<String, ImageProvider>> imageProviders() {
        return this.imageProviders;
    }

    public Stack<Manual.History> history() {
        return this.history;
    }

    @Override
    public void addTab(TabIconRenderer renderer, String tooltip, String path) {
        this.tabs().$plus$eq((Object)new Manual.Tab(renderer, (Option<String>)Option$.MODULE$.apply((Object)tooltip), path));
        if (this.tabs().length() > 7) {
            OpenComputers$.MODULE$.log().warn("Gosh I'm popular! Too many tabs were added to the OpenComputers in-game manual, so some won't be shown. In case this actually happens, let me know and I'll look into making them scrollable or something...");
        }
    }

    @Override
    public void addProvider(PathProvider provider) {
        this.pathProviders().$plus$eq((Object)provider);
    }

    @Override
    public void addProvider(ContentProvider provider) {
        this.contentProviders().$plus$eq((Object)provider);
    }

    @Override
    public void addProvider(String prefix, ImageProvider provider) {
        this.imageProviders().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)(Strings.isNullOrEmpty((String)prefix) ? "" : new StringBuilder().append((Object)prefix).append((Object)":").toString())), (Object)provider));
    }

    @Override
    public String pathFor(ItemStack stack) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            String string;
            Object object = new Object();
            try {
                this.pathProviders().foreach((Function1)new Serializable(stack, object){
                    private final ItemStack stack$1;
                    private final Object nonLocalReturnKey1$1;

                    public final void apply(PathProvider provider) {
                        String path;
                        String string;
                        try {
                            string = provider.pathFor(this.stack$1);
                        }
                        catch (Throwable throwable) {
                            OpenComputers$.MODULE$.log().warn("A path provider threw an error when queried with an item.", throwable);
                            string = path = null;
                        }
                        if (path == null) {
                            return;
                        }
                        throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)path);
                    }
                    {
                        this.stack$1 = stack$1;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                string = null;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                string = (String)nonLocalReturnControl2.value();
            }
            return string;
        }
        throw nonLocalReturnControl2;
    }

    @Override
    public String pathFor(World world, int x, int y, int z) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            String string;
            Object object = new Object();
            try {
                this.pathProviders().foreach((Function1)new Serializable(world, x, y, z, object){
                    private final World world$1;
                    private final int x$2;
                    private final int y$1;
                    private final int z$1;
                    private final Object nonLocalReturnKey2$1;

                    public final void apply(PathProvider provider) {
                        String path;
                        String string;
                        try {
                            string = provider.pathFor(this.world$1, this.x$2, this.y$1, this.z$1);
                        }
                        catch (Throwable throwable) {
                            OpenComputers$.MODULE$.log().warn("A path provider threw an error when queried with a block.", throwable);
                            string = path = null;
                        }
                        if (path == null) {
                            return;
                        }
                        throw new NonLocalReturnControl(this.nonLocalReturnKey2$1, (Object)path);
                    }
                    {
                        this.world$1 = world$1;
                        this.x$2 = x$2;
                        this.y$1 = y$1;
                        this.z$1 = z$1;
                        this.nonLocalReturnKey2$1 = nonLocalReturnKey2$1;
                    }
                });
                string = null;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                string = (String)nonLocalReturnControl2.value();
            }
            return string;
        }
        throw nonLocalReturnControl2;
    }

    @Override
    public java.lang.Iterable<String> contentFor(String path) {
        String cleanPath = Files.simplifyPath((String)path);
        String language = FMLCommonHandler.instance().getCurrentLanguage();
        return (java.lang.Iterable)this.li$cil$oc$client$Manual$$contentForWithRedirects(cleanPath.replaceAll("%LANGUAGE%", language), this.li$cil$oc$client$Manual$$contentForWithRedirects$default$2()).orElse((Function0)new Serializable(cleanPath){
            private final String cleanPath$1;

            public final Option<java.lang.Iterable<String>> apply() {
                return Manual$.MODULE$.li$cil$oc$client$Manual$$contentForWithRedirects(this.cleanPath$1.replaceAll("%LANGUAGE%", "en_US"), Manual$.MODULE$.li$cil$oc$client$Manual$$contentForWithRedirects$default$2());
            }
            {
                this.cleanPath$1 = cleanPath$1;
            }
        }).orNull(Predef$.MODULE$.$conforms());
    }

    @Override
    public ImageRenderer imageFor(String href) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            ImageRenderer imageRenderer;
            Object object = new Object();
            try {
                ((TraversableLike)this.imageProviders().reverse()).withFilter((Function1)new Serializable(){

                    public final boolean apply(Tuple2<String, ImageProvider> check$ifrefutable$1) {
                        Tuple2<String, ImageProvider> tuple2 = check$ifrefutable$1;
                        boolean bl = tuple2 != null;
                        return bl;
                    }
                }).foreach((Function1)new Serializable(href, object){
                    private final String href$1;
                    private final Object nonLocalReturnKey3$1;

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public final void apply(Tuple2<String, ImageProvider> x$1) {
                        BoxedUnit boxedUnit;
                        Tuple2<String, ImageProvider> tuple2 = x$1;
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        String prefix = (String)tuple2._1();
                        ImageProvider provider = (ImageProvider)tuple2._2();
                        if (!this.href$1.startsWith(prefix)) {
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            ImageRenderer imageRenderer;
                            try {
                                imageRenderer = provider.getImage(new StringOps(Predef$.MODULE$.augmentString(this.href$1)).stripPrefix(prefix));
                            }
                            catch (Throwable throwable) {
                                OpenComputers$.MODULE$.log().warn("An image provider threw an error when queried.", throwable);
                                imageRenderer = null;
                            }
                            ImageRenderer image = imageRenderer;
                            if (image != null) {
                                throw new NonLocalReturnControl(this.nonLocalReturnKey3$1, (Object)image);
                            }
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                    }
                    {
                        this.href$1 = href$1;
                        this.nonLocalReturnKey3$1 = nonLocalReturnKey3$1;
                    }
                });
                imageRenderer = null;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                imageRenderer = (ImageRenderer)nonLocalReturnControl2.value();
            }
            return imageRenderer;
        }
        throw nonLocalReturnControl2;
    }

    @Override
    public void openFor(EntityPlayer player) {
        if (player.func_130014_f_().field_72995_K) {
            player.openGui((Object)OpenComputers$.MODULE$, GuiType$.MODULE$.Manual().id(), player.func_130014_f_(), 0, 0, 0);
        }
    }

    @Override
    public void reset() {
        this.history().clear();
        this.history().push((Object)new Manual.History(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/index.md"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"%LANGUAGE%"})), Manual$History$.MODULE$.$lessinit$greater$default$2()));
    }

    @Override
    public void navigate(String path) {
        GuiScreen guiScreen = Minecraft.func_71410_x().field_71462_r;
        if (guiScreen instanceof Manual) {
            Manual manual = (Manual)guiScreen;
            manual.pushPage(path);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.history().push((Object)new Manual.History(path, Manual$History$.MODULE$.$lessinit$greater$default$2()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public String makeRelative(String path, String base) {
        int splitAt;
        return path.startsWith("/") ? path : ((splitAt = base.lastIndexOf(47)) >= 0 ? new StringBuilder().append((Object)((String)new StringOps(Predef$.MODULE$.augmentString(base)).splitAt(splitAt)._1())).append((Object)"/").append((Object)path).toString() : path);
    }

    public Option<java.lang.Iterable<String>> li$cil$oc$client$Manual$$contentForWithRedirects(String path, List<String> seen) {
        None$ none$;
        block3: {
            block2: {
                java.lang.Iterable content;
                while (true) {
                    Some some;
                    String line;
                    if (seen.contains((Object)path)) {
                        return new Some((Object)WrapAsJava$.MODULE$.asJavaIterable((Iterable)((TraversableLike)((TraversableLike)package$.MODULE$.Iterable().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Redirection loop: "}))).$plus$plus(seen, Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)package$.MODULE$.Iterable().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{path})), Iterable$.MODULE$.canBuildFrom())));
                    }
                    Option<java.lang.Iterable<String>> option = this.doContentLookup(path);
                    if (!(option instanceof Some)) break block2;
                    Some some2 = (Some)option;
                    content = (java.lang.Iterable)some2.x();
                    Option option2 = WrapAsScala$.MODULE$.iterableAsScalaIterable(content).headOption();
                    if (!(option2 instanceof Some) || !(line = (String)(some = (Some)option2).x()).toLowerCase().startsWith("#redirect ")) break;
                    seen = (List)seen.$colon$plus((Object)path, List$.MODULE$.canBuildFrom());
                    path = this.makeRelative(line.substring("#redirect ".length()), path);
                }
                Some some = new Some((Object)content);
                none$ = some;
                break block3;
            }
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public List<String> li$cil$oc$client$Manual$$contentForWithRedirects$default$2() {
        return List$.MODULE$.empty();
    }

    private Option<java.lang.Iterable<String>> doContentLookup(String path) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            None$ none$;
            Object object = new Object();
            try {
                this.contentProviders().foreach((Function1)new Serializable(path, object){
                    private final String path$1;
                    private final Object nonLocalReturnKey4$1;

                    public final void apply(ContentProvider provider) {
                        java.lang.Iterable<String> lines;
                        java.lang.Iterable<String> iterable;
                        try {
                            iterable = provider.getContent(this.path$1);
                        }
                        catch (Throwable throwable) {
                            OpenComputers$.MODULE$.log().warn("A content provider threw an error when queried.", throwable);
                            iterable = lines = null;
                        }
                        if (lines == null) {
                            return;
                        }
                        throw new NonLocalReturnControl(this.nonLocalReturnKey4$1, (Object)new Some(lines));
                    }
                    {
                        this.path$1 = path$1;
                        this.nonLocalReturnKey4$1 = nonLocalReturnKey4$1;
                    }
                });
                none$ = None$.MODULE$;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                none$ = (Option)nonLocalReturnControl2.value();
            }
            return none$;
        }
        throw nonLocalReturnControl2;
    }

    private Manual$() {
        MODULE$ = this;
        this.tabs = (Buffer)Buffer$.MODULE$.empty();
        this.pathProviders = (Buffer)Buffer$.MODULE$.empty();
        this.contentProviders = (Buffer)Buffer$.MODULE$.empty();
        this.imageProviders = (Buffer)Buffer$.MODULE$.empty();
        this.history = new Stack();
        this.reset();
    }
}

