/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.reporting;

import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.data.IAEItemStack;
import appeng.client.texture.CableBusTextures;
import appeng.core.sync.GuiBridge;
import appeng.parts.reporting.PartTerminal;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.InvOperation;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class PartPatternTerminal
extends PartTerminal {
    private final AppEngInternalInventory crafting = new AppEngInternalInventory(this, 9);
    private final AppEngInternalInventory output = new AppEngInternalInventory(this, 3);
    private final AppEngInternalInventory pattern = new AppEngInternalInventory(this, 2);
    private boolean craftingMode = true;

    public PartPatternTerminal(ItemStack is) {
        super(is);
        this.frontBright = CableBusTextures.PartPatternTerm_Bright;
        this.frontColored = CableBusTextures.PartPatternTerm_Colored;
        this.frontDark = CableBusTextures.PartPatternTerm_Dark;
    }

    @Override
    public void getDrops(List<ItemStack> drops, boolean wrenched) {
        for (ItemStack is : this.pattern) {
            if (is == null) continue;
            drops.add(is);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.setCraftingRecipe(data.func_74767_n("craftingMode"));
        this.pattern.readFromNBT(data, "pattern");
        this.output.readFromNBT(data, "outputList");
        this.crafting.readFromNBT(data, "craftingGrid");
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a("craftingMode", this.craftingMode);
        this.pattern.writeToNBT(data, "pattern");
        this.output.writeToNBT(data, "outputList");
        this.crafting.writeToNBT(data, "craftingGrid");
    }

    @Override
    public GuiBridge getGui(EntityPlayer p) {
        int x = (int)p.field_70165_t;
        int y = (int)p.field_70163_u;
        int z = (int)p.field_70161_v;
        if (this.getHost().getTile() != null) {
            x = this.tile.field_145851_c;
            y = this.tile.field_145848_d;
            z = this.tile.field_145849_e;
        }
        if (GuiBridge.GUI_PATTERN_TERMINAL.hasPermissions(this.getHost().getTile(), x, y, z, this.side, p)) {
            return GuiBridge.GUI_PATTERN_TERMINAL;
        }
        return GuiBridge.GUI_ME;
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        if (inv == this.pattern && slot == 1) {
            ICraftingPatternItem pattern;
            ICraftingPatternDetails details;
            ItemStack is = this.pattern.func_70301_a(1);
            if (is != null && is.func_77973_b() instanceof ICraftingPatternItem && (details = (pattern = (ICraftingPatternItem)is.func_77973_b()).getPatternForItem(is, this.getHost().getTile().func_145831_w())) != null) {
                IAEItemStack item;
                int x;
                this.setCraftingRecipe(details.isCraftable());
                for (x = 0; x < this.crafting.func_70302_i_() && x < details.getInputs().length; ++x) {
                    item = details.getInputs()[x];
                    this.crafting.func_70299_a(x, item == null ? null : item.getItemStack());
                }
                for (x = 0; x < this.output.func_70302_i_() && x < details.getOutputs().length; ++x) {
                    item = details.getOutputs()[x];
                    this.output.func_70299_a(x, item == null ? null : item.getItemStack());
                }
            }
        } else if (inv == this.crafting) {
            this.fixCraftingRecipes();
        }
        this.host.markForSave();
    }

    private void fixCraftingRecipes() {
        if (this.craftingMode) {
            for (int x = 0; x < this.crafting.func_70302_i_(); ++x) {
                ItemStack is = this.crafting.func_70301_a(x);
                if (is == null) continue;
                is.field_77994_a = 1;
            }
        }
    }

    public boolean isCraftingRecipe() {
        return this.craftingMode;
    }

    public void setCraftingRecipe(boolean craftingMode) {
        this.craftingMode = craftingMode;
        this.fixCraftingRecipes();
    }

    @Override
    public IInventory getInventoryByName(String name) {
        if (name.equals("crafting")) {
            return this.crafting;
        }
        if (name.equals("output")) {
            return this.output;
        }
        if (name.equals("pattern")) {
            return this.pattern;
        }
        return super.getInventoryByName(name);
    }
}

