/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync;

import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.features.AEFeature;
import appeng.core.sync.AppEngPacketHandlerBase;
import appeng.core.sync.network.INetworkInfo;
import appeng.core.sync.network.NetworkHandler;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;

public abstract class AppEngPacket {
    AppEngPacketHandlerBase.PacketTypes id;
    private ByteBuf p;

    public void serverPacketData(INetworkInfo manager, AppEngPacket packet, EntityPlayer player) {
        throw new UnsupportedOperationException("This packet ( " + this.getPacketID() + " does not implement a server side handler.");
    }

    public final int getPacketID() {
        return AppEngPacketHandlerBase.PacketTypes.getID(this.getClass()).ordinal();
    }

    public void clientPacketData(INetworkInfo network, AppEngPacket packet, EntityPlayer player) {
        throw new UnsupportedOperationException("This packet ( " + this.getPacketID() + " does not implement a client side handler.");
    }

    protected void configureWrite(ByteBuf data) {
        data.capacity(data.readableBytes());
        this.p = data;
    }

    public FMLProxyPacket getProxy() {
        if (this.p.array().length > 0x200000) {
            throw new IllegalArgumentException("Sorry AE2 made a " + this.p.array().length + " byte packet by accident!");
        }
        FMLProxyPacket pp = new FMLProxyPacket(this.p, NetworkHandler.instance.getChannel());
        if (AEConfig.instance.isFeatureEnabled(AEFeature.PacketLogging)) {
            AELog.info(this.getClass().getName() + " : " + pp.payload().readableBytes(), new Object[0]);
        }
        return pp;
    }
}

