/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.item;

import ckathode.weaponmod.PlayerWeaponData;
import ckathode.weaponmod.entity.projectile.EntityFlail;
import ckathode.weaponmod.item.WMItem;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemFlail
extends WMItem {
    public IIcon iconIndexThrown;
    private float flailDamage;

    public ItemFlail(String id, Item.ToolMaterial toolmaterial) {
        super(id);
        this.func_77656_e(toolmaterial.func_77997_a());
        this.flailDamage = 4.0f + toolmaterial.func_78000_c() * 1.0f;
    }

    public int func_77619_b() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77629_n_() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public void func_77663_a(ItemStack itemstack, World world, Entity entity, int i, boolean flag) {
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (!PlayerWeaponData.isFlailThrown(player)) {
            return;
        }
        ItemStack itemstack2 = player.func_71045_bC();
        if (itemstack2 == null || itemstack2.func_77973_b() != this) {
            this.setThrown(player, false);
        } else {
            Entity entity1;
            int id = PlayerWeaponData.getFlailEntityId(player);
            if (id != 0 && (entity1 = world.func_73045_a(id)) instanceof EntityFlail) {
                ((EntityFlail)entity1).field_70250_c = player;
                ((EntityFlail)entity1).setThrownItemStack(itemstack);
            }
        }
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        this.removePreviousFlail(world, entityplayer);
        if (itemstack.field_77994_a > 0) {
            entityplayer.func_71038_i();
            itemstack.func_77972_a(1, (EntityLivingBase)entityplayer);
            this.throwFlail(itemstack, world, entityplayer);
        }
        return itemstack;
    }

    public boolean onLeftClickEntity(ItemStack itemstack, EntityPlayer entityplayer, Entity entity) {
        this.func_77659_a(itemstack, entityplayer.field_70170_p, entityplayer);
        return false;
    }

    public void throwFlail(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        world.func_72956_a((Entity)entityplayer, "random.bow", 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
        if (!world.field_72995_K) {
            EntityFlail entity = new EntityFlail(world, (EntityLivingBase)entityplayer, itemstack);
            PlayerWeaponData.setFlailEntityId(entityplayer, entity.func_145782_y());
            world.func_72838_d((Entity)entity);
        }
        this.setThrown(entityplayer, true);
    }

    public void setThrown(EntityPlayer entityplayer, boolean flag) {
        PlayerWeaponData.setFlailThrown(entityplayer, flag);
    }

    private void removePreviousFlail(World world, EntityPlayer entityplayer) {
        Entity entity;
        int id = PlayerWeaponData.getFlailEntityId(entityplayer);
        if (id != 0 && (entity = world.func_73045_a(id)) instanceof EntityFlail) {
            entity.func_70106_y();
        }
    }

    public boolean getThrown(EntityPlayer entityplayer) {
        return PlayerWeaponData.isFlailThrown(entityplayer);
    }

    public float getFlailDamage() {
        return this.flailDamage;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        if (PlayerWeaponData.isFlailThrown(player)) {
            return this.iconIndexThrown;
        }
        return super.getIcon(stack, renderPass, player, usingItem, useRemaining);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconregister) {
        super.func_94581_a(iconregister);
        this.iconIndexThrown = iconregister.func_94245_a("weaponmod:flail-thrown");
    }
}

