/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.entity.projectile;

import ckathode.weaponmod.BalkonsWeaponMod;
import cpw.mods.fml.common.registry.IThrowableEntity;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S2BPacketChangeGameState;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class EntityProjectile
extends EntityArrow
implements IThrowableEntity {
    public static final int NO_PICKUP = 0;
    public static final int PICKUP_ALL = 1;
    public static final int PICKUP_CREATIVE = 2;
    public static final int PICKUP_OWNER = 3;
    protected int xTile = -1;
    protected int yTile = -1;
    protected int zTile = -1;
    protected Block inTile = null;
    protected int field_70253_h = 0;
    protected boolean field_70254_i = false;
    public int pickupMode;
    protected int field_70252_j;
    protected int field_70257_an;
    public boolean beenInGround;
    public float extraDamage;
    public int knockBack;

    public EntityProjectile(World world) {
        super(world);
        this.field_70249_b = 0;
        this.field_70257_an = 0;
        this.field_70129_M = 0.0f;
        this.pickupMode = 0;
        this.extraDamage = 0.0f;
        this.knockBack = 0;
        this.func_70105_a(0.5f, 0.5f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public Entity getThrower() {
        return this.field_70250_c;
    }

    public void setThrower(Entity entity) {
        this.field_70250_c = entity;
    }

    protected void setPickupModeFromEntity(EntityLivingBase entityliving) {
        if (entityliving instanceof EntityPlayer) {
            if (((EntityPlayer)entityliving).field_71075_bZ.field_75098_d) {
                this.setPickupMode(2);
            } else {
                this.setPickupMode(BalkonsWeaponMod.instance.modConfig.allCanPickup ? 1 : 3);
            }
        } else {
            this.setPickupMode(0);
        }
    }

    public void func_70186_c(double x, double y, double z, float speed, float deviation) {
        float f2 = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f2;
        y /= (double)f2;
        z /= (double)f2;
        x += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)deviation;
        y += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)deviation;
        z += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)deviation;
        this.field_70159_w = x *= (double)speed;
        this.field_70181_x = y *= (double)speed;
        this.field_70179_y = z *= (double)speed;
        float f3 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(x, z) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(y, f3) * 180.0 / Math.PI);
        this.field_70252_j = 0;
    }

    public void func_70016_h(double d, double d1, double d2) {
        this.field_70159_w = d;
        this.field_70181_x = d1;
        this.field_70179_y = d2;
        if (this.aimRotation() && this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(d * d + d2 * d2));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(d, d2) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(d1, f) * 180.0 / Math.PI);
            this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            this.field_70252_j = 0;
        }
    }

    public void func_70071_h_() {
        this.func_70030_z();
    }

    public void func_70030_z() {
        Block i;
        super.func_70030_z();
        if (this.aimRotation()) {
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f) * 180.0 / Math.PI);
        }
        if ((i = this.field_70170_p.func_147439_a(this.xTile, this.yTile, this.zTile)) != null) {
            i.func_149719_a((IBlockAccess)this.field_70170_p, this.xTile, this.yTile, this.zTile);
            AxisAlignedBB axisalignedbb = i.func_149668_a(this.field_70170_p, this.xTile, this.yTile, this.zTile);
            if (axisalignedbb != null && axisalignedbb.func_72318_a(Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v))) {
                this.field_70254_i = true;
            }
        }
        if (this.field_70249_b > 0) {
            --this.field_70249_b;
        }
        if (this.field_70254_i) {
            Block j = this.field_70170_p.func_147439_a(this.xTile, this.yTile, this.zTile);
            int k = this.field_70170_p.func_72805_g(this.xTile, this.yTile, this.zTile);
            if (j == this.inTile && k == this.field_70253_h) {
                ++this.field_70252_j;
                int t = this.getMaxLifetime();
                if (t != 0 && this.field_70252_j >= t) {
                    this.func_70106_y();
                }
            } else {
                this.field_70254_i = false;
                this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70252_j = 0;
                this.field_70257_an = 0;
            }
            return;
        }
        ++this.field_70257_an;
        Vec3 vec3d = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
        Vec3 vec3d1 = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
        MovingObjectPosition movingobjectposition = this.field_70170_p.func_147447_a(vec3d, vec3d1, false, true, false);
        vec3d = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
        vec3d1 = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
        if (movingobjectposition != null) {
            vec3d1 = Vec3.func_72443_a((double)movingobjectposition.field_72307_f.field_72450_a, (double)movingobjectposition.field_72307_f.field_72448_b, (double)movingobjectposition.field_72307_f.field_72449_c);
        }
        Entity entity = null;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
        double d = 0.0;
        for (int l = 0; l < list.size(); ++l) {
            double d1;
            float f4;
            AxisAlignedBB axisalignedbb1;
            MovingObjectPosition movingobjectposition1;
            Entity entity1 = (Entity)list.get(l);
            if (!entity1.func_70067_L() || entity1 == this.field_70250_c && this.field_70257_an < 5 || (movingobjectposition1 = (axisalignedbb1 = entity1.field_70121_D.func_72314_b((double)(f4 = 0.3f), (double)f4, (double)f4)).func_72327_a(vec3d, vec3d1)) == null || !((d1 = vec3d.func_72438_d(movingobjectposition1.field_72307_f)) < d) && d != 0.0) continue;
            entity = entity1;
            d = d1;
        }
        if (entity != null) {
            movingobjectposition = new MovingObjectPosition(entity);
        }
        if (movingobjectposition != null) {
            if (movingobjectposition.field_72308_g != null) {
                this.onEntityHit(movingobjectposition.field_72308_g);
            } else {
                this.onGroundHit(movingobjectposition);
            }
        }
        if (this.func_70241_g()) {
            for (int i1 = 0; i1 < 2; ++i1) {
                this.field_70170_p.func_72869_a("crit", this.field_70165_t + this.field_70159_w * (double)i1 / 4.0, this.field_70163_u + this.field_70181_x * (double)i1 / 4.0, this.field_70161_v + this.field_70179_y * (double)i1 / 4.0, -this.field_70159_w, -this.field_70181_x + 0.2, -this.field_70179_y);
            }
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        if (this.aimRotation()) {
            float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
            this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f2) * 180.0 / Math.PI);
            while (this.field_70125_A - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
            this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        }
        float res = this.getAirResistance();
        float grav = this.getGravity();
        if (this.func_70090_H()) {
            this.beenInGround = true;
            for (int i1 = 0; i1 < 4; ++i1) {
                float f6 = 0.25f;
                this.field_70170_p.func_72869_a("bubble", this.field_70165_t - this.field_70159_w * (double)f6, this.field_70163_u - this.field_70181_x * (double)f6, this.field_70161_v - this.field_70179_y * (double)f6, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            }
            res *= 0.8080808f;
        }
        this.field_70159_w *= (double)res;
        this.field_70181_x *= (double)res;
        this.field_70179_y *= (double)res;
        this.field_70181_x -= (double)grav;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_145775_I();
    }

    public void onEntityHit(Entity entity) {
        this.bounceBack();
        this.applyEntityHitEffects(entity);
    }

    public void applyEntityHitEffects(Entity entity) {
        if (this.func_70027_ad() && !(entity instanceof EntityEnderman)) {
            entity.func_70015_d(5);
        }
        if (entity instanceof EntityLivingBase) {
            float f;
            EntityLivingBase entityliving = (EntityLivingBase)entity;
            if (this.knockBack > 0 && (f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y))) > 0.0f) {
                entity.func_70024_g(this.field_70159_w * (double)this.knockBack * 0.6 / (double)f, 0.1, this.field_70179_y * (double)this.knockBack * 0.6 / (double)f);
            }
            if (this.field_70250_c instanceof EntityLivingBase) {
                EnchantmentHelper.func_151384_a((EntityLivingBase)entityliving, (Entity)this.field_70250_c);
                EnchantmentHelper.func_151385_b((EntityLivingBase)((EntityLivingBase)this.field_70250_c), (Entity)entityliving);
            }
            if (this.field_70250_c instanceof EntityPlayerMP && this.field_70250_c != entity && entity instanceof EntityPlayer) {
                ((EntityPlayerMP)this.field_70250_c).field_71135_a.func_147359_a((Packet)new S2BPacketChangeGameState(6, 0.0f));
            }
        }
    }

    public void onGroundHit(MovingObjectPosition mop) {
        this.xTile = mop.field_72311_b;
        this.yTile = mop.field_72312_c;
        this.zTile = mop.field_72309_d;
        this.inTile = this.field_70170_p.func_147439_a(this.xTile, this.yTile, this.zTile);
        this.field_70253_h = this.field_70170_p.func_72805_g(this.xTile, this.yTile, this.zTile);
        this.field_70159_w = mop.field_72307_f.field_72450_a - this.field_70165_t;
        this.field_70181_x = mop.field_72307_f.field_72448_b - this.field_70163_u;
        this.field_70179_y = mop.field_72307_f.field_72449_c - this.field_70161_v;
        float f1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
        this.field_70165_t -= this.field_70159_w / (double)f1 * 0.05;
        this.field_70163_u -= this.field_70181_x / (double)f1 * 0.05;
        this.field_70161_v -= this.field_70179_y / (double)f1 * 0.05;
        this.field_70254_i = true;
        this.beenInGround = true;
        this.func_70243_d(false);
        this.field_70249_b = this.getMaxArrowShake();
        this.playHitSound();
        if (this.inTile != null) {
            this.inTile.func_149670_a(this.field_70170_p, this.xTile, this.yTile, this.zTile, (Entity)this);
        }
    }

    protected void bounceBack() {
        this.field_70159_w *= -0.1;
        this.field_70181_x *= -0.1;
        this.field_70179_y *= -0.1;
        this.field_70177_z += 180.0f;
        this.field_70126_B += 180.0f;
        this.field_70257_an = 0;
    }

    public final double getTotalVelocity() {
        return Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y);
    }

    public boolean aimRotation() {
        return true;
    }

    public int getMaxLifetime() {
        return 1200;
    }

    public ItemStack getPickupItem() {
        return null;
    }

    public float getAirResistance() {
        return 0.99f;
    }

    public float getGravity() {
        return 0.05f;
    }

    public int getMaxArrowShake() {
        return 7;
    }

    public void playHitSound() {
    }

    public boolean canBeCritical() {
        return false;
    }

    public void func_70243_d(boolean flag) {
        if (this.canBeCritical()) {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(flag ? 1 : 0)));
        }
    }

    public boolean func_70241_g() {
        return this.canBeCritical() && this.field_70180_af.func_75683_a(16) != 0;
    }

    public void setExtraDamage(float f) {
        this.extraDamage = f;
    }

    public void func_70240_a(int i) {
        this.knockBack = i;
    }

    public void setPickupMode(int i) {
        this.pickupMode = i;
    }

    public int getPickupMode() {
        return this.pickupMode;
    }

    public boolean canPickup(EntityPlayer entityplayer) {
        if (this.pickupMode == 1) {
            return true;
        }
        if (this.pickupMode == 2) {
            return entityplayer.field_71075_bZ.field_75098_d;
        }
        if (this.pickupMode == 3) {
            return entityplayer == this.field_70250_c;
        }
        return false;
    }

    public void func_70100_b_(EntityPlayer entityplayer) {
        if (this.field_70254_i && this.field_70249_b <= 0 && this.canPickup(entityplayer) && !this.field_70170_p.field_72995_K) {
            ItemStack item = this.getPickupItem();
            if (item == null) {
                return;
            }
            if (this.pickupMode == 2 && entityplayer.field_71075_bZ.field_75098_d || entityplayer.field_71071_by.func_70441_a(item)) {
                this.field_70170_p.func_72956_a((Entity)this, "random.pop", 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                this.onItemPickup(entityplayer);
                this.func_70106_y();
            }
        }
    }

    protected void onItemPickup(EntityPlayer entityplayer) {
        entityplayer.func_71001_a((Entity)this, 1);
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70053_R() {
        return 0.0f;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74777_a("xTile", (short)this.xTile);
        nbttagcompound.func_74777_a("yTile", (short)this.yTile);
        nbttagcompound.func_74777_a("zTile", (short)this.zTile);
        nbttagcompound.func_74774_a("inTile", (byte)Block.func_149682_b((Block)this.inTile));
        nbttagcompound.func_74774_a("inData", (byte)this.field_70253_h);
        nbttagcompound.func_74774_a("shake", (byte)this.field_70249_b);
        nbttagcompound.func_74757_a("inGround", this.field_70254_i);
        nbttagcompound.func_74757_a("beenInGround", this.beenInGround);
        nbttagcompound.func_74774_a("pickup", (byte)this.pickupMode);
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        this.xTile = nbttagcompound.func_74765_d("xTile");
        this.yTile = nbttagcompound.func_74765_d("yTile");
        this.zTile = nbttagcompound.func_74765_d("zTile");
        this.inTile = Block.func_149729_e((int)(nbttagcompound.func_74771_c("inTile") & 0xFF));
        this.field_70253_h = nbttagcompound.func_74771_c("inData") & 0xFF;
        this.field_70249_b = nbttagcompound.func_74771_c("shake") & 0xFF;
        this.field_70254_i = nbttagcompound.func_74767_n("inGround");
        this.beenInGround = nbttagcompound.func_74767_n("beenInGrond");
        this.pickupMode = nbttagcompound.func_74771_c("pickup");
    }
}

