/*
 * Decompiled with CFR 0.152.
 */
package solarexpansion.tile;

import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyReceiver;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;
import solarexpansion.energy.EnergyStorage;
import solarexpansion.tile.baseclasses.TileEntityBase;

public class TileEntitySolarPanel
extends TileEntityBase
implements IEnergyHandler {
    private EnergyStorage energyStorage;
    private int energyGeneration;

    public TileEntitySolarPanel() {
        this(0, 0, 0);
    }

    public TileEntitySolarPanel(int energyGeneration, int energyTransfer, int energyCapacity) {
        this.energyGeneration = energyGeneration;
        this.energyStorage = new EnergyStorage(energyCapacity, energyTransfer);
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.generateEnergy();
            if (this.getEnergyStored() > 0) {
                this.transferEnergy();
            }
        }
    }

    private int getEnergyGeneration() {
        float multiplicator = 1.5f;
        float displacement = 1.2f;
        float celestialAngleRadians = this.field_145850_b.func_72929_e(1.0f);
        if ((double)celestialAngleRadians > Math.PI) {
            celestialAngleRadians = 6.283184f - celestialAngleRadians;
        }
        int sunGeneration = Math.round((float)this.energyGeneration * multiplicator * MathHelper.func_76134_b((float)(celestialAngleRadians / displacement)));
        if (this.field_145850_b.func_72937_j(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) && sunGeneration > 0) {
            if (this.field_145850_b.func_72896_J()) {
                return 0;
            }
            if (this.field_145850_b.func_72911_I()) {
                return 0;
            }
            return Math.min(this.energyGeneration, sunGeneration);
        }
        return 0;
    }

    protected void generateEnergy() {
        int energyGeneration = this.getEnergyGeneration();
        if (energyGeneration > 0) {
            this.energyStorage.receiveEnergy(energyGeneration, false);
        }
    }

    public void transferEnergy() {
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tileEntity = this.func_145831_w().func_147438_o(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ);
            if (tileEntity instanceof TileEntitySolarPanel || !(tileEntity instanceof IEnergyReceiver) || this.energyStorage.getEnergyStored() <= 0) continue;
            IEnergyReceiver receiver = (IEnergyReceiver)tileEntity;
            this.energyStorage.sendEnergy(receiver, direction.getOpposite());
        }
    }

    @Override
    protected void loadDataFromNBT(NBTTagCompound nbtTagCompound) {
        this.energyGeneration = nbtTagCompound.func_74762_e("EnergyGeneration");
        this.energyStorage.readFromNBT(nbtTagCompound);
    }

    @Override
    protected void addDataToNBT(NBTTagCompound nbtTagCompound) {
        nbtTagCompound.func_74768_a("EnergyGeneration", this.energyGeneration);
        this.energyStorage.writeToNBT(nbtTagCompound);
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return from == ForgeDirection.DOWN;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return 0;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.energyStorage.extractEnergy(this.energyStorage.getMaxExtract(), simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.energyStorage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.energyStorage.getMaxEnergyStored();
    }

    public void setEnergyStored(int energyStored) {
        this.energyStorage.setEnergyStored(energyStored);
    }

    public int getEnergyStored() {
        return this.getEnergyStored(ForgeDirection.DOWN);
    }

    public int getMaxEnergyStored() {
        return this.getMaxEnergyStored(ForgeDirection.DOWN);
    }

    public static class Ultimate
    extends TileEntitySolarPanel {
        public Ultimate() {
            this(0, 0, 0);
        }

        public Ultimate(int energyGeneration, int energyTransfer, int energyCapacity) {
            super(energyGeneration, energyTransfer, energyCapacity);
        }
    }

    public static class Advanced
    extends TileEntitySolarPanel {
        public Advanced() {
            this(0, 0, 0);
        }

        public Advanced(int energyGeneration, int energyTransfer, int energyCapacity) {
            super(energyGeneration, energyTransfer, energyCapacity);
        }
    }

    public static class Resonant
    extends TileEntitySolarPanel {
        public Resonant() {
            this(0, 0, 0);
        }

        public Resonant(int energyGeneration, int energyTransfer, int energyCapacity) {
            super(energyGeneration, energyTransfer, energyCapacity);
        }
    }

    public static class Redstone
    extends TileEntitySolarPanel {
        public Redstone() {
            this(0, 0, 0);
        }

        public Redstone(int energyGeneration, int energyTransfer, int energyCapacity) {
            super(energyGeneration, energyTransfer, energyCapacity);
        }
    }

    public static class Hardened
    extends TileEntitySolarPanel {
        public Hardened() {
            this(0, 0, 0);
        }

        public Hardened(int energyGeneration, int energyTransfer, int energyCapacity) {
            super(energyGeneration, energyTransfer, energyCapacity);
        }
    }

    public static class Leadstone
    extends TileEntitySolarPanel {
        public Leadstone() {
            this(0, 0, 0);
        }

        public Leadstone(int energyGeneration, int energyTransfer, int energyCapacity) {
            super(energyGeneration, energyTransfer, energyCapacity);
        }
    }
}

