/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.utils;

import net.minecraft.world.World;

public class MuseBlockUtils {
    public static byte[] rotateType = new byte[4096];
    public static final int[][] SIDE_COORD_MOD = new int[][]{{0, -1, 0}, {0, 1, 0}, {0, 0, -1}, {0, 0, 1}, {-1, 0, 0}, {1, 0, 0}};
    public static final int[] SIDE_LEFT = new int[]{4, 5, 5, 4, 2, 3};
    public static final int[] SIDE_RIGHT = new int[]{5, 4, 4, 5, 3, 2};
    public static final int[] SIDE_OPPOSITE = new int[]{1, 0, 3, 2, 5, 4};
    public static final int[] SIDE_UP = new int[]{2, 3, 1, 1, 1, 1};
    public static final int[] SIDE_DOWN = new int[]{3, 2, 0, 0, 0, 0};

    public static boolean canRotate(int blockId) {
        return rotateType[blockId] != 0;
    }

    public static int rotateVanillaBlock(World world, int block, int meta, int x, int y, int z) {
        switch (rotateType[block]) {
            case 1: {
                return SIDE_LEFT[meta];
            }
            case 2: {
                if (meta < 6) {
                    return ++meta % 6;
                }
                return meta;
            }
            case 3: {
                if (meta < 2) {
                    return ++meta % 2;
                }
                return meta;
            }
            case 4: {
                return ++meta % 4;
            }
            case 5: {
                return ++meta % 8;
            }
            case 6: {
                int upper = meta & 0xC;
                int lower = meta & 3;
                return upper + ++lower % 4;
            }
            case 7: {
                return (meta + 4) % 12;
            }
            case 8: {
                return (meta + 8) % 16;
            }
            case 9: {
                for (int i = 2; i < 6; ++i) {
                    int[] coords = MuseBlockUtils.getAdjacentCoordinatesForSide(x, y, z, i);
                }
                return SIDE_LEFT[meta];
            }
            case 10: {
                int shift = 0;
                if (meta > 7) {
                    meta -= 8;
                    shift = 8;
                }
                if (meta == 5) {
                    return 6 + shift;
                }
                if (meta == 6) {
                    return 5 + shift;
                }
                if (meta == 7) {
                    return 0 + shift;
                }
                if (meta == 0) {
                    return 7 + shift;
                }
                return meta + shift;
            }
            case 11: {
                return ++meta % 16;
            }
        }
        return meta;
    }

    public static int rotateVanillaBlockAlt(World world, int block, int meta, int x, int y, int z) {
        switch (rotateType[block]) {
            case 1: {
                return SIDE_RIGHT[meta];
            }
            case 2: {
                if (meta < 6) {
                    return (meta + 5) % 6;
                }
                return meta;
            }
            case 3: {
                if (meta < 2) {
                    return ++meta % 2;
                }
                return meta;
            }
            case 4: {
                return (meta + 3) % 4;
            }
            case 5: {
                return (meta + 7) % 8;
            }
            case 6: {
                int upper = meta & 0xC;
                int lower = meta & 3;
                return upper + (lower + 3) % 4;
            }
            case 7: {
                return (meta + 8) % 12;
            }
            case 8: {
                return (meta + 8) % 16;
            }
            case 9: {
                for (int i = 2; i < 6; ++i) {
                    int[] coords = MuseBlockUtils.getAdjacentCoordinatesForSide(x, y, z, i);
                }
                return SIDE_RIGHT[meta];
            }
            case 10: {
                int shift = 0;
                if (meta > 7) {
                    meta -= 8;
                    shift = 8;
                }
                if (meta == 5) {
                    return 6 + shift;
                }
                if (meta == 6) {
                    return 5 + shift;
                }
                if (meta == 7) {
                    return 0 + shift;
                }
                if (meta != 0) break;
                return 7 + shift;
            }
            case 11: {
                return ++meta % 16;
            }
        }
        return meta;
    }

    public static int[] getAdjacentCoordinatesForSide(int x, int y, int z, int side) {
        return new int[]{x + SIDE_COORD_MOD[side][0], y + SIDE_COORD_MOD[side][1], z + SIDE_COORD_MOD[side][2]};
    }
}

