/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.tool;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.List;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IBlockBreakingModule;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class ScoopModule
extends PowerModuleBase
implements IBlockBreakingModule {
    public static final String MODULE_SCOOP = "Scoop";
    public static final String SCOOP_HARVEST_SPEED = "Scoop Harvest Speed";
    public static final String SCOOP_ENERGY_CONSUMPTION = "Scoop Energy Consumption";
    public static final ItemStack scoop = GameRegistry.findItemStack((String)"Forestry", (String)"scoop", (int)1);

    public ScoopModule(List<IModularItem> validItems) {
        super(validItems);
        this.addInstallCost(scoop);
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.solenoid, 1));
        this.addBaseProperty(SCOOP_ENERGY_CONSUMPTION, 2000.0, "J");
        this.addBaseProperty(SCOOP_HARVEST_SPEED, 5.0, "x");
    }

    @Override
    public String getCategory() {
        return "Tool";
    }

    @Override
    public String getDataName() {
        return MODULE_SCOOP;
    }

    @Override
    public String getUnlocalizedName() {
        return "scoop";
    }

    @Override
    public IIcon getIcon(ItemStack item) {
        return scoop.func_77954_c();
    }

    @Override
    public String getTextureFile() {
        return null;
    }

    @Override
    public boolean canHarvestBlock(ItemStack stack, Block block, int meta, EntityPlayer player) {
        return ForgeHooks.canToolHarvestBlock((Block)block, (int)meta, (ItemStack)scoop) && ElectricItemUtils.getPlayerEnergy(player) > ModuleManager.computeModularProperty(stack, SCOOP_ENERGY_CONSUMPTION);
    }

    @Override
    public boolean onBlockDestroyed(ItemStack stack, World world, Block block, int x, int y, int z, EntityPlayer player) {
        int meta = world.func_72805_g(x, y, z);
        if (this.canHarvestBlock(stack, block, meta, player)) {
            ElectricItemUtils.drainPlayerEnergy(player, ModuleManager.computeModularProperty(stack, SCOOP_ENERGY_CONSUMPTION));
            return true;
        }
        return false;
    }

    @Override
    public void handleBreakSpeed(PlayerEvent.BreakSpeed event) {
        event.newSpeed = (float)((double)event.newSpeed * ModuleManager.computeModularProperty(event.entityPlayer.func_71045_bC(), SCOOP_HARVEST_SPEED));
    }
}

