/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.event;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.HashMap;
import java.util.Map;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.numina.basemod.NuminaConfig;
import net.machinemuse.numina.sound.Musique;
import net.machinemuse.powersuits.item.ItemPowerArmor;
import net.machinemuse.utils.ElectricItemUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;

public class MovementManager {
    public static Map<String, Double> playerJumpMultipliers = new HashMap<String, Double>();
    public static final double DEFAULT_GRAVITY = -0.0784000015258789;

    public static double getPlayerJumpMultiplier(EntityPlayer player) {
        if (playerJumpMultipliers.containsKey(player.func_70005_c_())) {
            return playerJumpMultipliers.get(player.func_70005_c_());
        }
        return 0.0;
    }

    public static void setPlayerJumpTicks(EntityPlayer player, double number) {
        playerJumpMultipliers.put(player.func_70005_c_(), number);
    }

    @SubscribeEvent
    public void handleLivingJumpEvent(LivingEvent.LivingJumpEvent event) {
        EntityPlayer player;
        ItemStack stack;
        if (event.entityLiving instanceof EntityPlayer && (stack = (player = (EntityPlayer)event.entityLiving).func_82169_q(1)) != null && stack.func_77973_b() instanceof ItemPowerArmor && ModuleManager.itemHasActiveModule(stack, "Jump Assist")) {
            double jumpAssist = ModuleManager.computeModularProperty(stack, "Jump Boost") * 2.0;
            double drain = ModuleManager.computeModularProperty(stack, "Jump Energy Consumption");
            double avail = ElectricItemUtils.getPlayerEnergy(player);
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && NuminaConfig.useSounds()) {
                Musique.playerSound((EntityPlayer)player, (String)"powersuits:JumpAssist", (float)((float)(jumpAssist / 8.0)), (float)1.0f, (boolean)false);
            }
            if (drain < avail) {
                ElectricItemUtils.drainPlayerEnergy(player, drain);
                MovementManager.setPlayerJumpTicks(player, jumpAssist);
                double jumpCompensationRatio = ModuleManager.computeModularProperty(stack, "Jump Exhaustion Compensation");
                if (player.func_70051_ag()) {
                    player.func_71024_bL().func_75113_a((float)(-0.8 * jumpCompensationRatio));
                } else {
                    player.func_71024_bL().func_75113_a((float)(-0.2 * jumpCompensationRatio));
                }
            }
        }
    }

    @SubscribeEvent
    public void handleFallEvent(LivingFallEvent event) {
        EntityPlayer player;
        ItemStack boots;
        if (event.entityLiving instanceof EntityPlayer && (boots = (player = (EntityPlayer)event.entityLiving).func_82169_q(0)) != null && ModuleManager.itemHasActiveModule(boots, "Shock Absorber") && event.distance > 3.0f) {
            double avail;
            double drain;
            double distanceAbsorb = (double)event.distance * ModuleManager.computeModularProperty(boots, "Distance Reduction");
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && NuminaConfig.useSounds()) {
                Musique.playerSound((EntityPlayer)player, (String)"powersuits:GUIInstall", (float)((float)distanceAbsorb), (float)1.0f, (boolean)false);
            }
            if ((drain = distanceAbsorb * ModuleManager.computeModularProperty(boots, "Impact Energy consumption")) < (avail = ElectricItemUtils.getPlayerEnergy(player))) {
                ElectricItemUtils.drainPlayerEnergy(player, drain);
                event.distance = (float)((double)event.distance - distanceAbsorb);
            }
        }
    }

    public static double computeFallHeightFromVelocity(double velocity) {
        double ticks = velocity / -0.0784000015258789;
        double distance = 0.03920000076293945 * ticks * ticks;
        return distance;
    }
}

