/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.api.electricity;

import ic2.api.item.ElectricItem;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.electricity.ElectricConversions$;
import net.machinemuse.api.electricity.MuseElectricItem;
import net.machinemuse.utils.ElectricItemUtils$;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public abstract class MuseElectricItem$class {
    public static double getCurrentEnergy(MuseElectricItem $this, ItemStack stack) {
        return MuseItemUtils.getDoubleOrZero(stack, ElectricItemUtils$.MODULE$.CURRENT_ENERGY());
    }

    public static double getMaxEnergy(MuseElectricItem $this, ItemStack stack) {
        return ModuleManager.computeModularProperty(stack, ElectricItemUtils$.MODULE$.MAXIMUM_ENERGY());
    }

    public static void setCurrentEnergy(MuseElectricItem $this, ItemStack stack, double energy) {
        MuseItemUtils.setDoubleOrRemove(stack, ElectricItemUtils$.MODULE$.CURRENT_ENERGY(), Math.min(energy, $this.getMaxEnergy(stack)));
    }

    public static double drainEnergyFrom(MuseElectricItem $this, ItemStack stack, double requested) {
        double d;
        double available = $this.getCurrentEnergy(stack);
        if (available > requested) {
            $this.setCurrentEnergy(stack, available - requested);
            d = requested;
        } else {
            $this.setCurrentEnergy(stack, 0.0);
            d = available;
        }
        return d;
    }

    public static double giveEnergyTo(MuseElectricItem $this, ItemStack stack, double provided) {
        double d;
        double max;
        double available = $this.getCurrentEnergy(stack);
        if (available + provided < (max = $this.getMaxEnergy(stack))) {
            $this.setCurrentEnergy(stack, available + provided);
            d = provided;
        } else {
            $this.setCurrentEnergy(stack, max);
            d = max - available;
        }
        return d;
    }

    public static MuseElectricItem getManager(MuseElectricItem $this, ItemStack itemStack) {
        return $this;
    }

    public static void chargeFromArmor(MuseElectricItem $this, ItemStack itemStack, EntityLivingBase entity) {
        ElectricItem.rawManager.chargeFromArmor(itemStack, entity);
    }

    public static boolean use(MuseElectricItem $this, ItemStack itemStack, double amount, EntityLivingBase entity) {
        return ElectricItem.rawManager.use(itemStack, ElectricConversions$.MODULE$.museEnergyToEU(amount), entity);
    }

    public static boolean canProvideEnergy(MuseElectricItem $this, ItemStack itemStack) {
        return true;
    }

    public static double getCharge(MuseElectricItem $this, ItemStack itemStack) {
        return ElectricConversions$.MODULE$.museEnergyToEU($this.getCurrentEnergy(itemStack));
    }

    public static double getMaxCharge(MuseElectricItem $this, ItemStack itemStack) {
        return ElectricConversions$.MODULE$.museEnergyToEU($this.getMaxEnergy(itemStack));
    }

    public static int getTier(MuseElectricItem $this, ItemStack itemStack) {
        return ElectricConversions$.MODULE$.getTier(itemStack);
    }

    public static double getTransferLimit(MuseElectricItem $this, ItemStack itemStack) {
        return ElectricConversions$.MODULE$.museEnergyToEU(Math.sqrt($this.getMaxEnergy(itemStack)));
    }

    public static double charge(MuseElectricItem $this, ItemStack itemStack, double amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        double current = $this.getCurrentEnergy(itemStack);
        double transfer = ignoreTransferLimit || amount < $this.getTransferLimit(itemStack) ? ElectricConversions$.MODULE$.museEnergyFromEU(amount) : $this.getTransferLimit(itemStack);
        double given = $this.giveEnergyTo(itemStack, transfer);
        if (simulate) {
            $this.setCurrentEnergy(itemStack, current);
        }
        return ElectricConversions$.MODULE$.museEnergyToEU(given);
    }

    public static double discharge(MuseElectricItem $this, ItemStack itemStack, double amount, int tier, boolean ignoreTransferLimit, boolean externally, boolean simulate) {
        double current = $this.getCurrentEnergy(itemStack);
        double transfer = ignoreTransferLimit || amount < $this.getTransferLimit(itemStack) ? ElectricConversions$.MODULE$.museEnergyFromEU(amount) : $this.getTransferLimit(itemStack);
        double taken = $this.drainEnergyFrom(itemStack, transfer);
        if (simulate) {
            $this.setCurrentEnergy(itemStack, current);
        }
        return ElectricConversions$.MODULE$.museEnergyToEU(taken);
    }

    public static boolean canUse(MuseElectricItem $this, ItemStack itemStack, double amount) {
        return ElectricConversions$.MODULE$.museEnergyFromEU(amount) < $this.getCurrentEnergy(itemStack);
    }

    public static String getToolTip(MuseElectricItem $this, ItemStack itemStack) {
        return $this.getToolTip(itemStack);
    }

    public static Item getChargedItem(MuseElectricItem $this, ItemStack itemStack) {
        return (Item)$this;
    }

    public static Item getEmptyItem(MuseElectricItem $this, ItemStack itemStack) {
        return (Item)$this;
    }

    public static int receiveEnergy(MuseElectricItem $this, ItemStack stack, int energy, boolean simulate) {
        double current = $this.getCurrentEnergy(stack);
        double receivedME = ElectricConversions$.MODULE$.museEnergyFromRF(energy);
        double eatenME = $this.giveEnergyTo(stack, receivedME);
        if (simulate) {
            $this.setCurrentEnergy(stack, current);
        }
        return ElectricConversions$.MODULE$.museEnergyToRF(eatenME);
    }

    public static int extractEnergy(MuseElectricItem $this, ItemStack stack, int energy, boolean simulate) {
        double current = $this.getCurrentEnergy(stack);
        double requesteddME = ElectricConversions$.MODULE$.museEnergyFromRF(energy);
        double takenME = $this.drainEnergyFrom(stack, requesteddME);
        if (simulate) {
            $this.setCurrentEnergy(stack, current);
        }
        return ElectricConversions$.MODULE$.museEnergyToRF(takenME);
    }

    public static int getEnergyStored(MuseElectricItem $this, ItemStack theItem) {
        return ElectricConversions$.MODULE$.museEnergyToRF($this.getCurrentEnergy(theItem));
    }

    public static int getMaxEnergyStored(MuseElectricItem $this, ItemStack theItem) {
        return ElectricConversions$.MODULE$.museEnergyToRF($this.getMaxEnergy(theItem));
    }

    public static int getMaxDamage(MuseElectricItem $this, ItemStack itemStack) {
        return 0;
    }

    public static void $init$(MuseElectricItem $this) {
    }
}

