/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.lib.manual;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;

public class ManualUtils {
    static HashMap<String, ResourceLocation> resourceMap = new HashMap();

    public static boolean stackMatchesObject(ItemStack stack, Object o) {
        if (o instanceof String) {
            return ManualUtils.compareToOreName(stack, (String)o);
        }
        if (o instanceof ItemStack) {
            return OreDictionary.itemMatches((ItemStack)((ItemStack)o), (ItemStack)stack, (boolean)false);
        }
        return false;
    }

    public static boolean compareToOreName(ItemStack stack, String oreName) {
        for (int oid : OreDictionary.getOreIDs((ItemStack)stack)) {
            if (!OreDictionary.getOreName((int)oid).equals(oreName)) continue;
            return true;
        }
        return false;
    }

    public static void drawTexturedRect(int x, int y, int w, int h, double ... uv) {
        Tessellator tes = Tessellator.field_78398_a;
        tes.func_78382_b();
        tes.func_78374_a((double)x, (double)(y + h), 0.0, uv[0], uv[3]);
        tes.func_78374_a((double)(x + w), (double)(y + h), 0.0, uv[1], uv[3]);
        tes.func_78374_a((double)(x + w), (double)y, 0.0, uv[1], uv[2]);
        tes.func_78374_a((double)x, (double)y, 0.0, uv[0], uv[2]);
        tes.func_78381_a();
    }

    public static ArrayList<String> getPrimitiveSpellingCorrections(String query, String[] valid, int maxDistance) {
        ArrayList<String> list = new ArrayList<String>();
        for (String s : valid) {
            if (s == null || s.trim().isEmpty() || ManualUtils.getSpellingDistanceBetweenStrings(query, s) >= maxDistance) continue;
            list.add(s);
        }
        Collections.sort(list, new Comparator<String>(){

            @Override
            public int compare(String s0, String s1) {
                return ManualUtils.getSpellingDistanceBetweenStrings(s1, s0);
            }
        });
        return list;
    }

    public static int getSpellingDistanceBetweenStrings(String query, String target) {
        query = query.toLowerCase();
        target = target.toLowerCase();
        String[] queryWords = query.split(" ");
        String[] targetWords = target.split(" ");
        int distance = 0;
        for (int iWord = 0; iWord < queryWords.length; ++iWord) {
            if (iWord >= targetWords.length) {
                ++distance;
                continue;
            }
            int wordDistance = 0;
            for (int iChar = 0; iChar < queryWords[iWord].length(); ++iChar) {
                if (iChar >= targetWords[iWord].length()) {
                    ++distance;
                    continue;
                }
                if (queryWords[iWord].charAt(iChar) == targetWords[iWord].charAt(iChar)) continue;
                ++wordDistance;
                if (iChar <= 0 || queryWords[iWord].charAt(iChar - 1) != targetWords[iWord].charAt(iChar) || queryWords[iWord].charAt(iChar) != targetWords[iWord].charAt(iChar - 1)) continue;
                wordDistance -= 2;
            }
            if (wordDistance > 0) {
                wordDistance += targetWords[iWord].length() - queryWords[iWord].length();
            }
            distance += wordDistance;
        }
        return distance;
    }

    public static Tessellator tes() {
        return Tessellator.field_78398_a;
    }

    public static Minecraft mc() {
        return Minecraft.func_71410_x();
    }

    public static void bindTexture(String path) {
        ManualUtils.mc().func_110434_K().func_110577_a(ManualUtils.getResource(path));
    }

    public static ResourceLocation getResource(String path) {
        ResourceLocation rl;
        ResourceLocation resourceLocation = rl = resourceMap.containsKey(path) ? resourceMap.get(path) : new ResourceLocation(path);
        if (!resourceMap.containsKey(path)) {
            resourceMap.put(path, rl);
        }
        return rl;
    }
}

