/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.minetweaker;

import blusunrize.immersiveengineering.api.tool.ExcavatorHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenSetter;

@ZenClass(value="mods.immersiveengineering.Excavator")
public class Excavator {
    @ZenMethod
    public static void addMineral(String name, int mineralWeight, double failChance, String[] ores, double[] chances, @Optional int[] dimensionWhitelist, @Optional boolean blacklist) {
        float[] fChances = new float[chances.length];
        for (int i = 0; i < chances.length; ++i) {
            fChances[i] = (float)chances[i];
        }
        System.out.println("name: " + name + ", dim " + dimensionWhitelist + ", black: " + blacklist);
        MineTweakerAPI.apply((IUndoableAction)new AddMineral(name, mineralWeight, (float)failChance, ores, fChances, dimensionWhitelist, blacklist));
    }

    @ZenMethod
    public static void removeMineral(String name) {
        MineTweakerAPI.apply((IUndoableAction)new RemoveMineral(name));
    }

    @ZenMethod
    public static MTMineralMix getMineral(String name) {
        for (ExcavatorHandler.MineralMix mix : ExcavatorHandler.mineralList.keySet()) {
            if (!mix.name.equalsIgnoreCase(name)) continue;
            return new MTMineralMix(mix, ExcavatorHandler.mineralList.get(mix));
        }
        return null;
    }

    @ZenClass(value="mods.immersiveengineering.MineralMix")
    public static class MTMineralMix {
        ExcavatorHandler.MineralMix mix;
        int weight;

        public MTMineralMix(ExcavatorHandler.MineralMix mix, int weight) {
            this.mix = mix;
            this.weight = weight;
        }

        @ZenGetter(value="failChance")
        public double getFailChance() {
            return this.mix.failChance;
        }

        @ZenSetter(value="failChance")
        public void setFailChance(double chance) {
            this.mix.failChance = (float)chance;
        }

        @ZenMethod
        public void addOre(String ore, double chance) {
            String[] newOres = new String[this.mix.ores.length + 1];
            float[] newChances = new float[newOres.length];
            System.arraycopy(this.mix.ores, 0, newOres, 0, this.mix.ores.length);
            System.arraycopy(this.mix.chances, 0, newChances, 0, this.mix.chances.length);
            newOres[this.mix.ores.length] = ore;
            newChances[this.mix.ores.length] = (float)chance;
            this.mix.ores = newOres;
            this.mix.chances = newChances;
        }

        @ZenMethod
        public void removeOre(String ore) {
            int i;
            HashMap<String, Float> map = new HashMap<String, Float>();
            for (i = 0; i < this.mix.ores.length; ++i) {
                map.put(this.mix.ores[i], Float.valueOf(this.mix.chances[i]));
            }
            map.remove(ore);
            this.mix.ores = new String[map.size()];
            this.mix.chances = new float[map.size()];
            i = 0;
            for (Map.Entry e : map.entrySet()) {
                this.mix.ores[i] = (String)e.getKey();
                this.mix.chances[i] = ((Float)e.getValue()).floatValue();
                ++i;
            }
        }
    }

    private static class RemoveMineral
    implements IUndoableAction {
        private final String name;
        ArrayList<ExcavatorHandler.MineralMix> mix;
        ArrayList<Integer> weight;

        public RemoveMineral(String name) {
            this.name = name;
            this.mix = new ArrayList();
            this.weight = new ArrayList();
        }

        public void apply() {
            this.mix.clear();
            this.weight.clear();
            Iterator<Map.Entry<ExcavatorHandler.MineralMix, Integer>> it = ExcavatorHandler.mineralList.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<ExcavatorHandler.MineralMix, Integer> e = it.next();
                if (!e.getKey().name.equalsIgnoreCase(this.name) || this.mix.contains(e.getKey())) continue;
                this.mix.add(e.getKey());
                this.weight.add(e.getValue());
                it.remove();
            }
        }

        public void undo() {
            if (this.mix != null && this.weight != null) {
                for (int i = 0; i < this.mix.size(); ++i) {
                    boolean exists = false;
                    for (ExcavatorHandler.MineralMix mm : ExcavatorHandler.mineralList.keySet()) {
                        if (mm == null || !this.mix.get((int)i).name.equalsIgnoreCase(mm.name)) continue;
                        exists = true;
                        break;
                    }
                    if (exists) continue;
                    ExcavatorHandler.mineralList.put(this.mix.get(i), this.weight.get(i));
                }
            }
        }

        public String describe() {
            return "Removing MineralMix: " + this.name;
        }

        public String describeUndo() {
            return "Re-Adding MineralMix: " + this.name;
        }

        public Object getOverrideKey() {
            return null;
        }

        public boolean canUndo() {
            return true;
        }
    }

    private static class AddMineral
    implements IUndoableAction {
        private final String name;
        private final int mineralWeight;
        private final float failChance;
        private final String[] ores;
        private final float[] chances;
        private final int[] dimensions;
        private final boolean blacklist;
        ExcavatorHandler.MineralMix mineral;

        public AddMineral(String name, int mineralWeight, float failChance, String[] ores, float[] chances, int[] dimensions, boolean blacklist) {
            this.name = name;
            this.mineralWeight = mineralWeight;
            this.failChance = failChance;
            this.ores = ores;
            this.chances = chances;
            this.dimensions = dimensions;
            this.blacklist = blacklist;
        }

        public void apply() {
            this.mineral = ExcavatorHandler.addMineral(this.name, this.mineralWeight, this.failChance, this.ores, this.chances);
            if (this.dimensions != null) {
                if (this.blacklist) {
                    this.mineral.dimensionBlacklist = this.dimensions;
                } else {
                    this.mineral.dimensionWhitelist = this.dimensions;
                }
            }
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            Iterator<Map.Entry<ExcavatorHandler.MineralMix, Integer>> it = ExcavatorHandler.mineralList.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<ExcavatorHandler.MineralMix, Integer> e = it.next();
                if (!e.getKey().name.equalsIgnoreCase(this.name)) continue;
                it.remove();
            }
        }

        public String describe() {
            return "Adding MineralMix: " + this.name + " with weight " + this.mineralWeight;
        }

        public String describeUndo() {
            return "Removing MineralMix: " + this.name;
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

