/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.aquatweaks.api.IAquaConnectable;
import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.client.render.BlockRenderWoodenDevices;
import blusunrize.immersiveengineering.common.blocks.BlockIEBase;
import blusunrize.immersiveengineering.common.blocks.wooden.ItemBlockWoodenDevices;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityModWorkbench;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityWatermill;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityWindmill;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityWindmillAdvanced;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityWoodenBarrel;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityWoodenCrate;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityWoodenPost;
import blusunrize.immersiveengineering.common.util.Utils;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

@Optional.Interface(iface="blusunrize.aquatweaks.api.IAquaConnectable", modid="AquaTweaks")
public class BlockWoodenDevices
extends BlockIEBase
implements IAquaConnectable {
    IIcon[] iconBarrel = new IIcon[3];

    public BlockWoodenDevices() {
        super("woodenDevice", Material.field_151575_d, 1, ItemBlockWoodenDevices.class, "post", "watermill", "windmill", "windmillAdvanced", "crate", "modificationWorkbench", "barrel");
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.setMetaLightOpacity(4, 255);
        this.setMetaLightOpacity(6, 255);
    }

    @Override
    public boolean allowHammerHarvest(int meta) {
        return true;
    }

    @Override
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < this.subNames.length; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.icons[0][0] = iconRegister.func_94245_a("immersiveengineering:woodenPost");
        this.icons[1][0] = iconRegister.func_94245_a("immersiveengineering:treatedWood");
        this.icons[2][0] = iconRegister.func_94245_a("immersiveengineering:treatedWood");
        this.icons[3][0] = iconRegister.func_94245_a("immersiveengineering:treatedWood");
        this.icons[4][0] = iconRegister.func_94245_a("immersiveengineering:woodenCrate");
        this.icons[5][0] = iconRegister.func_94245_a("immersiveengineering:workbench");
        this.icons[6][0] = iconRegister.func_94245_a("immersiveengineering:woodBarrel");
        this.iconBarrel[0] = iconRegister.func_94245_a("immersiveengineering:woodBarrel_top_none");
        this.iconBarrel[1] = iconRegister.func_94245_a("immersiveengineering:woodBarrel_top_in");
        this.iconBarrel[2] = iconRegister.func_94245_a("immersiveengineering:woodBarrel_top_out");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (meta == 6 && side < 2) {
            return this.iconBarrel[0];
        }
        return super.func_149691_a(side, meta);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityWoodenBarrel && side < 2) {
            return this.iconBarrel[((TileEntityWoodenBarrel)te).sideConfig[side] + 1];
        }
        return super.func_149673_e(world, x, y, z, side);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return BlockRenderWoodenDevices.renderID;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEntityWoodenPost) {
            byte type = ((TileEntityWoodenPost)tileEntity).type;
            switch (type) {
                case 0: {
                    this.func_149676_a(0.25f, 0.0f, 0.25f, 0.75f, 1.0f, 0.75f);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    float fd = 0.4375f;
                    float fu = 1.0f;
                    if (this.canArmConnectToBlock(world, x, y - 1, z, true)) {
                        fd = 0.0f;
                        if (!this.canArmConnectToBlock(world, x, y + 1, z, false)) {
                            fu = 0.5625f;
                        }
                    }
                    this.func_149676_a(type == 7 ? 0.0f : 0.3125f, fd, type == 5 ? 0.0f : 0.3125f, type == 6 ? 1.0f : 0.6875f, fu, type == 4 ? 1.0f : 0.6875f);
                    break;
                }
                default: {
                    this.func_149676_a(this.isPost(world, x - 1, y, z, 6) ? 0.0f : 0.3125f, 0.0f, this.isPost(world, x, y, z - 1, 4) ? 0.0f : 0.3125f, this.isPost(world, x + 1, y, z, 7) ? 1.0f : 0.6875f, 1.0f, this.isPost(world, x, y, z + 1, 5) ? 1.0f : 0.6875f);
                    break;
                }
            }
        } else {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    boolean isPost(IBlockAccess world, int x, int y, int z, int type) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityWoodenPost) {
            return ((TileEntityWoodenPost)te).type == type;
        }
        return world.func_147439_a(x, y, z) == this && world.func_72805_g(x, y, z) == 0;
    }

    boolean canArmConnectToBlock(IBlockAccess world, int x, int y, int z, boolean down) {
        if (world.func_147437_c(x, y, z)) {
            return false;
        }
        world.func_147439_a(x, y, z).func_149719_a(world, x, y, z);
        return down ? world.func_147439_a(x, y, z).func_149669_A() >= 1.0 : world.func_147439_a(x, y, z).func_149665_z() <= 0.0;
    }

    public boolean isLadder(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
        return world.func_147438_o(x, y, z) instanceof TileEntityWoodenPost;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149668_a(world, x, y, z);
    }

    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149668_a(world, x, y, z);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityWoodenPost && Utils.isHammer(player.func_71045_bC())) {
            byte type = ((TileEntityWoodenPost)te).type;
            if (type == 3) {
                ForgeDirection fd = ForgeDirection.getOrientation((int)side);
                ForgeDirection rot0 = fd.getRotation(ForgeDirection.UP);
                ForgeDirection rot1 = rot0.getOpposite();
                if (!world.func_147437_c(x + fd.offsetX, y + fd.offsetY, z + fd.offsetZ)) {
                    return false;
                }
                te = world.func_147438_o(x + rot0.offsetX, y + rot0.offsetY, z + rot0.offsetZ);
                if (te instanceof TileEntityWoodenPost && ((TileEntityWoodenPost)te).type - 2 == rot0.ordinal()) {
                    return false;
                }
                te = world.func_147438_o(x + rot1.offsetX, y + rot1.offsetY, z + rot1.offsetZ);
                if (te instanceof TileEntityWoodenPost && ((TileEntityWoodenPost)te).type - 2 == rot1.ordinal()) {
                    return false;
                }
                world.func_147465_d(x + fd.offsetX, y, z + fd.offsetZ, (Block)this, 0, 3);
                TileEntity tileEntity = world.func_147438_o(x + fd.offsetX, y, z + fd.offsetZ);
                if (tileEntity instanceof TileEntityWoodenPost) {
                    ((TileEntityWoodenPost)tileEntity).type = (byte)(2 + side);
                }
                world.func_147471_g(x, y - 3, z);
            } else if (type == 4 || type == 5 || type == 6 || type == 7) {
                world.func_147468_f(x, y, z);
                ForgeDirection fd = ForgeDirection.getOrientation((int)(type - 2));
                world.func_147471_g(x - fd.offsetX, y - 3, z - fd.offsetZ);
            }
            return true;
        }
        if (te instanceof TileEntityWindmillAdvanced && Utils.getDye(player.func_71045_bC()) >= 0 && ((TileEntityWindmillAdvanced)te).facing == side) {
            int f = ((TileEntityWindmillAdvanced)te).facing;
            float w = f == 2 ? 1.0f - hitX : (f == 3 ? hitX : (f == 4 ? hitZ : 1.0f - hitZ));
            double r = Math.sqrt(((double)w - 0.5) * ((double)w - 0.5) + ((double)hitY - 0.5) * ((double)hitY - 0.5));
            double ax = Math.toDegrees(Math.acos(((double)w - 0.5) / r));
            double ay = Math.toDegrees(Math.asin(((double)hitY - 0.5) / r));
            double a = (ay < 0.0 ? 360.0 - ax : ax) + 22.25;
            int sel = (4 - (int)(a / 45.0) + 6) % 8;
            if (((TileEntityWindmillAdvanced)te).dye[sel] == Utils.getDye(player.func_71045_bC())) {
                return false;
            }
            ((TileEntityWindmillAdvanced)te).dye[sel] = (byte)Utils.getDye(player.func_71045_bC());
            if (!player.field_71075_bZ.field_75098_d) {
                --player.func_71045_bC().field_77994_a;
            }
            return true;
        }
        if (!player.func_70093_af() && te instanceof TileEntityWoodenCrate) {
            if (!world.field_72995_K) {
                player.openGui((Object)ImmersiveEngineering.instance, 4, world, x, y, z);
            }
            return true;
        }
        if (!player.func_70093_af() && te instanceof TileEntityModWorkbench) {
            TileEntityModWorkbench tile = (TileEntityModWorkbench)te;
            if (tile.dummy) {
                int zz;
                int f = tile.facing;
                int off = tile.dummyOffset;
                int xx = x - (f < 4 ? off : 0);
                TileEntity tileEntityModWorkbench = world.func_147438_o(xx, y, zz = z - (f > 3 ? off : 0));
                if (tileEntityModWorkbench instanceof TileEntityModWorkbench) {
                    tile = (TileEntityModWorkbench)tileEntityModWorkbench;
                }
            }
            if (!world.field_72995_K) {
                player.openGui((Object)ImmersiveEngineering.instance, 9, world, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
            }
            return true;
        }
        if (te instanceof TileEntityWoodenBarrel) {
            if (!world.field_72995_K) {
                TileEntityWoodenBarrel barrel = (TileEntityWoodenBarrel)te;
                if (Utils.isHammer(player.func_71045_bC()) && side < 2) {
                    if (player.func_70093_af()) {
                        side = ForgeDirection.OPPOSITES[side];
                    }
                    barrel.toggleSide(side);
                } else if (!player.func_70093_af()) {
                    FluidStack f = Utils.getFluidFromItemStack(player.func_71045_bC());
                    if (f != null) {
                        if (f.getFluid().isGaseous(f)) {
                            player.func_146105_b((IChatComponent)new ChatComponentTranslation("chat.ImmersiveEngineering.info.noGasAllowed", new Object[0]));
                        } else if (f.getFluid().getTemperature(f) >= 573) {
                            player.func_146105_b((IChatComponent)new ChatComponentTranslation("chat.ImmersiveEngineering.info.tooHot", new Object[0]));
                        } else if (Utils.fillFluidHandlerWithPlayerItem(world, barrel, player)) {
                            world.func_147471_g(x, y, z);
                            return true;
                        }
                    }
                    if (Utils.fillPlayerItemFromFluidHandler(world, barrel, player, barrel.tank.getFluid())) {
                        world.func_147471_g(x, y, z);
                        return true;
                    }
                    if (player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() instanceof IFluidContainerItem) {
                        world.func_147471_g(x, y, z);
                        return true;
                    }
                }
            }
            return true;
        }
        return false;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        int zz;
        int yy;
        int[] off;
        int f;
        int xx;
        TileEntity tileEntity2;
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEntityWatermill && (tileEntity2 = world.func_147438_o(xx = x - ((f = ((TileEntityWatermill)tileEntity).facing) == 2 || f == 3 ? off[0] : 0), yy = y - (off = ((TileEntityWatermill)tileEntity).offset)[1], zz = z - (f == 2 || f == 3 ? 0 : off[0]))) instanceof TileEntityWatermill) {
            ((TileEntityWatermill)tileEntity2).resetRotationVec();
        }
    }

    public void func_149681_a(World world, int x, int y, int z, int meta, EntityPlayer player) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!world.field_72995_K) {
            NBTTagCompound tag;
            ItemStack stack;
            if (te instanceof TileEntityWoodenCrate) {
                stack = new ItemStack((Block)this, 1, meta);
                tag = new NBTTagCompound();
                ((TileEntityWoodenCrate)te).writeInv(tag, true);
                if (!tag.func_82582_d()) {
                    stack.func_77982_d(tag);
                }
                world.func_72838_d((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, stack));
            }
            if (te instanceof TileEntityWoodenBarrel) {
                stack = new ItemStack((Block)this, 1, meta);
                tag = new NBTTagCompound();
                ((TileEntityWoodenBarrel)te).writeTank(tag, true);
                if (!tag.func_82582_d()) {
                    stack.func_77982_d(tag);
                }
                world.func_72838_d((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, stack));
            }
        }
    }

    public void onBlockExploded(World world, int x, int y, int z, Explosion explosion) {
        if (!world.field_72995_K) {
            NBTTagCompound tag;
            ItemStack stack;
            TileEntity te = world.func_147438_o(x, y, z);
            if (te instanceof TileEntityWoodenCrate) {
                stack = new ItemStack((Block)this, 1, world.func_72805_g(x, y, z));
                tag = new NBTTagCompound();
                ((TileEntityWoodenCrate)te).writeInv(tag, true);
                if (!tag.func_82582_d()) {
                    stack.func_77982_d(tag);
                }
                world.func_72838_d((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, stack));
            }
            if (te instanceof TileEntityWoodenBarrel) {
                stack = new ItemStack((Block)this, 1, world.func_72805_g(x, y, z));
                tag = new NBTTagCompound();
                ((TileEntityWoodenBarrel)te).writeTank(tag, true);
                if (!tag.func_82582_d()) {
                    stack.func_77982_d(tag);
                }
                world.func_72838_d((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, stack));
            }
        }
        super.onBlockExploded(world, x, y, z, explosion);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (metadata == 0 || metadata == 4 || metadata == 6) {
            return ret;
        }
        int count = this.quantityDropped(metadata, fortune, world.field_73012_v);
        for (int i = 0; i < count; ++i) {
            Item item = this.func_149650_a(metadata, world.field_73012_v, fortune);
            if (item == null) continue;
            ret.add(new ItemStack(item, 1, this.func_149692_a(metadata)));
        }
        return ret;
    }

    public void func_149749_a(World world, int x, int y, int z, Block par5, int par6) {
        int f;
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEntityWoodenPost) {
            int yy = y;
            byte type = ((TileEntityWoodenPost)tileEntity).type;
            switch (type) {
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    return;
                }
            }
            yy -= ((TileEntityWoodenPost)tileEntity).type;
            for (int i = 0; i <= 3; ++i) {
                world.func_147468_f(x, yy + i, z);
                if (i != 3) continue;
                for (ForgeDirection fd : new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.EAST, ForgeDirection.WEST}) {
                    TileEntity te = world.func_147438_o(x + fd.offsetX, yy + i, z + fd.offsetZ);
                    if (!(te instanceof TileEntityWoodenPost) || ((TileEntityWoodenPost)te).type != 2 + fd.ordinal()) continue;
                    world.func_147468_f(x + fd.offsetX, yy + i, z + fd.offsetZ);
                }
            }
            if (type == 0 && !world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops") && !world.restoringBlockSnapshots) {
                world.func_72838_d((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, new ItemStack((Block)this, 1, 0)));
            }
        }
        if (tileEntity instanceof TileEntityWatermill) {
            int[] off = ((TileEntityWatermill)tileEntity).offset;
            f = ((TileEntityWatermill)tileEntity).facing;
            int xx = x - (f == 2 || f == 3 ? off[0] : 0);
            int yy = y - off[1];
            int zz = z - (f == 2 || f == 3 ? 0 : off[0]);
            if ((off[0] != 0 || off[1] != 0) && world.func_147437_c(xx, yy, zz)) {
                return;
            }
            world.func_147468_f(xx, yy, zz);
            for (int hh = -2; hh <= 2; ++hh) {
                int r = hh < -1 || hh > 1 ? 1 : 2;
                for (int ww = -r; ww <= r; ++ww) {
                    world.func_147468_f(xx + (f == 2 || f == 3 ? ww : 0), yy + hh, zz + (f == 2 || f == 3 ? 0 : ww));
                }
            }
        }
        if (tileEntity instanceof TileEntityModWorkbench) {
            int zz;
            int xx;
            TileEntityModWorkbench tile = (TileEntityModWorkbench)tileEntity;
            f = tile.facing;
            int off = tile.dummyOffset;
            if (tile.dummy) {
                off *= -1;
            }
            if (world.func_147438_o(xx = x + (f < 4 ? off : 0), y, zz = z + (f > 3 ? off : 0)) instanceof TileEntityModWorkbench) {
                world.func_147468_f(xx, y, zz);
            }
            if (!world.field_72995_K && !tile.dummy && world.func_82736_K().func_82766_b("doTileDrops")) {
                for (int i = 0; i < tile.func_70302_i_(); ++i) {
                    ItemStack stack = tile.func_70301_a(i);
                    if (stack == null) continue;
                    float fx = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                    float fz = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                    EntityItem entityitem = new EntityItem(world, (double)((float)x + fx), (double)y + 0.5, (double)((float)z + fz), stack);
                    entityitem.field_70159_w = world.field_73012_v.nextGaussian() * 0.05;
                    entityitem.field_70181_x = world.field_73012_v.nextGaussian() * 0.05 + 0.2;
                    entityitem.field_70179_y = world.field_73012_v.nextGaussian() * 0.05;
                    if (stack.func_77942_o()) {
                        entityitem.func_92059_d().func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
                    }
                    world.func_72838_d((Entity)entityitem);
                }
            }
        }
        super.func_149749_a(world, x, y, z, par5, par6);
    }

    public TileEntity func_149915_a(World world, int meta) {
        switch (meta) {
            case 0: {
                return new TileEntityWoodenPost();
            }
            case 1: {
                return new TileEntityWatermill();
            }
            case 2: {
                return new TileEntityWindmill();
            }
            case 3: {
                return new TileEntityWindmillAdvanced();
            }
            case 4: {
                return new TileEntityWoodenCrate();
            }
            case 5: {
                return new TileEntityModWorkbench();
            }
            case 6: {
                return new TileEntityWoodenBarrel();
            }
        }
        return null;
    }

    @Optional.Method(modid="AquaTweaks")
    public boolean shouldRenderFluid(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return meta == 0;
    }

    @Optional.Method(modid="AquaTweaks")
    public boolean canConnectTo(IBlockAccess world, int x, int y, int z, int side) {
        int meta = world.func_72805_g(x, y, z);
        return meta == 0;
    }
}

