/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.util.Utils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;
import powercrystals.minefactoryreloaded.api.IDeepStorageUnit;

public class TileEntitySilo
extends TileEntityMultiblockPart
implements ISidedInventory,
IDeepStorageUnit {
    public ItemStack identStack;
    public int storageAmount = 0;
    static int maxStorage = 41472;
    ItemStack inputStack;
    ItemStack outputStack;
    ItemStack prevInputStack;
    ItemStack prevOutputStack;
    boolean lockItem = false;
    private int[] oldComps = new int[6];
    private int masterCompOld;

    @Override
    public TileEntitySilo master() {
        if (this.offset[0] == 0 && this.offset[1] == 0 && this.offset[2] == 0) {
            return null;
        }
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c - this.offset[0], this.field_145848_d - this.offset[1], this.field_145849_e - this.offset[2]);
        return te instanceof TileEntitySilo ? (TileEntitySilo)te : null;
    }

    public void func_145845_h() {
        if (this.pos == 4 && !this.field_145850_b.field_72995_K && this.outputStack == null && this.storageAmount > 0 && this.identStack != null) {
            this.func_70296_d();
        }
        if (this.pos == 4 && !this.field_145850_b.field_72995_K && this.outputStack != null && this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e) && this.field_145850_b.func_82737_E() % 8L == 0L) {
            this.updateComparatorValuesPart1();
            for (int i = 0; i < 6; ++i) {
                if (i == 1) continue;
                TileEntity inventory = this.field_145850_b.func_147438_o(this.field_145851_c + (i == 4 ? -1 : (i == 5 ? 1 : 0)), this.field_145848_d + (i == 0 ? -1 : 0), this.field_145849_e + (i == 2 ? -1 : (i == 3 ? 1 : 0)));
                ItemStack stack = Utils.copyStackWithAmount(this.identStack, 1);
                if (inventory instanceof ISidedInventory && ((ISidedInventory)inventory).func_94128_d(ForgeDirection.OPPOSITES[i]).length > 0 || inventory instanceof IInventory && ((IInventory)inventory).func_70302_i_() > 0) {
                    stack = Utils.insertStackIntoInventory((IInventory)inventory, stack, ForgeDirection.OPPOSITES[i]);
                }
                if (stack != null) continue;
                --this.outputStack.field_77994_a;
                this.func_70296_d();
                if (this.outputStack == null) break;
            }
            this.updateComparatorValuesPart2();
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        if (nbt.func_74764_b("identStack")) {
            NBTTagCompound t = nbt.func_74775_l("identStack");
            this.identStack = ItemStack.func_77949_a((NBTTagCompound)t);
        } else {
            this.identStack = null;
        }
        this.storageAmount = nbt.func_74762_e("storageAmount");
        this.lockItem = nbt.func_74767_n("lockItem");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        if (this.identStack != null) {
            NBTTagCompound t = this.identStack.func_77955_b(new NBTTagCompound());
            nbt.func_74782_a("identStack", (NBTBase)t);
        }
        nbt.func_74768_a("storageAmount", this.storageAmount);
        nbt.func_74757_a("lockItem", this.lockItem);
    }

    @Override
    public float[] getBlockBounds() {
        if (this.pos == 0 || this.pos == 2 || this.pos == 6 || this.pos == 8) {
            return new float[]{this.pos < 6 ? 0.0f : 0.75f, 0.0f, this.pos == 0 || this.pos == 6 ? 0.0f : 0.75f, this.pos > 2 ? 1.0f : 0.25f, 1.0f, this.pos == 2 || this.pos == 8 ? 1.0f : 0.25f};
        }
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    @Override
    public ItemStack getOriginalBlock() {
        return this.pos == 0 || this.pos == 2 || this.pos == 6 || this.pos == 8 ? new ItemStack((Block)IEContent.blockWoodenDecoration, 1, 1) : new ItemStack((Block)IEContent.blockMetalDecoration, 1, 10);
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.formed && !this.field_145850_b.field_72995_K) {
            int startX = this.field_145851_c - this.offset[0];
            int startY = this.field_145848_d - this.offset[1];
            int startZ = this.field_145849_e - this.offset[2];
            if (!(this.offset[0] == 0 && this.offset[1] == 0 && this.offset[2] == 0 || this.field_145850_b.func_147438_o(startX, startY, startZ) instanceof TileEntitySilo)) {
                return;
            }
            for (int yy = 0; yy <= 6; ++yy) {
                for (int xx = -1; xx <= 1; ++xx) {
                    for (int zz = -1; zz <= 1; ++zz) {
                        ItemStack s = null;
                        TileEntity tileEntity = this.field_145850_b.func_147438_o(startX + xx, startY + yy, startZ + zz);
                        if (tileEntity instanceof TileEntitySilo) {
                            s = ((TileEntitySilo)tileEntity).getOriginalBlock();
                            ((TileEntitySilo)tileEntity).formed = false;
                        }
                        if (startX + xx == this.field_145851_c && startY + yy == this.field_145848_d && startZ + zz == this.field_145849_e) {
                            s = this.getOriginalBlock();
                        }
                        if (s == null || Block.func_149634_a((Item)s.func_77973_b()) == null) continue;
                        if (startX + xx == this.field_145851_c && startY + yy == this.field_145848_d && startZ + zz == this.field_145849_e) {
                            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, s));
                            continue;
                        }
                        if (Block.func_149634_a((Item)s.func_77973_b()) == IEContent.blockMetalMultiblocks) {
                            this.field_145850_b.func_147468_f(startX + xx, startY + yy, startZ + zz);
                        }
                        this.field_145850_b.func_147465_d(startX + xx, startY + yy, startZ + zz, Block.func_149634_a((Item)s.func_77973_b()), s.func_77960_j(), 3);
                    }
                }
            }
        }
    }

    public int func_70302_i_() {
        if (!this.formed) {
            return 0;
        }
        return 2;
    }

    public ItemStack func_70301_a(int slot) {
        if (!this.formed) {
            return null;
        }
        if (this.master() != null) {
            return this.master().func_70301_a(slot);
        }
        return slot == 0 ? this.inputStack : this.outputStack;
    }

    public ItemStack func_70298_a(int slot, int amount) {
        this.updateComparatorValuesPart1();
        if (!this.formed) {
            return null;
        }
        if (this.master() != null) {
            return this.master().func_70298_a(slot, amount);
        }
        if (this.outputStack == null) {
            return null;
        }
        int rem = Math.min(amount, this.outputStack.field_77994_a);
        ItemStack ret = Utils.copyStackWithAmount(this.outputStack, rem);
        this.outputStack.field_77994_a -= rem;
        if (this.outputStack.field_77994_a <= 0) {
            this.outputStack = null;
        }
        this.func_70296_d();
        this.updateComparatorValuesPart2();
        return ret;
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.updateComparatorValuesPart1();
        if (!this.formed) {
            return;
        }
        if (this.master() != null) {
            this.master().func_70299_a(slot, stack);
            return;
        }
        if (slot == 0) {
            this.inputStack = stack;
        } else {
            this.outputStack = stack;
        }
        this.func_70296_d();
        this.updateComparatorValuesPart2();
    }

    public String func_145825_b() {
        return "IESilo";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return maxStorage;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (this.master() != null) {
            return this.master().func_94041_b(slot, stack);
        }
        return this.identStack == null || OreDictionary.itemMatches((ItemStack)this.identStack, (ItemStack)stack, (boolean)true);
    }

    public int[] func_94128_d(int side) {
        return new int[]{0, 1};
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        if (!this.formed || this.pos != 58 || slot != 0 || stack == null) {
            return false;
        }
        if (this.master() != null) {
            return this.master().identStack == null || OreDictionary.itemMatches((ItemStack)this.master().identStack, (ItemStack)stack, (boolean)true) && this.master().storageAmount < maxStorage;
        }
        return this.identStack == null || OreDictionary.itemMatches((ItemStack)this.identStack, (ItemStack)stack, (boolean)true) && this.master().storageAmount < maxStorage;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        if (!this.formed || this.pos != 4 || slot != 1 || stack == null) {
            return false;
        }
        if (this.master() != null) {
            return this.master().outputStack != null && OreDictionary.itemMatches((ItemStack)this.master().identStack, (ItemStack)stack, (boolean)true);
        }
        return this.outputStack != null && OreDictionary.itemMatches((ItemStack)this.identStack, (ItemStack)stack, (boolean)true);
    }

    public void func_70296_d() {
        super.func_70296_d();
        int oldStorage = this.storageAmount;
        if (this.inputStack != null) {
            if (this.identStack == null) {
                this.identStack = this.inputStack;
            }
            if (maxStorage - this.storageAmount > 0) {
                this.storageAmount = this.prevInputStack == null ? (this.storageAmount += this.inputStack.field_77994_a) : (this.storageAmount += this.inputStack.field_77994_a - this.prevInputStack.field_77994_a);
                if (this.storageAmount > maxStorage) {
                    this.storageAmount = maxStorage;
                }
            }
            if (maxStorage - this.storageAmount >= this.identStack.func_77976_d()) {
                this.inputStack = null;
                this.prevInputStack = null;
            } else {
                this.inputStack = Utils.copyStackWithAmount(this.identStack, this.identStack.func_77976_d() - (maxStorage - this.storageAmount));
                this.prevInputStack = this.inputStack.func_77946_l();
            }
        }
        if (this.prevOutputStack != null) {
            this.storageAmount = this.outputStack == null ? (this.storageAmount -= this.prevOutputStack.field_77994_a) : (this.storageAmount -= this.prevOutputStack.field_77994_a - this.outputStack.field_77994_a);
            if (this.storageAmount < 0) {
                this.storageAmount = 0;
            }
        }
        boolean forceUpdate = false;
        if (this.storageAmount == 0 && !this.lockItem) {
            this.identStack = null;
            this.outputStack = null;
            this.prevOutputStack = null;
            this.inputStack = null;
            this.prevInputStack = null;
            forceUpdate = true;
        } else if (this.identStack != null) {
            if (this.outputStack == null) {
                this.outputStack = this.identStack.func_77946_l();
            }
            this.outputStack.field_77994_a = Math.min(this.outputStack.func_77976_d(), this.storageAmount);
            this.prevOutputStack = this.outputStack.func_77946_l();
        }
        if (this.storageAmount != oldStorage || forceUpdate) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.pos == 4) {
            return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 7), (double)(this.field_145849_e + 2));
        }
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e);
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return super.func_145833_n() * Config.getDouble("increasedTileRenderdistance");
    }

    @Override
    public ItemStack getStoredItemType() {
        if (this.identStack != null) {
            return Utils.copyStackWithAmount(this.identStack, this.storageAmount);
        }
        return null;
    }

    @Override
    public void setStoredItemCount(int amount) {
        this.updateComparatorValuesPart1();
        if (amount > maxStorage) {
            amount = maxStorage;
        }
        this.storageAmount = amount;
        this.func_70296_d();
        this.updateComparatorValuesPart2();
    }

    @Override
    public void setStoredItemType(ItemStack type, int amount) {
        this.updateComparatorValuesPart1();
        this.identStack = Utils.copyStackWithAmount(this.identStack, 0);
        if (amount > maxStorage) {
            amount = maxStorage;
        }
        this.storageAmount = amount;
        this.func_70296_d();
        this.updateComparatorValuesPart2();
    }

    @Override
    public int getMaxStoredCount() {
        return maxStorage;
    }

    public int getComparatorOutput() {
        if (this.pos == 4) {
            return 15 * this.storageAmount / maxStorage;
        }
        if (this.offset[1] >= 1 && this.offset[1] <= 6 && this.master() != null) {
            TileEntitySilo t = this.master();
            int layer = this.offset[1] - 1;
            int vol = maxStorage / 6;
            int filled = t.storageAmount - layer * vol;
            int ret = Math.min(15, Math.max(0, 15 * filled / vol));
            return ret;
        }
        return 0;
    }

    private void updateComparatorValuesPart1() {
        int vol = maxStorage / 6;
        for (int i = 0; i < 6; ++i) {
            int filled = this.storageAmount - i * vol;
            this.oldComps[i] = Math.min(15, Math.max(15 * filled / vol, 0));
        }
        this.masterCompOld = 15 * this.storageAmount / maxStorage;
    }

    private void updateComparatorValuesPart2() {
        int vol = maxStorage / 6;
        if (15 * this.storageAmount / maxStorage != this.masterCompOld) {
            this.field_145850_b.func_147453_f(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        }
        for (int i = 0; i < 6; ++i) {
            int filled = this.storageAmount - i * vol;
            int now = Math.min(15, Math.max(15 * filled / vol, 0));
            if (now == this.oldComps[i]) continue;
            int y = this.field_145848_d - this.offset[1] + i + 1;
            for (int x = -1; x < 2; ++x) {
                for (int z = -1; z < 2; ++z) {
                    this.field_145850_b.func_147453_f(this.field_145851_c - this.offset[0] + x, y, this.field_145849_e - this.offset[2] + z, this.field_145850_b.func_147439_a(this.field_145851_c - this.offset[0] + x, y, this.field_145849_e - this.offset[2] + z));
                }
            }
        }
    }
}

