/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.energy.DieselHandler;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.blocks.multiblocks.MultiblockRefinery;
import blusunrize.immersiveengineering.common.util.Utils;
import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityRefinery
extends TileEntityMultiblockPart
implements IFluidHandler,
IEnergyReceiver,
ISidedInventory {
    public int facing = 2;
    public FluidTank tank0 = new FluidTank(12000);
    public FluidTank tank1 = new FluidTank(12000);
    public FluidTank tank2 = new FluidTank(12000);
    public EnergyStorage energyStorage = new EnergyStorage(32000, Math.max(256, Config.getInt("refinery_consumption")));
    public ItemStack[] inventory = new ItemStack[6];

    @Override
    public TileEntityRefinery master() {
        if (this.offset[0] == 0 && this.offset[1] == 0 && this.offset[2] == 0) {
            return null;
        }
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c - this.offset[0], this.field_145848_d - this.offset[1], this.field_145849_e - this.offset[2]);
        return te instanceof TileEntityRefinery ? (TileEntityRefinery)te : null;
    }

    public static boolean _Immovable() {
        return true;
    }

    @Override
    public ItemStack getOriginalBlock() {
        if (this.pos < 0) {
            return null;
        }
        ItemStack s = MultiblockRefinery.instance.getStructureManual()[this.pos % 15 / 5][this.pos % 5][this.pos / 15];
        return s != null ? s.func_77946_l() : null;
    }

    @Override
    public float[] getBlockBounds() {
        if (this.pos == 7) {
            return new float[]{0.0625f, 0.0f, 0.0625f, 0.9375f, 1.0f, 0.9375f};
        }
        if (this.pos == 37) {
            return new float[]{this.facing == 4 ? 0.5f : 0.0f, 0.0f, this.facing == 2 ? 0.5f : 0.0f, this.facing == 5 ? 0.5f : 1.0f, 1.0f, this.facing == 3 ? 0.5f : 1.0f};
        }
        if (this.pos == 20 || this.pos == 25) {
            return new float[]{this.facing == 3 ? 0.1875f : 0.0f, 0.0f, this.facing == 4 ? 0.1875f : 0.0f, this.facing == 2 ? 0.8125f : 1.0f, 1.0f, this.facing == 5 ? 0.8125f : 1.0f};
        }
        if (this.pos == 24 || this.pos == 29) {
            return new float[]{this.facing == 2 ? 0.1875f : 0.0f, 0.0f, this.facing == 5 ? 0.1875f : 0.0f, this.facing == 3 ? 0.8125f : 1.0f, 1.0f, this.facing == 4 ? 0.8125f : 1.0f};
        }
        if (this.pos >= 5 && this.pos < 15 && this.pos != 9 || this.pos >= 35 && this.pos < 45) {
            float maxZ;
            float minZ;
            float maxX;
            float minX;
            float minY = this.pos / 5 > 1 ? 0.0f : 0.375f;
            float maxY = 1.0f;
            float f = this.facing == 3 ? 0.4375f : (minX = this.facing == 4 ? 0.6875f : 0.0f);
            float f2 = this.facing == 2 ? 0.5625f : (maxX = this.facing == 5 ? 0.3125f : 1.0f);
            float f3 = this.facing == 4 ? 0.4375f : (minZ = this.facing == 2 ? 0.6875f : 0.0f);
            float f4 = this.facing == 5 ? 0.5625f : (maxZ = this.facing == 3 ? 0.3125f : 1.0f);
            if (this.pos % 5 == 4) {
                minX += this.facing == 3 ? -0.4375f : (this.facing == 2 ? 0.4375f : 0.0f);
                maxX += this.facing == 3 ? -0.4375f : (this.facing == 2 ? 0.4375f : 0.0f);
                minZ += this.facing == 4 ? -0.4375f : (this.facing == 5 ? 0.4375f : 0.0f);
                maxZ += this.facing == 4 ? -0.4375f : (this.facing == 5 ? 0.4375f : 0.0f);
            }
            if (this.pos / 15 == 2) {
                minX += this.facing == 4 ? -0.6875f : (this.facing == 5 ? 0.6875f : 0.0f);
                maxX += this.facing == 4 ? -0.6875f : (this.facing == 5 ? 0.6875f : 0.0f);
                minZ += this.facing == 3 ? 0.6875f : (this.facing == 2 ? -0.6875f : 0.0f);
                maxZ += this.facing == 3 ? 0.6875f : (this.facing == 2 ? -0.6875f : 0.0f);
            }
            if (this.pos % 5 != 0 && this.pos % 5 != 4) {
                minX = this.facing == 2 || this.facing == 3 ? 0.0f : minX;
                maxX = this.facing == 2 || this.facing == 3 ? 1.0f : maxX;
                minZ = this.facing == 4 || this.facing == 5 ? 0.0f : minZ;
                maxZ = this.facing == 4 || this.facing == 5 ? 1.0f : maxZ;
            }
            return new float[]{minX, minY, minZ, maxX, maxY, maxZ};
        }
        if (this.pos == 0 || this.pos == 1 || this.pos == 3 || this.pos == 30 || this.pos == 31 || this.pos == 33 || this.pos == 34) {
            return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f};
        }
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    public void func_145845_h() {
        if (!this.formed || this.pos != 17) {
            return;
        }
        if (!this.field_145850_b.field_72995_K && !this.field_145850_b.func_72864_z(this.field_145851_c + (this.facing == 4 ? -1 : (this.facing == 5 ? 1 : (this.facing == 2 ? -2 : 2))), this.field_145848_d + 1, this.field_145849_e + (this.facing == 2 ? -1 : (this.facing == 3 ? 1 : (this.facing == 4 ? 2 : -2))))) {
            ItemStack emptyContainer;
            int consumed;
            boolean update = false;
            DieselHandler.RefineryRecipe recipe = this.getRecipe();
            if (recipe != null && this.energyStorage.extractEnergy(consumed = Config.getInt("refinery_consumption"), true) == consumed && this.tank2.fill(recipe.output.copy(), false) == recipe.output.amount) {
                this.energyStorage.extractEnergy(consumed, false);
                int drain0 = this.tank0.getFluid().isFluidEqual(recipe.input0) ? recipe.input0.amount : recipe.input1.amount;
                int drain1 = this.tank0.getFluid().isFluidEqual(recipe.input0) ? recipe.input1.amount : recipe.input0.amount;
                this.tank0.drain(drain0, true);
                this.tank1.drain(drain1, true);
                this.tank2.fill(recipe.output.copy(), true);
                update = true;
            }
            if (this.tank2.getFluidAmount() > 0) {
                int prevAmount = this.tank2.getFluidAmount();
                ItemStack filledContainer = Utils.fillFluidContainer(this.tank2, this.inventory[4], this.inventory[5]);
                if (filledContainer != null) {
                    if (this.inventory[5] != null && OreDictionary.itemMatches((ItemStack)this.inventory[5], (ItemStack)filledContainer, (boolean)true)) {
                        this.inventory[5].field_77994_a += filledContainer.field_77994_a;
                    } else if (this.inventory[5] == null) {
                        this.inventory[5] = filledContainer.func_77946_l();
                    }
                    this.func_70298_a(4, filledContainer.field_77994_a);
                    update = true;
                } else if (prevAmount != this.tank2.getFluidAmount()) {
                    update = true;
                }
                if (this.tank2.getFluidAmount() > 0) {
                    ForgeDirection f = ForgeDirection.getOrientation((int)this.facing);
                    int out = Math.min(144, this.tank2.getFluidAmount());
                    TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + f.offsetX * 2, this.field_145848_d, this.field_145849_e + f.offsetZ * 2);
                    if (te != null && te instanceof IFluidHandler && ((IFluidHandler)te).canFill(f.getOpposite(), this.tank2.getFluid().getFluid())) {
                        int accepted = ((IFluidHandler)te).fill(f.getOpposite(), new FluidStack(this.tank2.getFluid().getFluid(), out), false);
                        FluidStack drained = this.tank2.drain(accepted, true);
                        ((IFluidHandler)te).fill(f.getOpposite(), drained, true);
                    }
                }
            }
            if ((emptyContainer = Utils.drainFluidContainer(this.tank0, this.inventory[0])) != null) {
                if (this.inventory[1] != null && OreDictionary.itemMatches((ItemStack)this.inventory[1], (ItemStack)emptyContainer, (boolean)true)) {
                    this.inventory[1].field_77994_a += emptyContainer.field_77994_a;
                } else if (this.inventory[1] == null) {
                    this.inventory[1] = emptyContainer.func_77946_l();
                }
                this.func_70298_a(0, emptyContainer.field_77994_a);
                update = true;
            }
            if ((emptyContainer = Utils.drainFluidContainer(this.tank1, this.inventory[2])) != null) {
                if (this.inventory[3] != null && OreDictionary.itemMatches((ItemStack)this.inventory[3], (ItemStack)emptyContainer, (boolean)true)) {
                    this.inventory[3].field_77994_a += emptyContainer.field_77994_a;
                } else if (this.inventory[3] == null) {
                    this.inventory[3] = emptyContainer.func_77946_l();
                }
                this.func_70298_a(2, emptyContainer.field_77994_a);
                update = true;
            }
            if (update) {
                this.func_70296_d();
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    public DieselHandler.RefineryRecipe getRecipe() {
        DieselHandler.RefineryRecipe recipe = DieselHandler.findRefineryRecipe(this.tank0.getFluid(), this.tank1.getFluid());
        if (recipe == null) {
            return null;
        }
        if (this.tank2.getFluid() == null || this.tank2.getFluid().isFluidEqual(recipe.output) && this.tank2.getFluidAmount() + recipe.output.amount <= this.tank2.getCapacity()) {
            return recipe;
        }
        return null;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.facing = nbt.func_74762_e("facing");
        this.tank0.readFromNBT(nbt.func_74775_l("tank0"));
        this.tank1.readFromNBT(nbt.func_74775_l("tank1"));
        this.tank2.readFromNBT(nbt.func_74775_l("tank2"));
        this.energyStorage.readFromNBT(nbt);
        if (!descPacket) {
            NBTTagList invList = nbt.func_150295_c("inventory", 10);
            for (int i = 0; i < invList.func_74745_c(); ++i) {
                NBTTagCompound itemTag = invList.func_150305_b(i);
                int slot = itemTag.func_74771_c("Slot") & 0xFF;
                if (slot < 0 || slot >= this.inventory.length) continue;
                this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)itemTag);
            }
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74768_a("facing", this.facing);
        NBTTagCompound tankTag = this.tank0.writeToNBT(new NBTTagCompound());
        nbt.func_74782_a("tank0", (NBTBase)tankTag);
        tankTag = this.tank1.writeToNBT(new NBTTagCompound());
        nbt.func_74782_a("tank1", (NBTBase)tankTag);
        tankTag = this.tank2.writeToNBT(new NBTTagCompound());
        nbt.func_74782_a("tank2", (NBTBase)tankTag);
        this.energyStorage.writeToNBT(nbt);
        if (!descPacket) {
            NBTTagList invList = new NBTTagList();
            for (int i = 0; i < this.inventory.length; ++i) {
                if (this.inventory[i] == null) continue;
                NBTTagCompound itemTag = new NBTTagCompound();
                itemTag.func_74774_a("Slot", (byte)i);
                this.inventory[i].func_77955_b(itemTag);
                invList.func_74742_a((NBTBase)itemTag);
            }
            nbt.func_74782_a("inventory", (NBTBase)invList);
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (!this.formed) {
            return 0;
        }
        if (this.master() != null) {
            if (this.pos != 15 && this.pos != 19) {
                return 0;
            }
            return this.master().fill(from, resource, doFill);
        }
        if (resource != null) {
            int fill = 0;
            if (resource.isFluidEqual(this.tank0.getFluid())) {
                fill = this.tank0.fill(resource, doFill);
            } else if (resource.isFluidEqual(this.tank1.getFluid())) {
                fill = this.tank1.fill(resource, doFill);
            } else if (this.tank0.getFluidAmount() <= 0 && this.tank1.getFluidAmount() <= 0) {
                fill = DieselHandler.findIncompleteRefineryRecipe(resource, null) != null ? this.tank0.fill(resource, doFill) : 0;
            } else if (this.tank0.getFluidAmount() > 0) {
                fill = DieselHandler.findIncompleteRefineryRecipe(resource, this.tank0.getFluid()) != null ? this.tank1.fill(resource, doFill) : 0;
            } else if (this.tank1.getFluidAmount() > 0) {
                fill = DieselHandler.findIncompleteRefineryRecipe(resource, this.tank1.getFluid()) != null ? this.tank0.fill(resource, doFill) : 0;
            }
            this.func_70296_d();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return fill;
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (!this.formed) {
            return null;
        }
        if (this.master() != null) {
            if (this.pos != 2) {
                return null;
            }
            return this.master().drain(from, resource, doDrain);
        }
        if (resource != null) {
            return this.drain(from, resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (!this.formed) {
            return null;
        }
        if (this.master() != null) {
            if (this.pos != 2) {
                return null;
            }
            return this.master().drain(from, maxDrain, doDrain);
        }
        FluidStack drain = this.tank2.drain(maxDrain, doDrain);
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return drain;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (!this.formed) {
            return false;
        }
        return this.pos == 15 || this.pos == 19;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        if (!this.formed) {
            return false;
        }
        return this.pos == 2;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (!this.formed) {
            return new FluidTankInfo[0];
        }
        if (this.master() != null) {
            return this.master().getTankInfo(from);
        }
        return new FluidTankInfo[]{this.tank0.getInfo(), this.tank1.getInfo(), this.tank2.getInfo()};
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.pos == 17) {
            return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - (this.facing == 2 || this.facing == 3 ? 2 : 1)), (double)this.field_145848_d, (double)(this.field_145849_e - (this.facing == 4 || this.facing == 5 ? 2 : 1)), (double)(this.field_145851_c + (this.facing == 2 || this.facing == 3 ? 3 : 2)), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + (this.facing == 4 || this.facing == 5 ? 3 : 2)));
        }
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e);
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return super.func_145833_n() * Config.getDouble("increasedTileRenderdistance");
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.formed && !this.field_145850_b.field_72995_K) {
            int f = this.facing;
            int il = this.pos / 15;
            int ih = this.pos % 15 / 5 - 1;
            int iw = this.pos % 5 - 2;
            int startX = this.field_145851_c - (f == 4 ? il : (f == 5 ? -il : (f == 2 ? -iw : iw)));
            int startY = this.field_145848_d - ih;
            int startZ = this.field_145849_e - (f == 2 ? il : (f == 3 ? -il : (f == 5 ? -iw : iw)));
            for (int l = 0; l < 3; ++l) {
                for (int w = -2; w <= 2; ++w) {
                    for (int h = -1; h <= 1; ++h) {
                        if (w == 0 && (h == 1 || h == 0 && l == 1)) continue;
                        int xx = f == 4 ? l : (f == 5 ? -l : (f == 2 ? -w : w));
                        int yy = h;
                        int zz = f == 2 ? l : (f == 3 ? -l : (f == 5 ? -w : w));
                        ItemStack s = null;
                        TileEntity te = this.field_145850_b.func_147438_o(startX + xx, startY + yy, startZ + zz);
                        if (te instanceof TileEntityRefinery) {
                            s = ((TileEntityRefinery)te).getOriginalBlock();
                            ((TileEntityRefinery)te).formed = false;
                        }
                        if (startX + xx == this.field_145851_c && startY + yy == this.field_145848_d && startZ + zz == this.field_145849_e) {
                            s = this.getOriginalBlock();
                        }
                        if (s == null || Block.func_149634_a((Item)s.func_77973_b()) == null) continue;
                        if (startX + xx == this.field_145851_c && startY + yy == this.field_145848_d && startZ + zz == this.field_145849_e) {
                            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, s));
                            continue;
                        }
                        if (Block.func_149634_a((Item)s.func_77973_b()) == IEContent.blockMetalMultiblocks) {
                            this.field_145850_b.func_147468_f(startX + xx, startY + yy, startZ + zz);
                        }
                        this.field_145850_b.func_147465_d(startX + xx, startY + yy, startZ + zz, Block.func_149634_a((Item)s.func_77973_b()), s.func_77960_j(), 3);
                    }
                }
            }
        }
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return this.formed && this.pos == 37 && ForgeDirection.getOrientation((int)this.facing).getOpposite().equals((Object)from);
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (this.formed && this.pos == 37 && this.master() != null && ForgeDirection.getOrientation((int)this.facing).getOpposite().equals((Object)from)) {
            TileEntityRefinery master = this.master();
            int rec = master.energyStorage.receiveEnergy(maxReceive, simulate);
            master.func_70296_d();
            if (rec > 0) {
                this.field_145850_b.func_147471_g(this.master().field_145851_c, this.master().field_145848_d, this.master().field_145849_e);
            }
            return rec;
        }
        return 0;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        if (this.master() != null) {
            return this.master().energyStorage.getEnergyStored();
        }
        return this.energyStorage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        if (this.master() != null) {
            return this.master().energyStorage.getMaxEnergyStored();
        }
        return this.energyStorage.getMaxEnergyStored();
    }

    public int func_70302_i_() {
        if (!this.formed) {
            return 0;
        }
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slot) {
        if (!this.formed) {
            return null;
        }
        if (this.master() != null) {
            return this.master().func_70301_a(slot);
        }
        if (slot < this.inventory.length) {
            return this.inventory[slot];
        }
        return null;
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (!this.formed) {
            return null;
        }
        if (this.master() != null) {
            return this.master().func_70298_a(slot, amount);
        }
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a <= amount) {
                this.func_70299_a(slot, null);
            } else {
                stack = stack.func_77979_a(amount);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return stack;
    }

    public ItemStack func_70304_b(int slot) {
        if (!this.formed) {
            return null;
        }
        if (this.master() != null) {
            return this.master().func_70304_b(slot);
        }
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            this.func_70299_a(slot, null);
        }
        return stack;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (!this.formed) {
            return;
        }
        if (this.master() != null) {
            this.master().func_70299_a(slot, stack);
            return;
        }
        this.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "IERefinery";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : this.formed && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (!this.formed) {
            return false;
        }
        if (this.master() != null) {
            return this.master().func_94041_b(slot, stack);
        }
        if (slot == 1 || slot == 3 || slot == 5) {
            return false;
        }
        if (slot == 4) {
            return this.tank2.getFluidAmount() <= 0 ? FluidContainerRegistry.isEmptyContainer((ItemStack)stack) : FluidContainerRegistry.fillFluidContainer((FluidStack)this.tank2.getFluid(), (ItemStack)Utils.copyStackWithAmount(stack, 1)) != null;
        }
        FluidStack fs = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
        if (fs == null) {
            return false;
        }
        DieselHandler.RefineryRecipe partialRecipe = DieselHandler.findIncompleteRefineryRecipe(fs, null);
        if (partialRecipe == null) {
            return false;
        }
        if (slot == 0) {
            return !(this.tank0.getFluidAmount() > 0 && !fs.isFluidEqual(this.tank0.getFluid()) || this.tank1.getFluidAmount() > 0 && DieselHandler.findIncompleteRefineryRecipe(fs, this.tank1.getFluid()) == null);
        }
        if (slot == 2) {
            return !(this.tank1.getFluidAmount() > 0 && !fs.isFluidEqual(this.tank1.getFluid()) || this.tank0.getFluidAmount() > 0 && DieselHandler.findIncompleteRefineryRecipe(fs, this.tank0.getFluid()) == null);
        }
        return false;
    }

    public int[] func_94128_d(int side) {
        if (!this.formed) {
            return new int[0];
        }
        if (this.master() != null) {
            return this.master().func_94128_d(side);
        }
        return new int[]{0, 1, 2, 3, 4, 5};
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        if (!this.formed) {
            return false;
        }
        if (this.master() != null) {
            return this.master().func_102007_a(slot, stack, side);
        }
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        if (!this.formed) {
            return false;
        }
        if (this.master() != null) {
            return this.master().func_102008_b(slot, stack, side);
        }
        return slot == 1 || slot == 3 || slot == 5;
    }
}

