/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockPart;
import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityLightningRod
extends TileEntityMultiblockPart
implements IEnergyProvider {
    public EnergyStorage energyStorage = new EnergyStorage(Config.getInt("lightning_output"));
    ArrayList<ChunkCoordinates> fenceNet = null;
    int height;

    public static boolean _Immovable() {
        return true;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K && this.formed && this.pos == 4) {
            if (this.energyStorage.getEnergyStored() > 0) {
                for (ForgeDirection fd : new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.EAST, ForgeDirection.WEST}) {
                    TileEntity tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c + fd.offsetX * 2, this.field_145848_d, this.field_145849_e + fd.offsetZ * 2);
                    if (!(tileEntity instanceof IEnergyReceiver)) continue;
                    IEnergyReceiver ier = (IEnergyReceiver)tileEntity;
                    int accepted = ier.receiveEnergy(fd.getOpposite(), this.energyStorage.getEnergyStored(), true);
                    int extracted = this.energyStorage.extractEnergy(accepted, false);
                    ier.receiveEnergy(fd.getOpposite(), extracted, false);
                }
            }
            if (this.field_145850_b.func_82737_E() % 256L == (long)((this.field_145851_c ^ this.field_145849_e) & 0xFF)) {
                this.fenceNet = null;
            }
            if (this.fenceNet == null) {
                this.fenceNet = this.getFenceNet();
            }
            if (this.fenceNet != null && this.field_145850_b.func_82737_E() % 128L == (long)((this.field_145851_c ^ this.field_145849_e) & 0x7F) && (this.field_145850_b.func_72911_I() || this.field_145850_b.func_72896_J() && this.field_145850_b.field_73012_v.nextInt(10) == 0)) {
                int i = this.height + this.fenceNet.size();
                if (this.field_145850_b.field_73012_v.nextInt(4096 * this.field_145850_b.func_72800_K()) < i * (this.field_145848_d + i)) {
                    this.energyStorage.setEnergyStored(Config.getInt("lightning_output"));
                    ChunkCoordinates cc = this.fenceNet.get(this.field_145850_b.field_73012_v.nextInt(this.fenceNet.size()));
                    EntityLightningBolt entityLightningBolt = new EntityLightningBolt(this.field_145850_b, (double)cc.field_71574_a, (double)cc.field_71572_b, (double)cc.field_71573_c);
                    this.field_145850_b.func_72942_c((Entity)entityLightningBolt);
                    this.field_145850_b.func_72838_d((Entity)entityLightningBolt);
                }
            }
        }
    }

    ArrayList<ChunkCoordinates> getFenceNet() {
        this.height = 0;
        boolean broken = false;
        for (int i = this.field_145848_d + 1; i < this.field_145850_b.func_72800_K() - 1; ++i) {
            if (!broken && this.field_145850_b.func_147439_a(this.field_145851_c, i, this.field_145849_e).equals((Object)IEContent.blockMetalDecoration) && this.field_145850_b.func_72805_g(this.field_145851_c, i, this.field_145849_e) == 0) {
                ++this.height;
                continue;
            }
            if (!this.field_145850_b.func_147437_c(this.field_145851_c, i, this.field_145849_e)) {
                return null;
            }
            if (broken) continue;
            broken = true;
        }
        ArrayList<ChunkCoordinates> openList = new ArrayList<ChunkCoordinates>();
        ArrayList<ChunkCoordinates> closedList = new ArrayList<ChunkCoordinates>();
        openList.add(new ChunkCoordinates(this.field_145851_c, this.field_145848_d + this.height, this.field_145849_e));
        while (!openList.isEmpty() && closedList.size() < 256) {
            ChunkCoordinates next = (ChunkCoordinates)openList.get(0);
            if (!closedList.contains(next) && this.field_145850_b.func_147439_a(next.field_71574_a, next.field_71572_b, next.field_71573_c).equals((Object)IEContent.blockMetalDecoration) && this.field_145850_b.func_72805_g(next.field_71574_a, next.field_71572_b, next.field_71573_c) == 0) {
                closedList.add(next);
                openList.add(new ChunkCoordinates(next.field_71574_a + 1, next.field_71572_b, next.field_71573_c));
                openList.add(new ChunkCoordinates(next.field_71574_a - 1, next.field_71572_b, next.field_71573_c));
                openList.add(new ChunkCoordinates(next.field_71574_a, next.field_71572_b, next.field_71573_c + 1));
                openList.add(new ChunkCoordinates(next.field_71574_a, next.field_71572_b, next.field_71573_c - 1));
                openList.add(new ChunkCoordinates(next.field_71574_a, next.field_71572_b + 1, next.field_71573_c));
            }
            openList.remove(0);
        }
        return closedList;
    }

    @Override
    public TileEntityLightningRod master() {
        if (this.offset[0] == 0 && this.offset[1] == 0 && this.offset[2] == 0) {
            return null;
        }
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c - this.offset[0], this.field_145848_d - this.offset[1], this.field_145849_e - this.offset[2]);
        return te instanceof TileEntityLightningRod ? (TileEntityLightningRod)te : null;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.energyStorage.readFromNBT(nbt);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        this.energyStorage.writeToNBT(nbt);
    }

    public boolean func_145842_c(int id, int arg) {
        if (id == 0) {
            this.formed = arg == 1;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        return false;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        ForgeDirection fd = this.pos == 1 ? ForgeDirection.NORTH : (this.pos == 7 ? ForgeDirection.SOUTH : (this.pos == 3 ? ForgeDirection.EAST : ForgeDirection.WEST));
        return from == fd.getOpposite();
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        if (this.master() != null) {
            return this.master().energyStorage.extractEnergy(maxExtract, simulate);
        }
        return this.energyStorage.extractEnergy(maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        if (this.master() != null) {
            return this.master().getEnergyStored(from);
        }
        return this.energyStorage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        if (this.master() != null) {
            return this.master().getMaxEnergyStored(from);
        }
        return this.energyStorage.getMaxEnergyStored();
    }

    @Override
    public ItemStack getOriginalBlock() {
        return new ItemStack((Block)IEContent.blockMetalMultiblocks, 1, 0);
    }

    @Override
    public float[] getBlockBounds() {
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.formed && !this.field_145850_b.field_72995_K) {
            TileEntityLightningRod master = this.master();
            if (master == null) {
                master = this;
            }
            for (int l = -1; l <= 1; ++l) {
                for (int w = -1; w <= 1; ++w) {
                    int xx = master.field_145851_c + w;
                    int yy = master.field_145848_d;
                    int zz = master.field_145849_e + l;
                    ItemStack s = null;
                    TileEntity te = this.field_145850_b.func_147438_o(xx, yy, zz);
                    if (te instanceof TileEntityLightningRod) {
                        s = ((TileEntityLightningRod)te).getOriginalBlock();
                        ((TileEntityLightningRod)te).formed = false;
                    }
                    if (xx == this.field_145851_c && yy == this.field_145848_d && zz == this.field_145849_e) {
                        s = this.getOriginalBlock();
                    }
                    if (s == null || Block.func_149634_a((Item)s.func_77973_b()) == null) continue;
                    if (xx == this.field_145851_c && yy == this.field_145848_d && zz == this.field_145849_e) {
                        this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, s));
                        continue;
                    }
                    if (Block.func_149634_a((Item)s.func_77973_b()) == IEContent.blockMetalMultiblocks) {
                        this.field_145850_b.func_147468_f(xx, yy, zz);
                    }
                    this.field_145850_b.func_147465_d(xx, yy, zz, Block.func_149634_a((Item)s.func_77973_b()), s.func_77960_j(), 3);
                    this.field_145850_b.func_147452_c(xx, yy, zz, (Block)IEContent.blockMetalMultiblocks, 0, 0);
                }
            }
        }
    }
}

