/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.DirectionalChunkCoords;
import blusunrize.immersiveengineering.api.fluid.PipeConnection;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableSortedMap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityFluidPipe_old
extends TileEntityIEBase
implements IEBlockInterfaces.IBlockOverlayText {
    public static int MODE_NORMAL = 0;
    public static int MODE_INPUT = 1;
    public static int MODE_OUTPUT = 2;
    public HashSet<PipeConnection> connections = new HashSet();
    public int mode = 0;
    protected int cooldown = 5;

    public void func_145845_h() {
        if (this.func_145830_o() && !this.func_145837_r() && !this.field_145850_b.field_72995_K && this.mode == MODE_INPUT && this.cooldown-- == 0) {
            this.cooldown = 5;
            HashMap<DirectionalChunkCoords, Integer> tanks = null;
            ImmutableSortedMap sortedTanks = null;
            for (PipeConnection connection : this.connections) {
                FluidStack insert;
                TileEntity tankTile = connection.getEndTile(this.field_145850_b);
                if (!PipeConnection.isTank(tankTile, connection.direction.getOpposite())) continue;
                if (tanks == null) {
                    tanks = this.getAllTanks();
                    sortedTanks = ImmutableSortedMap.copyOf(tanks, (Comparator)new DistanceComparator(tanks));
                }
                if ((insert = ((IFluidHandler)tankTile).drain(connection.direction.getOpposite(), 500, false)) == null) break;
                int initAmount = insert.amount;
                insert = insert.copy();
                for (DirectionalChunkCoords tankCoords : sortedTanks.keySet()) {
                    TileEntity tileEntity;
                    if (tankCoords.field_71574_a == this.field_145851_c && tankCoords.field_71572_b == this.field_145848_d && tankCoords.field_71573_c == this.field_145849_e || !((tileEntity = tankCoords.getTile(this.field_145850_b)) instanceof IFluidHandler)) continue;
                    insert.amount -= ((IFluidHandler)tileEntity).fill(tankCoords.direction, insert, true);
                    if (insert.amount != 0) continue;
                    break;
                }
                ((IFluidHandler)tankTile).drain(connection.direction.getOpposite(), initAmount - insert.amount, true);
            }
        }
    }

    public HashMap<DirectionalChunkCoords, Integer> getAllTanks() {
        HashSet<String> traversed = new HashSet<String>();
        HashMap<DirectionalChunkCoords, Integer> tanks = new HashMap<DirectionalChunkCoords, Integer>();
        traversed.add(this.field_145851_c + ":" + this.field_145848_d + ":" + this.field_145849_e);
        this.getAllTanks(traversed, tanks, 1);
        traversed.clear();
        return tanks;
    }

    public void getAllTanks(HashSet<String> traversed, HashMap<DirectionalChunkCoords, Integer> tanksMap, int depth) {
        for (PipeConnection connection : this.connections) {
            String strCon = connection.to.field_71574_a + ":" + connection.to.field_71572_b + ":" + connection.to.field_71573_c;
            if (traversed.contains(strCon)) continue;
            traversed.add(strCon);
            TileEntity tileEntity = this.field_145850_b.func_147438_o(connection.to.field_71574_a, connection.to.field_71572_b, connection.to.field_71573_c);
            if (tileEntity instanceof TileEntityFluidPipe_old) {
                ((TileEntityFluidPipe_old)tileEntity).getAllTanks(traversed, tanksMap, depth + 1);
                continue;
            }
            if (this.mode != MODE_OUTPUT || !PipeConnection.isTank(tileEntity, connection.direction.getOpposite())) continue;
            tanksMap.put(Utils.toDirCC(tileEntity, connection.direction.getOpposite()), depth);
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.mode = nbt.func_74762_e("PipeMode");
        NBTTagList connectionTags = nbt.func_150295_c("PipeConnections", 10);
        HashSet<PipeConnection> newConnections = new HashSet<PipeConnection>();
        for (int i = 0; i < connectionTags.func_74745_c(); ++i) {
            newConnections.add(PipeConnection.fromNBT(connectionTags.func_150305_b(i)));
        }
        this.connections = newConnections;
        if (descPacket) {
            this.field_145850_b.func_147458_c(this.field_145851_c - 1, this.field_145848_d - 1, this.field_145849_e - 1, this.field_145851_c + 1, this.field_145848_d + 1, this.field_145849_e + 1);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.func_74768_a("PipeMode", this.mode);
        NBTTagList connectionTags = new NBTTagList();
        for (PipeConnection connection : this.connections) {
            connectionTags.func_74742_a((NBTBase)connection.toNBT());
        }
        nbt.func_74782_a("PipeConnections", (NBTBase)connectionTags);
    }

    public void func_145843_s() {
        super.func_145843_s();
        for (PipeConnection connection : this.connections) {
            TileEntity connectedTE = this.field_145850_b.func_147438_o(connection.to.field_71574_a, connection.to.field_71572_b, connection.to.field_71573_c);
            if (!(connectedTE instanceof TileEntityFluidPipe_old)) continue;
            TileEntityFluidPipe_old fluidPipe = (TileEntityFluidPipe_old)connectedTE;
            HashSet<PipeConnection> connectionsToRemove = new HashSet<PipeConnection>();
            for (PipeConnection con : fluidPipe.connections) {
                if (!con.to.equals((Object)connection.from)) continue;
                connectionsToRemove.add(con);
            }
            for (PipeConnection remove : connectionsToRemove) {
                fluidPipe.connections.remove(remove);
            }
            fluidPipe.func_70296_d();
            this.field_145850_b.func_147471_g(connection.to.field_71574_a, connection.to.field_71572_b, connection.to.field_71573_c);
        }
    }

    @Override
    public String[] getOverlayText(EntityPlayer player, MovingObjectPosition mop, boolean hammer) {
        return new String[]{"Mode: " + (this.mode == 0 ? "Normal" : (this.mode == 1 ? "Input" : "Output")), "Connections: " + this.connections.size()};
    }

    public byte getConnections() {
        byte connections = 0;
        for (PipeConnection connection : this.connections) {
            if (connection.direction == ForgeDirection.UNKNOWN) continue;
            connections = (byte)(connections | 1 << connection.direction.ordinal());
        }
        return connections;
    }

    private class DistanceComparator
    implements Comparator<DirectionalChunkCoords> {
        protected Map<DirectionalChunkCoords, Integer> base;

        public DistanceComparator(Map<DirectionalChunkCoords, Integer> base) {
            this.base = base;
        }

        @Override
        public int compare(DirectionalChunkCoords dirA, DirectionalChunkCoords dirB) {
            if (this.base.get((Object)dirA) < this.base.get((Object)dirB)) {
                return -1;
            }
            return 1;
        }
    }
}

