/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.energy.DieselHandler;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.blocks.multiblocks.MultiblockDieselGenerator;
import blusunrize.immersiveengineering.common.util.IESound;
import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityDieselGenerator
extends TileEntityMultiblockPart
implements IFluidHandler,
IEBlockInterfaces.ISoundTile,
IEnergyConnection {
    public int facing = 2;
    public FluidTank tank = new FluidTank(8000);
    public boolean active = false;
    public float fanRotationStep = 0.0f;
    public float fanRotation = 0.0f;
    public int fanFadeIn = 0;
    public int fanFadeOut = 0;
    static IESound sound;

    @Override
    public TileEntityDieselGenerator master() {
        if (this.offset[0] == 0 && this.offset[1] == 0 && this.offset[2] == 0) {
            return null;
        }
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c - this.offset[0], this.field_145848_d - this.offset[1], this.field_145849_e - this.offset[2]);
        return te instanceof TileEntityDieselGenerator ? (TileEntityDieselGenerator)te : null;
    }

    public static boolean _Immovable() {
        return true;
    }

    @Override
    public ItemStack getOriginalBlock() {
        if (this.pos < 0) {
            return null;
        }
        ItemStack s = MultiblockDieselGenerator.instance.getStructureManual()[this.pos % 9 / 3][4 - this.pos / 9][this.pos % 3];
        return s != null ? s.func_77946_l() : null;
    }

    public void func_145845_h() {
        if (!this.formed || this.pos != 31) {
            return;
        }
        if (this.active || this.fanFadeIn > 0 || this.fanFadeOut > 0) {
            float step;
            float base = 18.0f;
            float f = step = this.active ? base : 0.0f;
            if (this.fanFadeIn > 0) {
                step -= (float)this.fanFadeIn / 80.0f * base;
                --this.fanFadeIn;
            }
            if (this.fanFadeOut > 0) {
                step += (float)this.fanFadeOut / 80.0f * base;
                --this.fanFadeOut;
            }
            this.fanRotationStep = step;
            this.fanRotation += step;
            this.fanRotation %= 360.0f;
        }
        if (this.field_145850_b.field_72995_K) {
            ImmersiveEngineering.proxy.handleTileSound("dieselGenerator", this, this.active, 0.5f, 1.0f);
            if (this.active && this.field_145850_b.func_82737_E() % 4L == 0L) {
                this.field_145850_b.func_72869_a("largesmoke", (double)this.field_145851_c + 0.5 + (this.facing == 4 ? 1.25 : (this.facing == 5 ? -1.25 : (this.facing == (this.mirrored ? 2 : 3) ? 0.625 : -0.625))), (double)this.field_145848_d + 2.25, (double)this.field_145849_e + 0.5 + (this.facing == 2 ? 1.25 : (this.facing == 3 ? -1.25 : (this.facing == (this.mirrored ? 5 : 4) ? 0.625 : -0.625))), 0.0, 0.0, 0.0);
            }
        } else {
            boolean prevActive = this.active;
            boolean rs = this.field_145850_b.func_72864_z(this.field_145851_c + (this.facing == 4 || this.facing == (this.mirrored ? 2 : 3) ? 1 : -1), this.field_145848_d, this.field_145849_e + (this.facing == 2 || this.facing == (this.mirrored ? 5 : 4) ? 1 : -1));
            if (!rs && this.tank.getFluid() != null && this.tank.getFluid().getFluid() != null) {
                int burnTime = DieselHandler.getBurnTime(this.tank.getFluid().getFluid());
                int fluidConsumed = 1000 / burnTime;
                int output = Config.getInt("dieselGen_output");
                int connected = 0;
                for (int i = 0; i < 3; ++i) {
                    IEnergyReceiver receiver = this.getOutput(i == 1 ? -1 : (i == 2 ? 1 : 0));
                    if (receiver == null || !receiver.canConnectEnergy(ForgeDirection.DOWN) || receiver.receiveEnergy(ForgeDirection.DOWN, 4096, true) <= 0) continue;
                    ++connected;
                }
                if (connected > 0 && this.tank.getFluidAmount() >= fluidConsumed) {
                    if (!this.active) {
                        this.active = true;
                        this.fanFadeIn = 80;
                    }
                    this.tank.drain(fluidConsumed, true);
                    int splitOutput = output / connected;
                    for (int i = 0; i < 3; ++i) {
                        IEnergyReceiver receiver = this.getOutput(i == 1 ? -1 : (i == 2 ? 1 : 0));
                        if (receiver == null || !receiver.canConnectEnergy(ForgeDirection.DOWN)) continue;
                        receiver.receiveEnergy(ForgeDirection.DOWN, splitOutput, false);
                    }
                } else if (this.active) {
                    this.active = false;
                    this.fanFadeOut = 80;
                }
            } else if (this.active) {
                this.active = false;
                this.fanFadeOut = 80;
            }
            if (prevActive != this.active) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    IEnergyReceiver getOutput(int w) {
        TileEntity eTile = this.field_145850_b.func_147438_o(this.field_145851_c + (this.facing == 4 ? -1 : (this.facing == 5 ? 1 : w)), this.field_145848_d + 1, this.field_145849_e + (this.facing == 2 ? -1 : (this.facing == 3 ? 1 : w)));
        if (eTile != null && eTile instanceof IEnergyReceiver) {
            return (IEnergyReceiver)eTile;
        }
        return null;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.facing = nbt.func_74762_e("facing");
        this.active = nbt.func_74767_n("active");
        this.fanRotation = nbt.func_74760_g("fanRotation");
        this.fanFadeIn = nbt.func_74762_e("fanFadeIn");
        this.fanFadeOut = nbt.func_74762_e("fanFadeOut");
        this.tank.readFromNBT(nbt.func_74775_l("tank"));
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74768_a("facing", this.facing);
        nbt.func_74757_a("active", this.active);
        nbt.func_74776_a("fanRotation", this.fanRotation);
        nbt.func_74768_a("fanFadeIn", this.fanFadeIn);
        nbt.func_74768_a("fanFadeOut", this.fanFadeOut);
        NBTTagCompound tankTag = this.tank.writeToNBT(new NBTTagCompound());
        nbt.func_74782_a("tank", (NBTBase)tankTag);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (!this.formed) {
            return 0;
        }
        if (this.master() != null) {
            if (this.pos != 36 && this.pos != 38) {
                return 0;
            }
            return this.master().fill(from, resource, doFill);
        }
        if (resource != null && DieselHandler.isValidFuel(resource.getFluid())) {
            int f = this.tank.fill(resource, doFill);
            return f;
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (!this.canDrain(from, resource != null ? resource.getFluid() : null)) {
            return null;
        }
        if (this.master() != null) {
            if (this.pos != 36 && this.pos != 38) {
                return null;
            }
            return this.master().drain(from, resource, doDrain);
        }
        if (resource != null) {
            return this.drain(from, resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (!this.formed) {
            return null;
        }
        if (this.master() != null) {
            if (this.pos != 36 && this.pos != 38) {
                return null;
            }
            return this.master().drain(from, maxDrain, doDrain);
        }
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.formed && (this.pos == 36 || this.pos == 38) && DieselHandler.isValidFuel(fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.formed && (this.pos == 36 || this.pos == 38);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (!this.formed) {
            return new FluidTankInfo[0];
        }
        if (this.master() != null) {
            return this.master().getTankInfo(from);
        }
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.pos == 31) {
            return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - (this.facing == 5 ? 3 : 1)), (double)(this.field_145848_d - 1), (double)(this.field_145849_e - (this.facing == 3 ? 3 : 1)), (double)(this.field_145851_c + (this.facing == 4 ? 4 : 2)), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + (this.facing == 2 ? 4 : 2)));
        }
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e);
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return super.func_145833_n() * Config.getDouble("increasedTileRenderdistance");
    }

    @Override
    public float[] getBlockBounds() {
        boolean mirror;
        boolean bl = mirror = this.master() != null ? this.master().mirrored : this.mirrored;
        if (this.pos >= 3 && this.pos < 36) {
            float height;
            float f = this.pos == 24 || this.pos == 26 ? 1.0f : (height = this.pos % 9 >= 6 && this.pos > 9 ? 0.375f : 1.0f);
            if (this.pos == 9 || this.pos == 11 || this.pos == 27 || this.pos == 29) {
                return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
            }
            if (this.pos == 34) {
                return new float[]{this.facing == 4 ? 0.375f : 0.0f, 0.0f, this.facing == 2 ? 0.375f : 0.0f, this.facing == 5 ? 0.625f : 1.0f, height, this.facing == 3 ? 0.625f : 1.0f};
            }
            if (this.pos % 9 == 0 || this.pos % 9 == 3 || this.pos % 9 == 6) {
                if (this.pos == 33) {
                    float[] fArray = new float[6];
                    fArray[0] = this.facing == 2 ? 0.5f : (this.facing == 4 ? 0.375f : 0.0f);
                    fArray[1] = 0.0f;
                    float f2 = this.facing == 5 ? 0.5f : (fArray[2] = this.facing == 2 ? 0.375f : 0.0f);
                    fArray[3] = this.facing == 3 ? 0.5f : (this.facing == 5 ? 0.625f : 1.0f);
                    fArray[4] = height;
                    fArray[5] = this.facing == 4 ? 0.5f : (this.facing == 3 ? 0.625f : 1.0f);
                    return fArray;
                }
                if (this.pos == 18) {
                    return new float[]{this.facing == 2 ? 0.4375f : 0.0f, 0.0f, this.facing == 5 ? 0.4375f : 0.0f, this.facing == 3 ? 0.5625f : 1.0f, height, this.facing == 4 ? 0.5625f : 1.0f};
                }
                if (this.pos == 21 && !mirror) {
                    return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
                }
                return new float[]{this.facing == 2 ? 0.5f : 0.0f, 0.0f, this.facing == 5 ? 0.5f : 0.0f, this.facing == 3 ? 0.5f : 1.0f, height, this.facing == 4 ? 0.5f : 1.0f};
            }
            if (this.pos % 9 == 2 || this.pos % 9 == 5 || this.pos % 9 == 8) {
                if (this.pos == 35) {
                    float[] fArray = new float[6];
                    fArray[0] = this.facing == 3 ? 0.5f : (this.facing == 4 ? 0.375f : 0.0f);
                    fArray[1] = 0.0f;
                    float f3 = this.facing == 4 ? 0.5f : (fArray[2] = this.facing == 2 ? 0.375f : 0.0f);
                    fArray[3] = this.facing == 2 ? 0.5f : (this.facing == 5 ? 0.625f : 1.0f);
                    fArray[4] = height;
                    fArray[5] = this.facing == 5 ? 0.5f : (this.facing == 3 ? 0.625f : 1.0f);
                    return fArray;
                }
                if (this.pos == 20) {
                    return new float[]{this.facing == 3 ? 0.4375f : 0.0f, 0.0f, this.facing == 4 ? 0.4375f : 0.0f, this.facing == 2 ? 0.5625f : 1.0f, height, this.facing == 5 ? 0.5625f : 1.0f};
                }
                if (this.pos == 23 && mirror) {
                    return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
                }
                return new float[]{this.facing == 3 ? 0.5f : 0.0f, 0.0f, this.facing == 4 ? 0.5f : 0.0f, this.facing == 2 ? 0.5f : 1.0f, height, this.facing == 5 ? 0.5f : 1.0f};
            }
            return new float[]{0.0f, 0.0f, 0.0f, 1.0f, height, 1.0f};
        }
        if (this.pos == 36 || this.pos == 38) {
            return new float[]{this.facing == (this.pos == 36 ? 3 : 2) ? 0.5f : 0.0f, 0.0f, this.facing == (this.pos == 36 ? 4 : 5) ? 0.5f : 0.0f, this.facing == (this.pos == 36 ? 2 : 3) ? 0.5f : 1.0f, 1.0f, this.facing == (this.pos == 36 ? 5 : 4) ? 0.5f : 1.0f};
        }
        if (this.pos == 37) {
            return new float[]{0.0f, 0.5f, 0.0f, 1.0f, 1.0f, 1.0f};
        }
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    public void func_145843_s() {
        super.func_145843_s();
        ImmersiveEngineering.proxy.stopTileSound("dieselGenerator", this);
        if (this.formed && !this.field_145850_b.field_72995_K) {
            int f = this.facing;
            int il = this.pos / 9;
            int ih = this.pos % 9 / 3 - 1;
            int iw = this.pos % 3 - 1;
            int startX = this.field_145851_c - (f == 5 ? il : (f == 4 ? -il : (f == 2 ? iw : -iw)));
            int startY = this.field_145848_d - ih;
            int startZ = this.field_145849_e - (f == 3 ? il : (f == 2 ? -il : (f == 5 ? iw : -iw)));
            for (int l = 0; l < 5; ++l) {
                for (int w = -1; w <= 1; ++w) {
                    for (int h = -1; h <= (l == 4 ? 0 : 1); ++h) {
                        int xx = f == 5 ? l : (f == 4 ? -l : (f == 2 ? -w : w));
                        int yy = h;
                        int zz = f == 3 ? l : (f == 2 ? -l : (f == 5 ? -w : w));
                        ItemStack s = null;
                        TileEntity te = this.field_145850_b.func_147438_o(startX + xx, startY + yy, startZ + zz);
                        if (te instanceof TileEntityDieselGenerator) {
                            s = ((TileEntityDieselGenerator)te).getOriginalBlock();
                            ((TileEntityDieselGenerator)te).formed = false;
                        }
                        if (startX + xx == this.field_145851_c && startY + yy == this.field_145848_d && startZ + zz == this.field_145849_e) {
                            s = this.getOriginalBlock();
                        }
                        if (s == null || Block.func_149634_a((Item)s.func_77973_b()) == null) continue;
                        if (startX + xx == this.field_145851_c && startY + yy == this.field_145848_d && startZ + zz == this.field_145849_e) {
                            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, s));
                            continue;
                        }
                        if (Block.func_149634_a((Item)s.func_77973_b()) == IEContent.blockMetalMultiblocks) {
                            this.field_145850_b.func_147468_f(startX + xx, startY + yy, startZ + zz);
                        }
                        this.field_145850_b.func_147465_d(startX + xx, startY + yy, startZ + zz, Block.func_149634_a((Item)s.func_77973_b()), s.func_77960_j(), 3);
                    }
                }
            }
        }
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return this.pos >= 38 && this.pos <= 41 && from == ForgeDirection.UP;
    }
}

