/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.crafting.BottlingMachineRecipe;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityConveyorBelt;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.blocks.multiblocks.MultiblockBottlingMachine;
import blusunrize.immersiveengineering.common.util.Utils;
import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityBottlingMachine
extends TileEntityMultiblockPart
implements ISidedInventory,
IEnergyReceiver,
IFluidHandler {
    public int facing = 2;
    public EnergyStorage energyStorage = new EnergyStorage(16000);
    public ItemStack[] inventory = new ItemStack[5];
    public int[] process = new int[5];
    public FluidTank tank = new FluidTank(32000);
    public ItemStack[] predictedOutput = new ItemStack[5];

    @Override
    public TileEntityBottlingMachine master() {
        if (this.offset[0] == 0 && this.offset[1] == 0 && this.offset[2] == 0) {
            return null;
        }
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c - this.offset[0], this.field_145848_d - this.offset[1], this.field_145849_e - this.offset[2]);
        return te instanceof TileEntityBottlingMachine ? (TileEntityBottlingMachine)te : null;
    }

    @Override
    public ItemStack getOriginalBlock() {
        if (this.pos < 0) {
            return null;
        }
        ItemStack s = MultiblockBottlingMachine.instance.getStructureManual()[this.pos / 6][1 - this.pos % 6 / 3][this.pos % 3];
        return s != null ? s.func_77946_l() : null;
    }

    public void func_145845_h() {
        if (!this.formed || this.pos != 4) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean update = false;
        int consumed = Config.getInt("bottlingMachine_consumption");
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            if (this.process[i] > 72) {
                if (this.energyStorage.extractEnergy(consumed, true) == consumed) {
                    this.energyStorage.extractEnergy(consumed, false);
                    int n = i;
                    this.process[n] = this.process[n] + 1;
                }
            } else {
                ItemStack filled = this.getFilledItem(this.inventory[i], false);
                if (this.energyStorage.extractEnergy(consumed, true) == consumed) {
                    if (this.predictedOutput[i] == null || !OreDictionary.itemMatches((ItemStack)filled, (ItemStack)this.predictedOutput[i], (boolean)true)) {
                        this.predictedOutput[i] = filled;
                    }
                    this.energyStorage.extractEnergy(consumed, false);
                    if (this.process[i] == 0) {
                        update = true;
                    }
                    int n = i;
                    this.process[n] = this.process[n] + 1;
                    if (filled != null && this.process[i] > 72) {
                        this.inventory[i] = this.getFilledItem(this.inventory[i], true).func_77946_l();
                    }
                }
            }
            if (this.process[i] <= 120) continue;
            ItemStack output = this.inventory[i].func_77946_l();
            TileEntity invOutput = this.field_145850_b.func_147438_o(this.field_145851_c + (this.facing == 4 ? 1 : (this.facing == 5 ? -1 : (this.mirrored ? -1 : 1) * (this.facing == 3 ? 1 : -1))), this.field_145848_d + 1, this.field_145849_e + (this.facing == 2 ? 1 : (this.facing == 3 ? -1 : (this.mirrored ? -1 : 1) * (this.facing == 4 ? 1 : -1))));
            if (invOutput instanceof ISidedInventory && ((ISidedInventory)invOutput).func_94128_d(this.facing).length > 0 || invOutput instanceof IInventory && ((IInventory)invOutput).func_70302_i_() > 0) {
                output = Utils.insertStackIntoInventory((IInventory)invOutput, output, this.facing);
            }
            if (output != null) {
                ForgeDirection fd = ForgeDirection.getOrientation((int)this.facing);
                EntityItem ei = new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5 + (double)(this.facing == 4 ? 1 : (this.facing == 5 ? -1 : (this.mirrored ? -1 : 1) * (this.facing == 3 ? 1 : -1))), (double)(this.field_145848_d + 1) + 0.25, (double)this.field_145849_e + 0.5 + (double)(this.facing == 2 ? 1 : (this.facing == 3 ? -1 : (this.mirrored ? -1 : 1) * (this.facing == 4 ? 1 : -1))), output.func_77946_l());
                ei.field_70159_w = 0.075f * (float)fd.offsetX;
                ei.field_70181_x = 0.025000000372529;
                ei.field_70179_y = 0.075f * (float)fd.offsetZ;
                this.field_145850_b.func_72838_d((Entity)ei);
            }
            this.process[i] = -1;
            this.inventory[i] = null;
            this.predictedOutput[i] = null;
            update = true;
        }
        if (update) {
            this.func_70296_d();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public int getNextProcessID() {
        if (this.master() != null) {
            return this.master().getNextProcessID();
        }
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] != null) continue;
            int lowestProcess = 200;
            for (int j = 0; j < this.inventory.length; ++j) {
                if (this.inventory[j] == null || this.process[j] >= lowestProcess) continue;
                lowestProcess = this.process[j];
            }
            if (lowestProcess == 200 || lowestProcess > 24) {
                return i;
            }
            return -1;
        }
        return -1;
    }

    public ItemStack getFilledItem(ItemStack empty, boolean drainTank) {
        int accepted;
        if (empty == null || this.tank.getFluid() == null) {
            return null;
        }
        BottlingMachineRecipe recipe = BottlingMachineRecipe.findRecipe(empty, this.tank.getFluid());
        if (recipe != null && recipe.output != null) {
            if (drainTank) {
                this.tank.drain(recipe.fluidInput.amount, true);
            }
            return recipe.output;
        }
        ItemStack filled = FluidContainerRegistry.fillFluidContainer((FluidStack)new FluidStack(this.tank.getFluid(), Integer.MAX_VALUE), (ItemStack)empty);
        FluidStack fs = FluidContainerRegistry.getFluidForFilledItem((ItemStack)filled);
        if (filled != null && fs.amount <= this.tank.getFluidAmount()) {
            if (drainTank) {
                this.tank.drain(fs.amount, true);
            }
            return filled;
        }
        if (empty.func_77973_b() instanceof IFluidContainerItem && (accepted = ((IFluidContainerItem)empty.func_77973_b()).fill(empty, this.tank.getFluid(), false)) > 0) {
            filled = empty.func_77946_l();
            ((IFluidContainerItem)filled.func_77973_b()).fill(filled, new FluidStack(this.tank.getFluid(), accepted), true);
            if (drainTank) {
                this.tank.drain(accepted, true);
            }
            return filled;
        }
        return null;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.facing = nbt.func_74762_e("facing");
        this.energyStorage.readFromNBT(nbt);
        this.tank.readFromNBT(nbt.func_74775_l("tank"));
        NBTTagList invList = nbt.func_150295_c("inventory", 10);
        this.inventory = new ItemStack[5];
        for (int i = 0; i < invList.func_74745_c(); ++i) {
            NBTTagCompound itemTag = invList.func_150305_b(i);
            int slot = itemTag.func_74771_c("Slot") & 0xFF;
            if (slot < 0 || slot >= this.inventory.length) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)itemTag);
        }
        NBTTagList finishedList = nbt.func_150295_c("predictedOutput", 10);
        this.predictedOutput = new ItemStack[5];
        for (int i = 0; i < finishedList.func_74745_c(); ++i) {
            NBTTagCompound itemTag = finishedList.func_150305_b(i);
            int slot = itemTag.func_74771_c("Slot") & 0xFF;
            if (slot < 0 || slot >= this.predictedOutput.length) continue;
            this.predictedOutput[slot] = ItemStack.func_77949_a((NBTTagCompound)itemTag);
        }
        this.process = nbt.func_74759_k("process");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74768_a("facing", this.facing);
        this.energyStorage.writeToNBT(nbt);
        NBTTagCompound tankTag = this.tank.writeToNBT(new NBTTagCompound());
        nbt.func_74782_a("tank", (NBTBase)tankTag);
        NBTTagList invList = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(itemTag);
            invList.func_74742_a((NBTBase)itemTag);
        }
        nbt.func_74782_a("inventory", (NBTBase)invList);
        NBTTagList finishedList = new NBTTagList();
        for (int i = 0; i < this.predictedOutput.length; ++i) {
            if (this.predictedOutput[i] == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74774_a("Slot", (byte)i);
            this.predictedOutput[i].func_77955_b(itemTag);
            finishedList.func_74742_a((NBTBase)itemTag);
        }
        nbt.func_74782_a("predictedOutput", (NBTBase)finishedList);
        nbt.func_74783_a("process", this.process);
    }

    public boolean func_145842_c(int id, int arg) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.pos == 4) {
            return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 2));
        }
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e);
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return super.func_145833_n() * Config.getDouble("increasedTileRenderdistance");
    }

    @Override
    public float[] getBlockBounds() {
        int ff;
        if (this.pos < 6) {
            return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
        }
        if (this.pos == 10) {
            return new float[]{this.facing < 4 ? -0.0625f : 0.0f, 0.0f, this.facing > 3 ? -0.0625f : 0.0f, this.facing < 4 ? 1.0625f : 1.0f, 1.0f, this.facing > 3 ? 1.0625f : 1.0f};
        }
        float xMin = 0.0f;
        float yMin = 0.0f;
        float zMin = 0.0f;
        float xMax = 1.0f;
        float yMax = 1.0f;
        float zMax = 1.0f;
        int n = ff = this.mirrored ? ForgeDirection.OPPOSITES[this.facing] : this.facing;
        if (this.pos % 6 < 3) {
            xMin = this.facing == 4 ? 0.5625f : 0.0f;
            zMin = this.facing == 2 ? 0.5625f : 0.0f;
            xMax = this.facing == 5 ? 0.4375f : 1.0f;
            float f = zMax = this.facing == 3 ? 0.4375f : 1.0f;
        }
        if (this.pos % 3 == 0 && ff == 4 || this.pos % 3 == 2 && ff == 5) {
            zMin = 0.4375f;
        } else if (this.pos % 3 == 0 && ff == 5 || this.pos % 3 == 2 && ff == 4) {
            zMax = 0.5625f;
        } else if (this.pos % 3 == 0 && ff == 3 || this.pos % 3 == 2 && ff == 2) {
            xMin = 0.4375f;
        } else if (this.pos % 3 == 0 && ff == 2 || this.pos % 3 == 2 && ff == 3) {
            xMax = 0.5625f;
        }
        return new float[]{xMin, yMin, zMin, xMax, yMax, zMax};
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.formed && !this.field_145850_b.field_72995_K) {
            TileEntityBottlingMachine master = this.master();
            if (master == null) {
                master = this;
            }
            int startX = master.field_145851_c;
            int startY = master.field_145848_d;
            int startZ = master.field_145849_e;
            for (int yy = -1; yy <= 1; ++yy) {
                for (int zz = -1; zz <= 1; ++zz) {
                    for (int xx = -1; xx <= 1; ++xx) {
                        int fExpected;
                        ItemStack s = null;
                        int prevPos = 0;
                        TileEntity te = this.field_145850_b.func_147438_o(startX + xx, startY + yy, startZ + zz);
                        if (te instanceof TileEntityBottlingMachine) {
                            s = ((TileEntityBottlingMachine)te).getOriginalBlock();
                            prevPos = ((TileEntityBottlingMachine)te).pos;
                            ((TileEntityBottlingMachine)te).formed = false;
                        }
                        if (startX + xx == this.field_145851_c && startY + yy == this.field_145848_d && startZ + zz == this.field_145849_e) {
                            s = this.getOriginalBlock();
                        }
                        if (s == null || Block.func_149634_a((Item)s.func_77973_b()) == null) continue;
                        if (startX + xx == this.field_145851_c && startY + yy == this.field_145848_d && startZ + zz == this.field_145849_e) {
                            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, s));
                        } else {
                            if (Block.func_149634_a((Item)s.func_77973_b()) == IEContent.blockMetalMultiblocks) {
                                this.field_145850_b.func_147468_f(startX + xx, startY + yy, startZ + zz);
                            }
                            this.field_145850_b.func_147465_d(startX + xx, startY + yy, startZ + zz, Block.func_149634_a((Item)s.func_77973_b()), s.func_77960_j(), 3);
                        }
                        TileEntity tile = this.field_145850_b.func_147438_o(startX + xx, startY + yy, startZ + zz);
                        if (!(tile instanceof TileEntityConveyorBelt)) continue;
                        int l = prevPos % 6 / 3;
                        int w = prevPos % 3;
                        ((TileEntityConveyorBelt)tile).facing = fExpected = l == 1 ? (w == 0 ? ForgeDirection.OPPOSITES[this.facing] : this.facing) : (w < 2 ? ForgeDirection.ROTATION_MATRIX[this.mirrored ? 0 : 1][this.facing] : this.facing);
                    }
                }
            }
        }
    }

    public int func_70302_i_() {
        if (!this.formed) {
            return 0;
        }
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slot) {
        if (!this.formed) {
            return null;
        }
        if (this.master() != null) {
            return this.master().func_70301_a(slot);
        }
        if (slot < this.inventory.length) {
            return this.inventory[slot];
        }
        return null;
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (!this.formed) {
            return null;
        }
        if (this.master() != null) {
            return this.master().func_70298_a(slot, amount);
        }
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a <= amount) {
                this.func_70299_a(slot, null);
            } else {
                stack = stack.func_77979_a(amount);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        this.func_70296_d();
        return stack;
    }

    public ItemStack func_70304_b(int slot) {
        if (!this.formed) {
            return null;
        }
        if (this.master() != null) {
            return this.master().func_70304_b(slot);
        }
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            this.func_70299_a(slot, null);
        }
        return stack;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (!this.formed || this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.master() != null) {
            this.master().func_70299_a(slot, stack);
            return;
        }
        this.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public String func_145825_b() {
        return "IEBottlingMachine";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (!this.formed || stack == null) {
            return false;
        }
        if (this.master() != null) {
            return this.master().func_94041_b(slot, stack);
        }
        return true;
    }

    public int[] func_94128_d(int side) {
        if (!this.formed) {
            return new int[0];
        }
        if (this.pos == 9) {
            int next = this.getNextProcessID();
            if (next == -1) {
                return new int[0];
            }
            return new int[]{next};
        }
        return new int[0];
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        if (!this.formed) {
            return true;
        }
        if (this.master() != null) {
            return this.master().func_102007_a(slot, stack, side);
        }
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return false;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return this.formed && this.pos == 10 && from == ForgeDirection.UP;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (this.formed && this.pos == 10 && from == ForgeDirection.UP && this.master() != null) {
            TileEntityBottlingMachine master = this.master();
            int rec = master.energyStorage.receiveEnergy(maxReceive, simulate);
            master.func_70296_d();
            if (rec > 0) {
                this.field_145850_b.func_147471_g(this.master().field_145851_c, this.master().field_145848_d, this.master().field_145849_e);
            }
            return rec;
        }
        return 0;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        if (this.master() != null) {
            return this.master().energyStorage.getEnergyStored();
        }
        return this.energyStorage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        if (this.master() != null) {
            return this.master().energyStorage.getMaxEnergyStored();
        }
        return this.energyStorage.getMaxEnergyStored();
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        if (this.master() != null) {
            return this.master().fill(from, resource, doFill);
        }
        int fill = this.tank.fill(resource, doFill);
        if (fill > 0) {
            this.func_70296_d();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return fill < 0 ? 0 : fill;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.formed && this.pos == 4 && from == ForgeDirection.getOrientation((int)this.facing);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (this.master() != null) {
            return this.master().getTankInfo(from);
        }
        return new FluidTankInfo[]{this.tank.getInfo()};
    }
}

